@echo off
REM FTA Pre Requisites utility v1.1
REM Modified by Alan Baldwin 20151223 to check for Administrator rights
REM PH TFS 13-37341 : Added permissions to the FTADLL folder and added extra messaging and state verification.
echo Check if run as administrator
whoami /groups | findstr /b BUILTIN\Administrators | findstr /c:"Enabled group" >NUL && goto :isadministrator
goto :notadministrator

:isadministrator
echo [is run as administrator]
echo ----------
echo Setting up prerequisites...
echo .

echo --- Set up FTA dll folder ---
echo check if FTA dll folder exists
if exist "C:\Program Files\FTADLL" goto :folderexists
echo - create FTA dll folder
mkdir "C:\Program Files\FTADLL"
goto :grantpermissions
:folderexists
echo [folder already exists]
echo .

:grantpermissions
echo --- Apply permissions to FTA dll folder ---
icacls "C:\Program Files\FTADLL" /grant Everyone:M
echo .

echo --- Set up FTA service URL interface ---
echo check if FTA service URL interface exists
netsh http show urlacl url=http://+:50124/FtaInterface
if not ERRORLEVEL 1 (
echo [URL interface already exists]
echo delete existing interface
netsh http delete urlacl url=http://+:50124/FtaInterface
)
echo create new interface
netsh http add urlacl url=http://+:50124/FtaInterface user=Everyone

echo ----------
goto :end

:notadministrator
echo [is not run as administrator]
echo ----------
echo You MUST right click this batch file and "Run As Administrator"
echo Otherwise Windows may prevent necessary update
echo ----------
goto :end

:end
echo ...set up completed
echo ----------
pause
