-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_ResponseQuestion')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_ResponseQuestion] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets all question responses for response report
-- Version:		13
-- =============================================
-- MarkP: TFS bug 4233
-- Jeremyf: TFS 5058
-- JE TFS 5458/5459: added ListSamplesOnReport option col and SampleSummary col
-- JT TFS 4929: added ResponseQuestionID to output so that sub-report for images can be linked to it
-- JT TFS 6580 - Use new multi-sort function (for performance)
-- JT TFS 7010 - Show section headers when suppress blanks is true.
-- JT TFS 7920 - DataTypeID null or zero means header.
-- JE TFS 8717 - amended filter to show archived questions if they have a response against them
-- JT TFS 13-33004: 14/06/2016 - Treat empty strings as Blanks, rather than just NULL entries.
-- JT TFS 13-54521: 22/08/2016 - Include samples if supress blanks is enabled.
-- JT TFS 13-147073: 04/03/2020 - Performance: Convert single huge query into chunks of little queries.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_ResponseQuestion]
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0
AS
BEGIN
	SET NOCOUNT ON

/* To test: 

-- INSERT TEMP_Selected (SelectedID, UserID, TransactionID) SELECT TOP 1 ResponseID, 888, 'FF2C33AA-0A69-44F7-825E-A0B87760E609' FROM QMS_Response order by newid()
-- INSERT TEMP_Selected (SelectedID, UserID, TransactionID) SELECT TOP 10 ResponseID, 777, 'D4309576-0D22-483E-8BFC-CC5AC52B4D38' FROM QMS_Response order by newid()
-- SELECT UserID, count(*) FROM TEMP_Selected GROUP BY UserID
-- EXEC RPT_Response_ResponseQuestion 777, 0, 0
-- EXEC RPT_Response_ResponseQuestion 888, 0, 0

*/

	DECLARE @SupressBlanks bit
	SET @SupressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0)

	IF NULLIF(object_id('tempdb..#tmpAllAssesmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpAllAssesmentQuestions;
	SELECT question.AssessmentID, question.AssessmentQuestionID, question.OverallSortIndex as SortIndex, question.OverallQuestionNo as QuestionNumber
	INTO #tmpAllAssesmentQuestions
	FROM QMS_AssessmentQuestion question
	INNER JOIN QMS_Response response ON question.AssessmentID = response.AssessmentID
	INNER JOIN TEMP_Selected selected ON response.ResponseID = selected.SelectedID AND selected.UserID = @UserID
	GROUP BY question.AssessmentID, question.AssessmentQuestionID, question.OverallSortIndex, question.OverallQuestionNo;

	IF NULLIF(object_id('tempdb..#tmpShownAssessmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpShownAssessmentQuestions;
	SELECT QMS_ResponseQuestion.ResponseID, assessment_questions.AssessmentQuestionID 
	INTO #tmpShownAssessmentQuestions
	FROM #tmpAllAssesmentQuestions assessment_questions
	INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = assessment_questions.AssessmentQuestionID
	INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
	WHERE (
				(@SupressBlanks = 1 AND NULLIF(QMS_ResponseQuestion.Response_Text, '') IS NOT NULL)
		OR
				(@SupressBlanks = 0) 
	);


	IF (@SupressBlanks = 1)
	BEGIN
		-- Don't accidentally suppress blank entries if 
		--   a) they have children which should be shown, or 
		--   b) they have samples.
	
		-- Idea is: Make a list of parent-child links, where any child of your children is also included.
		IF NULLIF(OBJECT_ID('tempdb..#tmpQuestionChildLinks'), 0) IS NOT NULL DROP TABLE #tmpQuestionChildLinks;
		CREATE TABLE #tmpQuestionChildLinks(ParentAssessmentQuestionID int, ChildAssessmentQuestionID int)
		INSERT #tmpQuestionChildLinks(ParentAssessmentQuestionID, ChildAssessmentQuestionID)
		SELECT ParentAssessmentQuestionID = questions.AssessmentQuestionID, ChildAssessmentQuestionID = children.AssessmentQuestionID
		FROM #tmpAllAssesmentQuestions questions
		INNER JOIN #tmpAllAssesmentQuestions children
							ON children.QuestionNumber LIKE questions.QuestionNumber + '.%' 
							AND children.AssessmentID = questions.AssessmentID

		--         Then add the parents of any assessmentquestion with answers to our list of responseid/assessmentquestions pairs we need to show.
		INSERT #tmpShownAssessmentQuestions /*addparents*/ (ResponseID, AssessmentQuestionID)
		SELECT ResponseID, ParentAssessmentQuestionID
		FROM #tmpQuestionChildLinks as link
		INNER JOIN #tmpShownAssessmentQuestions as shown ON link.ChildAssessmentQuestionID = shown.AssessmentQuestionID
		WHERE NOT EXISTS (SELECT 1 FROM #tmpShownAssessmentQuestions WHERE ResponseID = shown.ResponseID AND AssessmentQuestionID = link.ParentAssessmentQuestionID)
		GROUP BY ResponseID, ParentAssessmentQuestionID

		-- Also make sure we include any responses with samples in them.
		INSERT #tmpShownAssessmentQuestions /*samples*/ (ResponseID, AssessmentQuestionID)
		SELECT QMS_ResponseQuestion.ResponseID, assessment_questions.AssessmentQuestionID 
		FROM #tmpAllAssesmentQuestions assessment_questions
		INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = assessment_questions.AssessmentQuestionID  
		INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
		INNER JOIN QMS_ResponseQuestionSample ON QMS_ResponseQuestion.ResponseQuestionID = QMS_ResponseQuestionSample.ResponseQuestionID
		-- which do not have an entry existing already.
		LEFT OUTER JOIN #tmpShownAssessmentQuestions ignore ON ignore.ResponseID = QMS_ResponseQuestion.ResponseID 
															AND ignore.AssessmentQuestionID = assessment_questions.AssessmentQuestionID
		WHERE ignore.ResponseID IS NULL
	END

	-- Pay the expensive "Row-by-agonising-row" function for this upfront for the single value it returns.
	DECLARE @HideScore nvarchar(10)
	SELECT @HideScore = ISNULL(dbo.FNC_GetOptionValue(15), N'0')


	-- Pay the expensive "Row-by-agonising-row" function for this upfront for all 7 statuses.
	IF NULLIF(OBJECT_ID('tempdb..#tmpCAStatus'), 0) IS NOT NULL DROP TABLE #tmpCAStatus;
	CREATE TABLE #tmpCAStatus (CAStatusID int, CAStatus nvarchar(100))
	INSERT #tmpCAStatus (CAStatusID, CAStatus)
	SELECT	APP_CorrectiveActionStatus.CAStatusID, 
			ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus
	FROM APP_CorrectiveActionStatus

	-- Sub-query of original query was very expensive, but we can get it as a chunk relatively cheaply.
	IF NULLIF(OBJECT_ID('tempdb..#tmpResponseQuestions'), 0) IS NOT NULL DROP TABLE #tmpResponseQuestions;
	CREATE TABLE #tmpResponseQuestions (ResponseID int, ResponseQuestionID int)
	INSERT #tmpResponseQuestions (ResponseID, ResponseQuestionID)
	SELECT shown.ResponseID, responsequestion.ResponseQuestionID
	FROM #tmpShownAssessmentQuestions shown
	INNER JOIN QMS_ResponseQuestion responsequestion ON shown.ResponseID = responsequestion.ResponseID
	WHERE responsequestion.RecordStatus < 201
	GROUP BY shown.ResponseID, responsequestion.ResponseQuestionID

	-- This function was fairly quick on it's own, but again expensive when outer joined on.
	IF NULLIF(OBJECT_ID('tempdb..#tmpResponseSample'), 0) IS NOT NULL DROP TABLE #tmpResponseSample;
	CREATE TABLE #tmpResponseSample (  
		ResponseQuestionID int,   
		MinSample float, MaxSample float, AvgSample float, NumSample int, SumSample float,
		SampleList nvarchar(1000)  -- should be nvarchar(max)
	)
	INSERT #tmpResponseSample(ResponseQuestionID, MinSample, MaxSample, AvgSample, NumSample, SumSample, SampleList)
	SELECT ResponseQuestionID, MinSample, MaxSample, AvgSample, NumSample, SumSample, substring(SampleList, 1, 1000)
	FROM dbo.FNC_ResponseQuestion_SampleSummary(@UserID)

	-- The main original select statement, stripped of (most) of the left and right outer joins added later.
	IF NULLIF(OBJECT_ID('tempdb..#tmpMainQuery'), 0) IS NOT NULL DROP TABLE #tmpMainQuery;
	SELECT	-- join columns
			QMS_ResponseQuestion.ResponseQuestionID, QMS_AssessmentQuestion.ParentQuestionID, QMS_AssessmentQuestion.AssessmentID, 
			QMS_AssessmentQuestion.QuestionLevelID, QMS_AssessmentQuestion.GuidanceID, QMS_AssessmentQuestion.SampleSummaryID,
			-- sort columns
			QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.SortIndex,
			-- select columns (alphabetical order)
			APP_QAFlag.QAFlagBackColour, 
			APP_QAFlag.QAFlagForeColour,
			AssessmentQuestion_Sort.QuestionNumber, 
			QMS_AssessmentQuestion.DataTypeID,
			QMS_AssessmentQuestion.HasSamples,
			QMS_AssessmentQuestion.ListSamplesOnReport,
			QMS_AssessmentQuestion.ResponseIsScore, 
			QMS_AssessmentQuestion.ShortGuidance,
			QMS_AssessmentQuestion.ScoreCalculationID, 
			QMS_QuestionPool.Question,
			QMS_QuestionPool.Sys_Question, 
			QMS_ResponseQuestion.QuestionComments, 
			QMS_ResponseQuestion.Recommended_QAFlagID, 
			QMS_ResponseQuestion.Response_Boolean, 
			QMS_ResponseQuestion.Response_Date, 
			QMS_ResponseQuestion.Response_Numeric, 
			QMS_ResponseQuestion.Response_SourceID, 
			QMS_ResponseQuestion.Response_Text, 
			QMS_ResponseQuestion.Score
	INTO #tmpMainQuery
	FROM 
								QMS_ResponseQuestion 
			INNER JOIN			QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID 
			INNER JOIN			TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID 
			INNER JOIN			#tmpAllAssesmentQuestions AS AssessmentQuestion_Sort ON QMS_AssessmentQuestion.AssessmentQuestionID = AssessmentQuestion_Sort.AssessmentQuestionID 
			INNER JOIN			QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID 
			LEFT OUTER JOIN		APP_QAFlag ON QMS_ResponseQuestion.Recommended_QAFlagID = APP_QAFlag.QAFlagID 
			WHERE	(TEMP_Selected.UserID = @UserID) 
	AND		(QMS_ResponseQuestion.RecordStatus < 201)
	AND		(QMS_AssessmentQuestion.HideFromReports = 0)
	AND		EXISTS (SELECT * FROM #tmpShownAssessmentQuestions WHERE ResponseID = QMS_ResponseQuestion.ResponseID AND AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID)

	SET NOCOUNT OFF

	-- Remaining performance candidates: Corrective Action and Amber & Red Constraint queries
	SELECT		mainQuery.ResponseID, mainQuery.QuestionNumber, mainQuery.Question, APP_QuestionLevel.QuestionLevel, 
						  APP_QuestionLevel.ListIndex AS QuestionLevelSort, mainQuery.Sys_Question, mainQuery.Response_Text, 
						  mainQuery.Response_Boolean, mainQuery.Response_Date, mainQuery.Response_Numeric, 
						  mainQuery.Response_SourceID, 
				ROUND(mainQuery.Score, 1) AS Score, 
						  mainQuery.Recommended_QAFlagID, mainQuery.QuestionComments, 
				CASE WHEN mainQuery.ResponseIsScore = 1 
						THEN ISNULL(mainQuery.Score, 0) 
					 ELSE 0 END AS ResponseScore, 
				@ShowCA AS ShowCA, 
				CAST(CASE WHEN CorrectiveAction.ResponseQuestionID IS NULL THEN 0 ELSE 1 END AS bit) AS HasCA, 
						  CorrectiveAction.CorrectiveActionID, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
						  CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, 
				@ShowGuidance AS ShowGuidance, 
				CAST(CASE WHEN QMS_Guidance.GuidanceString IS NULL THEN 
						CASE WHEN mainQuery.ShortGuidance IS NULL THEN 0 ELSE 1 END 
					ELSE 1 END AS bit) AS HasGuidance, 
				QMS_Guidance.GuidanceString, mainQuery.ShortGuidance, 
						  RedConstraints.Constraint_Score_Min AS LevelScoreMinRed, RedConstraints.Constraint_Score_Max AS LevelScoreMaxRed, 
						  RedConstraints.GuidanceString AS LevelGuidance, 
						  CAST(CASE WHEN RedConstraints.GuidanceString IS NULL THEN 0 ELSE 1 END AS bit) AS HasLevelGuidance, 
				@HideScore AS HideQAScore,  -- No longer row-by-row.
						  mainQuery.ScoreCalculationID, 
						  AmberConstraints.Constraint_Score_Min AS LevelScoreMinAmber, AmberConstraints.Constraint_Score_Max AS LevelScoreMaxAmber, 
						  mainQuery.HasSamples, mainQuery.SampleSummaryID, 
						  SampleSummary.MinSample, SampleSummary.MaxSample, 
						  SampleSummary.AvgSample, SampleSummary.NumSample, SampleSummary.SumSample, SampleSummary.SampleList, 
						  QMS_QuestionPool_Parent.Question AS ParentQuestion, mainQuery.QAFlagBackColour, mainQuery.QAFlagForeColour,
						  mainQuery.ListSamplesOnReport AS ShowSamples, APP_SampleSummary.SampleSummary,
						  mainQuery.ResponseQuestionID,
				IsSectionHeaderRow = convert(bit, CASE WHEN NULLIF(mainQuery.DataTypeID, 0) IS NULL THEN 1 ELSE 0 END)

	FROM	(
		SELECT			QMS_CorrectiveAction.SourceObjectID AS ResponseQuestionID, QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, 
				APP_CorrectiveActionStatus.CAStatus AS CAStatus, -- note: changed this.
						QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline
		FROM				QMS_CorrectiveAction 
		INNER JOIN			#tmpCAStatus APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID 
		INNER JOIN			#tmpResponseQuestions responsequestions ON responsequestions.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
		LEFT OUTER JOIN	QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
		WHERE   (QMS_CorrectiveAction.CASourceID = 2) AND (QMS_CorrectiveAction.RecordStatus < 201)
	) AS CorrectiveAction 
	RIGHT OUTER JOIN #tmpResponseSample AS SampleSummary 
		RIGHT OUTER JOIN	
			#tmpMainQuery as mainQuery
		 ON SampleSummary.ResponseQuestionID = mainQuery.ResponseQuestionID 
		LEFT OUTER JOIN	QMS_AssessmentQuestion AS QMS_AssessmentQuestion_Parent ON mainQuery.ParentQuestionID = QMS_AssessmentQuestion_Parent.AssessmentQuestionID 
		LEFT OUTER JOIN	(
			SELECT     QMS_AssessmentConstraint_1.AssessmentID, APP_AssessmentConstraintType_1.QuestionLevelID, 
						MIN(QMS_AssessmentConstraint_1.Constraint_Score_Min) AS Constraint_Score_Min, 
						MAX(QMS_AssessmentConstraint_1.Constraint_Score_Max) AS Constraint_Score_Max
			FROM          APP_AssessmentConstraintType AS APP_AssessmentConstraintType_1 
			INNER JOIN	QMS_AssessmentConstraint AS QMS_AssessmentConstraint_1 ON APP_AssessmentConstraintType_1.AssessmentConstraintTypeID = QMS_AssessmentConstraint_1.AssessmentConstraintTypeID
			WHERE		(QMS_AssessmentConstraint_1.RecordStatus < 201) 
			AND			(QMS_AssessmentConstraint_1.QAFlagID = 2)
			GROUP BY APP_AssessmentConstraintType_1.QuestionLevelID, QMS_AssessmentConstraint_1.AssessmentID
		) AS AmberConstraints ON mainQuery.AssessmentID = AmberConstraints.AssessmentID 
								AND mainQuery.QuestionLevelID = AmberConstraints.QuestionLevelID 
		LEFT OUTER JOIN	APP_QuestionLevel ON mainQuery.QuestionLevelID = APP_QuestionLevel.QuestionLevelID 
		LEFT OUTER JOIN	(
			SELECT		QMS_AssessmentConstraint.AssessmentID, APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, 
						APP_QuestionLevel_1.ListIndex, 
						MIN(QMS_AssessmentConstraint.Constraint_Score_Min) AS Constraint_Score_Min, 
						MAX(QMS_AssessmentConstraint.Constraint_Score_Max) AS Constraint_Score_Max, 
						QMS_Guidance_1.GuidanceString
			FROM			APP_QuestionLevel AS APP_QuestionLevel_1 
			INNER JOIN		APP_AssessmentConstraintType ON APP_QuestionLevel_1.QuestionLevelID = APP_AssessmentConstraintType.QuestionLevelID 
			INNER JOIN		QMS_AssessmentConstraint ON APP_AssessmentConstraintType.AssessmentConstraintTypeID = QMS_AssessmentConstraint.AssessmentConstraintTypeID 
			LEFT OUTER JOIN	QMS_Guidance AS QMS_Guidance_1 ON QMS_AssessmentConstraint.GuidanceID = QMS_Guidance_1.GuidanceID
			WHERE      (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.QAFlagID = 3)
			GROUP BY APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, APP_QuestionLevel_1.ListIndex, 
					 QMS_AssessmentConstraint.AssessmentID, QMS_Guidance_1.GuidanceString
		) AS RedConstraints ON mainQuery.QuestionLevelID = RedConstraints.QuestionLevelID 
							AND mainQuery.AssessmentID = RedConstraints.AssessmentID 
		LEFT OUTER JOIN	QMS_Guidance ON mainQuery.GuidanceID = QMS_Guidance.GuidanceID 
	ON CorrectiveAction.ResponseQuestionID = mainQuery.ResponseQuestionID 
	LEFT OUTER JOIN	QMS_QuestionPool AS QMS_QuestionPool_Parent ON QMS_AssessmentQuestion_Parent.QuestionID = QMS_QuestionPool_Parent.QuestionID 
	LEFT OUTER JOIN	APP_SampleSummary ON mainQuery.SampleSummaryID = APP_SampleSummary.SampleSummaryID
	-- where clauses have been moved to #tmpMainQuery selection above.
	ORDER BY mainQuery.ResponseID, mainQuery.SortIndex
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PreviousList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		29
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- MP TFS 13-12735: Added logic to check for AQC approval config setting
-- jf 13042 - AQC may not be multicheck so allow for it
-- PH TFS 13-15140:  Added 'IsWebChecks' column to determine whether the Response is authorised to be edited using WebChecks front end (permission derived from APP_Menu with ParentID = 233)
-- jf tfs 16880 -- removed inner joins to FNC_User_ResponseList and used TEMP_selected instead - UBE Check view performance for user with 2000+ stock code permissions
				-- took resource string calcs out of nexted select and put in main output query (QAFlagID, ResourceName,QAFlag)
-- PH TFS 13-34304:		Reformatted and refactored QRY_Response_PreviousList to make more sense, perform better and be forward compatible
-- PH TFS 13-34304:		Reformatted to close up gaps
-- SS TFS 13-33017: When AssessmentTypeID = 16, AQC_FNC_ResponseHeader is now used instead of FNC_ResponseHeader
-- JT TFS 13-82047: Extract SP for shelf life to improve performance.
-- JF TFS 13-89956: It appears the origanl issue with using FNC_ResponseHeader for AQC checks has been resolved so we no longer have to use AQC_FNC_ResponseHeader (which performs badly)
-- JF TFS 13-89956: replaced multiple calls to FNC_Response_IsMultiCheck with TEMP_selected value
-- JT TFS 13-148235: Precalculate resource strings and number of attachments before main select.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport

		--SELECT  @AssessmentTypeID = 2,  @DateFrom = '1 Aug 2017 00:00:00',  @DateTo = '15 Sep 2017 23:59:59',  @UserID = 1,  @ShowOutstanding = 1,  @DisplayMode = 1

		--exec QRY_Response_PreviousList  @AssessmentTypeID = 2,  @DateFrom = '1 Aug 2017 00:00:00',  @DateTo = '15 Sep 2017 23:59:59',  @UserID = 1,  @ShowOutstanding = 1,  @DisplayMode = 1
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

	UPDATE TEMP_Selected SET SelectedValue = dbo.FNC_Response_IsMultiCheck(SelectedID ) WHERE (UserID = @UserID);
    
	IF NULLIF(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag;
	SELECT	flag.QAFlagID, --flag.ResourceName, flag.QAFlag,
			ISNULL(dbo.FNC_ResourceString_User(flag.ResourceName, @UserID), flag.QAFlag) as QAFlag
	INTO #tmpQAFlag
	FROM	APP_QAFlag flag

	IF NULLIF(object_id('tempdb..#tmpAttachmentCount'), 0) IS NOT NULL DROP TABLE #tmpAttachmentCount;
	SELECT	QMS_Attachment.SourceObjectID AS ResponseID, COUNT(QMS_Attachment.AttachmentID) AS NumAttachments
	INTO #tmpAttachmentCount
	FROM	QMS_Attachment
	INNER JOIN TEMP_Selected ON QMS_Attachment.SourceObjectID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
	WHERE	QMS_Attachment.AttachmentSourceID = 1
	AND		QMS_Attachment.RecordStatus < 201
	GROUP BY QMS_Attachment.SourceObjectID

	SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				QAFlag.QAFlag AS QAFlag, -- This is the FNC_ResourceString_User precalculated value.
                QMS_Response.Override_QAFlagID, 
				QAFlag_Override.QAFlag AS Override_QAFlag, -- This is the FNC_ResourceString_User precalculated value.
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN #tmpAttachmentCount AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN #tmpQAFlag AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN #tmpQAFlag AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					QAFlag.QAFlag AS QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Override_QAFlagID, 
					QAFlag_Override.QAFlag AS Override_QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN #tmpAttachmentCount AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			--SELECT 
			--		UserID = @UserID, 
			--		AssessmentID = @AssessmentID,
			--		AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
			--		ShowOutstanding = @ShowOutstanding,
			--		multiCheckDisplay = @multiCheckDisplay

		     EXEC QRY_Response_PreviousList_ShelfLife 
					@UserID = @UserID, 
					@AssessmentID = @AssessmentID,
					@AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
					@ShowOutstanding = @ShowOutstanding,
					@multiCheckDisplay = @multiCheckDisplay
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					QAFlag.QAFlag AS QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Override_QAFlagID, 
					QAFlag_Override.QAFlag AS Override_QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					--ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
					ISNULL(TEMP_Selected.SelectedValue,0) AS MultiCheckLevel
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			--LEFT OUTER JOIN	dbo.AQC_FNC_ResponseHeader() AS ResponseHeader
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					#tmpAttachmentCount AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag_Override	ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag			ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
							AND TEMP_Selected.SelectedValue=1
						)
						OR
						(
							@multiCheckDisplay = 2
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
							AND TEMP_Selected.SelectedValue IN (1,2)
						)
						--OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
						OR TEMP_Selected.SelectedValue = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					QAFlag.QAFlag AS QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Override_QAFlagID, 
					QAFlag_Override.QAFlag AS Override_QAFlag, -- This is the FNC_ResourceString_User precalculated value.
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					#tmpAttachmentCount AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN #tmpQAFlag AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						--dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
						TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END
GO





PRINT 'Database updated successfully!'
GO