-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_StockCodeID')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets stock code id for responses
-- Version:		9
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- JF TFS 15314 - timeout issues - changed duplicate check to an outer join (Greencell had 100k records in @ResponseHeader)
-- TC TFS 87211 - Re-written to remove the wrapper and improve performance
-- JF TFS 95146 - updated to make sure we pick up the stockcodeid rather than the Consignmentitemid (and remove duplicates)
-- JF TFS 109198 - Pick up final stock code
-- =============================================
/*
    Example call:
    SELECT * FROM [dbo].[FNC_ResponseHeader_StockCodeID]()
	select * from APP_DataLookup where DataLookup like '%stock%' 
*/
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID]()
RETURNS TABLE
AS
RETURN 
SELECT	ResponseID, 
		StockCodeID
FROM (
		SELECT  R.ResponseID,
				ROW_NUMBER() OVER (
					PARTITION BY R.ResponseID 
					ORDER BY	CASE	WHEN AH.DataLookupID = 8	THEN 3		-- GoodsIntake (lowest precedence)
										WHEN AH.DataLookupID = 6	THEN 2		-- Consigment  
																	ELSE 1 END,	-- Stockcode or raw stockcode (highest precedence)
								AH.ListIndex,
								RH.ResponseHeaderID
				) AS row_order,
		CASE WHEN AH.DataLookupID in (6,8) THEN COALESCE(CI_Direct.StockCodeID, CI.StockCodeID) 
             ELSE RH.Header_SourceID END AS StockCodeID --make sure we only pick up the Header_SourceID when its a stockcodeid
      FROM QMS_Response R
      JOIN QMS_ResponseHeader RH ON R.ResponseID = RH.ResponseID
      JOIN QMS_AssessmentHeader AH ON RH.AssessmentHeaderID = AH.AssessmentHeaderID

          LEFT JOIN PM_VW_GoodsIntake GI ON RH.Header_SourceID = GI.GoodsIntakeID AND AH.DataLookupID = 8
                     LEFT OUTER JOIN PM_VW_ConsignmentItems CI ON GI.ConsignmentItemID = CI.ConsignmentItemID 
          LEFT JOIN PM_VW_ConsignmentItems CI_Direct ON CI_Direct.ConsignmentItemID = RH.Header_SourceID AND AH.DataLookupID = 6

     WHERE R.RecordStatus < 201
       AND RH.Header_SourceID IS NOT NULL
       AND AH.DataTypeID = 9
       AND AH.DataLookupID IN (2, 35, 6, 8,69) -- stockcode, raw stockcode, POitem (consignment item), intake, final product
       AND AH.RecordStatus < 201

	) AS tmp
WHERE tmp.row_order = 1
GO






PRINT 'Database updated successfully!'
GO

