-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_CorrectiveAction_NotificationSent')
	EXEC ('CREATE PROCEDURE [dbo].[UP_CorrectiveAction_NotificationSent] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Update corrective action to mark notification as sent
-- version: 2
-- =============================================
-- JF TFS 131009Update sent flag QMS_CorrectiveAction_Update
-- =============================================
ALTER PROCEDURE [dbo].[UP_CorrectiveAction_NotificationSent] 
	@CorrectiveActionID int,
	@IsReminderAlert bit = 0
AS
BEGIN
	-- DECLARE @CorrectiveActionID int = 3,	@IsReminderAlert bit = 1
	 
	UPDATE  
		QMS_CorrectiveAction
	SET     
		Updated = GETUTCDATE(), 
		NotificationSent	= CASE WHEN @IsReminderAlert = 0 THEN 1 ELSE NotificationSent	END, /* unchanged if Is Reminder Alert */
		ReminderSent		= CASE WHEN @IsReminderAlert = 1 THEN 1 ELSE ReminderSent		END  /* only change if Is Reminder Alert */
	WHERE     
		(CorrectiveActionID = @CorrectiveActionID)
		and
		(
		NotificationSent	<> CASE WHEN @IsReminderAlert = 0 THEN 1 ELSE NotificationSent	END
		OR
		ReminderSent		<> CASE WHEN @IsReminderAlert = 1 THEN 1 ELSE ReminderSent END
		)

	--update all the records - assume the alert service has only sent out an alert for the latest one
	UPDATE QMS_CorrectiveAction_Update
	Set NotificationSent =1 
	WHERE     
		(CorrectiveActionID = @CorrectiveActionID) AND
		NotificationSent =0 
		




END
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_SignOffPending')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_SignOffPending] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 22/02/2012
-- Description:	Returns Signed-off CA's pending alert send 
-- =============================================
-- JF TFS 131009 - use the update table for the pending as it has its own NotificationSent
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_SignOffPending]

AS
BEGIN

	--SELECT	CorrectiveActionID
	--FROM	QMS_CorrectiveAction INNER JOIN
	--			QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
	--WHERE	(NotificationSent = 0) AND (QMS_CorrectiveAction.RecordStatus < 201) AND
	--			(CAStatusID = 5) AND (Failure_NotificationGroupID IS NOT NULL)


	SELECT	
		QMS_CorrectiveAction.CorrectiveActionID
		--QMS_CorrectiveAction_Update.CorrectiveActionUpdateID,
		--QMS_CorrectiveAction_Update.CAStatusID
	FROM	QMS_CorrectiveAction 
		--INNER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
		INNER JOIN QMS_CorrectiveAction_Update on QMS_CorrectiveAction_Update.CorrectiveActionid = QMS_CorrectiveAction.CorrectiveActionid
	WHERE	
		QMS_CorrectiveAction_Update.NotificationSent = 0 AND 
		QMS_CorrectiveAction.RecordStatus < 201 AND 
		QMS_CorrectiveAction_Update.Recordstatus<201 and 
		QMS_CorrectiveAction_Update.CAStatusID = 5 

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_Rejected')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_Rejected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jeremy Formby			
-- Create date: 12/072/2019
-- Description:	Returns Rejected CA's pending alert send 
-- Version:		1
-- =============================================
-- JF TFS 131009 - use the update table for the pending as it has its own NotificationSent
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_Rejected]

AS
BEGIN

	SELECT	
		distinct QMS_CorrectiveAction.CorrectiveActionID--,
		--QMS_CorrectiveAction_Update.CorrectiveActionUpdateID,
		--QMS_CorrectiveAction_Update.CAStatusID
	FROM	QMS_CorrectiveAction 
		--INNER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
		INNER JOIN QMS_CorrectiveAction_Update on QMS_CorrectiveAction_Update.CorrectiveActionid = QMS_CorrectiveAction.CorrectiveActionid
	WHERE	
		QMS_CorrectiveAction_Update.NotificationSent = 0 AND 
		QMS_CorrectiveAction.RecordStatus < 201 AND 
		QMS_CorrectiveAction_Update.Recordstatus<201 and 
		QMS_CorrectiveAction_Update.CAStatusID = 6 

END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_Alert')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_Alert] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Gets list of users to notify for specific corrective action
-- Version:		17
-- =============================================
-- JE TFS 2947 - use Failure_NotificationGroupID for Completed CA's
-- JE TFS 2948 - get linked Supplier users for Signed-off CA's
-- JT TFS 3052 - new CAs for AssignSupplierID get an alert, too.
-- JT TFS 3054 - SP now handles all status/assignment cases.
-- JT TFS 3067 - SP handles reminder alerts too.
-- JT TFS 3077 - Returns CAStatus for email content.
-- JE TFS 7700 - added Logged_UserID to recipient list for sign-off alert
-- JE TFS 7877 - corrected above change to alert Logged_UserID for CA PENDING sign-off
-- JE TFS 13-4921: added CompletedByUser column
-- JE TFS 13-6298: added Location permissions check for Failed CAs
-- JE TFS 13-6298: added Location permissions check for all CA statuses
-- JE TFS 13-8940: amended query to populate @UserList so admin users are included
-- JT TFS 13-88643: Report UTCOffset back to email notification
-- JT TFS 13-88643: Always return same column names for first query (with NULL for impossible columns)
-- JF TFS 131009 - add reject section
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_Alert]
	@CorrectiveActionID int,
	@IsReminderAlert bit = 0
AS

-- TEST DATA: 
-- DECLARE @CorrectiveActionID int = 18507, @IsReminderAlert bit = 0
BEGIN
	--Get location for check to filter users
	DECLARE		@LocationID int, 
				@CASource int, 
				@CAStatusID int,
				@CAStatus nvarchar(255),
				@NotificationGroupID int, 
				@FailureNotificationGroupID int,
				@AssignUserID int,
				@AssignSupplierID int,
				@IsNotificationAlreadySent bit,
				@LoggedUserID int
			
	SET NOCOUNT ON

	--Get Corrective Action Source and Corrective Action Status, and destinations.
	SELECT		@CASource					= QMS_CorrectiveAction.CASourceID, 
				@CAStatusID					= QMS_CorrectiveAction.CAStatusID, 
				@CAStatus					= ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 1), APP_CorrectiveActionStatus.CAStatus),
				@NotificationGroupID		= QMS_CorrectiveAction.NotificationGroupID,
				@FailureNotificationGroupID	= QMS_CorrectiveActionEscalation.Failure_NotificationGroupID,
				@AssignUserID				= QMS_CorrectiveAction.AssignUserID,
				@AssignSupplierID			= QMS_CorrectiveAction.AssignSupplierID,
				@IsNotificationAlreadySent  = CASE	WHEN @IsReminderAlert = 0 AND NotificationSent = 1	THEN 1
													WHEN @IsReminderAlert = 1 AND ReminderSent = 1		THEN 1
																										ELSE 0 END,
				@LoggedUserID				= QMS_CorrectiveAction.Logged_UserID								
	FROM			QMS_CorrectiveAction
	LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
	LEFT OUTER JOIN	APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)

	-- Potentially short circuit the whole process if the notification has already gone.
	-- IF (@IsNotificationAlreadySent = 1) RETURN

	-- Get location
	IF @CASource = 1 --Get location from response header
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  QMS_CorrectiveAction ON QMS_ResponseHeader.ResponseID = QMS_CorrectiveAction.SourceObjectID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
							  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 2 --Response question
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseQuestion INNER JOIN
						  QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID INNER JOIN
						  QMS_ResponseHeader INNER JOIN
						  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID ON 
						  QMS_ResponseQuestion.ResponseID = QMS_ResponseHeader.ResponseID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
						  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 4 --Ad Hoc, so get Location CA has been assigned to
	BEGIN
		SELECT	@LocationID  = LocationID
		FROM	QMS_CorrectiveAction
		WHERE	(CorrectiveActionID = @CorrectiveActionID)
	END

	IF @LocationID IS NULL --Get location assigned to user
	BEGIN
		SELECT     @LocationID = QMS_User.LocationID
		FROM        QMS_User 
		INNER JOIN	QMS_CorrectiveAction ON QMS_User.UserID = QMS_CorrectiveAction.Logged_UserID
		WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	-- Get body details (for non-sent notifications).
	IF @CAStatusID IN (4)  --Completed CA
	BEGIN
		--Get Completed CA details for message body
		SELECT  QMS_CorrectiveAction.CATitle, 
				QMS_CorrectiveAction.CASubTitle, 
				QMS_CorrectiveAction.CAReason,
				QMS_CorrectiveAction.CARequired, 
				QMS_CorrectiveAction.DateLogged, 
				QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
				APP_PriorityLevel.PriorityLevel, 
				QMS_CorrectiveAction.DateDeadline, 
				QMS_CorrectiveAction.ActionTaken,
				convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
				@CAStatus as [CAStatus],
				QMS_User.FullName AS CompletedByUser,
				QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction 
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		LEFT OUTER JOIN QMS_User ON QMS_CorrectiveAction.Completed_UserID = QMS_User.UserID	
		WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	ELSE IF @CAStatusID IN (5) --Signed-off CA
	BEGIN
			--Get Signed-off CA details for message body
			SELECT		QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CASubTitle, 
						QMS_CorrectiveAction.CAReason, 
						QMS_CorrectiveAction.CARequired, 
						QMS_CorrectiveAction.DateLogged, 
						--QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
						null as EscalationLevel,
						APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline, 
						QMS_CorrectiveAction.ActionTaken,
						QMS_User.UserName, -- Signed off user
						@CAStatus as [CAStatus],
						convert(nvarchar(255), NULL) AS CompletedByUser,
						QMS_CorrectiveAction.UTCOffset
			FROM			QMS_CorrectiveAction 
			INNER JOIN		QMS_User ON QMS_CorrectiveAction.SignOff_UserID = QMS_User.UserID 
			--LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
			INNER JOIN QMS_CorrectiveAction_Update on QMS_CorrectiveAction_Update.CorrectiveActionid = QMS_CorrectiveAction.CorrectiveActionid
			LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
			WHERE		(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) AND
						--(@IsNotificationAlreadySent = 0) AND
						QMS_CorrectiveAction_Update.NotificationSent = 0 AND
						QMS_CorrectiveAction_Update.CAStatusID = 5
	END

	ELSE IF @CAStatusID IN (6) --Rejected CA
	BEGIN
			-- alert the assigned user
			SELECT		QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CASubTitle, 
						QMS_CorrectiveAction.CAReason, 
						QMS_CorrectiveAction.CARequired, 
						QMS_CorrectiveAction.DateLogged, 
						--QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
						Null AS EscalationLevel, 
						APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline, 
						QMS_CorrectiveAction.ActionTaken,
						QMS_User.UserName, -- Signed off user
						@CAStatus as [CAStatus],
						convert(nvarchar(255), NULL) AS CompletedByUser,
						QMS_CorrectiveAction.UTCOffset
			FROM			QMS_CorrectiveAction 
			--INNER JOIN		QMS_User ON QMS_CorrectiveAction.AssignUserID = QMS_User.UserID 
			LEFT OUTER JOIN		QMS_User ON QMS_CorrectiveAction.AssignUserID = QMS_User.UserID 
			--LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
			INNER JOIN QMS_CorrectiveAction_Update on QMS_CorrectiveAction_Update.CorrectiveActionid = QMS_CorrectiveAction.CorrectiveActionid
			LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
			WHERE		QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID AND			
						--@IsNotificationAlreadySent = 0	
						QMS_CorrectiveAction_Update.NotificationSent = 0 AND
						QMS_CorrectiveAction_Update.CAStatusID = 6

	END

	ELSE -- Not Completed or Signed-off CA
	BEGIN
		--Get New CA details for message body
		SELECT      QMS_CorrectiveAction.CATitle, 
					QMS_CorrectiveAction.CASubTitle, 
					QMS_CorrectiveAction.CAReason, 
					QMS_CorrectiveAction.CARequired, 
					QMS_CorrectiveAction.DateLogged, 
					QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
					APP_PriorityLevel.PriorityLevel, 
					QMS_CorrectiveAction.DateDeadline,
					QMS_CorrectiveAction.ActionTaken,
					convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
					@CAStatus as [CAStatus],
					convert(nvarchar(255), NULL) AS CompletedByUser,
					QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		WHERE   (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		--AND		(QMS_CorrectiveAction.CAStatusID = 1) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	SET NOCOUNT OFF


	DECLARE @UserList TABLE (
		FullName nvarchar(256),
		Email nvarchar(256)
	)
	SET NOCOUNT ON

	IF @AssignUserID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) -- Individual user emails (New, In Progress, Signed-off, Rejected)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT		QMS_User.FullName, QMS_User.EMail
		FROM		QMS_User 
		WHERE   (QMS_User.UserID = @AssignUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	--Get list of users to include in alert (groupwise)
	IF @NotificationGroupID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --By group (not applicable for Signed-off CA)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT QMS_User.FullName,QMS_User.EMail
		FROM         QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @NotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	-- Suppliers get their own emails.
	IF @AssignSupplierID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --List of Suppliers linked to AssignSupplierID (everything except Completed)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User 
		INNER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID 
		WHERE	(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
		AND		(dbo.FNC_GetUserLevel(QMS_User.UserID) = 9) -- suppliers only.
		AND     (QMS_UserPermissions.PermissionTitle = @AssignSupplierID)
		AND		(QMS_UserPermissions.PermissionType = 101) 
		AND		(QMS_UserPermissions.PermissionAllow = 1)
	END

	--Get extra users to include in alert (owners of the CA alert (failure notification group))
	IF @FailureNotificationGroupID IS NOT NULL AND @CAStatusID IN (3, 4, 7) -- Failed, Completed, Failed (escalated)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT	QMS_User.FullName,QMS_User.EMail
		FROM        QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @FailureNotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	--get user who originally logged CA to include in notification list if CA is pending sign off (i.e. Completed)
	IF @LoggedUserID IS NOT NULL AND @CAStatusID = 4
	BEGIN
		INSERT INTO @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User
		WHERE	(QMS_User.UserID = @LoggedUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	SET NOCOUNT OFF

	SELECT FullName, Email FROM @UserList
END
GO





PRINT 'Database updated successfully!'
GO

