-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_SupplierLotNo_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_SupplierLotNo_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 13/05/2009
-- Description:	Gets lookup of Supplier Lot no
-- version:3
-- =============================================
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- JF TFS 116829 - Lot Summary report - add @SupplierID,@DateFrom,@DateTo params
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_SupplierLotNo_Combo] 
	@Barcode nvarchar(50) = NULL,
	@SupplierID int = null,
	@DateFrom datetime = null,
	@DateTo datetime = null

AS

DECLARE @GoodsIntakeID int
SELECT     @GoodsIntakeID = GoodsIntakeID
FROM         PM_VW_GoodsIntake
WHERE     (Barcode =  dbo.FNC_BarcodeFormat(@Barcode))

IF @GoodsIntakeID IS NOT NULL
	SELECT 
		DISTINCT SupplierLotNo
	FROM         
		PM_VW_GoodsIntake
	WHERE     
		(SupplierLotNo IS NOT NULL) AND 
		(GoodsIntakeID = @GoodsIntakeID)
	ORDER BY 
		SupplierLotNo

ELSE IF @SupplierID IS NOT NULL --Lot summary report
	SELECT 
		DISTINCT SupplierLotNo
	FROM         
		PM_VW_GoodsIntake
	WHERE     
		(SupplierLotNo IS NOT NULL) AND 
		(SupplierID = @SupplierID) and 
		(PM_VW_GoodsIntake.DateArrived BETWEEN @DateFrom AND @DateTo OR @DateFrom IS NULL )
	ORDER BY 
		SupplierLotNo

ELSE
	SELECT 
		DISTINCT SupplierLotNo
	FROM         
		PM_VW_GoodsIntake
	WHERE     
		(SupplierLotNo IS NOT NULL)
	ORDER BY 
		SupplierLotNo
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_Alert')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_Alert] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/10/2008
-- Description:	Gets details for response alert
-- Version:		6
-- =============================================
-- JE TFS 2546 - added NumCorrectiveActions
-- JT TFS 4102 : 11-Jul-2012 - Return correct QA flag.
-- JT TFS 4406 : 22-Aug-2012 - Added dynamic functions to return userlists.
-- JT TFS 121383 : Return StorageID so that attachments can be downloaded from Azure if required.
-- JT TFS 13-121970 - Bug fix where by .jpeg extensions were not included
-- =============================================
ALTER PROCEDURE QRY_Response_Alert 
	@ResponseID int,
	@UserID int = NULL
AS

SET NOCOUNT ON
IF nullif(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
SELECT	QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
INTO 	#tmpQAFlag
FROM	APP_QAFlag
SET NOCOUNT OFF

--added in TFS 2546
DECLARE @DirectCorrectiveActions int, @QuestionCorrectiveActions int
--Get count of CA's linked directly to Response
SET @DirectCorrectiveActions =	(SELECT		COUNT(CorrectiveActionID) AS NumCAs
									FROM	QMS_CorrectiveAction
									WHERE	(SourceObjectID = @ResponseID) AND (RecordStatus < 201) AND (CASourceID = 1))

--Get count of CA's linked via Question
SET @QuestionCorrectiveActions = (SELECT	COUNT(CorrectiveActionID) AS NumCAs
									FROM	QMS_CorrectiveAction INNER JOIN
												QMS_ResponseQuestion ON QMS_CorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
									WHERE	(QMS_ResponseQuestion.ResponseID = @ResponseID) AND (QMS_CorrectiveAction.RecordStatus < 201) AND (CASourceID = 2))

--Get assessment details
SELECT     APP_AssessmentType.AssessmentTypeID, APP_AssessmentType.AssessmentType, QMS_Assessment.AssessmentName, QMS_AssessmentHeader.HeaderText, 
                      QMS_ResponseHeader.Header_Text AS ResponseText, QMS_Response.Actual_Score, APP_QAFlag.QAFlagID, APP_QAFlag.QAFlag, QMS_Response.EndDate, 
                      QMS_Response.Comments, APP_AssessmentType.ImmediateSupplierReport, ISNULL(Attachment.NumAttachments, 0) AS NumAttachments, 
                      QMS_AssessmentHeader.AssessmentHeaderID, CustomAlert.Subject, CustomAlert.MessageBody, CustomAlert.MessageFooter, 
                      APP_QAFlag_Override.QAFlagID AS QAFlagID_Override, APP_QAFlag_Override.QAFlag AS QAFlag_Override, QAAction.QAAction, QAAction.ActionCode, 
                      QAAction.Comments AS ActionComments, QMS_Response.QuantityReceived, QMS_Response.QuantityChecked, QMS_Response.QuantityAccepted, 
                      QMS_Response.QuantityRejected, QMS_Response.QuantityReplaced, ISNULL(@QuestionCorrectiveActions, 0) + ISNULL(@DirectCorrectiveActions, 0) AS NumCorrectiveActions,
                      QMS_Response.ResponseID
FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID INNER JOIN
                      #tmpQAFlag as APP_QAFlag ON QMS_Response.Actual_QAFlagID = APP_QAFlag.QAFlagID INNER JOIN
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID LEFT OUTER JOIN
                      #tmpQAFlag AS APP_QAFlag_Override ON QMS_Response.Override_QAFlagID = APP_QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     TOP (1) QMS_ResponseAction.ResponseID, QMS_ResponseAction.QAActionID, APP_QAAction.QAAction, APP_QAAction.ActionCode, 
                                                   QMS_ResponseAction.Comments
                            FROM          QMS_ResponseAction INNER JOIN
                                                   APP_QAAction ON QMS_ResponseAction.QAActionID = APP_QAAction.QAActionID
                            WHERE      (QMS_ResponseAction.ResponseID = @ResponseID) AND (QMS_ResponseAction.RecordStatus < 201)
                            ORDER BY QMS_ResponseAction.ResponseActionID DESC) AS QAAction ON QMS_Response.ResponseID = QAAction.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS AssessmentTypeID, Subject, MessageBody, MessageFooter
                            FROM          QMS_CustomAlert
                            WHERE      (RecordStatus < 201) AND (CustomAlertSourceID = 1) AND (ReportType = 2)) AS CustomAlert ON 
                      APP_AssessmentType.AssessmentTypeID = CustomAlert.AssessmentTypeID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (RecordStatus < 201) AND (AttachmentSourceID = 1)
                            GROUP BY SourceObjectID) AS Attachment ON QMS_Response.ResponseID = Attachment.ResponseID
WHERE     (QMS_AssessmentHeader.RecordStatus < 201) AND (QMS_ResponseHeader.RecordStatus < 201) AND (QMS_AssessmentHeader.HideFromReports = 0) AND 
                      (QMS_Response.ResponseID = @ResponseID)
ORDER BY QMS_AssessmentHeader.ListIndex

--Get response question details
--Union to include section totals ie Major minor etc

SELECT     QMS_ResponseQuestion.Recommended_QAFlagID AS QAFlagID, QMS_QuestionPool.Question, QMS_ResponseQuestion.Response_Text, 
                      QMS_ResponseQuestion.QuestionComments,QMS_QuestionPool.QuestionLevelID
FROM         QMS_AssessmentQuestion INNER JOIN
                      QMS_ResponseQuestion ON QMS_AssessmentQuestion.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID
WHERE     (QMS_ResponseQuestion.ResponseID = @ResponseID) AND (QMS_ResponseQuestion.Recommended_QAFlagID IS NOT NULL)

UNION 

SELECT     QMS_AssessmentConstraint.QAFlagID, APP_QuestionLevel.QuestionLevel + ' Defects' AS Question, CAST(ResponseSummary.LevelScore AS nvarchar) 
                      AS ResponseText, '' AS QuestionComments, ResponseSummary.QuestionLevelID
FROM         APP_AssessmentConstraintType INNER JOIN
                      APP_QuestionLevel ON APP_AssessmentConstraintType.QuestionLevelID = APP_QuestionLevel.QuestionLevelID INNER JOIN
                      QMS_AssessmentConstraint ON 
                      APP_AssessmentConstraintType.AssessmentConstraintTypeID = QMS_AssessmentConstraint.AssessmentConstraintTypeID INNER JOIN
                          (SELECT     QMS_ResponseQuestion.ResponseID, QMS_AssessmentQuestion.AssessmentID, QMS_AssessmentQuestion.QuestionLevelID, 
                                                   SUM(QMS_ResponseQuestion.Score) AS LevelScore
                            FROM          QMS_ResponseQuestion INNER JOIN
                                                   QMS_Response ON QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID INNER JOIN
                                                   QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
                            WHERE      (QMS_ResponseQuestion.RecordStatus < 201)
                            GROUP BY QMS_ResponseQuestion.ResponseID, QMS_AssessmentQuestion.AssessmentID, QMS_AssessmentQuestion.QuestionLevelID
                            HAVING      (SUM(QMS_ResponseQuestion.Score) IS NOT NULL) AND (QMS_ResponseQuestion.ResponseID = @ResponseID)) AS ResponseSummary ON 
                      QMS_AssessmentConstraint.AssessmentID = ResponseSummary.AssessmentID AND 
                      APP_AssessmentConstraintType.QuestionLevelID = ResponseSummary.QuestionLevelID
WHERE     (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NOT NULL) AND 
                      (QMS_AssessmentConstraint.Constraint_Score_Max IS NOT NULL) AND (ResponseSummary.LevelScore >= QMS_AssessmentConstraint.Constraint_Score_Min) AND 
                      (ResponseSummary.LevelScore <= QMS_AssessmentConstraint.Constraint_Score_Max) OR
                      (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NULL) AND 
                      (QMS_AssessmentConstraint.Constraint_Score_Max IS NOT NULL) AND (ResponseSummary.LevelScore <= QMS_AssessmentConstraint.Constraint_Score_Max) OR
                      (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NOT NULL) AND 
                      (QMS_AssessmentConstraint.Constraint_Score_Max IS NULL) AND (ResponseSummary.LevelScore >= QMS_AssessmentConstraint.Constraint_Score_Min)
						  
ORDER BY QAFlagID DESC, QuestionLevelID DESC

------------------------------------------------------------------------
-- TFS 4406: Setup for dynamic functions to return user/supplier lists
------------------------------------------------------------------------

SET NOCOUNT ON

	-- Do some custom filtering if it is set up.
	DECLARE @CustomFilterFunction nvarchar(50)
	DECLARE @customSql nvarchar(1000)

	SET @CustomFilterFunction = NULL

	CREATE TABLE #tmpCustomFilter (
		FullName nvarchar(255),
		Email nvarchar(100)
	)
	
SET NOCOUNT OFF

------------------------
-- Get users to notify
------------------------
SET NOCOUNT ON
	SELECT @CustomFilterFunction = dbo.FNC_GetOptionValue(69) --UserNotifyFunction
	
	-- If the custom filter function is the same as the one we have as default, use the default directly instead.
	IF NULLIF(@CustomFilterFunction, 'FNC_Response_UserNotify') IS NOT NULL
	BEGIN
		SELECT @customSql = 'INSERT #tmpCustomFilter (FullName, Email) SELECT FullName, Email FROM dbo.[' + @CustomFilterFunction + ']' + 
							'(' + convert(nvarchar(10), @ResponseID) + ');'

		IF @customSql IS NOT NULL EXECUTE (@customSql)
	END
	ELSE
	BEGIN -- Default function
		INSERT #tmpCustomFilter (FullName, Email)
		SELECT FullName, Email FROM dbo.FNC_Response_UserNotify(@ResponseID)
	END
SET NOCOUNT OFF

SELECT DISTINCT FullName, Email FROM #tmpCustomFilter AS Response_UserNotify
                      
---------------------------
-- Get Supplier to notify
---------------------------
SET NOCOUNT ON
	DELETE #tmpCustomFilter
	SELECT @CustomFilterFunction = dbo.FNC_GetOptionValue(70) --SupplierNotifyFunction

	IF NULLIF(@CustomFilterFunction, 'FNC_Response_SupplierNotify') IS NOT NULL
	BEGIN
		SELECT @customSql = 'INSERT #tmpCustomFilter (FullName, Email) SELECT FullName, Email FROM dbo.[' + @CustomFilterFunction + ']' + 
							'(' + convert(nvarchar(10), @ResponseID) + ');'

		IF @customSql IS NOT NULL EXECUTE (@customSql)
	END
	ELSE
	BEGIN -- Default function
		INSERT #tmpCustomFilter (FullName, Email)
		SELECT FullName, Email FROM dbo.FNC_Response_SupplierNotify(@ResponseID) 
	END

SET NOCOUNT OFF

SELECT DISTINCT FullName, Email  FROM #tmpCustomFilter AS Response_SupplierNotify

--JE TFS 1990
--Get Attachments which aren't images (and also send storageID)
SELECT     AttachmentFileName, Attachment, GreenlightStorageId
FROM         QMS_Attachment
WHERE	(SourceObjectID = @ResponseID) 
AND		(RecordStatus < 201) 
AND		(LOWER(RIGHT(AttachmentFileName, 4)) NOT IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png')) 
AND		(AttachmentSourceID = 1)
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_CorrectiveActionDetail_AttachmentImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_CorrectiveActionDetail_AttachmentImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 30/11/2012
-- Description:	Gets attachment data for check images
-- Version:		2
-- =============================================
-- JT TFS 5455: Created.
-- JT TFS 13-121970 - Bug fix where by .jpeg extensions were not included
-- =============================================
ALTER PROCEDURE [dbo].[RPT_CorrectiveActionDetail_AttachmentImages] 
	@UserID int
AS

SELECT	TEMP_Selected.SelectedID as CorrectiveActionID, 
		QMS_Attachment.AttachmentTitle, 
		QMS_Attachment.AttachmentFileName, 
		QMS_Attachment.Attachment, 
		QMS_Attachment.AttachmentURL,
		CASE WHEN AttachmentTitle LIKE '%FIX%' THEN 1 ELSE 0 END IsFixAttachment -- Whether the attachment has been attached as a demonstration of the problem, or part of the fix.
FROM        TEMP_Selected 
INNER JOIN	QMS_Attachment ON TEMP_Selected.SelectedID = QMS_Attachment.SourceObjectID AND QMS_Attachment.AttachmentSourceID = 2
WHERE   (QMS_Attachment.RecordStatus < 201) 
AND		(QMS_Attachment.AttachmentFileName IS NOT NULL) 
AND		(LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 4)) IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png'))
AND		(TEMP_Selected.UserID = @UserID) 
ORDER BY TEMP_Selected.SelectedID, QMS_Attachment.AttachmentID
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_AttachmentImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_AttachmentImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================    
-- Author:  Markp    
-- Create date: 12/03/2009    
-- Description: Gets attachment data for check images    
-- Version:  8
-- =============================================    
-- MP TFS 5658 - added images linked to corrective actions    
-- MartinP TFS 13-45992 - Removed CROSS JOIN by splitting out into temporary tables  
-- MartinP TFS 13- 72418 - Added ORDER BY QMS_Attachment.Inserted DESC to final select statement   
-- MartinP TFS 13 - 72826 - Corrected ORDER BY Statement to sort by ASC (default behaviour of ORDER BY)  
-- SS TFS 13-96838 - GreenlightStorageId returned in select statement
-- SS TFS 13-121970 - Bug fix where by .jpeg extensions were not included (NOTE: '.jpeg' -> 'jpeg')
-- =============================================    
ALTER PROCEDURE [dbo].[RPT_Response_AttachmentImages]     
 @UserID int     
AS    
BEGIN    
    
 SET NOCOUNT ON    
    
 DECLARE @ResponseCATable TABLE (ResponseID INT, CorrectiveActionID INT)    
    
 INSERT INTO @ResponseCATable (ResponseID, CorrectiveActionID)    
  SELECT SelectedID,NULL     
  FROM TEMP_Selected    
  WHERE UserID = @UserID    
    
 UPDATE    ResponseCATable    
 SET          CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID    
 FROM         QMS_CorrectiveAction     
     INNER JOIN @ResponseCATable AS ResponseCATable ON QMS_CorrectiveAction.SourceObjectID = ResponseCATable.ResponseID    
 WHERE     (QMS_CorrectiveAction.CASourceID = 1)     
    
 DECLARE @ResponseAttachTable TABLE (ResponseID INT, AttachmentID INT)    
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)    
 SELECT ResponseCATable.ResponseID, AttachmentID    
 FROM @ResponseCATable AS ResponseCATable    
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID    
 WHERE      (QMS_Attachment.AttachmentSourceID = 1)     
    AND (QMS_Attachment.RecordStatus < 201)     
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)     
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 4)) IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png'))     
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.ResponseID)    
       
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)    
 SELECT ResponseCATable.ResponseID, AttachmentID    
 FROM @ResponseCATable AS ResponseCATable    
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID    
    AND (QMS_Attachment.AttachmentSourceID = 2)     
    AND (QMS_Attachment.RecordStatus < 201)    
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)     
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 4)) IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png'))     
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.CorrectiveActionID)    
    
 SET NOCOUNT OFF    
    
 SELECT     ResponseAttachTable.ResponseID,    
      QMS_Attachment.AttachmentTitle,     
      QMS_Attachment.AttachmentFileName,     
      QMS_Attachment.Attachment,      
      QMS_Attachment.AttachmentURL,
	  QMS_Attachment.GreenlightStorageId
 FROM @ResponseAttachTable AS ResponseAttachTable    
 INNER JOIN QMS_Attachment ON ResponseAttachTable.AttachmentID = QMS_Attachment.AttachmentID  
 ORDER BY QMS_Attachment.Inserted     
END    
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_MultiCheck_Attachments')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_MultiCheck_Attachments] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 16/01/2014
-- Description:	Gets attachment data for Multi QC Check
-- Version:		3
-- =============================================
-- DPC TFS 13-94491 - Include GreenlightStorageId in Attachments returned
-- JT TFS 13-121970 - Bug fix where by .jpeg extensions were not included
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_MultiCheck_Attachments]
	@UserID int
AS
BEGIN

	SELECT	QMS_Response.ResponseID, Attachments.AttachmentTitle, Attachments.AttachmentFileName, Attachments.Attachment, 
				Attachments.AttachmentURL, TEMP_Selected.SelectedValue AS ParentID, Attachments.GreenlightStorageId
	FROM TEMP_Selected INNER JOIN
			QMS_Response ON TEMP_Selected.SelectedID = QMS_Response.ResponseID INNER JOIN
			(SELECT	AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, SourceObjectID, AttachmentSourceID, GreenlightStorageId
			 FROM	QMS_Attachment --sub query to get attachments
			 WHERE	(QMS_Attachment.AttachmentFileName IS NOT NULL) AND
						(LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 4)) IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png'))) AS Attachments
				ON QMS_Response.ResponseID = Attachments.SourceObjectID AND Attachments.AttachmentSourceID = 1 --Attachments to Response Questions
	WHERE	(QMS_Response.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID)
	ORDER BY	QMS_Response.ResponseID, Attachments.SourceObjectID

END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_ResponseQuestion_CAImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_ResponseQuestion_CAImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Jonathan Toolan  
-- Create date: 12/12/2012  
-- Description: Gets attachment data for response question check images  
-- Version:  4 
-- JE TFS 5846: CAs now returned even if they don't have an image attachment  
-- SS TFS 13-96839: GreenlightStorageId returned in select statement
-- JT TFS 13-121970 - Bug fix where by .jpeg extensions were not included
-- =============================================  
ALTER PROCEDURE [dbo].[RPT_Response_ResponseQuestion_CAImages]   
 @UserID int  
AS  
BEGIN -- declare @UserID int = 1  
 SELECT QMS_ResponseQuestion.ResponseID,  
   QMS_CorrectiveAction.SourceObjectID AS ResponseQuestionID,   
   Attachments.AttachmentTitle,   
   Attachments.AttachmentFileName,   
   Attachments.Attachment,   
   Attachments.AttachmentURL,  
   Attachments.GreenlightStorageId,
   QMS_CorrectiveAction.CorrectiveActionID,  
   dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) as CARef,  
   QMS_CorrectiveAction.CAReason,   
   QMS_CorrectiveAction.CARequired,   
   QMS_CorrectiveAction.CAStatusID,  
   ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus  
 FROM QMS_ResponseQuestion  
 INNER JOIN QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID AND QMS_CorrectiveAction.CASourceID = 2 --eCorrectiveActionSource.AssessmentQuestion  
 INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID  
 LEFT OUTER JOIN APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID  
 LEFT OUTER JOIN (SELECT AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, SourceObjectID, AttachmentSourceID, GreenlightStorageId
      FROM QMS_Attachment --sub query to get attachments  
      WHERE (QMS_Attachment.AttachmentFileName IS NOT NULL)   
         AND  (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 4)) IN ('.jpg', 'jpeg', '.bmp', '.gif', '.png'))) AS Attachments  
    ON QMS_CorrectiveAction.CorrectiveActionID = Attachments.SourceObjectID AND Attachments.AttachmentSourceID = 2 -- eAttachmentSource.CorrectiveAction  
 WHERE QMS_ResponseQuestion.RecordStatus < 201  
 AND  QMS_CorrectiveAction.RecordStatus < 201  
 ORDER BY QMS_ResponseQuestion.ResponseID,   
    Attachments.SourceObjectID  
END  
GO






PRINT 'Database updated successfully!'
GO

