-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[PM_GoodsIntake]') and name='IX_PM_GoodsIntake_DateArrived')
	CREATE NONCLUSTERED INDEX [IX_PM_GoodsIntake_DateArrived]
	ON [dbo].[PM_GoodsIntake] ([DateArrived] ASC)


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Customer_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Customer_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		2 
-- =============================================
-- JF TFS 116450 - 
-- JF TFS 118913- make consignmentid optional
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Customer_Lookup] 
	@ConsignmentID int = NULL
AS

SELECT     PM_VW_Customer.CustomerID,PM_VW_Customer.CustomerName
FROM         PM_VW_Consignment
INNER JOIN PM_VW_Customer on PM_VW_Consignment.customerid = PM_VW_Customer.customerID
WHERE     (ConsignmentID = @ConsignmentID)

GO



PRINT 'Database updated successfully!'
GO

