-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PM_ProductionJob' AND COLUMN_NAME = 'Packout')
BEGIN
    ALTER TABLE [dbo].[PM_ProductionJob] ADD Packout real null
	ALTER TABLE [dbo].[PM_ProductionJob] ADD JobStatus int null
	ALTER TABLE [dbo].[PM_ProductionJob] ADD Priority int null
	ALTER TABLE [dbo].[PM_ProductionJob] ADD UserID int null
	ALTER TABLE [dbo].[PM_ProductionJob] ADD Source tinyint null
	ALTER TABLE [dbo].[PM_ProductionJob] ADD UserGroupID int null
END


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentQuantity_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentQuantity_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/06/2010
-- Description:	Lookup the Arrival quantity
-- Version:		2 
-- =============================================
-- tfs 13- 113415 - add ability to trigger on Consignmentitemid
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentQuantity_Lookup] 
	@ConsignmentID int = NULL,
	@StockCodeID int = NULL,
	@ConsignmentItemID INT = null
AS


SELECT     SUM(Quantity) as Quantity
FROM         PM_VW_ConsignmentItems
WHERE   
		(StockCodeID = @StockCodeID AND ConsignmentID = @ConsignmentID and @ConsignmentItemID IS NULL)
			OR
		(ConsignmentItemID =@ConsignmentItemID and @ConsignmentItemID IS NOT NULL)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ProductionJob')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ProductionJob] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 18/12/2008
-- Description:	Imports data to PM_ProductionJob
-- version: 2
-- =============================================
-- JF tfs 116175 added all cols from PM_ProductionJob
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ProductionJob] 
	@ProductionJobID int,
	@JobRef nvarchar(50),
	@StartTime datetime,
	@FinishTime datetime,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,

	@LocationID int=null,
	@CustomerID int=null,
	@StockCodeID int=null,
	@Quantity real = null,
	@Packout real = null,
	@DUDate datetime = null,
	@DepotDate datetime = null,
	@JobStatus int=null,
	@Priority int = null,
	@UserID int=null,
	@Comments nvarchar(255) = null,
	@Source tinyint = null,
	@Updated datetime =null,
	@UserGroupID int=null,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM PM_ProductionJob WHERE (ProductionJobID = @ProductionJobID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_ProductionJob
                      (ProductionJobID, JobRef, StartTime, FinishTime, RecordStatus, GUID,LocationID,	CustomerID,	StockCodeID,	Quantity,	Packout,	DUDate,	DepotDate,	JobStatus,	Priority,	UserID,	Comments,	Source,	Updated,	UserGroupID)
		VALUES     (@ProductionJobID,@JobRef,@StartTime,@FinishTime,@RecordStatus,@GUID,@LocationID,	@CustomerID,	@StockCodeID,	@Quantity,	@Packout,	@DUDate,	@DepotDate,	@JobStatus,	@Priority,	@UserID,	@Comments,	@Source,	@Updated,	@UserGroupID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_ProductionJob
	SET              
	JobRef = @JobRef, 
	StartTime = @StartTime, 
	FinishTime = @FinishTime, 
	RecordStatus = @RecordStatus,
	LocationID	=@LocationID,	
	CustomerID	=@CustomerID,	
	StockCodeID=@StockCodeID,	
	Quantity	=@Quantity,	
	Packout	=@Packout,	
	DUDate	=@DUDate,	
	DepotDate	=@DepotDate,	
	JobStatus	=@JobStatus,	
	Priority	=@Priority,	
	UserID	=@UserID,	
	Comments	=@Comments,	
	Source	=@Source,	
	Updated	=@Updated,	
	UserGroupID=@UserGroupID

	WHERE     (ProductionJobID = @ProductionJobID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

-- BEGIN DATA ConsignmentItemsTetColumns
--Generic schema script
IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'Text1' AND Object_ID = Object_ID (N'PM_ConsignmentItems'))
BEGIN
	ALTER Table PM_ConsignmentItems Add Text1 nvarchar(100)
	ALTER Table PM_ConsignmentItems Add Text2 nvarchar(100)
	ALTER Table PM_ConsignmentItems Add Text3 nvarchar(100)
	ALTER Table PM_ConsignmentItems Add Text4 nvarchar(100)
	ALTER Table PM_ConsignmentItems Add Text5 nvarchar(100)
	ALTER Table PM_ConsignmentItems Add CountryID int

	ALTER Table PM_ConsignmentItems Add Rowversion timestamp
	ALTER Table PM_ConsignmentItems Add Created bigint
	ALTER Table PM_ConsignmentItems Add Updated datetime



END

IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'Rowversion' AND Object_ID = Object_ID (N'PM_ConsignmentItems'))
	BEGIN
	ALTER Table PM_ConsignmentItems Add Rowversion timestamp
	ALTER Table PM_ConsignmentItems Add Created bigint
	ALTER Table PM_ConsignmentItems Add Updated datetime
	END

GO
-- END DATA ConsignmentItemsTetColumns

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_ConsignmentItems')
	EXEC ('CREATE VIEW [dbo].[PM_VW_ConsignmentItems] AS SELECT 1 as ''stub version, to be replaced''')
GO
--===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_ConsignmentItems
-- Version:		6
-- ===================================================
-- JF: Added DateRequired column
-- JF: Added E_POItem column
-- jf tfs 19430 - added GUID, RowVersion, Hide, RecordStatus, VersionNo, Created, Updated for sync purposes
-- jf tfs 29101 - added itemstatus
-- jf tfs 116450 - added text1 to text5 and countryid
-- ===================================================
ALTER VIEW [dbo].[PM_VW_ConsignmentItems]
AS
SELECT        ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, QuantityAccepted, UnitPrice, UnitQuantity, UnitStockCodeID, DepotDate, Comments, DateRequired, E_POItem, GUID, RowVersion, Hide, RecordStatus, 
                         VersionNo, Created, Updated, ItemStatus,QuantityReceived,Text1,Text2,Text3,Text4,Text5,CountryID
FROM            PM_ConsignmentItems
WHERE        (Hide = 0) AND (RecordStatus < 201)




GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Customer_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Customer_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Customer_Lookup] 
	@ConsignmentID int
AS

SELECT     PM_VW_Customer.CustomerID,PM_VW_Customer.CustomerName
FROM         PM_VW_Consignment
INNER JOIN PM_VW_Customer on PM_VW_Consignment.customerid = PM_VW_Customer.customerID
WHERE     (ConsignmentID = @ConsignmentID)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Text1_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Text1_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Text1_Lookup] 
	@ConsignmentID int = NULL
AS

	SELECT    
		Text1
	FROM         
		PM_VW_Consignment
	WHERE     
		ConsignmentID = @ConsignmentID

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Text2_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Text2_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Text2_Lookup] 
	@ConsignmentID int = NULL
AS

	SELECT    
		Text2
	FROM         
		PM_VW_Consignment
	WHERE     
		ConsignmentID = @ConsignmentID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Text3_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Text3_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Text3_Lookup] 
	@ConsignmentID int = NULL
AS

	SELECT    
		Text3
	FROM         
		PM_VW_Consignment
	WHERE     
		ConsignmentID = @ConsignmentID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Text4_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Text4_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Text4_Lookup] 
	@ConsignmentID int = NULL
AS

	SELECT    
		Text4
	FROM         
		PM_VW_Consignment
	WHERE     
		ConsignmentID = @ConsignmentID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Comments_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Comments_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Comments_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Comments
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Country_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Country_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Country_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT	
		APP_Country.CountryID,APP_Country.Country 
	FROM	
		PM_VW_ConsignmentItems INNER JOIN APP_Country on APP_Country.CountryID = PM_VW_ConsignmentItems.CountryID 
	WHERE     
		ConsignmentItemID = @ConsignmentItemID
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_DateRequired_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_DateRequired_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_DateRequired_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		DateRequired
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Text1_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text1_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text1_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Text1
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Text2_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text2_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text2_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Text2
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Text3_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text3_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text3_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Text3
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Text4_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text4_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text4_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Text4
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Text5_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text5_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		1 
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Text5_Lookup] 
	@ConsignmentItemID int = NULL
AS

	SELECT    
		Text5
	FROM         
		PM_VW_ConsignmentItems
	WHERE     
		ConsignmentItemID = @ConsignmentItemID

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_DepotDate_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_DepotDate_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 11/12/18
-- Description:	Data Lookup
-- Version:		2
-- =============================================
-- JF TFS 116450 - 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_DepotDate_Lookup]
	@GoodsIntakeID int = NULL,
	@ConsignmentItemID int = null
AS

IF @GoodsIntakeID IS NULL and @ConsignmentItemID IS NULL
	SELECT NULL

ELSE IF @GoodsIntakeID IS NOT NULL 
	SELECT     PM_VW_ConsignmentItems.DepotDate
	FROM         PM_VW_GoodsIntake INNER JOIN
                      PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID
	WHERE     (PM_VW_GoodsIntake.GoodsIntakeID = @GoodsIntakeID)

ELSE IF @ConsignmentItemID IS NOT NULL 
	SELECT     PM_VW_ConsignmentItems.DepotDate
	FROM         PM_VW_ConsignmentItems 
	WHERE     (PM_VW_ConsignmentItems.ConsignmentItemID = @ConsignmentItemID)
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		9
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - add itemstatus
-- PH TFS 13-46056 : v4 16/05/2016 - Added @DateRequiredAsText and @DepotDateAsText to work around unwanted XML UTC offset conversions.  As prescribed by Mark Powell.
-- PH TFS 13-46056 : v5 16/05/2016 - Reformatted code to make more understandable and inserted semi-colons to make forward compatible added dbo schema prefix.
-- PH TFS 13-46056 : v6 25/05/2016 - Fixed the Markleville and WaterFord Township (48327) bugs by specifying all nvarchar lengths on new parameters.
-- JF TFS 70104 - make sure all the PO items fields are imported - specifically @E_UOM
-- jf tfs 92515 - added QuantityReceived
-- jf tfs 116450 - added text1 to text5 and countryid
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@DepotDateAsText nvarchar(50) = NULL,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@DateRequiredAsText nvarchar(50) = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@ItemStatus INT,
	
	@E_UOM nvarchar(10)=null,
	@CurrencyID INT=null,
	@Discount money=null,
	@VAT money=null,
	@ItemAccepted BIT=null,
	@PalletLabels int=null,
	@E_UOM_OTHER nvarchar(10)=null,
	@LocationID INT=null,
	@Source tinyint=null,
	@QuantityReceived real = null,
	@Text1 nvarchar(100)=null,
	@Text2 nvarchar(100)=null,
	@Text3 nvarchar(100)=null,
	@Text4 nvarchar(100)=null,
	@Text5 nvarchar(100)=null,
	@CountryID INT=null,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @DepotDateAsText IS NOT NULL
	SET @DepotDate = @DepotDateAsText;
ELSE
	SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate);

IF @DateRequiredAsText IS NOT NULL
	SET @DateRequired = @DateRequiredAsText;
ELSE
	SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired);

IF @Hide  IS NULL
	SET @Hide = 0;

IF NOT EXISTS(SELECT * FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO PM_ConsignmentItems
        (
			ConsignmentItemID,
			ConsignmentID,
			StockCodeID,
			Quantity,
			UnitStockCodeID,
			UnitQuantity,
			QuantityAccepted,
			DepotDate,
			UnitPrice,
			Comments,
			DateRequired,
			E_POItem,
			Hide,
			RecordStatus,
			GUID,
			VersionNo,
			ItemStatus,

			E_UOM ,
			CurrencyID ,
			Discount ,
			VAT ,
			ItemAccepted ,
			PalletLabels ,
			E_UOM_OTHER ,
			LocationID ,
			Source,
			QuantityReceived,
			Text1,
			Text2,
			Text3,
			Text4,
			Text5,
			CountryID

		)
		VALUES
		(
			@ConsignmentItemID,
			@ConsignmentID,
			@StockCodeID,
			@Quantity,
			@UnitStockCodeID,
			@UnitQuantity,
			@QuantityAccepted,
			@DepotDate,
			@UnitPrice,
			@Comments,
			@DateRequired,
			@E_POItem,
			@Hide,
			@RecordStatus,
			@GUID,
			@VersionNo,
			@ItemStatus,

			@E_UOM ,
			@CurrencyID ,
			@Discount ,
			@VAT ,
			@ItemAccepted ,
			@PalletLabels ,
			@E_UOM_OTHER ,
			@LocationID ,
			@Source,
			@QuantityReceived,
			@Text1,
			@Text2,
			@Text3,
			@Text4,
			@Text5,
			@CountryID 

		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE	PM_ConsignmentItems
	SET
		StockCodeID = @StockCodeID,
		Quantity = @Quantity,
		UnitStockCodeID = @UnitStockCodeID,
		UnitQuantity = @UnitQuantity,
		QuantityAccepted = @QuantityAccepted,
		DepotDate = @DepotDate,
		UnitPrice = @UnitPrice,
		Comments = @Comments,
		DateRequired = @DateRequired,
		E_POItem = @E_POItem,
		Hide = @Hide,
		RecordStatus = @RecordStatus,
		VersionNo=@VersionNo,
		ItemStatus=@ItemStatus,

		E_UOM=@E_UOM ,
		CurrencyID=@CurrencyID ,
		Discount=@Discount ,
		VAT=@VAT ,
		ItemAccepted=@ItemAccepted ,
		PalletLabels=@PalletLabels ,
		E_UOM_OTHER=@E_UOM_OTHER ,
		LocationID=@LocationID ,
		Source =@Source,
		QuantityReceived=@QuantityReceived,
		Text1=@Text1,
		Text2=@Text2,
		Text3=@Text3,
		Text4=@Text4,
		Text5=@Text5,
		CountryID=@CountryID

	WHERE	ConsignmentItemID = @ConsignmentItemID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;

GO







PRINT 'Database updated successfully!'
GO

