-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PM_ProductionJob' AND COLUMN_NAME = 'CustomerID')
BEGIN
    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD CustomerID int null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD Updated datetime null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD Locationid int null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD StockCodeid int null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD Quantity real null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD DUDate datetime null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD DepotDate datetime null

    ALTER TABLE [dbo].[PM_ProductionJob]
    ADD Comments real null

END


-- BEGIN DATA QMS_SupplierResponse_Add_ParentResponseGUID_106776
BEGIN TRY
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'QMS_SupplierResponse' AND COLUMN_NAME = 'ParentResponseGUID')
BEGIN
    ALTER TABLE [dbo].[QMS_SupplierResponse]
    ADD [ParentResponseGUID] uniqueidentifier
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA QMS_SupplierResponse_Add_ParentResponseGUID_106776', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA QMS_SupplierResponse_Add_ParentResponseGUID_106776



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_SupplierResponse')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_SupplierResponse] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 23/12/2009
-- Description:	Imports individual row into QMS_SupplierResponse table on GreenlightQC_Mobile
-- Version:		3
-- =============================================
-- JT TFS 81301 - Add ConsignmentItemID to column list to import
-- DPC TFS 13-106776: 16/11/2018 - Copy ParentResponseGUID from QMS_Response to QMS_SupplierResponse
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_SupplierResponse]
	@ResponseID int,
	@SupplierID int,
	@StockCodeID int,
	@LocationID int,
	@EndDate datetime,
	@ArrivalDate datetime,
	@QuantityReceived int,
	@QuantityChecked int,
	@QuantityAccepted int,
	@QuantityRejected int,
	@QAFlagID int,
	@RedResponses nvarchar(1000),
	@Comments nvarchar(2000),
	@AssessmentTypeID int = NULL,
	@AssessmentID int = NULL,
	@ConsignmentID int = NULL,
	@ConsignmentItemID int = NULL,
	@DUDate datetime = NULL,
	@RecordStatus tinyint,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Barcode nvarchar(max),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT,
	@ParentResponseGUID uniqueidentifier
AS
BEGIN
	SET @EndDate = dbo.FNC_ConvertServerDate(@EndDate)
	SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)
	SET @DUDate = dbo.FNC_ConvertServerDate(@DUDate)

	IF NOT EXISTS(SELECT * FROM QMS_SupplierResponse WHERE (ResponseID = @ResponseID))
	BEGIN --Append record
		IF @RecordStatus < 201
		BEGIN
			--SET IDENTITY_INSERT QMS_SupplierResponse ON
			INSERT INTO QMS_SupplierResponse
						  (ResponseID, SupplierID, StockCodeID, LocationID, EndDate, ArrivalDate, QuantityReceived, QuantityChecked, QuantityAccepted, QuantityRejected, QAFlagID, 
						  RedResponses, Comments, AssessmentTypeID, AssessmentID, DUDate, ConsignmentID, RecordStatus, Updated, GUID, Barcode, ConsignmentItemID, ParentResponseGUID)
			VALUES     (@ResponseID, @SupplierID, @StockCodeID, @LocationID, @EndDate, @ArrivalDate, @QuantityReceived, @QuantityChecked, @QuantityAccepted, @QuantityRejected, @QAFlagID,
						@RedResponses, @Comments, @AssessmentTypeID, @AssessmentID, @DUDate, @ConsignmentID, @RecordStatus, @Updated, @GUID, @Barcode, @ConsignmentItemID, @ParentResponseGUID)
			SET @InsertCount = @@rowcount
			--SET IDENTITY_INSERT QMS_SupplierResponse OFF
		END
	END

	ELSE
	BEGIN --Update record
		UPDATE    QMS_SupplierResponse
		SET              SupplierID = @SupplierID, StockCodeID = @StockCodeID, LocationID = @LocationID, EndDate = @EndDate, ArrivalDate = @ArrivalDate, 
						  QuantityReceived = @QuantityReceived, QuantityChecked = @QuantityChecked, QuantityAccepted = @QuantityAccepted, QuantityRejected = @QuantityRejected, 
						  QAFlagID = @QAFlagID, RedResponses = @RedResponses, Comments = @Comments, AssessmentTypeID = @AssessmentTypeID, 
						  AssessmentID = @AssessmentID, DUDate = @DUDate, ConsignmentID = @ConsignmentID, RecordStatus = @RecordStatus, Updated = @Updated, Barcode = @Barcode,
						  ConsignmentItemID = @ConsignmentItemID, ParentResponseGUID = @ParentResponseGUID
		WHERE     (ResponseID = @ResponseID)
		SET @UpdateCount = @@rowcount
	END

	IF CAST(@RowVersion AS bigint) > @Created
		SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
	ELSE
		SET @ReceivedAnchor = @Created
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Assessment_ActiveComboUser')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Assessment_ActiveComboUser] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 22/07/2008
-- Description:	Gets active assessments
-- Version:		7
-- =============================================
-- Jonathan Toolan, 25-Aug-2011: Change so that we can use multiple types for an assessment.
-- Jonathan Toolan, 12-Sep-2011: Don't include deleted types from AssessmentTypeMulti.
-- JE TFS 2671 - added fill for assessment targets that have SourceObjectText instead of SourceObjectID
-- JE TFS 3485 - changed @CheckDate conversion to use standard SQL datetime format
-- JT TFS 13-22155: Final query changed so that it can only pick up masters (TempSpec = 0).
-- SS TFS 13-113420: Assessment targetting available for stock code area
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Assessment_ActiveComboUser] 
	@AssessmentTypeID int,
	@UserID int
AS

DECLARE @CheckDate datetime

IF @AssessmentTypeID = 4 --label check
BEGIN --lookup depot date
	DECLARE @DepotDateString nvarchar(20)

	SELECT	@DepotDateString = TEMP_ResponseHeader.Header_Text
	FROM		TEMP_ResponseHeader 
	INNER JOIN	QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE   (TEMP_ResponseHeader.UserID = @UserID) 
	AND		(QMS_AssessmentHeader.DataLookupID = 12)

	IF @DepotDateString IS NOT NULL
		SELECT @CheckDate = CONVERT(datetime, @DepotDateString)
END

IF @CheckDate IS NULL
	SET @CheckDate = GETDATE()
	
-- declare @AssessmentTypeID int, @UserID int SELECT @AssessmentTypeID = 2, @UserID = 1
DECLARE @Table_Assessment TABLE (AssessmentID int)

SET NOCOUNT ON

--Fill assessments with specific target / temp spec
INSERT INTO @Table_Assessment (AssessmentID)
SELECT DISTINCT QMS_Assessment.AssessmentID
FROM         APP_AssessmentStatus 
INNER JOIN	QMS_Assessment ON APP_AssessmentStatus.AssessmentStatusID = QMS_Assessment.AssessmentStatusID 
INNER JOIN	(	SELECT DISTINCT ai.AssessmentID
                FROM          TEMP_ResponseHeader AS rh 
				INNER JOIN	QMS_AssessmentTarget AS at ON rh.SourceObjectID = at.SourceObjectID 
				INNER JOIN	QMS_Assessment AS ai ON at.AssessmentID = ai.AssessmentID 
												AND rh.AssessmentTargetTypeID = ai.AssessmentTargetTypeID
                WHERE   (at.Hide = 0) 
				AND		(at.RecordStatus < 201) 
				AND		(rh.UserID = @UserID)

	) AS SelectedTargets ON QMS_Assessment.AssessmentID = SelectedTargets.AssessmentID 
INNER JOIN	(	SELECT     ash.AssessmentID, ash.Spec_SourceID AS SupplierID, ash.Spec_Text AS SupplierName
                FROM          QMS_AssessmentSpecHeader AS ash 
				INNER JOIN	QMS_SpecificationHeader AS sh ON ash.SpecificationHeaderID = sh.SpecificationHeaderID
                WHERE   (sh.RecordStatus < 201) 
				AND		(ash.RecordStatus < 201) 
				AND		(sh.Sys_SpecHeader = N'TempSpec_Supplier')

	) AS TempSpec_Supplier ON QMS_Assessment.AssessmentID = TempSpec_Supplier.AssessmentID 
INNER JOIN	(	SELECT     rh.Header_SourceID AS SupplierID, rh.Header_Text AS SupplierName
                FROM        TEMP_ResponseHeader AS rh 
				INNER JOIN	QMS_AssessmentHeader AS ah ON rh.AssessmentHeaderID = ah.AssessmentHeaderID
                WHERE   (ah.DataTypeID = 9) 
				AND		(ah.DataLookupID = 1) 
				AND		(rh.UserID = @UserID)

	) AS Selected_Supplier ON TempSpec_Supplier.SupplierID = Selected_Supplier.SupplierID
WHERE	(APP_AssessmentStatus.Active = 1) 
AND		(QMS_Assessment.RecordStatus < 201) 
AND		(QMS_Assessment.TempSpec = 1) 
AND		(QMS_Assessment.ValidFrom IS NULL OR QMS_Assessment.ValidFrom <= @CheckDate) 
AND		(QMS_Assessment.ValidTo IS NULL OR QMS_Assessment.ValidTo >= @CheckDate) 
AND		(-- assessment type matches
		QMS_Assessment.AssessmentTypeID = @AssessmentTypeID
		OR EXISTS	(	SELECT  AssessmentTypeMultiID
						FROM    QMS_AssessmentTypeMulti AS atm
						WHERE   (AssessmentID = QMS_Assessment.AssessmentID) 
						AND		(RecordStatus < 201) 
						AND		(AssessmentTypeID = @AssessmentTypeID)
		)
) 
	
IF (SELECT COUNT(AssessmentID) FROM @Table_Assessment) = 0
BEGIN
	--Fill assessments with specific target using SourceObjectID (e.g. StockCode)
	INSERT INTO @Table_Assessment (AssessmentID)
	SELECT     QMS_Assessment.AssessmentID
	FROM         APP_AssessmentStatus 
	INNER JOIN	QMS_Assessment ON APP_AssessmentStatus.AssessmentStatusID = QMS_Assessment.AssessmentStatusID 
	INNER JOIN	(	SELECT DISTINCT a.AssessmentID
					FROM        TEMP_ResponseHeader AS rh 
					INNER JOIN	QMS_AssessmentTarget AS at ON rh.SourceObjectID = at.SourceObjectID 
					INNER JOIN	QMS_Assessment AS a ON at.AssessmentID = a.AssessmentID 
													AND rh.AssessmentTargetTypeID = a.AssessmentTargetTypeID
					WHERE   (at.Hide = 0) 
					AND		(at.RecordStatus < 201) 
					AND		(rh.UserID = @UserID)

		) AS SelectedTargets ON QMS_Assessment.AssessmentID = SelectedTargets.AssessmentID 
	LEFT OUTER JOIN	(	SELECT  QMS_AssessmentSpecHeader.AssessmentID, 
								QMS_AssessmentSpecHeader.Spec_SourceID AS SupplierID,
								QMS_AssessmentSpecHeader.Spec_Text AS SupplierName
                        FROM        QMS_AssessmentSpecHeader 
						INNER JOIN	QMS_SpecificationHeader ON QMS_AssessmentSpecHeader.SpecificationHeaderID = QMS_SpecificationHeader.SpecificationHeaderID
                        WHERE	(QMS_SpecificationHeader.RecordStatus < 201) 
						AND		(QMS_AssessmentSpecHeader.RecordStatus < 201) 
						AND		(QMS_SpecificationHeader.Sys_SpecHeader = N'TempSpec_Supplier')

		) AS TempSpec_Supplier ON QMS_Assessment.AssessmentID = TempSpec_Supplier.AssessmentID
	WHERE     (APP_AssessmentStatus.Active = 1) 
	AND		(QMS_Assessment.RecordStatus < 201) 
	AND	(QMS_Assessment.ValidFrom IS NULL OR QMS_Assessment.ValidFrom <= @CheckDate) 
	AND (QMS_Assessment.ValidTo IS NULL OR QMS_Assessment.ValidTo >= @CheckDate) 
	AND (-- supplierID matches for temp specs.
			QMS_Assessment.TempSpec = 0
			OR 
			(QMS_Assessment.TempSpec = 1 AND TempSpec_Supplier.SupplierID IS NULL)
	) 
	AND (-- assessment type matches
			QMS_Assessment.AssessmentTypeID = @AssessmentTypeID
			OR EXISTS	(	SELECT     AssessmentTypeMultiID
							FROM    QMS_AssessmentTypeMulti AS atm
							WHERE   (AssessmentID = QMS_Assessment.AssessmentID) 
							AND		(RecordStatus < 201) 
							AND		(AssessmentTypeID = @AssessmentTypeID)
			)
	)
	
END

-- TFS 2671 --joins on SourceObjectText instead of SourceObjectID
IF (SELECT COUNT(AssessmentID) FROM @Table_Assessment) = 0
BEGIN
	--Fill assessments with target using SourceText (e.g. BusinessGroup)
	INSERT INTO @Table_Assessment (AssessmentID)
	SELECT     QMS_Assessment.AssessmentID
	FROM        APP_AssessmentStatus 
	INNER JOIN	QMS_Assessment ON APP_AssessmentStatus.AssessmentStatusID = QMS_Assessment.AssessmentStatusID 
	INNER JOIN	(	SELECT DISTINCT a.AssessmentID
                    FROM        TEMP_ResponseHeader AS rh 
					INNER JOIN	QMS_AssessmentTarget AS at ON rh.SourceObjectText = at.SourceObjectText 
					INNER JOIN	QMS_Assessment AS a ON at.AssessmentID = a.AssessmentID
                    WHERE   (at.Hide = 0) 
					AND		(at.RecordStatus < 201) 
					AND		(rh.UserID = @UserID)

	) AS SelectedTargets ON QMS_Assessment.AssessmentID = SelectedTargets.AssessmentID
	WHERE   (APP_AssessmentStatus.Active = 1) 
	AND		(QMS_Assessment.RecordStatus < 201) 
	AND		(QMS_Assessment.TempSpec = 0) 
	AND		(QMS_Assessment.ValidFrom IS NULL OR QMS_Assessment.ValidFrom <= @CheckDate) 
	AND		(QMS_Assessment.ValidTo IS NULL OR QMS_Assessment.ValidTo >= @CheckDate) 
	AND		(-- assessment type matches
				QMS_Assessment.AssessmentTypeID = @AssessmentTypeID
				OR EXISTS	(	SELECT     AssessmentTypeMultiID
								FROM          QMS_AssessmentTypeMulti AS atm
								WHERE   (AssessmentID = QMS_Assessment.AssessmentID) 
								AND		(RecordStatus < 201) 
								AND		(AssessmentTypeID = @AssessmentTypeID)
				)
	)
END

-- TFS 2671 --joins on SourceObjectText instead of SourceObjectID
IF (SELECT COUNT(AssessmentID) FROM @Table_Assessment) = 0
BEGIN
	DECLARE  @StockCodeID int
	SELECT     @StockCodeID = ResponseHeader.Header_SourceID
	FROM         TEMP_ResponseHeader AS ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE     (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 2) AND (ResponseHeader.UserID = @UserID)

-- TFS 13-113420: StockCodeArea can be targetted
	DECLARE @StockCodeArea nvarchar(255)
	SELECT	@StockcodeArea =  PM_VW_StockCode.StockCodeArea
	FROM	PM_VW_StockCode 
	WHERE	(PM_VW_StockCode.StockCodeID = @StockCodeID)

	INSERT INTO @Table_Assessment (AssessmentID)
	SELECT     QMS_Assessment.AssessmentID
	FROM         APP_AssessmentStatus 
	INNER JOIN	QMS_Assessment ON APP_AssessmentStatus.AssessmentStatusID = QMS_Assessment.AssessmentStatusID 
	INNER JOIN	(	SELECT DISTINCT a.AssessmentID
					FROM        
					QMS_AssessmentTarget AS at
					INNER JOIN	QMS_Assessment AS a ON at.AssessmentID = a.AssessmentID 
												AND at.sourceobjectText = @StockcodeArea
					WHERE   (at.Hide = 0) 
					AND		(at.RecordStatus < 201) 
					AND		(a.AssessmentTargetTypeID = 5)

		) AS SelectedTargets ON QMS_Assessment.AssessmentID = SelectedTargets.AssessmentID 
	WHERE     (APP_AssessmentStatus.Active = 1) 
	AND		(QMS_Assessment.RecordStatus < 201) 
	AND	(QMS_Assessment.ValidFrom IS NULL OR QMS_Assessment.ValidFrom <= @CheckDate) 
	AND (QMS_Assessment.ValidTo IS NULL OR QMS_Assessment.ValidTo >= @CheckDate) 
	AND (-- assessment type matches
			QMS_Assessment.AssessmentTypeID = @AssessmentTypeID
			OR EXISTS	(	SELECT     AssessmentTypeMultiID
							FROM    QMS_AssessmentTypeMulti AS atm
							WHERE   (AssessmentID = QMS_Assessment.AssessmentID) 
							AND		(RecordStatus < 201) 
							AND		(AssessmentTypeID = @AssessmentTypeID)
			)
	)
END

IF (SELECT COUNT(AssessmentID) FROM @Table_Assessment) = 0
BEGIN
	--Fill assessments with no target                      
	INSERT INTO @Table_Assessment (AssessmentID)
	SELECT     QMS_Assessment.AssessmentID
	FROM         APP_AssessmentStatus 
	INNER JOIN	QMS_Assessment ON APP_AssessmentStatus.AssessmentStatusID = QMS_Assessment.AssessmentStatusID 
	LEFT OUTER JOIN	(	SELECT     AssessmentID, COUNT(AssessmentTargetID) AS NrTargets
                        FROM          QMS_AssessmentTarget AS at
                        WHERE   (Hide = 0) 
						AND		(RecordStatus < 201)
                        GROUP BY AssessmentID

		) AS TargetCount ON QMS_Assessment.AssessmentID = TargetCount.AssessmentID
	WHERE	(APP_AssessmentStatus.Active = 1) 
	AND		(QMS_Assessment.RecordStatus < 201) 
	AND		(QMS_Assessment.ValidFrom IS NULL OR QMS_Assessment.ValidFrom <= @CheckDate) 
	AND		(QMS_Assessment.ValidTo IS NULL OR QMS_Assessment.ValidTo >= @CheckDate)
	AND		(QMS_Assessment.TempSpec = 0) -- when we get to here, we should have already eliminated temp specs as a possibility.
	AND ( -- no targets
			QMS_Assessment.AssessmentTargetTypeID IS NULL
		OR	TargetCount.NrTargets IS NULL 
		OR	TargetCount.NrTargets = 0
	)
	AND ( -- assessment type matches
			QMS_Assessment.AssessmentTypeID = @AssessmentTypeID
			OR EXISTS (	SELECT     AssessmentTypeMultiID
						FROM          QMS_AssessmentTypeMulti AS atm
						WHERE      (AssessmentID = QMS_Assessment.AssessmentID) 
						AND (RecordStatus < 201) 
						AND (AssessmentTypeID = @AssessmentTypeID)
			)
	)
END

SET NOCOUNT OFF

SELECT		a.AssessmentID, a.AssessmentName + CASE WHEN a.Version IS NULL THEN '' ELSE ' v' + a.Version END AS AssessmentText
FROM		QMS_Assessment a
INNER JOIN	@Table_Assessment AS SelectedAssessment ON a.AssessmentID = SelectedAssessment.AssessmentID
ORDER BY AssessmentText
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_Temp_ReportFilter')
	EXEC ('CREATE PROCEDURE [dbo].[APP_Temp_ReportFilter] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JToolan
-- Create date: 22/03/2012
-- Description:	Works out which ResponseIDs need to be put in the filter.
--              Can be used by any report.
-- Version:		26
-- =============================================
-- j.toolan 30-mar-2012: If @AssessmentTypeID_LIST is empty, then join all assessments
-- j.toolan 13 Apr 2012: Fixed bug with 2nd filter incorrectly clearing.
-- j.toolan 18 Apr 2012: Added Code to filter by stockcode where appropriate (renamed to ReportFilter)
-- JE 25 Apr 2012: made ReportFilterID1 optional, so can just filter by AssessmentType if necessary (TFS 3382)
-- j.toolan 6 July 2012: TFS 4013: Dynamic filtering added.
-- JE TFS 4740: removed GROUP BY for performance reasons
-- JE TFS 5037: corrected @ReportFilterID2 check as 2nd tier filter wasn't working
-- MP TFS 5289: changed date format used for custom filter functions
-- JT TFS 5396: changed code to allow commas in FilterTexts passed in as CSV. (replace "," with "&comma;" )
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 8117: Added offline filtering.
-- MP TFS 8227: Made temp table user specific and added performance logging
-- JE TFS 8274: Put result set of FNC_User_ResponseList into temp table before using it
-- JT TFS 13-667: Do not filter responses if the date range is too big.
-- JT TFS 13-1076: Search either QMS_Response or QMS_SupplierResponse, but not both.
-- JF TFS 2281 - if filter doesn't have a sourceid, this wasn't working
-- JT TFS 13-17467: Only include checks which are eligible candidates for the data warehouse.
-- JT TFS 13-38578: Convert SP to use QRY_User_ResponseList (rather than FNC_UserResponseList)
-- JT TFS 13-40008: 22/02/2016 - Added transaction IDs to response list generation, and extracted stockcode filtering
-- JT TFS 13-42222: 02/03/2016 - Added link to TokenUserID so that reports can be run simultaneously.
-- JF TFS 35438 - make sure we remove data which wouldn't show in the data warehouse - ie parent checks for Assessment type 5
-- jf TFS 90761 - Morrisons QC Office - Issue with reports not generating - removed the use of FNC_Response_ShouldIncludeInDataWarehouse dues to performance issues 
-- CJP TFS 87358 - Appending FilterText to TEMP_UserData table to ensure it is visible on report
-- jf TFS 102053 - increased GroupByText nvarchar(50) to GroupByText nvarchar(255)
-- DPC TFS 13-104879: 05/09/2018 - Allow multiple choices in second level filter
-- DPC TFS 13-106776: 16/11/2018 - Copy ParentResponseGUID from QMS_Response to QMS_SupplierResponse
-- =============================================
ALTER PROCEDURE [dbo].[APP_Temp_ReportFilter]
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(255),

	@ReportFilterID1 int = NULL,
	@FilterID_LIST1 nvarchar(4000),
	@FilterText_LIST1 nvarchar(4000),
	@ReportFilterID2 int = NULL,
	@FilterID_LIST2 nvarchar(4000) = NULL,
	@FilterText_LIST2 nvarchar(4000) = NULL,
	
	@Offline bit = NULL,
	@SearchLocalChecksIfOffline bit = 1, -- Use QMS_Response even if offline (default)
	@TransactionID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	--//This can be removed when fixed properly
	--Insert the filter text into TEMP_UserData for retreival later
	DELETE FROM TEMP_UserData where @UserID=@UserID
	INSERT INTO TEMP_UserData (UserID, String1) VALUES (@UserID, CASE WHEN LEN(@FilterText_LIST1)>100 THEN LEFT(@FilterText_LIST1,97)+ '...' ELSE LEFT(@FilterText_LIST1,100) END)
	--//End of fix
	
	EXEC SAVE_TEMP_Transaction @TransactionID, @UserID

	DECLARE @TokenUserID int;
	SELECT @TokenUserID = dbo.FNC_GetTempTransaction_TokenUserID(@TransactionID, @UserID)

	DECLARE @DateCalled DATETIME
	SET @DateCalled = GETDATE()	
	IF @Offline IS NULL SELECT @Offline = CASE WHEN db_name() = 'GreenlightQC_Mobile' THEN 1 ELSE 0 END
	
	DECLARE @SearchOffline bit -- if this is set, then we search in QMS_SupplierResponse.
	SELECT @SearchOffline  = CASE WHEN @Offline = 1 AND @SearchLocalChecksIfOffline = 0 THEN 1 ELSE 0 END
		
	-- Do not filter responses if the date range is not specified
	DECLARE @performResponseFiltering bit 
	SELECT @performResponseFiltering = CASE WHEN @DateFrom <= '1 Jan 2001' and datediff(year, @DateFrom, @DateTo) >= 10 THEN 0 ELSE 1 END
	
	DELETE TEMP_ResponseFilter WHERE UserID = @TokenUserID OR TransactionID = @TransactionID

	-- If the first criteria is empty, but the second is not, swap them over.
	IF (LEN(ISNULL(@FilterID_LIST1, '')) = 0 AND
		LEN(ISNULL(@FilterText_LIST1, '')) = 0 AND
		@ReportFilterID2 IS NOT NULL AND
		(LEN(ISNULL(@FilterID_LIST2, '')) > 0 OR LEN(ISNULL(@FilterText_LIST2, '')) > 0)
	)
	BEGIN -- The great fairness swaparoo! (in two steps)
		SELECT	@ReportFilterID1 = @ReportFilterID2,
				@FilterID_LIST1 = @FilterID_LIST2,
				@FilterText_LIST1 = @FilterText_LIST2
				
		SELECT @ReportFilterID2 = NULL, @FilterID_LIST2 = NULL, @FilterText_LIST2 = NULL
	END

	-- Is the second question correctly formulated? You must have an id or a text (or both) but not neither.
	-- JE TFS 5037 - corrected this as it was always setting @ReportFilterID2 to NULL for filters with no ID (i.e. text only)
	IF (@ReportFilterID2 IS NOT NULL) AND (LEN(ISNULL(@FilterID_LIST2, '')) = 0) AND (LEN(ISNULL(@FilterText_LIST2, '')) = 0)
	BEGIN
		SET @ReportFilterID2 = NULL
	END

	DECLARE @FilterItem TABLE (pos int not null, id int, txt nvarchar(255))
	INSERT @FilterItem (pos, id, txt)
	SELECT 	ISNULL(a.Position, b.Position) pos, CONVERT(int, ISNULL(a.Token,0)) id, replace(b.Token, '&comma;', ',') txt
	FROM dbo.FNC_SplitString(@FilterID_LIST1, ',') a
	FULL JOIN dbo.FNC_SplitString(@FilterText_LIST1, ',') b on a.Position = b.Position

	DECLARE @AssessmentType TABLE (id int not null)
	INSERT @AssessmentType (id) 
	SELECT CONVERT(int, Token) FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
	INNER JOIN APP_AssessmentType ON CONVERT(int, Token) = AssessmentTypeID 
	IF NOT EXISTS (SELECT * FROM @AssessmentType) 
	BEGIN -- if we tried to join, and got nothing, that means that this report wants all non-hidden types.
		INSERT @AssessmentType (id) SELECT AssessmentTypeID FROM APP_AssessmentType WHERE Hide = 0
	END
	
	DECLARE @customSql nvarchar(1000)
	SET @customSql = NULL
	CREATE TABLE #tmpCustomFilter (UserID INT, ResponseID int, GroupByText nvarchar(255))	
	DECLARE @pos int, @FilterID int, @FilterText nvarchar(255)		
	DECLARE @CustomFilterFunction nvarchar(50)
	SET @CustomFilterFunction = NULL

	-- Do some custom filtering if it is set up. This acts like "AND" (restricting results)
	SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
	FROM APP_ReportFilter 
	WHERE ReportFilterID = @ReportFilterID1

	-- Build up a table of responses using the first level filter
	DECLARE @FilteredResponse TABLE (id int not null)	
	WHILE EXISTS (SELECT * FROM @FilterItem)
	BEGIN		
		SELECT @pos = pos,  @FilterID = id, @FilterText = txt
		FROM @FilterItem
		WHERE pos = (SELECT MIN(pos) FROM @FilterItem)

		IF @performResponseFiltering = 1
		BEGIN
			-- either the custom function runs, *OR* the generic one, *OR* the offline one, but not more than one.
			IF @SearchOffline = 1
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				SELECT @customSql =
					'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText)
					SELECT ' + convert(nvarchar(10), @TokenUserID) + ' AS UserID, ResponseID, GroupByText
					FROM dbo.[' + @CustomFilterFunction + ']' + 
										'(' + convert(nvarchar(10), @UserID) + ', ' +
										convert(nvarchar(30), @FilterID) + ', ' +
										'''' + convert(nvarchar(50), @FilterText) + ''', ' + 
										'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
										'''' + convert(nvarchar(30), @DateTo, 13) + ''');'				
				IF @customSql IS NOT NULL EXECUTE (@customSql)
			END
			ELSE
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
		END
		
		DELETE @FilterItem WHERE pos = @pos
	END

	-- insert all our new custom filtered items (added to temp table in loop above)
	INSERT @FilteredResponse (id)
	SELECT ResponseID  FROM #tmpCustomFilter WHERE UserID = @TokenUserID

	-- If there is another filter, it acts as an "AND" (restricting results returned), not an "OR" (expanding results returned). 
	IF @ReportFilterID2 IS NOT NULL
	BEGIN
	
		-- Build up a table of responses using the second level filter
		DELETE #tmpCustomFilter WHERE UserID = @TokenUserID --clear it out for second filter.	
		DECLARE @FilterItem2 TABLE (pos int not null, id int, txt nvarchar(255))
		INSERT @FilterItem2 (pos, id, txt)	
		SELECT 	ISNULL(a.Position, b.Position) pos, CONVERT(int, ISNULL(a.Token,0)) id, replace(b.Token, '&comma;', ',') txt
		FROM dbo.FNC_SplitString(@FilterID_LIST2, ',') a
		FULL JOIN dbo.FNC_SplitString(@FilterText_LIST2, ',') b on a.Position = b.Position
		
		-- Do some custom filtering if it is set up. This acts like "AND" (restricting results)
		SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
		FROM APP_ReportFilter 
		WHERE ReportFilterID = @ReportFilterID2		
		
		DECLARE @FilteredResponse2 TABLE (id int)
		
		WHILE EXISTS (SELECT * FROM @FilterItem2)
		BEGIN	
			SELECT @pos = pos,  @FilterID = id, @FilterText = txt
			FROM @FilterItem2
			WHERE pos = (SELECT MIN(pos) FROM @FilterItem2)
			
			IF @performResponseFiltering = 1
			BEGIN
				-- either the custom function runs, *OR* the generic one, *OR* the offline one, but not more than one.						
				IF @SearchOffline = 1
				BEGIN
					INSERT @FilteredResponse2 (id)
					SELECT ResponseID 
					FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID2, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
				END 
				ELSE IF @CustomFilterFunction IS NOT NULL
				BEGIN									
					SELECT @customSql =
						'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText)
						SELECT ' + convert(nvarchar(10), @TokenUserID) + ' AS UserID, ResponseID, GroupByText
						FROM dbo.[' + @CustomFilterFunction + ']' + 
											'(' + convert(nvarchar(10), @UserID) + ', ' +
											convert(nvarchar(30), @FilterID) + ', ' +
											'''' + convert(nvarchar(50), @FilterText) + ''', ' + 
											'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
											'''' + convert(nvarchar(30), @DateTo, 13) + ''');'
					IF @customSql IS NOT NULL EXECUTE (@customSql)					
				END
				ELSE
				BEGIN
					INSERT @FilteredResponse2 (id)
					SELECT ResponseID 
					FROM dbo.FNC_ReportFilter_Response(@ReportFilterID2, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
				END			
			END
			
			DELETE @FilterItem2 WHERE pos = @pos
		END
		
		-- insert all our new custom filtered items (added to temp table in loop above)
		INSERT @FilteredResponse2 (id)
		SELECT ResponseID FROM #tmpCustomFilter WHERE UserID = @TokenUserID
		
		-- remove responses from the first filter set that are not in the second filter set
		DELETE @FilteredResponse
		WHERE id NOT IN (SELECT id FROM @FilteredResponse2)

	END

	IF @performResponseFiltering = 1
	BEGIN
		IF @SearchOffline = 1
		BEGIN
			IF @ReportFilterID1 IS NOT NULL
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @TokenUserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID)
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_SupplierResponse.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_SupplierResponse.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_SupplierResponse
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_SupplierResponse.AssessmentTypeID
					WHERE	QMS_SupplierResponse.ResponseID = r.ResponseID
				) =1

				GROUP BY r.ResponseID
			ELSE
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @TokenUserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id	
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID)
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_SupplierResponse.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_SupplierResponse.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_SupplierResponse
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_SupplierResponse.AssessmentTypeID
					WHERE	QMS_SupplierResponse.ResponseID = r.ResponseID
				) =1

				GROUP BY r.ResponseID
		END
		ELSE
		BEGIN
			--JE TFS 82774 - temp table of responses user can view (moved from direct access in query to improve performance)
			IF nullif(object_id('tempdb..#tmpUserResponses'), 0) IS NOT NULL DROP TABLE #tmpUserResponses
			CREATE TABLE #tmpUserResponses (UserID int, ResponseID int, ResponseStatus int, QAFlagID int)
			INSERT #tmpUserResponses (UserID, ResponseID, ResponseStatus, QAFlagID)
			EXEC QRY_User_ResponseList @UserID, @DateFrom, @DateTo
			
			IF @ReportFilterID1 IS NOT NULL
				-- Only return responses that the user is allowed to see, filter by Assessment Type, and use filter
				INSERT TEMP_ResponseFilter (UserID, ResponseID, TransactionID)
				SELECT @TokenUserID as UserID, rl.ResponseID, @TransactionID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE rl.UserID = @UserID
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY rl.ResponseID
			
			IF @ReportFilterID1 IS NULL
				-- Only return responses that the user is allowed to see, but there has been no filter specified, so only filter by Assessment Type (if specified)
				INSERT TEMP_ResponseFilter (UserID, ResponseID, TransactionID)
				SELECT @TokenUserID as UserID, rl.ResponseID, @TransactionID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				WHERE rl.UserID = @UserID	
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY rl.ResponseID
			
			DROP TABLE #tmpUserResponses
		END

	END
	
	DECLARE @MonitorEnabled TINYINT
	SELECT @MonitorEnabled = ISNULL(dbo.FNC_GetOptionValue(92),0)

	IF @MonitorEnabled = 1 --Log filter to QMS_PerformanceLog
	BEGIN
		DECLARE @ReportString NVARCHAR(max)
		SET @ReportString = 'APP_Temp_ReportFilter '
		SET @ReportString = @ReportString + '@UserID = ' + CAST(@UserID AS NVARCHAR(10))
		SET @ReportString = @ReportString + ', @DateFrom = ' + CAST(@DateFrom AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @DateTo = ' + CAST(@DateTo AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @AssessmentTypeID_LIST = ' + CASE WHEN LEN(@AssessmentTypeID_LIST)=0 THEN 'NULL' ELSE @AssessmentTypeID_LIST END
		IF @ReportFilterID1>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID1 = ' + CAST(@ReportFilterID1 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID_LIST1 = ' + CASE WHEN LEN(@FilterID_LIST1)=0 THEN 'NULL' ELSE @FilterID_LIST1 END
			SET @ReportString = @ReportString + ', @FilterText_LIST1 = ' + CASE WHEN LEN(@FilterText_LIST1)=0 THEN 'NULL' ELSE @FilterText_LIST1 END
		END
		IF @ReportFilterID2>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID2 = ' + CAST(@ReportFilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID_LIST2 = ' + CASE WHEN LEN(@FilterID_LIST2)=0 THEN 'NULL' ELSE @FilterID_LIST2 END
			SET @ReportString = @ReportString + ', @FilterText_LIST2 = ' + CASE WHEN LEN(@FilterText_LIST2)=0 THEN 'NULL' ELSE @FilterText_LIST2 END
		END
		SET @ReportString = @ReportString + ', @TransactionID = ' + CASE WHEN @TransactionID IS NULL THEN 'NULL' ELSE '''' + CAST(@TransactionID AS NVARCHAR(36)) + '''' END

		DECLARE @ResponseCount INT
		SELECT @ResponseCount = COUNT(ResponseID) FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID
		
		INSERT INTO dbo.QMS_PerformanceLog
				( Action ,
				  StartTime ,
				  EndTime ,
				  RecordsAffected
				)
		VALUES  ( @ReportString ,
				  @DateCalled ,
				  GETDATE() ,
				  @ResponseCount
				  )
	END

	SET NOCOUNT OFF
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_UnitQuantityReceived_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_UnitQuantityReceived_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 1/1/2017
-- Description:	Get E_text2 for intake
-- Version:	1
-- =============================================
-- JF TFS 82724 - pick up Unit quantity from Intake barcode
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_UnitQuantityReceived_Lookup] 
	@Barcode nvarchar(50)=null
AS
	--exec PM_QRY_Intake_UnitQuantityReceived_Lookup '8096'

	--if @Barcode = '8096g' 
	--	select 99 as PackQtyReceived
	--else if @Barcode is not null
	--	select 66 as PackQtyReceived
	--else 
	--	select 55 as PackQtyReceived
	SELECT     UnitQuantity as PackQtyReceived
	FROM         dbo.PM_VW_Goodsintake
	--WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)
	WHERE     (Barcode = dbo.FNC_BarcodeFormat(@Barcode))
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_E_DateTime1_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_E_DateTime1_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 1/1/2017
-- Description:	Get E_datetime1 for intake
-- Version:	1
-- =============================================
-- JF TFS 113401 - pick up e_datetime1 from Intake barcode
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_E_DateTime1_Lookup] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct E_DateTime1 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_IntakeCustomer_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_IntakeCustomer_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jeremy formby
-- Create date: 14/05/2018
-- Description:	Looks up intake customer
-- Version:		1
-- =============================================
-- JF TFS 113401 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_IntakeCustomer_Lookup]
	@Barcode nvarchar(100) = null
AS
BEGIN

	SELECT	PM_VW_Customer.CustomerID,PM_VW_Customer.Customername
	FROM	PM_VW_GoodsIntake INNER JOIN PM_VW_Customer on PM_VW_Customer.CustomerID= PM_VW_GoodsIntake.CustomerID 
	WHERE	PM_VW_GoodsIntake.Barcode = dbo.FNC_BarcodeFormat(@Barcode)
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ProductionJob_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ProductionJob_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets production job information to fill combo
-- Version:		2
-- =============================================
-- JF TFS 113552: Brought inline with generic integration
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ProductionJob_Combo] 
	@AssessmentTypeID INT = null
AS

	DECLARE @DownloadConsignmentDays int, @DateFrom datetime
	SET @DownloadConsignmentDays = ISNULL(dbo.FNC_GetOptionValue(101),0)
	
	IF @DownloadConsignmentDays = 0 
		SELECT @DateFrom = NULL
	ELSE
		SET @DateFrom = DATEADD(day,-@DownloadConsignmentDays,GETDATE())


	SELECT     
		ProductionJobID, 
		ISNULL(JobRef,
			LEFT ('000000', 6 - LEN(CAST(ProductionJobID AS nvarchar))) + CAST(ProductionJobID AS nvarchar) 
		) as ProductionNo
	FROM         
		PM_ProductionJob
	WHERE 
		Recordstatus<201 and (updated>@DateFrom or @DateFrom is Null)
	ORDER BY 
		ProductionNo DESC

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ProductionJob_Customer_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ProductionJob_Customer_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets production job - depot date 
-- Version:		1
-- =============================================
-- JF TFS 113552: 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ProductionJob_Customer_Combo] 
	@AssessmentTypeID INT = null,
	@ProductionJobID INT = null
AS

	select PM_Customer.CustomerID, CustomerName + '(' + CustomerCode + ')'
	from pm_productionjob 
	inner join PM_Customer on PM_Customer.customerid = pm_productionjob.customerid
	where ProductionJobID=@ProductionJobID
	
	
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ProductionJob_DepotDate_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ProductionJob_DepotDate_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets production job - depot date 
-- Version:		1
-- =============================================
-- JF TFS 113552: 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ProductionJob_DepotDate_Lookup] 
	@AssessmentTypeID INT = null,
	@ProductionJobID INT = null
AS

	select DepotDate from pm_productionjob where ProductionJobID=@ProductionJobID
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ProductionJob_FinishTime_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ProductionJob_FinishTime_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets production job - finish time
-- Version:		1
-- =============================================
-- JF TFS 113552: 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ProductionJob_FinishTime_Lookup] 
	@AssessmentTypeID INT = null,
	@ProductionJobID INT = null
AS

	select FinishTime from pm_productionjob where ProductionJobID=@ProductionJobID
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ProductionJob_Quantity_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ProductionJob_Quantity_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets production job - quantities
-- Version:		1
-- =============================================
-- JF TFS 113552: 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ProductionJob_Quantity_Lookup] 
	@AssessmentTypeID INT = null,
	@ProductionJobID INT = null,
	@ProductionLineID INT = null

AS
	IF @ProductionLineID IS NULL
		select Quantity from pm_productionjob where ProductionJobID=@ProductionJobID
	ELSE
		select Quantity from pm_productionjobline where ProductionLineID=@ProductionLineID

GO




PRINT 'Database updated successfully!'
GO

