-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_LocationList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_LocationList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 13/10/2010
-- Description:	Returns list of locations that user can access
-- Version:		2
-- =============================================
-- JT TFS 7139 - Added IsExplicitPermission to show whether user has been actively granted permission, or if it's given as part of an administrator's
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_LocationList] 
(
	@UserID int
)
RETURNS 
@Location TABLE 
(
	LocationID int,
	IsExplicitPermission bit
)
AS
BEGIN
	--Get table of available locations
	DECLARE @Table_Location TABLE (LocationID int)
	INSERT INTO @Table_Location (LocationID)
	SELECT     CAST(PermissionTitle AS int) AS LocationID
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 103) AND (PermissionAllow = 1) AND (UserID = @UserID)
	
	IF (SELECT COUNT(LocationID) FROM @Table_Location)>0 --Has restrictions
		INSERT INTO @Location (LocationID, IsExplicitPermission)
		SELECT     LocationID, 1
		FROM         @Table_Location
	ELSE --All locations
		INSERT INTO @Location (LocationID, IsExplicitPermission)
		SELECT     LocationID, 0
		FROM         PM_VW_Location
		
	RETURN 
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_CorrectiveAction_Response')
	EXEC('CREATE FUNCTION [dbo].[FNC_CorrectiveAction_Response]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 15/02/2012
-- Description:	Returns a list of all CA's and their associated responses
-- Version:		2
-- =============================================
-- JE TFS 13-7950: added SELECT for CAs logged from an Ad Hoc CA
-- =============================================
ALTER FUNCTION [dbo].[FNC_CorrectiveAction_Response]
(	
)
RETURNS TABLE 
AS
RETURN 
(
	--Ad-Hoc CA's (no ResponseID)
	SELECT	CorrectiveActionID, SourceObjectID As ResponseID
	FROM	QMS_CorrectiveAction
	WHERE	CASourceID = 4
	UNION
	--CA's directly from a Response
	SELECT	CorrectiveActionID, SourceObjectID AS ResponseID
	FROM	QMS_CorrectiveAction
	WHERE	CASourceID = 1 
	UNION
	--CA's logged from a ResponseQuestion
	SELECT	CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction INNER JOIN
				QMS_ResponseQuestion ON QMS_CorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	CASourceID = 2
	UNION
	--CA's logged from another CA
	SELECT	CA_1.CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction CA_1 INNER JOIN
				QMS_CorrectiveAction CA_2 ON CA_1.SourceObjectID = CA_2.CorrectiveActionID INNER JOIN
				QMS_ResponseQuestion ON CA_2.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	CA_1.CASourceID = 3
	UNION
	--CAs logged from another Ad Hoc CA
	SELECT	CA_1.CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction  CA_1 INNER JOIN
				QMS_CorrectiveAction CA_2 ON CA_1.SourceObjectID = CA_2.CorrectiveActionID LEFT OUTER JOIN
				QMS_ResponseQuestion ON CA_2.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	(CA_1.CASourceID) = 3 AND (QMS_ResponseQuestion.ResponseQuestionID IS NULL)
)
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionPool_ListByAssessmentType')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionPool_ListByAssessmentType] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 09/04/2009
-- Description:	Gets all questions included in assessments
-- Version:		5
-- =============================================
-- Jonathan Toolan - 9 Sep 2011: Added link to only display questions that have a response.
-- Markp 12/07/12 used temp table to gather data to improve performance
-- TC 19/06/18 tfs 13-101321
-- =============================================
ALTER PROCEDURE [dbo].[QRY_QuestionPool_ListByAssessmentType] 
	@AssessmentTypeID int
AS

    DECLARE @Question TABLE (QuestionID int)

    SET NOCOUNT ON

    ;WITH Question AS(
    SELECT DISTINCT QMS_AssessmentQuestion.QuestionID
      FROM dbo.QMS_AssessmentQuestion
      JOIN QMS_Response ON QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID
     WHERE (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_Response.RecordStatus < 201) AND (QMS_Response.AssessmentTypeID = @AssessmentTypeID))

    SELECT DISTINCT 
           QuestionID
         , Question
      FROM dbo.QMS_QuestionPool
     WHERE (RecordStatus < 201) 
       AND (QuestionID IN (SELECT QuestionID FROM Question))
  ORDER BY Question
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ResponseSummary_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 14/10/08
-- Description:	Fills TEMP_Selected with AssessmentID for checks to show on QC Summary report
-- Version:		10
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- MarkP: 04-May-2012 Added @AlertPeriod parameter
-- JE TFS 4853: changed filtering to new method
-- JT TFS 6689: Added DataWarehouse code.
-- MP TFS 8278: Removed tables APP_QAFlag and QMS_Assessment from statements as not required
-- JE TFS 13-3050: replaced CROSS JOIN with LEFT JOIN in main query as this didn't work correctly when @AssessmentTypeID_LIST = NULL
-- JT TFS 13-12688: Log ResponseIDs to DEBUG tables to determine source of issues with daily reports.
-- JT TFS 13-17467: Only include multicheck items which are suitable for adding to the data warehouse.
-- JF TFS 100485: Aldi Sd - QC Check Summary Report - Option to Show/Hide records with no comments or check responses
-- =============================================
ALTER PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] 
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(100) = NULL,
	@AssessmentID int = NULL,
	@AlertPeriod tinyint = NULL,
	@UserID int,
	@FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
	@HideEmptyChecks bit = 0
AS
BEGIN
	SET NOCOUNT ON

	--test params
	-- declare @AssessmentTypeID_LIST nvarchar(100) = NULL,  @DateFrom datetime = '1 may 2018 02:00:00',  @DateTo datetime = '10 Jun 2018 23:59:59', @AlertPeriod tinyint = null,  @UserID int = 1, @FilterApplied bit = 0, @AssessmentID int = 1124, @HideEmptyChecks bit = 0

	DECLARE @UseDataWarehouse bit
	SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)

	--get config value for Override QAFlag
	DECLARE @OverrideFlag bit
	SET @OverrideFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	DECLARE @Table_Response TABLE (ResponseID int)
	IF ISNULL(@AlertPeriod,0) IN (2,5,6,7) --Hourly, Daily, Weekday, Weekend alerts - filter by uploaded time
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     User_ResponseList.ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, DATEADD(day, - 1, @DateFrom), @DateTo) AS User_ResponseList 
		INNER JOIN	QMS_Response ON User_ResponseList.ResponseID = QMS_Response.ResponseID
		WHERE	(User_ResponseList.ResponseStatus = 1) 
		AND		dbo.FNC_Response_ShouldIncludeInDataWarehouse(User_ResponseList.ResponseID) = 1
		AND (
				((QMS_Response.Uploaded IS NULL) AND (QMS_Response.EndDate BETWEEN @DateFrom AND @DateTo)) 
			OR	(QMS_Response.Uploaded BETWEEN @DateFrom AND @DateTo)
			)
		AND 
		(
			--count the null assessment questions
			(SELECT COUNT(QMS_ResponseQuestion.ResponseID) FROM QMS_ResponseQuestion WHERE (QuestionComments IS NULL and QMS_ResponseQuestion.response_text is null and QMS_Response.Comments is null) and QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID ) 
			<>
			--count the total assessment questions
			(SELECT COUNT(QMS_ResponseQuestion.ResponseID) FROM QMS_ResponseQuestion WHERE QMS_ResponseQuestion.ResponseID = User_ResponseList.ResponseID ) 
			OR 
			@HideEmptyChecks=0
		)


	END
	ELSE
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     User_ResponseList.ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) as User_ResponseList
		INNER JOIN	QMS_Response ON User_ResponseList.ResponseID = QMS_Response.ResponseID
		WHERE     (User_ResponseList.ResponseStatus = 1)
		AND		dbo.FNC_Response_ShouldIncludeInDataWarehouse(User_ResponseList.ResponseID) = 1
		AND 
		(
			--count the null assessment questions
			(SELECT COUNT(QMS_ResponseQuestion.ResponseID) FROM QMS_ResponseQuestion WHERE (QuestionComments IS NULL and QMS_ResponseQuestion.response_text is null and QMS_Response.Comments is null) and QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID ) 
			<>
			--count the total assessment questions
			(SELECT COUNT(QMS_ResponseQuestion.ResponseID) FROM QMS_ResponseQuestion WHERE QMS_ResponseQuestion.ResponseID = User_ResponseList.ResponseID ) 
			OR 
			@HideEmptyChecks=0
		)




	END

	SET NOCOUNT OFF

	IF (@UseDataWarehouse = 1)
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT RPT_Warehouse_Response.ResponseID, @UserID AS UserID
		FROM         RPT_Warehouse_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON RPT_Warehouse_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON RPT_Warehouse_Response.QAFlagID = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR RPT_Warehouse_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (RPT_Warehouse_Response.AssessmentID = @AssessmentID)
		)
	END
	ELSE
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT QMS_Response.ResponseID, @UserID AS UserID
		FROM         QMS_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON QMS_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON  --check config value to join on Actual or Override QAFlagID
						  (CASE WHEN @OverrideFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END) = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR QMS_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (dbo.QMS_Response.AssessmentID = @AssessmentID)
		)
	END

END
GO


PRINT 'Database updated successfully!'
GO

