-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ISOCode' AND Object_ID = Object_ID(N'APP_Country'))

alter table dbo.APP_Country add
	ISOCode nvarchar(10)


	IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_Country')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_Country] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	11 Apr 2017
-- Description:	[insert description here]
-- Version:		3
-- ===================================================
-- JMF TFS 96385 syn ISO code
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_Country] 
	@CountryID int,
	@Country nvarchar(255),
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@ResourceName nvarchar(255),
	@ISOCode nvarchar(10)=null,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM APP_Country WHERE (CountryID = @CountryID))
BEGIN --Append record
	INSERT INTO APP_Country
                      (CountryID, Country, Updated, GUID, ResourceName,IsoCode)
	VALUES     (@CountryID,@Country,@Updated,@GUID,@ResourceName,@IsoCode)
	SET @InsertCount = @@rowcount
END

ELSE
BEGIN --Update record
	UPDATE    APP_Country
	SET              Country = @Country, Updated = @Updated, ResourceName = @ResourceName,IsoCode=@IsoCode
	WHERE     (CountryID = @CountryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



-- BEGIN DATA OFFICE_CorrectiveAction_UTCOffset
BEGIN TRY
-- We need a UTC offset column. 99.995% of the time it will be the same for all dates in the table.
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_CorrectiveAction' AND c.name = 'UTCOffset' )
	ALTER TABLE QMS_CorrectiveAction ADD UTCOffset float
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA OFFICE_CorrectiveAction_UTCOffset', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA OFFICE_CorrectiveAction_UTCOffset

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	19
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- SS TFS 13-49897: Added ISNULL(Uploaded, EndDate) so that EndDate will be used if Uploaded contains a NULL Value
-- PH TSF 13-61027 : v16 18/11/2016 - Bug Fix.  When including checks from the datawarehouse for todays date, an assumption was made that the datawarehouse had been updated before @DateFrom.  
--                   However, if this was not the case then checks were included from the past (but after the warehouse had been updated).  The greater of the datawarehouse update time and @DateFrom is now used.
-- JT TFS 13-82627 : Fix issue of Uploaded results appearing on QC Checks screen not in the date range specified.
-- JT TFS 13-88313 : Only merge results from warehouse within the date range specified.
-- JT TFS 13-500241 : Add customer direct permissions.
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	-- This will contain responses which are not in the warehouse, typically those with today's date.
	DECLARE @UnfilteredResponseNotInWarehouse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	-- The datawarehouse can still be used when the user filters after the last warehouse build, but it will not contain much (if any) useful checks.
	-- We insert all the recent checks into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date.
	-- Just because the date range in entirely contained within the warehouse, doesn't mean that we only search in the warehouse. 
	-- Checks uploaded after the last warehouse build, but whose EndDate is within that range need to be included, as do incomplete checks (ResponseStatus 0)
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
	BEGIN
		DECLARE @override bit 
		SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

		DECLARE @ResponseFromDate datetime
		SELECT @ResponseFromDate = CASE WHEN @WarehouseBuildDate > @DateFrom THEN @WarehouseBuildDate ELSE @DateFrom END
			
		-- Get the majority of checks which will not be in the warehouse - the ones added after the warehouse has been built.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND EndDate BETWEEN @ResponseFromDate AND @DateTo


		-- Make sure we include the checks uploaded after the warehouse was last built, but within the entire date range. They will not yet be in the warehouse.
		-- Also, we have to make sure that incomplete checks get included, since they are never put in the warehouse.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND (Uploaded > @WarehouseBuildDate OR ResponseStatus = 0)
		AND EndDate BETWEEN @DateFrom AND @DateTo
		AND ResponseID NOT IN (SELECT ResponseID FROM @UnfilteredResponseNotInWarehouse)


		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponseTodaysDate
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
		
		-- Customer ID can be gleaned from the warehouse, or from the stockcode that the check is linked to.
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			UPDATE	UnfilteredResponseTodaysDate
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponseTodaysDate.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponseTodaysDate.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
			
			UPDATE	UnfilteredResponseTodaysDate
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE UnfilteredResponseTodaysDate.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponseTodaysDate
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)


		-- Include checks from the warehouse.
		INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
		FROM		RPT_Warehouse_Response 
		INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
		WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
		AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
		AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate
						WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = RPT_Warehouse_Response.SupplierID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			-- We do not currently store the CustomerID in the data warehouse. If we did, this section would be more in line with the others.
			UPDATE	UnfilteredResponse
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponse.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponse.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
		
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
						PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
			WHERE UnfilteredResponse.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

		INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
		SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseNotInWarehouse
	END
	ELSE --don't use warehouse table
	BEGIN
		DECLARE @OverrideOption bit 
		SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
		INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			UPDATE	UnfilteredResponse
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponse.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponse.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
			
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE UnfilteredResponse.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END
		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_UserList')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_UserList]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2009
-- Description:	Gets all users that should be notified for a check
-- Version:		9
-- =============================================
-- JE updated 10/01/2012 - Added filter by Business Group
-- JT TFS 4194 - 14/08/2012 - when @StockCodeID is null, we don't want to filter out users with 
--							  stockcode/sub-group/business unit permissions
-- MP TFS 6422 - fix to handle supplier site permissions
-- JE TFS 8956: alerts no longer go to all Supplier users when no Supplier captured in header
-- TC Re-written to make more performant for larger data sets.
/*
    Example call:
    SELECT * FROM [dbo].[FNC_Response_UserList](336) ORDER BY UserId
*/
-- JT TFS 95216: suppliersite permissions being picked up in error
-- TC TFS 95787: Use new responseheader_stockcode function to prevent parameter sniffing.
-- JT TFS 95842: Use merged fnc_response_Stockcode function.
-- JT TFS 100241: Merge customer permissions so that a CustomerID missing from the PM_StockCode table does not restrict direct response permissions.
-- =============================================
ALTER FUNCTION [dbo].[FNC_Response_UserList] 
(
	@ResponseID int
)
RETURNS TABLE 
AS
RETURN
    SELECT DISTINCT U.UserId
      FROM QMS_User U
     WHERE 1=1
       
       --Get stock code from response header, consignment item and delivery item 
       AND (NOT EXISTS (SELECT * 
                         FROM VW_PermissionLink PL1 
                        WHERE U.UserID = PL1.UserID 
                          AND PL1.PermissionAllow = 1 
                          AND PL1.StockCodeID IS NOT NULL 
                          AND PL1.PermissionType IN (101,102,103,104,105,106) 
                          --Only do this if we have a stock code
                          AND (SELECT COUNT(*) 
                                 FROM dbo.FNC_Response_StockCodeID(@ResponseId) A 
                                ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL2 
                          INNER JOIN dbo.FNC_Response_StockCodeID(@ResponseId) STK 
                               ON PL2.StockCodeID = STK.StockCodeID 
                               AND PL2.PermissionType = 104 --Stock Code Permission Type
                               AND PL2.UserID = U.UserID))
      
       --Get location from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL3 
                         WHERE U.UserID = PL3.UserID 
                           AND PL3.PermissionAllow = 1 
                           AND PL3.LocationID IS NOT NULL 
                           AND PL3.PermissionType IN (1, 101,102,103,104,105,106) 
                           --Only do this if we have a location
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_LocationID() B 
                                 WHERE B.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL4 
                          JOIN dbo.FNC_ResponseHeader_LocationID() LOC 
                               ON PL4.LocationID = LOC.LocationID 
                               AND LOC.ResponseId = @ResponseId 
                               AND PL4.PermissionType = 103 --Location Permission Type
                               AND PL4.UserID = U.UserID))
        
       --Get supplier from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL5 
                         WHERE U.UserID = PL5.UserID 
                           AND PL5.PermissionAllow = 1 
                           AND PL5.SupplierID IS NOT NULL 
                           AND PL5.PermissionType IN (101,102,103,104,105,106))
                           --No restriction for Supplier to exist in the header to accomodate TFS 8956.
            --All Supplier users aren't notified when no Supplier captured
             OR EXISTS (SELECT * 
              FROM VW_PermissionLink PL6 
                          JOIN dbo.FNC_ResponseHeader_SupplierID() SUP 
                               ON PL6.SupplierID = SUP.SupplierID 
                               AND SUP.ResponseId = @ResponseId 
                               AND PL6.PermissionType = 101 --Supplier Permission Type
                               AND PL6.UserID = U.UserID))
     
       --Get customer from response header or StockCode table.
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL7 
                         WHERE U.UserID = PL7.UserID 
                           AND PL7.PermissionAllow = 1 
                           AND PL7.CustomerID IS NOT NULL 
                           AND PL7.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a customer or a stockcode linked to the response.
                           AND (	(SELECT COUNT(*) 
									 FROM dbo.FNC_ResponseHeader_CustomerID() D 
									 WHERE D.ResponseId = @ResponseId) > 0
								 OR (SELECT COUNT(*) 
                                     FROM dbo.FNC_Response_StockCodeID(@ResponseId)) > 0
						   ) 
					)
			 -- Get customer directly from permission table.
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL8 
                          JOIN dbo.FNC_ResponseHeader_CustomerID() CUS 
                               ON PL8.CustomerID = CUS.CustomerID 
                               AND CUS.ResponseId = @ResponseId 
                               AND PL8.PermissionType = 102 --Customer Permission Type
                               AND PL8.UserID = U.UserID)
             -- Get customer assigned to stock code
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL12 
                          JOIN PM_VW_StockCode SC1 
                               ON U.UserID = PL12.UserID 
                               AND PL12.PermissionType = 102 --Customer Permission Type (again)
                               AND PL12.CustomerID = SC1.CustomerID 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK2 
                                           WHERE SC1.StockCodeID = STK2.StockCodeID 
                                            ))
       )
      
       --Get supplier site from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL9 
                         WHERE U.UserID = PL9.UserID 
                           AND PL9.PermissionAllow = 1 
                           AND PL9.LocationID IS NOT NULL 
                           AND PL9.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a supplier
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_SupplierSiteID() E 
                                 WHERE E.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL10 
                          JOIN dbo.FNC_ResponseHeader_SupplierSiteID() SUPS 
                               ON PL10.LocationID = SUPS.LocationID 
                               AND SUPS.ResponseId = @ResponseId 
                               AND PL10.PermissionType = 103 --Supplier Site Permission Type
                               AND PL10.UserID = U.UserID))

       --accomodate TFS 2565 by joining to PM_VW_StockCode then onto FNC_ResponseHeader_StockCodeID function
 -----------------------------------------------------------------------------------------------------------------
       --Get Business Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL13 
                         WHERE U.UserID = PL13.UserID 
                           AND PL13.PermissionAllow = 1 
                           AND PL13.BusinessGroup IS NOT NULL 
                           --Only do this if we have a Business Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) F 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL14 
                          INNER MERGE JOIN PM_VW_StockCode SC2 
                               ON U.UserID = PL14.UserID 
                               AND PL14.PermissionType = 106 --Business Group Permission Type
                               AND PL14.BusinessGroup = SC2.BusinessGroup 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK3 
                                           WHERE SC2.StockCodeID = STK3.StockCodeID 
                                             )))
 
       --Get Stock Code Sub Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL15 
                         WHERE U.UserID = PL15.UserID 
                           AND PL15.PermissionAllow = 1 
                           AND PL15.StockCodeSubGroup IS NOT NULL 
                           --Only do this if we have a Stock Code Sub Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) G 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL16 
                          JOIN PM_VW_StockCode SC3 
                               ON U.UserID = PL16.UserID 
                               AND PL16.PermissionType = 105 --Stock Code Sub Group Permission Type
                               AND PL16.StockCodeSubGroup = SC3.StockCodeSubGroup 
                               AND EXISTS (SELECT * 
                                             FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK4 
                                            WHERE SC3.StockCodeID = STK4.StockCodeID 
                                              )))

       -----------------------------------------------------------------------------------------------------------------
       AND U.LeftCompany = 0
       AND U.RecordStatus < 201
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'VW_LastResponseAction')
	EXEC ('CREATE VIEW [dbo].[VW_LastResponseAction] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonny Miles
-- Create date: 31/05/2018
-- Description:	Gets the last action performed on each QC Check
-- Version:		1
-- =============================================
-- TFS 98166: Created
-- =============================================

ALTER VIEW [dbo].[VW_LastResponseAction] 
AS
  SELECT qmsResponseAction.responseid, 
         appQaAction.qaaction         AS QCActionTaken, 
         qmsResponseAction.actiondate AS ActionTakenOn, 
         qmsUser.fullname             AS ActionCreatedBy, 
         qmsResponseAction.comments   AS ActionComments, 
         appQAFlag.qaflag             AS ActionQAFlag 
  FROM   dbo.qms_responseaction AS qmsResponseAction 
         LEFT OUTER JOIN dbo.app_qaaction AS appQaAction 
                      ON appQaAction.qaactionid = qmsResponseAction.qaactionid 
         LEFT OUTER JOIN dbo.qms_user AS qmsUser 
                      ON qmsUser.userid = qmsResponseAction.userid 
         LEFT OUTER JOIN dbo.app_qaflag AS appQAFlag 
                      ON appQAFlag.qaflagid = qmsResponseAction.action_qaflagid 
         INNER JOIN (SELECT responseid, 
                            Max(actiondate) AS LastActionDate 
                     FROM   dbo.qms_responseaction AS qmsResponseAction 
                     GROUP  BY responseid) AS lastActions 
                 ON lastActions.responseid = qmsResponseAction.responseid 
                    AND lastActions.lastactiondate = 
                        qmsResponseAction.actiondate 


GO




IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList_WithActionInfo]'))
BEGIN TRY
	     DROP PROCEDURE [dbo].[QRY_Response_PreviousList_WithActionInfo]
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DROP [dbo].[QRY_Response_PreviousList_WithActionInfo]', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- =============================================
-- Author:		Jonny Miles
-- Create date: 30/05/2018
-- Description:	Gets list of previous responses, with action data included
-- Version:		1
-- =============================================
-- TFS 98166: Created
-- =============================================
CREATE PROCEDURE [dbo].[QRY_Response_PreviousList_WithActionInfo]
--DECLARE
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport

		--SELECT  @AssessmentTypeID = 6,  @DateFrom = '1 Aug 2017 00:00:00',  @DateTo = '15 Sep 2017 23:59:59',  @UserID = 1,  @ShowOutstanding = 1,  @DisplayMode = 1
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

	UPDATE TEMP_Selected SET SelectedValue = dbo.FNC_Response_IsMultiCheck(SelectedID ) WHERE (UserID = @UserID);
    
	SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) as QAFlag,
                QMS_Response.Override_QAFlagID, 
				ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
				QAFlag_Override.QAFlag) as Override_QAFlag,
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName,
				vwLastResponseAction.[QCActionTaken],
				vwLastResponseAction.[ActionTakenOn],
				vwLastResponseAction.[ActionCreatedBy],
				vwLastResponseAction.[ActionComments],
				vwLastResponseAction.[ActionQAFlag]
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag AS APP_QAFlag_1
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE   AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			--SELECT 
			--		UserID = @UserID, 
			--		AssessmentID = @AssessmentID,
			--		AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
			--		ShowOutstanding = @ShowOutstanding,
			--		multiCheckDisplay = @multiCheckDisplay

		     EXEC QRY_Response_PreviousList_ShelfLife 
					@UserID = @UserID, 
					@AssessmentID = @AssessmentID,
					@AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
					@ShowOutstanding = @ShowOutstanding,
					@multiCheckDisplay = @multiCheckDisplay
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
					QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					--ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
					ISNULL(TEMP_Selected.SelectedValue,0) AS MultiCheckLevel,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			--LEFT OUTER JOIN	dbo.AQC_FNC_ResponseHeader() AS ResponseHeader
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments

						FROM	QMS_Attachment

						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201

						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
					
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag

						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
							AND TEMP_Selected.SelectedValue=1
						)
						OR
						(
							@multiCheckDisplay = 2
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
							AND TEMP_Selected.SelectedValue IN (1,2)
						)
						--OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
						OR TEMP_Selected.SelectedValue = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag, 							  
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								QAFlag,ResourceName 
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						--dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
						TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END
GO 
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList_WithActionInfo]') AND type in (N'P', N'PC'))
	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Failed to create [dbo].[QRY_Response_PreviousList_WithActionInfo]', ERROR_MESSAGE()
	FROM #tmpScriptName
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_DateAdd_ServerTime')
	EXEC('CREATE FUNCTION [dbo].[FNC_DateAdd_ServerTime]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Taj S
-- Create date: 31/05/2018
-- Description:	Date add function for QMS intervals using the instance timezone by default
-- Version: 1
-- =============================================
-- TS tfs 13-99836: Date add function for QMS intervals using the instance timezone by default

ALTER FUNCTION [dbo].[FNC_DateAdd_ServerTime] 
(
	@IntervalUnit nvarchar(10),
	@IntervalNumber int,
	@StartDate datetime
)
RETURNS datetime
AS
BEGIN
	
	DECLARE @Result datetime

	IF @StartDate IS NULL
		SET @StartDate = dbo.FNC_GetDate()

	SET @Result = CASE WHEN @IntervalUnit = 'mi' THEN
		DATEADD(minute, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'hh' THEN
		DATEADD(hour, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'dd' THEN
		DATEADD(day, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'wk' THEN
		DATEADD(week, @IntervalNumber, @StartDate)
	ELSE
		NULL
	END

	RETURN @Result

END



GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_CorrectiveAction_Escalation')
	EXEC ('CREATE PROCEDURE [dbo].[APP_CorrectiveAction_Escalation] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/08/2008
-- Description:	Generates escalation of failed corrective actions
-- Version:		7
-- =============================================
-- JT TFS 13-7950 - 6-Oct-14 - Copy across DateOccurred from previous failed CA.
-- JE TFS 13-12637	: updated QMS_CorrectiveActionUser after CA escalation
-- AC TFS 15148		: Only calls SAVE_CorrectiveActionUser for corrective actions have have been escalated
-- PH TFS 13-33834	: Reformatted to be more understandable
-- TS TFS 13-99836  : Refactor GetDate to Func_GetDate for Date Logged which uses the instance's utc offset
-- JF
-- =============================================
ALTER PROCEDURE [dbo].[APP_CorrectiveAction_Escalation]

AS
BEGIN

	--Update failed CA status
	EXEC UP_CorrectiveAction_DeadlineFailed

	DECLARE @EscalatedCorrectiveActions TABLE (CorrectiveActionID INTEGER)

	--Escalate failed CA
	INSERT INTO QMS_CorrectiveAction
	(
		CASourceID,
		SourceObjectID,
		CATitle,
		CASubTitle,
		CAReason,
		CARequired,
		CAStatusID,
		CorrectiveActionTypeID,
		CorrectiveActionEscalationID,
		NotificationGroupID,
		AssignUserID,
		PriorityLevelID,
		DateLogged,
		DateDeadline,
		Logged_UserID,
		Logged_MachineName,
		ActionTaken,
		Comments,
		DateOccurred,
		UTCOffset 
	)
	OUTPUT INSERTED.CorrectiveActionID
	INTO @EscalatedCorrectiveActions 
	SELECT
		3 AS CASourceID,
		QMS_CorrectiveAction_Failed.CorrectiveActionID,
		QMS_CorrectiveAction_Failed.CATitle,
		QMS_CorrectiveAction_Failed.CASubTitle,
		QMS_CorrectiveAction_Failed.CAReason,
		QMS_CorrectiveAction_Failed.CARequired,
		1 AS CAStatusID,
		QMS_CorrectiveAction_Failed.CorrectiveActionTypeID,
		QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID,
		QMS_CorrectiveActionEscalation.NotificationGroupID,
		QMS_CorrectiveActionEscalation.AssignUserID,
		QMS_CorrectiveActionEscalation.PriorityLevelID,
		dbo.FNC_GetDate() AS DateLogged,
		dbo.FNC_DateAdd (QMS_CorrectiveActionEscalation.IntervalUnit, QMS_CorrectiveActionEscalation.IntervalNumber,dbo.FNC_GetDate()) as DateDeadline,
		QMS_CorrectiveAction_Failed.Logged_UserID,
		QMS_CorrectiveAction_Failed.Logged_MachineName,
		QMS_CorrectiveAction_Failed.ActionTaken,
		QMS_CorrectiveAction_Failed.Comments,
		dbo.fnc_convertutcdate(dateadd(hour,-ISNULL(utcoffset,dbo.FNC_GetoptionValue(28)),DateOccurred)) as DateOccurred, 
		dbo.FNC_GetOptionValue(28)  
	FROM	QMS_CorrectiveAction AS QMS_CorrectiveAction_Failed
	INNER JOIN
	(
		SELECT
			CorrectiveActionEscalationID AS Initial_CorrectiveActionEscalationID,
			CorrectiveActionTypeID,
			ListIndex,
			(
				SELECT	MIN(ListIndex) AS MinIndex
				FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_2
				WHERE
					CorrectiveActionTypeID = QMS_CorrectiveActionEscalation_Initial.CorrectiveActionTypeID
					AND (ListIndex > QMS_CorrectiveActionEscalation_Initial.ListIndex)
			) AS NextListIndex
		FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_Initial
		WHERE
			(
				(
					SELECT	MIN(ListIndex) AS MinIndex
					FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_1
					WHERE
						CorrectiveActionTypeID = QMS_CorrectiveActionEscalation_Initial.CorrectiveActionTypeID
						AND ListIndex > QMS_CorrectiveActionEscalation_Initial.ListIndex
				)
			) IS NOT NULL
			AND RecordStatus < 201
	) AS CA_Escalation
		ON	QMS_CorrectiveAction_Failed.CorrectiveActionEscalationID = CA_Escalation.Initial_CorrectiveActionEscalationID
	INNER JOIN QMS_CorrectiveActionEscalation
		ON CA_Escalation.CorrectiveActionTypeID = QMS_CorrectiveActionEscalation.CorrectiveActionTypeID
		AND CA_Escalation.NextListIndex = QMS_CorrectiveActionEscalation.ListIndex
	LEFT OUTER JOIN
	(
		SELECT
			CASourceID,
			SourceObjectID AS CorrectiveActionID
		FROM	QMS_CorrectiveAction AS QMS_CorrectiveAction_1
		WHERE
			RecordStatus < 201
			AND CASourceID = 3
	) AS CA_Escalated
		ON QMS_CorrectiveAction_Failed.CorrectiveActionID = CA_Escalated.CorrectiveActionID
	WHERE
		CA_Escalated.CorrectiveActionID IS NULL
		AND QMS_CorrectiveActionEscalation.RecordStatus < 201
		AND QMS_CorrectiveAction_Failed.CAStatusID = 3

	--JE TFS 13-12637: update QMS_CorrectiveActionUser table for CA we've just escalated
	DECLARE @CorrectiveActionID int

	DECLARE cur CURSOR FOR SELECT CorrectiveActionID FROM @EscalatedCorrectiveActions
	OPEN cur

	FETCH NEXT FROM cur INTO @CorrectiveActionID

	WHILE @@FETCH_STATUS = 0 BEGIN
		EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
		FETCH NEXT FROM cur INTO @CorrectiveActionID
	END

	CLOSE cur    
	DEALLOCATE cur

	-- check for CA's that have failed after being escalated and set these to CAStatusID 7 (failed escalated)
	UPDATE	QMS_CorrectiveAction
	SET		CAStatusID = 7
	FROM	QMS_CorrectiveAction
	INNER JOIN QMS_CorrectiveAction AS CorrectiveAction_Dest
		ON QMS_CorrectiveAction.CorrectiveActionID = CorrectiveAction_Dest.SourceObjectID
	WHERE
		CorrectiveAction_Dest.CASourceID = 3
		AND QMS_CorrectiveAction.CAStatusID = 3

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_CorrectiveAction_DeadlineFailed')
	EXEC ('CREATE PROCEDURE [dbo].[UP_CorrectiveAction_DeadlineFailed] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/08/2008
-- Description:	Update status of corrective actions to failed if deadline exceeded
-- Version:		2
-- =============================================
-- j.toolan 7/3/12: Reset notification flag so emails go out.
-- =============================================
ALTER PROCEDURE [dbo].[UP_CorrectiveAction_DeadlineFailed] 

AS

UPDATE    QMS_CorrectiveAction
SET              CAStatusID = 3, NotificationSent = 0, DateFailed = GETDATE(), Updated = GETUTCDATE()
WHERE     (RecordStatus < 201) AND (CAStatusID <= 2) AND (DateDeadline < GETDATE())
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalItemCount_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/08/09
-- Description:	Lookup the Arrival quantity
-- Version:	3
-- Unit test:	PM_QRY_ArrivalItemCount_Lookup_TEST.sql
-- =============================================
-- JF TFS 92520 - Generic Integration -  Change Quantity Received lookup to read from PO data if intake data does not exist  
-- JF TFS 99832 - make sure data is returned from all code paths
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] 
	@GoodsIntakeID int = null,
	@Barcode nvarchar(50) = NULL,
	@ConsignmentItemID INT = null,
	@StockCodeID  INT = null,
	@ConsignmentID INT = null
AS

IF @Barcode IS NOT NULL 
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (Barcode = @Barcode)
	
ELSE IF @ConsignmentItemID IS NOT NULL and exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 6 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentItemID = @ConsignmentItemID

ELSE IF @StockCodeID IS NOT NULL and @ConsignmentID IS NOT NULL AND exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  SUM(QuantityReceived) as QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentID = @ConsignmentID and StockCodeID = @StockCodeID

ELSE IF @GoodsIntakeID IS NOT NULL
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
--ELSE
--	SELECT null as ItemCount


GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_IntakeCountry_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jeremy formby
-- Create date: 14/05/2018
-- Description:	Looks up intake country
-- Version:		1
-- =============================================
-- JMF TFS 96385 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup]
	@Barcode nvarchar(100) = null
AS
BEGIN
	SELECT	APP_Country.CountryID,APP_Country.Country + ' ('   + APP_Country.ISOCode  + ')' as Country
	FROM	PM_VW_GoodsIntake INNER JOIN APP_Country on APP_Country.CountryID = PM_VW_GoodsIntake.CountryID 
	WHERE	PM_VW_GoodsIntake.Barcode = @Barcode
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCodeBusinessUnit_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCodeBusinessUnit_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/03/2012
-- Description:	Returns distinct list of Stock Code Business Units
-- Version: 3
-- =============================================
-- JE TFS 3922 - added user permission filtering
-- JE TFS 13-4352: added Hide filter so old Business Units not shown
-- JMF TFS 96385 - lookup business unit from StockcodeID if trigger enabled
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCodeBusinessUnit_Combo]
	@UserID int = NULL,
	@StockCodeID int = null
AS
BEGIN

	--get table of available business groups
	DECLARE @Table_BusinessGroup TABLE (BusinessGroup nvarchar(100))
	INSERT INTO @Table_BusinessGroup (BusinessGroup)
	SELECT     PermissionTitle
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 106) AND (PermissionAllow = 1) AND (UserID = @UserID)

	Declare @FilterOnStockCode bit = 0
	if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 73 and enabled = 1)
		IF @StockCodeID IS NOT NULL
			SELECT @FilterOnStockCode=1
			


	--check business groups exist
	IF (SELECT COUNT(BusinessGroup) FROM @Table_BusinessGroup)>0 
		SELECT DISTINCT BusinessUnit
		FROM			PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS StockCodeList ON PM_VW_StockCode.StockCodeID = StockCodeList.StockCodeID
		WHERE			
			BusinessGroup IN (SELECT BusinessGroup FROM @Table_BusinessGroup) AND 
			(Hide = 0) AND
			(PM_VW_StockCode.StockCodeID = @StockCodeID OR @FilterOnStockCode=0)
		ORDER BY		BusinessUnit

	ELSE
		
		SELECT DISTINCT BusinessUnit
		FROM			PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS StockCodeList ON PM_VW_StockCode.StockCodeID = StockCodeList.StockCodeID
		WHERE		
			(BusinessGroup IS NOT NULL) AND 
			(Hide = 0) AND
			(PM_VW_StockCode.StockCodeID = @StockCodeID OR @FilterOnStockCode=0)
		ORDER BY		BusinessUnit


END



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_Alert')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_Alert] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Gets list of users to notify for specific corrective action
-- Version:		16
-- =============================================
-- JE TFS 2947 - use Failure_NotificationGroupID for Completed CA's
-- JE TFS 2948 - get linked Supplier users for Signed-off CA's
-- JT TFS 3052 - new CAs for AssignSupplierID get an alert, too.
-- JT TFS 3054 - SP now handles all status/assignment cases.
-- JT TFS 3067 - SP handles reminder alerts too.
-- JT TFS 3077 - Returns CAStatus for email content.
-- JE TFS 7700 - added Logged_UserID to recipient list for sign-off alert
-- JE TFS 7877 - corrected above change to alert Logged_UserID for CA PENDING sign-off
-- JE TFS 13-4921: added CompletedByUser column
-- JE TFS 13-6298: added Location permissions check for Failed CAs
-- JE TFS 13-6298: added Location permissions check for all CA statuses
-- JE TFS 13-8940: amended query to populate @UserList so admin users are included
-- JT TFS 13-88643: Report UTCOffset back to email notification
-- JT TFS 13-88643: Always return same column names for first query (with NULL for impossible columns)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_Alert]
	@CorrectiveActionID int,
	@IsReminderAlert bit = 0
AS

-- TEST DATA: 
-- DECLARE @CorrectiveActionID int = 18507, @IsReminderAlert bit = 0
BEGIN
	--Get location for check to filter users
	DECLARE		@LocationID int, 
				@CASource int, 
				@CAStatusID int,
				@CAStatus nvarchar(255),
				@NotificationGroupID int, 
				@FailureNotificationGroupID int,
				@AssignUserID int,
				@AssignSupplierID int,
				@IsNotificationAlreadySent bit,
				@LoggedUserID int
			
	SET NOCOUNT ON

	--Get Corrective Action Source and Corrective Action Status, and destinations.
	SELECT		@CASource					= QMS_CorrectiveAction.CASourceID, 
				@CAStatusID					= QMS_CorrectiveAction.CAStatusID, 
				@CAStatus					= ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 1), APP_CorrectiveActionStatus.CAStatus),
				@NotificationGroupID		= QMS_CorrectiveAction.NotificationGroupID,
				@FailureNotificationGroupID	= QMS_CorrectiveActionEscalation.Failure_NotificationGroupID,
				@AssignUserID				= QMS_CorrectiveAction.AssignUserID,
				@AssignSupplierID			= QMS_CorrectiveAction.AssignSupplierID,
				@IsNotificationAlreadySent  = CASE	WHEN @IsReminderAlert = 0 AND NotificationSent = 1	THEN 1
													WHEN @IsReminderAlert = 1 AND ReminderSent = 1		THEN 1
																										ELSE 0 END,
				@LoggedUserID				= QMS_CorrectiveAction.Logged_UserID								
	FROM			QMS_CorrectiveAction
	LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
	LEFT OUTER JOIN	APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)

	-- Potentially short circuit the whole process if the notification has already gone.
	-- IF (@IsNotificationAlreadySent = 1) RETURN

	-- Get location
	IF @CASource = 1 --Get location from response header
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  QMS_CorrectiveAction ON QMS_ResponseHeader.ResponseID = QMS_CorrectiveAction.SourceObjectID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
							  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 2 --Response question
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseQuestion INNER JOIN
						  QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID INNER JOIN
						  QMS_ResponseHeader INNER JOIN
						  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID ON 
						  QMS_ResponseQuestion.ResponseID = QMS_ResponseHeader.ResponseID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
						  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 4 --Ad Hoc, so get Location CA has been assigned to
	BEGIN
		SELECT	@LocationID  = LocationID
		FROM	QMS_CorrectiveAction
		WHERE	(CorrectiveActionID = @CorrectiveActionID)
	END

	IF @LocationID IS NULL --Get location assigned to user
	BEGIN
		SELECT     @LocationID = QMS_User.LocationID
		FROM        QMS_User 
		INNER JOIN	QMS_CorrectiveAction ON QMS_User.UserID = QMS_CorrectiveAction.Logged_UserID
		WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	-- Get body details (for non-sent notifications).
	IF @CAStatusID IN (4)  --Completed CA
	BEGIN
		--Get Completed CA details for message body
		SELECT  QMS_CorrectiveAction.CATitle, 
				QMS_CorrectiveAction.CASubTitle, 
				QMS_CorrectiveAction.CAReason,
				QMS_CorrectiveAction.CARequired, 
				QMS_CorrectiveAction.DateLogged, 
				QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
				APP_PriorityLevel.PriorityLevel, 
				QMS_CorrectiveAction.DateDeadline, 
				QMS_CorrectiveAction.ActionTaken,
				convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
				@CAStatus as [CAStatus],
				QMS_User.FullName AS CompletedByUser,
				QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction 
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		LEFT OUTER JOIN QMS_User ON QMS_CorrectiveAction.Completed_UserID = QMS_User.UserID	
		WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	ELSE IF @CAStatusID IN (5) --Signed-off CA
	BEGIN
			--Get Signed-off CA details for message body
			SELECT		QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CASubTitle, 
						QMS_CorrectiveAction.CAReason, 
						QMS_CorrectiveAction.CARequired, 
						QMS_CorrectiveAction.DateLogged, 
						QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
						APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline, 
						QMS_CorrectiveAction.ActionTaken,
						QMS_User.UserName, -- Signed off user
						@CAStatus as [CAStatus],
						convert(nvarchar(255), NULL) AS CompletedByUser,
						QMS_CorrectiveAction.UTCOffset
			FROM			QMS_CorrectiveAction 
			INNER JOIN		QMS_User ON QMS_CorrectiveAction.SignOff_UserID = QMS_User.UserID 
			LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
			LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
			WHERE		(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
			AND			(@IsNotificationAlreadySent = 0)
	END
	ELSE -- Not Completed or Signed-off CA
	BEGIN
		--Get New CA details for message body
		SELECT      QMS_CorrectiveAction.CATitle, 
					QMS_CorrectiveAction.CASubTitle, 
					QMS_CorrectiveAction.CAReason, 
					QMS_CorrectiveAction.CARequired, 
					QMS_CorrectiveAction.DateLogged, 
					QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
					APP_PriorityLevel.PriorityLevel, 
					QMS_CorrectiveAction.DateDeadline,
					QMS_CorrectiveAction.ActionTaken,
					convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
					@CAStatus as [CAStatus],
					convert(nvarchar(255), NULL) AS CompletedByUser,
					QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		WHERE   (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		--AND		(QMS_CorrectiveAction.CAStatusID = 1) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	SET NOCOUNT OFF


	DECLARE @UserList TABLE (
		FullName nvarchar(256),
		Email nvarchar(256)
	)
	SET NOCOUNT ON

	IF @AssignUserID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) -- Individual user emails (New, In Progress, Signed-off, Rejected)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT		QMS_User.FullName, QMS_User.EMail
		FROM		QMS_User 
		WHERE   (QMS_User.UserID = @AssignUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	--Get list of users to include in alert (groupwise)
	IF @NotificationGroupID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --By group (not applicable for Signed-off CA)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT QMS_User.FullName,QMS_User.EMail
		FROM         QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @NotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	-- Suppliers get their own emails.
	IF @AssignSupplierID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --List of Suppliers linked to AssignSupplierID (everything except Completed)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User 
		INNER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID 
		WHERE	(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
		AND		(dbo.FNC_GetUserLevel(QMS_User.UserID) = 9) -- suppliers only.
		AND     (QMS_UserPermissions.PermissionTitle = @AssignSupplierID)
		AND		(QMS_UserPermissions.PermissionType = 101) 
		AND		(QMS_UserPermissions.PermissionAllow = 1)
	END

	--Get extra users to include in alert (owners of the CA alert (failure notification group))
	IF @FailureNotificationGroupID IS NOT NULL AND @CAStatusID IN (3, 4, 7) -- Failed, Completed, Failed (escalated)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT	QMS_User.FullName,QMS_User.EMail
		FROM        QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @FailureNotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	--get user who originally logged CA to include in notification list if CA is pending sign off (i.e. Completed)
	IF @LoggedUserID IS NOT NULL AND @CAStatusID = 4
	BEGIN
		INSERT INTO @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User
		WHERE	(QMS_User.UserID = @LoggedUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	SET NOCOUNT OFF

	SELECT FullName, Email FROM @UserList
END
GO



/****** Object:  StoredProcedure [dbo].[CUST_UNVBE_INT_Inbound_ProductSensitivity]    Script Date: 23/05/2018 11:48:36 ******/
SET ANSI_NULLS ON
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		17
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- PH TFS 13-21031: 10/06/2015 - Got rid of code smell that may have been causing bug.  New CorrectiveActionID obtained OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
-- PH TFS 13-23902: 15/07/2015 - SourceObjectID is nullable, so parameter should not be mandatory when saving an Ad Hoc corrective action
-- JT TFS 13-59936: 25/04/2017 - Allow 100 characters for CATitle (to reflect underlying table)
-- TS TFS 13-88643: 05/06/18 - Capture UTCOFfset
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int = NULL,
	@CATitle nvarchar(100),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		DECLARE @caIdTable TABLE (CorrectiveActionID int)

		DECLARE @UTCOffset FLOAT
		SET @UTCOffset = DATEDIFF(mi, GETUTCDATE(), GETDATE()) / 60

		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID, UTCOffset)
				OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID, @UTCOffset)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         @caIdTable
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Download_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Download_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/12/2008
-- Description:	Gets data to download for QMS_CorrectiveAction table
-- Version:		5
-- =============================================
-- JE TFS 7396 - added extra params for Sync process improvements
-- MP TFS 14225 - made SP more efficient and changed logic so that only CA's from that device are downloaded
-- JM TFS 88643 - Added UTC offset column
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Download_CorrectiveAction] 
	@ClientID int = NULL,
	@LastReceived bigint,
	@GetRecordCountOnly bit = 0,
	@TotalRecordCount int OUTPUT
AS

--DECLARE @ClientID int = 175, @LastReceived BIGINT=0,@GetRecordCountOnly bit = 0,@TotalRecordCount int 

--For new CA, only download from last 7 days
DECLARE @DateFrom datetime
SET @DateFrom = DATEADD(day, - 7, GETDATE())

--create temp table to hold filtered Corrective Actions
IF NULLIF(object_id('tempdb..#tmpCorrectiveAction'), 0) IS NOT NULL DROP TABLE #tmpCorrectiveAction
CREATE TABLE #tmpCorrectiveAction (CorrectiveActionID int)

INSERT INTO #tmpCorrectiveAction (CorrectiveActionID)
SELECT CorrectiveActionID
FROM     dbo.QMS_CorrectiveAction
WHERE  (@LastReceived > 0) AND (RowVersion > @LastReceived) AND (ClientID = @ClientID) OR
                  (ClientID = @ClientID) AND (Created > @LastReceived) AND (RecordStatus < 201) AND (Inserted > @DateFrom)

SET @TotalRecordCount = (SELECT	COUNT(CorrectiveActionID)
							FROM #tmpCorrectiveAction)

IF @GetRecordCountOnly = 0
	BEGIN

		SET NOCOUNT ON

		--Populate temp table with CorrectiveActions to download so that source GUID can be looked up
		DECLARE @UserID int
		SET @UserID = 9999

		DELETE FROM TEMP_Selected
		WHERE     (UserID = @UserID)

		INSERT INTO TEMP_Selected
							  (UserID, SelectedID)
		SELECT     @UserID AS UserID, CorrectiveActionID
		FROM         QMS_CorrectiveAction
		WHERE     CorrectiveActionID IN (SELECT	CorrectiveActionID
							FROM #tmpCorrectiveAction)

		SET NOCOUNT OFF

		SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CASourceID, QMS_CorrectiveAction.SourceObjectID, SourceGUID.SourceObject_GUID, 
							  QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, QMS_CorrectiveAction.CAStatusID, 
							  QMS_CorrectiveAction.CorrectiveActionTypeID, QMS_CorrectiveAction.CorrectiveActionEscalationID, QMS_CorrectiveAction.NotificationGroupID, 
							  QMS_CorrectiveAction.PriorityLevelID, QMS_CorrectiveAction.DateLogged, QMS_CorrectiveAction.DateOccurred, QMS_CorrectiveAction.DateDeadline, 
							  QMS_CorrectiveAction.Logged_UserID, QMS_CorrectiveAction.Logged_MachineName, QMS_CorrectiveAction.NotificationSent, QMS_CorrectiveAction.ActionTaken, 
							  QMS_CorrectiveAction.Comments, QMS_CorrectiveAction.DateCompleted, QMS_CorrectiveAction.Completed_UserID, QMS_CorrectiveAction.Completed_MachineName, 
							  QMS_CorrectiveAction.DateSignedOff, QMS_CorrectiveAction.SignOff_UserID, QMS_CorrectiveAction.SignOff_MachineName, QMS_CorrectiveAction.DateFailed, 
							  QMS_CorrectiveAction.CASubTitle, QMS_CorrectiveAction.AssignUserID, QMS_CorrectiveAction.AssignSupplierID, QMS_CorrectiveAction.ReminderDate, 
							  QMS_CorrectiveAction.ReminderSent, dbo.QMS_CorrectiveAction.LocationID, QMS_CorrectiveAction.UTCOffset,QMS_CorrectiveAction.RecordStatus, QMS_CorrectiveAction.Inserted, QMS_CorrectiveAction.Updated,
							  QMS_CorrectiveAction.Deleted, QMS_CorrectiveAction.GUID, QMS_CorrectiveAction.RowVersion, QMS_CorrectiveAction.Created
		FROM        #tmpCorrectiveAction AS FilteredCAs INNER JOIN 
						QMS_CorrectiveAction ON FilteredCAs.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID LEFT OUTER JOIN
							  dbo.FNC_CorrectiveAction_SourceGUID(@UserID) AS SourceGUID ON QMS_CorrectiveAction.CorrectiveActionID = SourceGUID.CorrectiveActionID
	END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	5 Jun 2018
-- Description:	[insert description here]
-- Version:		1
-- ===================================================
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_CorrectiveAction] 
	@CASourceID int,
	@SourceObject_GUID uniqueidentifier,
	@CATitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateOccurred datetime = NULL,
	@DateDeadline datetime,
	@Logged_UserID int,
	@Logged_MachineName nvarchar(50),
	@NotificationSent bit,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@DateFailed datetime,
	@CASubTitle nvarchar(50),
	@AssignUserID int,
	@AssignSupplierID int = NULL,
	@ReminderDate datetime = NULL,
	@ReminderSent bit = NULL,
	@LocationID INT = NULL,
	@UTCOffset float = NULL,
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

--Lookup SourceObjectID from GUID
DECLARE @SourceObjectID int
IF @CASourceID = 1 --Response
	SELECT @SourceObjectID = ResponseID FROM QMS_Response WHERE (GUID = @SourceObject_GUID)
IF @CASourceID = 2 --ResponseQuestion
	SELECT @SourceObjectID = ResponseQuestionID FROM QMS_ResponseQuestion WHERE (GUID = @SourceObject_GUID)
IF @CASourceID = 3 --CorrectiveAction
	SELECT @SourceObjectID = CorrectiveActionID FROM QMS_CorrectiveAction WHERE (GUID = @SourceObject_GUID)

IF @ReminderSent IS NULL
	SET @ReminderSent = 0

IF NOT EXISTS(SELECT * FROM QMS_CorrectiveAction WHERE (GUID = @GUID))
BEGIN --Append record
	IF @RecordStatus < 201 AND @CAStatusID < 3 --Dont append closed actions
	BEGIN
		INSERT INTO QMS_CorrectiveAction
                      (CASourceID, SourceObjectID, CATitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, PriorityLevelID, 
                      DateLogged, DateOccurred, DateDeadline, Logged_UserID, Logged_MachineName, NotificationSent, ActionTaken, Comments, DateCompleted, Completed_UserID, 
                      Completed_MachineName, DateSignedOff, SignOff_UserID, SignOff_MachineName, DateFailed, CASubTitle, AssignUserID, AssignSupplierID, ReminderDate, 
                      ReminderSent, LocationID, UTCOffset, RecordStatus, Inserted, Updated, Deleted, GUID)
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,@CorrectiveActionEscalationID,@NotificationGroupID,@PriorityLevelID,@DateLogged,@DateOccurred,@DateDeadline,@Logged_UserID,@Logged_MachineName,@NotificationSent,@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@DateSignedOff,@SignOff_UserID,@SignOff_MachineName,@DateFailed,@CASubTitle,@AssignUserID,@AssignSupplierID,@ReminderDate,@ReminderSent,@LocationID,
                       @UTCOffset, 30,@Inserted,@Updated,@Deleted,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_CorrectiveAction
	SET              CATitle = @CATitle, CAReason = @CAReason, CARequired = @CARequired, CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, 
                      CorrectiveActionEscalationID = @CorrectiveActionEscalationID, NotificationGroupID = @NotificationGroupID, PriorityLevelID = @PriorityLevelID, 
                      DateLogged = @DateLogged, DateOccurred = @DateOccurred, DateDeadline = @DateDeadline, Logged_UserID = @Logged_UserID, 
                      Logged_MachineName = @Logged_MachineName, NotificationSent = @NotificationSent, ActionTaken = @ActionTaken, Comments = @Comments, 
                      DateCompleted = @DateCompleted, Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, 
                      DateSignedOff = @DateSignedOff, SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, DateFailed = @DateFailed, 
                      CASubTitle = @CASubTitle, AssignUserID = @AssignUserID, AssignSupplierID = @AssignSupplierID, ReminderDate = @ReminderDate, 
                      ReminderSent = @ReminderSent, RecordStatus = CASE WHEN @RecordStatus < 30 THEN 30 ELSE @RecordStatus END, LocationID = @LocationID, 
                      UTCOffset = @UTCOffset, Inserted = @Inserted, Updated = @Updated, Deleted = @Deleted
	WHERE     (GUID = @GUID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Upload_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Upload_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	5 Jun 2018
-- Description:	[insert description here]
-- Version:		1
-- ===================================================
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Upload_CorrectiveAction] 
	@LastSent bigint,
	@MaxSent bigint OUTPUT
AS

--Get anchor value
SET NOCOUNT ON
DECLARE @MaxCreated bigint, @MaxRowVersion bigint

SELECT     @MaxCreated = MAX(Created), @MaxRowVersion = MAX(CAST(RowVersion AS bigint))
FROM         QMS_CorrectiveAction

IF @MaxRowVersion > @MaxCreated
	SET @MaxSent = @MaxRowVersion
ELSE
	SET @MaxSent = @MaxCreated

--Populate temp table with CorrectiveActions to download so that source GUID can be looked up
DECLARE @UserID int
SET @UserID = 9999

DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

INSERT INTO TEMP_Selected
                      (UserID, SelectedID)
SELECT     @UserID AS UserID, CorrectiveActionID
FROM         QMS_CorrectiveAction
WHERE     (RowVersion > @LastSent) OR
                      (Created > @LastSent) AND (RecordStatus < 201)

SET NOCOUNT OFF

SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CASourceID, QMS_CorrectiveAction.SourceObjectID, SourceGUID.SourceObject_GUID, 
                      QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, QMS_CorrectiveAction.CAStatusID, 
                      QMS_CorrectiveAction.CorrectiveActionTypeID, QMS_CorrectiveAction.CorrectiveActionEscalationID, QMS_CorrectiveAction.NotificationGroupID, 
                      QMS_CorrectiveAction.PriorityLevelID, QMS_CorrectiveAction.DateLogged, QMS_CorrectiveAction.DateDeadline, QMS_CorrectiveAction.Logged_UserID, 
                      QMS_CorrectiveAction.Logged_MachineName, QMS_CorrectiveAction.NotificationSent, QMS_CorrectiveAction.ActionTaken, QMS_CorrectiveAction.Comments, 
                      QMS_CorrectiveAction.DateCompleted, QMS_CorrectiveAction.Completed_UserID, QMS_CorrectiveAction.Completed_MachineName, 
                      QMS_CorrectiveAction.DateSignedOff, QMS_CorrectiveAction.SignOff_UserID, QMS_CorrectiveAction.SignOff_MachineName, QMS_CorrectiveAction.DateFailed, 
                      QMS_CorrectiveAction.CASubTitle, QMS_CorrectiveAction.AssignUserID, QMS_CorrectiveAction.DateOccurred, QMS_CorrectiveAction.AssignSupplierID, 
                      QMS_CorrectiveAction.ReminderDate, QMS_CorrectiveAction.ReminderSent, QMS_CorrectiveAction.LocationID, QMS_CorrectiveAction.UTCOffset, QMS_CorrectiveAction.RecordStatus, 
                      QMS_CorrectiveAction.Inserted, QMS_CorrectiveAction.Updated, QMS_CorrectiveAction.Deleted, QMS_CorrectiveAction.GUID, QMS_CorrectiveAction.RowVersion, 
                      QMS_CorrectiveAction.Created
FROM         QMS_CorrectiveAction LEFT OUTER JOIN
                      dbo.FNC_CorrectiveAction_SourceGUID(@UserID) AS SourceGUID ON QMS_CorrectiveAction.CorrectiveActionID = SourceGUID.CorrectiveActionID
WHERE     (QMS_CorrectiveAction.RowVersion > @LastSent) AND (QMS_CorrectiveAction.RecordStatus <> 30) OR
                      (QMS_CorrectiveAction.RecordStatus <> 30) AND (QMS_CorrectiveAction.Created > @LastSent)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_List] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	20/5/2014
-- Description:	Lists all corrective actions for corrective action manager screen.
-- Version:		6
-- ===================================================
-- JT TFS 13-3845: Created
-- JT TFS 13-7000: Order by DateOccurred DESC, so that any truncations chop off old CAs first.
-- JT TFS 13-8870: Add source column.
-- JE TFS 13-12640: use new function to get corrective actions from QMS_CorrectiveActionUser
-- JT TFS 13-55914: 08/09/2016 - Performance: Inline reviewers function, prepopulate CAStatus, CAResponses and AssignUsers.
-- JM TFS 88643: Include UTC offset
-- ===================================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_List]
	@UserID int = 1,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@IsFilterApplied bit = 0
AS
BEGIN
	/* NOTE: Supplier and location filters work differently. All other filters are response filters. */

	-- NOTE: DateDeadline is the first sort order for completed.
	--       DateFailed is the first sort order for failed.
	--       DateCompleted is the first sort order for signed off.

	BEGIN -- setup temp tables 
		SET NOCOUNT ON 
		
		IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
		CREATE TABLE #tmpUserCAs (
			CorrectiveActionID int
		)
		
		IF @IsFilterApplied = 1
		BEGIN
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT CorrectiveActionID FROM TEMP_CorrectiveActionFilter
			WHERE UserID = @UserID
		
		END ELSE BEGIN
		
			--temp table containing all CAs (i.e. all statuses) user has permission to see
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	dbo.FNC_CorrectiveActionUser_CAList(@UserID)
			
		END

		--populate temp table with CA refs and their Reviewers' names (inline FNC_CorrectiveAction_ReviewList for all CAs)
		IF nullif(object_id('tempdb..#tmpCAReviewers'), 0) IS NOT NULL DROP TABLE #tmpCAReviewers
		CREATE TABLE #tmpCAReviewers (
			CorrectiveActionID int,
			Reviewers nvarchar(500)
		)
		INSERT INTO #tmpCAReviewers (CorrectiveActionID, Reviewers)
		SELECT outerquery.CorrectiveActionID, results = substring((
			SELECT DISTINCT ', ' + FullName
			FROM QMS_RecordLock 
			INNER JOIN QMS_User ON QMS_RecordLock.UserID = QMS_User.UserID
			WHERE	(ObjectName = N'QMS_CorrectiveAction') 
			AND		(LockStatus = 100)
			AND		(RowGUID = outerquery.GUID)
			FOR XML PATH(''), type
		).value('/', 'nvarchar(max)'), 3, 99999)
		FROM QMS_CorrectiveAction outerquery
		GROUP BY outerquery.CorrectiveActionID, outerquery.GUID
		
		-- Lookup responseIDs for all corrective actions.
		IF NULLIF(object_id('tempdb..#tmpCAResponses'), 0) IS NOT NULL DROP TABLE #tmpCAResponses;
		CREATE TABLE #tmpCAResponses (
			CorrectiveActionID int,
			ResponseID int
		)
		INSERT #tmpCAResponses (CorrectiveActionID, ResponseID)
		SELECT CorrectiveActionID, ResponseID FROM dbo.FNC_CorrectiveAction_Response()

		-- prepopulate status lookups.
		IF NULLIF(object_id('tempdb..#tmpCAStatus'), 0) IS NOT NULL DROP TABLE #tmpCAStatus;
		SELECT	APP_CorrectiveActionStatus.CAStatusID,
				ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS [Status],
				IsOutstanding = CASE WHEN APP_CorrectiveActionStatus.CAStatusID < 3 THEN 1 ELSE 0 END,
				IsCompleted = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 4 THEN 1 ELSE 0 END,
				IsFailed = CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (3,6,7) THEN 1 ELSE 0 END,
				IsSignedOff = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 5 THEN 1 ELSE 0 END,
				CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (1,2) THEN 'new'
					 WHEN APP_CorrectiveActionStatus.CAStatusID IN (4,5) THEN 'completed'
																		 ELSE 'failed' END AS [StatusClass]
		INTO #tmpCAStatus
		FROM APP_CorrectiveActionStatus;


		-- Prepopulate IsAssignedToMe list (for easier lookup)
		IF NULLIF(object_id('tempdb..#tmpCAAssignUsers'), 0) IS NOT NULL DROP TABLE #tmpCAAssignUsers;
		SELECT CorrectiveActionID, UserID
		INTO #tmpCAAssignUsers
		FROM dbo.FNC_CorrectiveAction_AssignUsers() AssignUser 
		WHERE AssignUser.UserID = @UserID

		SET NOCOUNT OFF
	END 

	SELECT 
			QMS_CorrectiveAction.CorrectiveActionID,
			dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) AS CARef,
			CAResponseList.ResponseID,
			QMS_CorrectiveAction.CATitle,
			QMS_CorrectiveAction.CASubTitle,
			QMS_CorrectiveAction.CAReason,
			QMS_CorrectiveAction.CARequired,
			QMS_CorrectiveAction.ActionTaken,
			QMS_CorrectiveAction.Comments,
			APP_CorrectiveActionStatus.[Status],
			APP_CorrectiveActionStatus.[StatusClass],
			APP_PriorityLevel.PriorityLevel,
			QMS_CorrectiveAction.DateOccurred,
			QMS_CorrectiveAction.DateLogged,
			QMS_CorrectiveAction.DateDeadline,
			QMS_CorrectiveActionType.CorrectiveActionType,
			QMS_CorrectiveActionEscalation.ListIndex AS [EscalationLevel],
			PM_VW_Location.LocationName AS Location,
			ISNULL(QMS_NotificationGroup.NotificationGroup, ISNULL(QMS_User_Assign.FullName, Supplier_Assign.SupplierName)) AS [AssignedTo],
			QMS_User_Logged.FullName AS [LoggedBy],
			QMS_CorrectiveAction.DateFailed,
			QMS_CorrectiveAction.DateCompleted,
			QMS_User_Completed.FullName AS [CompletedBy],
			CAReviewers.Reviewers AS [ReviewedBy],
			QMS_User_SignedOff.FullName AS [SignedOffBy],
			QMS_CorrectiveAction.DateSignedOff,
			QMS_CorrectiveAction.CAStatusID,

			CASE WHEN QMS_CorrectiveAction.CASourceID = 4 THEN N'Ad-Hoc'
					 WHEN QMS_CorrectiveAction.CASourceID = 3 THEN N'CA: ' + dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.SourceObjectID)
					 WHEN QMS_CorrectiveAction.CASourceID = 2 THEN 'Question'
					 WHEN QMS_CorrectiveAction.CASourceID = 1 THEN 'Check'
			END AS [Source],

			APP_CorrectiveActionStatus.IsOutstanding,
			IsLoggedByMe = CASE WHEN QMS_CorrectiveAction.Logged_UserID = @UserID THEN 1 ELSE 0 END,
			IsAssignedToMe = CASE WHEN EXISTS (	SELECT * FROM #tmpCAAssignUsers AssignUser 
												WHERE AssignUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
												AND AssignUser.UserID = @UserID) THEN 1 ELSE 0 END,
			APP_CorrectiveActionStatus.IsCompleted,
			APP_CorrectiveActionStatus.IsFailed,
			APP_CorrectiveActionStatus.IsSignedOff,
			QMS_CorrectiveAction.UTCOffset
		
	FROM QMS_CorrectiveAction
	INNER JOIN #tmpUserCAs AS UserCAList ON QMS_CorrectiveAction.CorrectiveActionID = UserCAList.CorrectiveActionID
	INNER JOIN #tmpCAReviewers AS CAReviewers ON UserCAList.CorrectiveActionID = CAReviewers.CorrectiveActionID
	INNER JOIN #tmpCAResponses AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
	INNER JOIN #tmpCAStatus AS APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	INNER JOIN QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID
	LEFT OUTER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
	LEFT OUTER JOIN QMS_CorrectiveActionType ON QMS_CorrectiveActionType.CorrectiveActionTypeID = QMS_CorrectiveAction.CorrectiveActionTypeID 
	LEFT OUTER JOIN QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID
	LEFT OUTER JOIN QMS_User AS QMS_User_SignedOff ON QMS_CorrectiveAction.SignOff_UserID = QMS_User_SignedOff.UserID
	LEFT OUTER JOIN APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
	LEFT OUTER JOIN PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
	LEFT OUTER JOIN PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID 
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR QMS_CorrectiveAction.DateOccurred > @DateFrom)
	AND (@DateTo IS NULL OR QMS_CorrectiveAction.DateOccurred <= @DateTo)
	ORDER BY	QMS_CorrectiveAction.DateOccurred DESC,
				QMS_CorrectiveAction.CorrectiveActionID DESC

	--get list of columns that need to be hidden in Excel export
	--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
	SELECT	1 AS TableIndex, convert(bit, 1) as ExportSetupTable, 'Portrait/Landscape' AS Orientation, 'n/a' AS SheetName, 'n/a' AS HiddenColumns
	UNION SELECT 0, 0, 'Landscape', 'Corrective Actions', 'CAStatusID,StatusClass,IsOutstanding,IsLoggedByMe,IsAssignedToMe,IsCompleted,IsFailed,IsSignedOff'
	ORDER BY TableIndex ASC

END
GO




PRINT 'Database updated successfully!'
GO

-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ISOCode' AND Object_ID = Object_ID(N'APP_Country'))

alter table dbo.APP_Country add
	ISOCode nvarchar(10)


	IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_Country')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_Country] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	11 Apr 2017
-- Description:	[insert description here]
-- Version:		3
-- ===================================================
-- JMF TFS 96385 syn ISO code
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_Country] 
	@CountryID int,
	@Country nvarchar(255),
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@ResourceName nvarchar(255),
	@ISOCode nvarchar(10)=null,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM APP_Country WHERE (CountryID = @CountryID))
BEGIN --Append record
	INSERT INTO APP_Country
                      (CountryID, Country, Updated, GUID, ResourceName,IsoCode)
	VALUES     (@CountryID,@Country,@Updated,@GUID,@ResourceName,@IsoCode)
	SET @InsertCount = @@rowcount
END

ELSE
BEGIN --Update record
	UPDATE    APP_Country
	SET              Country = @Country, Updated = @Updated, ResourceName = @ResourceName,IsoCode=@IsoCode
	WHERE     (CountryID = @CountryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



-- BEGIN DATA OFFICE_CorrectiveAction_UTCOffset
BEGIN TRY
-- We need a UTC offset column. 99.995% of the time it will be the same for all dates in the table.
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_CorrectiveAction' AND c.name = 'UTCOffset' )
	ALTER TABLE QMS_CorrectiveAction ADD UTCOffset float
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA OFFICE_CorrectiveAction_UTCOffset', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA OFFICE_CorrectiveAction_UTCOffset

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	19
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- SS TFS 13-49897: Added ISNULL(Uploaded, EndDate) so that EndDate will be used if Uploaded contains a NULL Value
-- PH TSF 13-61027 : v16 18/11/2016 - Bug Fix.  When including checks from the datawarehouse for todays date, an assumption was made that the datawarehouse had been updated before @DateFrom.  
--                   However, if this was not the case then checks were included from the past (but after the warehouse had been updated).  The greater of the datawarehouse update time and @DateFrom is now used.
-- JT TFS 13-82627 : Fix issue of Uploaded results appearing on QC Checks screen not in the date range specified.
-- JT TFS 13-88313 : Only merge results from warehouse within the date range specified.
-- JT TFS 13-500241 : Add customer direct permissions.
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	-- This will contain responses which are not in the warehouse, typically those with today's date.
	DECLARE @UnfilteredResponseNotInWarehouse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	-- The datawarehouse can still be used when the user filters after the last warehouse build, but it will not contain much (if any) useful checks.
	-- We insert all the recent checks into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date.
	-- Just because the date range in entirely contained within the warehouse, doesn't mean that we only search in the warehouse. 
	-- Checks uploaded after the last warehouse build, but whose EndDate is within that range need to be included, as do incomplete checks (ResponseStatus 0)
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
	BEGIN
		DECLARE @override bit 
		SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

		DECLARE @ResponseFromDate datetime
		SELECT @ResponseFromDate = CASE WHEN @WarehouseBuildDate > @DateFrom THEN @WarehouseBuildDate ELSE @DateFrom END
			
		-- Get the majority of checks which will not be in the warehouse - the ones added after the warehouse has been built.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND EndDate BETWEEN @ResponseFromDate AND @DateTo


		-- Make sure we include the checks uploaded after the warehouse was last built, but within the entire date range. They will not yet be in the warehouse.
		-- Also, we have to make sure that incomplete checks get included, since they are never put in the warehouse.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND (Uploaded > @WarehouseBuildDate OR ResponseStatus = 0)
		AND EndDate BETWEEN @DateFrom AND @DateTo
		AND ResponseID NOT IN (SELECT ResponseID FROM @UnfilteredResponseNotInWarehouse)


		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponseTodaysDate
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
		
		-- Customer ID can be gleaned from the warehouse, or from the stockcode that the check is linked to.
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			UPDATE	UnfilteredResponseTodaysDate
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponseTodaysDate.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponseTodaysDate.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
			
			UPDATE	UnfilteredResponseTodaysDate
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE UnfilteredResponseTodaysDate.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponseTodaysDate
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)


		-- Include checks from the warehouse.
		INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
		FROM		RPT_Warehouse_Response 
		INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
		WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
		AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
		AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate
						WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = RPT_Warehouse_Response.SupplierID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			-- We do not currently store the CustomerID in the data warehouse. If we did, this section would be more in line with the others.
			UPDATE	UnfilteredResponse
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponse.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponse.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
		
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
						PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
			WHERE UnfilteredResponse.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

		INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
		SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseNotInWarehouse
	END
	ELSE --don't use warehouse table
	BEGIN
		DECLARE @OverrideOption bit 
		SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
		INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
		BEGIN
			UPDATE	UnfilteredResponse
			SET		CustomerID = HeaderCustomer.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_CustomerID() AS HeaderCustomer ON UnfilteredResponse.ResponseID = HeaderCustomer.ResponseID 
			WHERE	UnfilteredResponse.CustomerID IS NULL 
			AND		HeaderCustomer.CustomerID IS NOT NULL
			
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE UnfilteredResponse.CustomerID IS NULL 
			AND PM_VW_StockCode.CustomerID IS NOT NULL
		END
		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_UserList')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_UserList]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2009
-- Description:	Gets all users that should be notified for a check
-- Version:		9
-- =============================================
-- JE updated 10/01/2012 - Added filter by Business Group
-- JT TFS 4194 - 14/08/2012 - when @StockCodeID is null, we don't want to filter out users with 
--							  stockcode/sub-group/business unit permissions
-- MP TFS 6422 - fix to handle supplier site permissions
-- JE TFS 8956: alerts no longer go to all Supplier users when no Supplier captured in header
-- TC Re-written to make more performant for larger data sets.
/*
    Example call:
    SELECT * FROM [dbo].[FNC_Response_UserList](336) ORDER BY UserId
*/
-- JT TFS 95216: suppliersite permissions being picked up in error
-- TC TFS 95787: Use new responseheader_stockcode function to prevent parameter sniffing.
-- JT TFS 95842: Use merged fnc_response_Stockcode function.
-- JT TFS 100241: Merge customer permissions so that a CustomerID missing from the PM_StockCode table does not restrict direct response permissions.
-- =============================================
ALTER FUNCTION [dbo].[FNC_Response_UserList] 
(
	@ResponseID int
)
RETURNS TABLE 
AS
RETURN
    SELECT DISTINCT U.UserId
      FROM QMS_User U
     WHERE 1=1
       
       --Get stock code from response header, consignment item and delivery item 
       AND (NOT EXISTS (SELECT * 
                         FROM VW_PermissionLink PL1 
                        WHERE U.UserID = PL1.UserID 
                          AND PL1.PermissionAllow = 1 
                          AND PL1.StockCodeID IS NOT NULL 
                          AND PL1.PermissionType IN (101,102,103,104,105,106) 
                          --Only do this if we have a stock code
                          AND (SELECT COUNT(*) 
                                 FROM dbo.FNC_Response_StockCodeID(@ResponseId) A 
                                ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL2 
                          INNER JOIN dbo.FNC_Response_StockCodeID(@ResponseId) STK 
                               ON PL2.StockCodeID = STK.StockCodeID 
                               AND PL2.PermissionType = 104 --Stock Code Permission Type
                               AND PL2.UserID = U.UserID))
      
       --Get location from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL3 
                         WHERE U.UserID = PL3.UserID 
                           AND PL3.PermissionAllow = 1 
                           AND PL3.LocationID IS NOT NULL 
                           AND PL3.PermissionType IN (1, 101,102,103,104,105,106) 
                           --Only do this if we have a location
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_LocationID() B 
                                 WHERE B.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL4 
                          JOIN dbo.FNC_ResponseHeader_LocationID() LOC 
                               ON PL4.LocationID = LOC.LocationID 
                               AND LOC.ResponseId = @ResponseId 
                               AND PL4.PermissionType = 103 --Location Permission Type
                               AND PL4.UserID = U.UserID))
        
       --Get supplier from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL5 
                         WHERE U.UserID = PL5.UserID 
                           AND PL5.PermissionAllow = 1 
                           AND PL5.SupplierID IS NOT NULL 
                           AND PL5.PermissionType IN (101,102,103,104,105,106))
                           --No restriction for Supplier to exist in the header to accomodate TFS 8956.
            --All Supplier users aren't notified when no Supplier captured
             OR EXISTS (SELECT * 
              FROM VW_PermissionLink PL6 
                          JOIN dbo.FNC_ResponseHeader_SupplierID() SUP 
                               ON PL6.SupplierID = SUP.SupplierID 
                               AND SUP.ResponseId = @ResponseId 
                               AND PL6.PermissionType = 101 --Supplier Permission Type
                               AND PL6.UserID = U.UserID))
     
       --Get customer from response header or StockCode table.
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL7 
                         WHERE U.UserID = PL7.UserID 
                           AND PL7.PermissionAllow = 1 
                           AND PL7.CustomerID IS NOT NULL 
                           AND PL7.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a customer or a stockcode linked to the response.
                           AND (	(SELECT COUNT(*) 
									 FROM dbo.FNC_ResponseHeader_CustomerID() D 
									 WHERE D.ResponseId = @ResponseId) > 0
								 OR (SELECT COUNT(*) 
                                     FROM dbo.FNC_Response_StockCodeID(@ResponseId)) > 0
						   ) 
					)
			 -- Get customer directly from permission table.
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL8 
                          JOIN dbo.FNC_ResponseHeader_CustomerID() CUS 
                               ON PL8.CustomerID = CUS.CustomerID 
                               AND CUS.ResponseId = @ResponseId 
                               AND PL8.PermissionType = 102 --Customer Permission Type
                               AND PL8.UserID = U.UserID)
             -- Get customer assigned to stock code
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL12 
                          JOIN PM_VW_StockCode SC1 
                               ON U.UserID = PL12.UserID 
                               AND PL12.PermissionType = 102 --Customer Permission Type (again)
                               AND PL12.CustomerID = SC1.CustomerID 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK2 
                                           WHERE SC1.StockCodeID = STK2.StockCodeID 
                                            ))
       )
      
       --Get supplier site from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL9 
                         WHERE U.UserID = PL9.UserID 
                           AND PL9.PermissionAllow = 1 
                           AND PL9.LocationID IS NOT NULL 
                           AND PL9.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a supplier
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_SupplierSiteID() E 
                                 WHERE E.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL10 
                          JOIN dbo.FNC_ResponseHeader_SupplierSiteID() SUPS 
                               ON PL10.LocationID = SUPS.LocationID 
                               AND SUPS.ResponseId = @ResponseId 
                               AND PL10.PermissionType = 103 --Supplier Site Permission Type
                               AND PL10.UserID = U.UserID))

       --accomodate TFS 2565 by joining to PM_VW_StockCode then onto FNC_ResponseHeader_StockCodeID function
 -----------------------------------------------------------------------------------------------------------------
       --Get Business Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL13 
                         WHERE U.UserID = PL13.UserID 
                           AND PL13.PermissionAllow = 1 
                           AND PL13.BusinessGroup IS NOT NULL 
                           --Only do this if we have a Business Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) F 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL14 
                          INNER MERGE JOIN PM_VW_StockCode SC2 
                               ON U.UserID = PL14.UserID 
                               AND PL14.PermissionType = 106 --Business Group Permission Type
                               AND PL14.BusinessGroup = SC2.BusinessGroup 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK3 
                                           WHERE SC2.StockCodeID = STK3.StockCodeID 
                                             )))
 
       --Get Stock Code Sub Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL15 
                         WHERE U.UserID = PL15.UserID 
                           AND PL15.PermissionAllow = 1 
                           AND PL15.StockCodeSubGroup IS NOT NULL 
                           --Only do this if we have a Stock Code Sub Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) G 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL16 
                          JOIN PM_VW_StockCode SC3 
                               ON U.UserID = PL16.UserID 
                               AND PL16.PermissionType = 105 --Stock Code Sub Group Permission Type
                               AND PL16.StockCodeSubGroup = SC3.StockCodeSubGroup 
                               AND EXISTS (SELECT * 
                                             FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK4 
                                            WHERE SC3.StockCodeID = STK4.StockCodeID 
                                              )))

       -----------------------------------------------------------------------------------------------------------------
       AND U.LeftCompany = 0
       AND U.RecordStatus < 201
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'VW_LastResponseAction')
	EXEC ('CREATE VIEW [dbo].[VW_LastResponseAction] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonny Miles
-- Create date: 31/05/2018
-- Description:	Gets the last action performed on each QC Check
-- Version:		1
-- =============================================
-- TFS 98166: Created
-- =============================================

ALTER VIEW [dbo].[VW_LastResponseAction] 
AS
  SELECT qmsResponseAction.responseid, 
         appQaAction.qaaction         AS QCActionTaken, 
         qmsResponseAction.actiondate AS ActionTakenOn, 
         qmsUser.fullname             AS ActionCreatedBy, 
         qmsResponseAction.comments   AS ActionComments, 
         appQAFlag.qaflag             AS ActionQAFlag 
  FROM   dbo.qms_responseaction AS qmsResponseAction 
         LEFT OUTER JOIN dbo.app_qaaction AS appQaAction 
                      ON appQaAction.qaactionid = qmsResponseAction.qaactionid 
         LEFT OUTER JOIN dbo.qms_user AS qmsUser 
                      ON qmsUser.userid = qmsResponseAction.userid 
         LEFT OUTER JOIN dbo.app_qaflag AS appQAFlag 
                      ON appQAFlag.qaflagid = qmsResponseAction.action_qaflagid 
         INNER JOIN (SELECT responseid, 
                            Max(actiondate) AS LastActionDate 
                     FROM   dbo.qms_responseaction AS qmsResponseAction 
                     GROUP  BY responseid) AS lastActions 
                 ON lastActions.responseid = qmsResponseAction.responseid 
                    AND lastActions.lastactiondate = 
                        qmsResponseAction.actiondate 


GO




IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList_WithActionInfo]'))
BEGIN TRY
	     DROP PROCEDURE [dbo].[QRY_Response_PreviousList_WithActionInfo]
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DROP [dbo].[QRY_Response_PreviousList_WithActionInfo]', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- =============================================
-- Author:		Jonny Miles
-- Create date: 30/05/2018
-- Description:	Gets list of previous responses, with action data included
-- Version:		1
-- =============================================
-- TFS 98166: Created
-- =============================================
CREATE PROCEDURE [dbo].[QRY_Response_PreviousList_WithActionInfo]
--DECLARE
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport

		--SELECT  @AssessmentTypeID = 6,  @DateFrom = '1 Aug 2017 00:00:00',  @DateTo = '15 Sep 2017 23:59:59',  @UserID = 1,  @ShowOutstanding = 1,  @DisplayMode = 1
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

	UPDATE TEMP_Selected SET SelectedValue = dbo.FNC_Response_IsMultiCheck(SelectedID ) WHERE (UserID = @UserID);
    
	SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) as QAFlag,
                QMS_Response.Override_QAFlagID, 
				ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
				QAFlag_Override.QAFlag) as Override_QAFlag,
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName,
				vwLastResponseAction.[QCActionTaken],
				vwLastResponseAction.[ActionTakenOn],
				vwLastResponseAction.[ActionCreatedBy],
				vwLastResponseAction.[ActionComments],
				vwLastResponseAction.[ActionQAFlag]
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag AS APP_QAFlag_1
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE   AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					AND TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			--SELECT 
			--		UserID = @UserID, 
			--		AssessmentID = @AssessmentID,
			--		AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
			--		ShowOutstanding = @ShowOutstanding,
			--		multiCheckDisplay = @multiCheckDisplay

		     EXEC QRY_Response_PreviousList_ShelfLife 
					@UserID = @UserID, 
					@AssessmentID = @AssessmentID,
					@AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
					@ShowOutstanding = @ShowOutstanding,
					@multiCheckDisplay = @multiCheckDisplay
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
					QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					--ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
					ISNULL(TEMP_Selected.SelectedValue,0) AS MultiCheckLevel,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			--LEFT OUTER JOIN	dbo.AQC_FNC_ResponseHeader() AS ResponseHeader
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments

						FROM	QMS_Attachment

						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201

						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
					
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag

						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
							AND TEMP_Selected.SelectedValue=1
						)
						OR
						(
							@multiCheckDisplay = 2
							--AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
							AND TEMP_Selected.SelectedValue IN (1,2)
						)
						--OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
						OR TEMP_Selected.SelectedValue = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag, 							  
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName,
					vwLastResponseAction.[QCActionTaken],
					vwLastResponseAction.[ActionTakenOn],
					vwLastResponseAction.[ActionCreatedBy],
					vwLastResponseAction.[ActionComments],
					vwLastResponseAction.[ActionQAFlag]
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								QAFlag,ResourceName 
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT JOIN [dbo].[VW_LastResponseAction] vwLastResponseAction ON vwLastResponseAction.[ResponseID] = QMS_Response.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						--dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
						TEMP_Selected.SelectedValue IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END
GO 
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList_WithActionInfo]') AND type in (N'P', N'PC'))
	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Failed to create [dbo].[QRY_Response_PreviousList_WithActionInfo]', ERROR_MESSAGE()
	FROM #tmpScriptName
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_DateAdd_ServerTime')
	EXEC('CREATE FUNCTION [dbo].[FNC_DateAdd_ServerTime]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Taj S
-- Create date: 31/05/2018
-- Description:	Date add function for QMS intervals using the instance timezone by default
-- Version: 1
-- =============================================
-- TS tfs 13-99836: Date add function for QMS intervals using the instance timezone by default

ALTER FUNCTION [dbo].[FNC_DateAdd_ServerTime] 
(
	@IntervalUnit nvarchar(10),
	@IntervalNumber int,
	@StartDate datetime
)
RETURNS datetime
AS
BEGIN
	
	DECLARE @Result datetime

	IF @StartDate IS NULL
		SET @StartDate = dbo.FNC_GetDate()

	SET @Result = CASE WHEN @IntervalUnit = 'mi' THEN
		DATEADD(minute, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'hh' THEN
		DATEADD(hour, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'dd' THEN
		DATEADD(day, @IntervalNumber, @StartDate)
	WHEN @IntervalUnit = 'wk' THEN
		DATEADD(week, @IntervalNumber, @StartDate)
	ELSE
		NULL
	END

	RETURN @Result

END



GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_CorrectiveAction_Escalation')
	EXEC ('CREATE PROCEDURE [dbo].[APP_CorrectiveAction_Escalation] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/08/2008
-- Description:	Generates escalation of failed corrective actions
-- Version:		5
-- =============================================
-- JT TFS 13-7950 - 6-Oct-14 - Copy across DateOccurred from previous failed CA.
-- JE TFS 13-12637	: updated QMS_CorrectiveActionUser after CA escalation
-- AC TFS 15148		: Only calls SAVE_CorrectiveActionUser for corrective actions have have been escalated
-- PH TFS 13-33834	: Reformatted to be more understandable
-- =============================================
ALTER PROCEDURE [dbo].[APP_CorrectiveAction_Escalation]

AS
BEGIN

	--Update failed CA status
	EXEC UP_CorrectiveAction_DeadlineFailed

	DECLARE @EscalatedCorrectiveActions TABLE (CorrectiveActionID INTEGER)

	--Escalate failed CA
	INSERT INTO QMS_CorrectiveAction
	(
		CASourceID,
		SourceObjectID,
		CATitle,
		CASubTitle,
		CAReason,
		CARequired,
		CAStatusID,
		CorrectiveActionTypeID,
		CorrectiveActionEscalationID,
		NotificationGroupID,
		AssignUserID,
		PriorityLevelID,
		DateLogged,
		DateDeadline,
		Logged_UserID,
		Logged_MachineName,
		ActionTaken,
		Comments,
		DateOccurred
	)
	OUTPUT INSERTED.CorrectiveActionID
	INTO @EscalatedCorrectiveActions 
	SELECT
		3 AS CASourceID,
		QMS_CorrectiveAction_Failed.CorrectiveActionID,
		QMS_CorrectiveAction_Failed.CATitle,
		QMS_CorrectiveAction_Failed.CASubTitle,
		QMS_CorrectiveAction_Failed.CAReason,
		QMS_CorrectiveAction_Failed.CARequired,
		1 AS CAStatusID,
		QMS_CorrectiveAction_Failed.CorrectiveActionTypeID,
		QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID,
		QMS_CorrectiveActionEscalation.NotificationGroupID,
		QMS_CorrectiveActionEscalation.AssignUserID,
		QMS_CorrectiveActionEscalation.PriorityLevelID,
		GETDATE() AS DateLogged,
		dbo.FNC_DateAdd(QMS_CorrectiveActionEscalation.IntervalUnit, QMS_CorrectiveActionEscalation.IntervalNumber, NULL) AS DateDeadline,
		QMS_CorrectiveAction_Failed.Logged_UserID,
		QMS_CorrectiveAction_Failed.Logged_MachineName,
		QMS_CorrectiveAction_Failed.ActionTaken,
		QMS_CorrectiveAction_Failed.Comments,
		QMS_CorrectiveAction_Failed.DateOccurred
	FROM	QMS_CorrectiveAction AS QMS_CorrectiveAction_Failed
	INNER JOIN
	(
		SELECT
			CorrectiveActionEscalationID AS Initial_CorrectiveActionEscalationID,
			CorrectiveActionTypeID,
			ListIndex,
			(
				SELECT	MIN(ListIndex) AS MinIndex
				FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_2
				WHERE
					CorrectiveActionTypeID = QMS_CorrectiveActionEscalation_Initial.CorrectiveActionTypeID
					AND (ListIndex > QMS_CorrectiveActionEscalation_Initial.ListIndex)
			) AS NextListIndex
		FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_Initial
		WHERE
			(
				(
					SELECT	MIN(ListIndex) AS MinIndex
					FROM	QMS_CorrectiveActionEscalation AS QMS_CorrectiveActionEscalation_1
					WHERE
						CorrectiveActionTypeID = QMS_CorrectiveActionEscalation_Initial.CorrectiveActionTypeID
						AND ListIndex > QMS_CorrectiveActionEscalation_Initial.ListIndex
				)
			) IS NOT NULL
			AND RecordStatus < 201
	) AS CA_Escalation
		ON	QMS_CorrectiveAction_Failed.CorrectiveActionEscalationID = CA_Escalation.Initial_CorrectiveActionEscalationID
	INNER JOIN QMS_CorrectiveActionEscalation
		ON CA_Escalation.CorrectiveActionTypeID = QMS_CorrectiveActionEscalation.CorrectiveActionTypeID
		AND CA_Escalation.NextListIndex = QMS_CorrectiveActionEscalation.ListIndex
	LEFT OUTER JOIN
	(
		SELECT
			CASourceID,
			SourceObjectID AS CorrectiveActionID
		FROM	QMS_CorrectiveAction AS QMS_CorrectiveAction_1
		WHERE
			RecordStatus < 201
			AND CASourceID = 3
	) AS CA_Escalated
		ON QMS_CorrectiveAction_Failed.CorrectiveActionID = CA_Escalated.CorrectiveActionID
	WHERE
		CA_Escalated.CorrectiveActionID IS NULL
		AND QMS_CorrectiveActionEscalation.RecordStatus < 201
		AND QMS_CorrectiveAction_Failed.CAStatusID = 3

	--JE TFS 13-12637: update QMS_CorrectiveActionUser table for CA we've just escalated
	DECLARE @CorrectiveActionID int

	DECLARE cur CURSOR FOR SELECT CorrectiveActionID FROM @EscalatedCorrectiveActions
	OPEN cur

	FETCH NEXT FROM cur INTO @CorrectiveActionID

	WHILE @@FETCH_STATUS = 0 BEGIN
		EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
		FETCH NEXT FROM cur INTO @CorrectiveActionID
	END

	CLOSE cur    
	DEALLOCATE cur

	-- check for CA's that have failed after being escalated and set these to CAStatusID 7 (failed escalated)
	UPDATE	QMS_CorrectiveAction
	SET		CAStatusID = 7
	FROM	QMS_CorrectiveAction
	INNER JOIN QMS_CorrectiveAction AS CorrectiveAction_Dest
		ON QMS_CorrectiveAction.CorrectiveActionID = CorrectiveAction_Dest.SourceObjectID
	WHERE
		CorrectiveAction_Dest.CASourceID = 3
		AND QMS_CorrectiveAction.CAStatusID = 3

END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_CorrectiveAction_DeadlineFailed')
	EXEC ('CREATE PROCEDURE [dbo].[UP_CorrectiveAction_DeadlineFailed] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/08/2008
-- Description:	Update status of corrective actions to failed if deadline exceeded
-- Version:		4
-- =============================================
-- j.toolan 7/3/12: Reset notification flag so emails go out.
-- JF TFS 99836 - Escalated Corrective Actions to use the server UTC offset determined by the timezone of the instance
-- =============================================
ALTER PROCEDURE [dbo].[UP_CorrectiveAction_DeadlineFailed] 

AS

UPDATE    QMS_CorrectiveAction
SET              
	CAStatusID = 3, 
	NotificationSent = 0, 
	DateFailed = dbo.FNC_GetDate(),
	Updated = GETUTCDATE()
WHERE     
	(RecordStatus < 201) AND 
	(CAStatusID <= 2) AND 
	dbo.fnc_convertutcdate(dateadd(hour,-ISNULL(utcoffset, dbo.FNC_GetoptionValue(28)),DateDeadline)) < dbo.FNC_GetDate()
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalItemCount_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/08/09
-- Description:	Lookup the Arrival quantity
-- Version:	3
-- Unit test:	PM_QRY_ArrivalItemCount_Lookup_TEST.sql
-- =============================================
-- JF TFS 92520 - Generic Integration -  Change Quantity Received lookup to read from PO data if intake data does not exist  
-- JF TFS 99832 - make sure data is returned from all code paths
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] 
	@GoodsIntakeID int = null,
	@Barcode nvarchar(50) = NULL,
	@ConsignmentItemID INT = null,
	@StockCodeID  INT = null,
	@ConsignmentID INT = null
AS

IF @Barcode IS NOT NULL 
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (Barcode = @Barcode)
	
ELSE IF @ConsignmentItemID IS NOT NULL and exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 6 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentItemID = @ConsignmentItemID

ELSE IF @StockCodeID IS NOT NULL and @ConsignmentID IS NOT NULL AND exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  SUM(QuantityReceived) as QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentID = @ConsignmentID and StockCodeID = @StockCodeID

ELSE IF @GoodsIntakeID IS NOT NULL
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
--ELSE
--	SELECT null as ItemCount


GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_IntakeCountry_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jeremy formby
-- Create date: 14/05/2018
-- Description:	Looks up intake country
-- Version:		1
-- =============================================
-- JMF TFS 96385 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup]
	@Barcode nvarchar(100) = null
AS
BEGIN
	SELECT	APP_Country.CountryID,APP_Country.Country + ' ('   + APP_Country.ISOCode  + ')' as Country
	FROM	PM_VW_GoodsIntake INNER JOIN APP_Country on APP_Country.CountryID = PM_VW_GoodsIntake.CountryID 
	WHERE	PM_VW_GoodsIntake.Barcode = @Barcode
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCodeBusinessUnit_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCodeBusinessUnit_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/03/2012
-- Description:	Returns distinct list of Stock Code Business Units
-- Version: 3
-- =============================================
-- JE TFS 3922 - added user permission filtering
-- JE TFS 13-4352: added Hide filter so old Business Units not shown
-- JMF TFS 96385 - lookup business unit from StockcodeID if trigger enabled
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCodeBusinessUnit_Combo]
	@UserID int = NULL,
	@StockCodeID int = null
AS
BEGIN

	--get table of available business groups
	DECLARE @Table_BusinessGroup TABLE (BusinessGroup nvarchar(100))
	INSERT INTO @Table_BusinessGroup (BusinessGroup)
	SELECT     PermissionTitle
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 106) AND (PermissionAllow = 1) AND (UserID = @UserID)

	Declare @FilterOnStockCode bit = 0
	if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 73 and enabled = 1)
		IF @StockCodeID IS NOT NULL
			SELECT @FilterOnStockCode=1
			


	--check business groups exist
	IF (SELECT COUNT(BusinessGroup) FROM @Table_BusinessGroup)>0 
		SELECT DISTINCT BusinessUnit
		FROM			PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS StockCodeList ON PM_VW_StockCode.StockCodeID = StockCodeList.StockCodeID
		WHERE			
			BusinessGroup IN (SELECT BusinessGroup FROM @Table_BusinessGroup) AND 
			(Hide = 0) AND
			(PM_VW_StockCode.StockCodeID = @StockCodeID OR @FilterOnStockCode=0)
		ORDER BY		BusinessUnit

	ELSE
		
		SELECT DISTINCT BusinessUnit
		FROM			PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS StockCodeList ON PM_VW_StockCode.StockCodeID = StockCodeList.StockCodeID
		WHERE		
			(BusinessGroup IS NOT NULL) AND 
			(Hide = 0) AND
			(PM_VW_StockCode.StockCodeID = @StockCodeID OR @FilterOnStockCode=0)
		ORDER BY		BusinessUnit


END



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_Alert')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_Alert] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Gets list of users to notify for specific corrective action
-- Version:		16
-- =============================================
-- JE TFS 2947 - use Failure_NotificationGroupID for Completed CA's
-- JE TFS 2948 - get linked Supplier users for Signed-off CA's
-- JT TFS 3052 - new CAs for AssignSupplierID get an alert, too.
-- JT TFS 3054 - SP now handles all status/assignment cases.
-- JT TFS 3067 - SP handles reminder alerts too.
-- JT TFS 3077 - Returns CAStatus for email content.
-- JE TFS 7700 - added Logged_UserID to recipient list for sign-off alert
-- JE TFS 7877 - corrected above change to alert Logged_UserID for CA PENDING sign-off
-- JE TFS 13-4921: added CompletedByUser column
-- JE TFS 13-6298: added Location permissions check for Failed CAs
-- JE TFS 13-6298: added Location permissions check for all CA statuses
-- JE TFS 13-8940: amended query to populate @UserList so admin users are included
-- JT TFS 13-88643: Report UTCOffset back to email notification
-- JT TFS 13-88643: Always return same column names for first query (with NULL for impossible columns)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_Alert]
	@CorrectiveActionID int,
	@IsReminderAlert bit = 0
AS

-- TEST DATA: 
-- DECLARE @CorrectiveActionID int = 18507, @IsReminderAlert bit = 0
BEGIN
	--Get location for check to filter users
	DECLARE		@LocationID int, 
				@CASource int, 
				@CAStatusID int,
				@CAStatus nvarchar(255),
				@NotificationGroupID int, 
				@FailureNotificationGroupID int,
				@AssignUserID int,
				@AssignSupplierID int,
				@IsNotificationAlreadySent bit,
				@LoggedUserID int
			
	SET NOCOUNT ON

	--Get Corrective Action Source and Corrective Action Status, and destinations.
	SELECT		@CASource					= QMS_CorrectiveAction.CASourceID, 
				@CAStatusID					= QMS_CorrectiveAction.CAStatusID, 
				@CAStatus					= ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 1), APP_CorrectiveActionStatus.CAStatus),
				@NotificationGroupID		= QMS_CorrectiveAction.NotificationGroupID,
				@FailureNotificationGroupID	= QMS_CorrectiveActionEscalation.Failure_NotificationGroupID,
				@AssignUserID				= QMS_CorrectiveAction.AssignUserID,
				@AssignSupplierID			= QMS_CorrectiveAction.AssignSupplierID,
				@IsNotificationAlreadySent  = CASE	WHEN @IsReminderAlert = 0 AND NotificationSent = 1	THEN 1
													WHEN @IsReminderAlert = 1 AND ReminderSent = 1		THEN 1
																										ELSE 0 END,
				@LoggedUserID				= QMS_CorrectiveAction.Logged_UserID								
	FROM			QMS_CorrectiveAction
	LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
	LEFT OUTER JOIN	APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)

	-- Potentially short circuit the whole process if the notification has already gone.
	-- IF (@IsNotificationAlreadySent = 1) RETURN

	-- Get location
	IF @CASource = 1 --Get location from response header
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  QMS_CorrectiveAction ON QMS_ResponseHeader.ResponseID = QMS_CorrectiveAction.SourceObjectID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
							  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 2 --Response question
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseQuestion INNER JOIN
						  QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID INNER JOIN
						  QMS_ResponseHeader INNER JOIN
						  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID ON 
						  QMS_ResponseQuestion.ResponseID = QMS_ResponseHeader.ResponseID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
						  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 4 --Ad Hoc, so get Location CA has been assigned to
	BEGIN
		SELECT	@LocationID  = LocationID
		FROM	QMS_CorrectiveAction
		WHERE	(CorrectiveActionID = @CorrectiveActionID)
	END

	IF @LocationID IS NULL --Get location assigned to user
	BEGIN
		SELECT     @LocationID = QMS_User.LocationID
		FROM        QMS_User 
		INNER JOIN	QMS_CorrectiveAction ON QMS_User.UserID = QMS_CorrectiveAction.Logged_UserID
		WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	-- Get body details (for non-sent notifications).
	IF @CAStatusID IN (4)  --Completed CA
	BEGIN
		--Get Completed CA details for message body
		SELECT  QMS_CorrectiveAction.CATitle, 
				QMS_CorrectiveAction.CASubTitle, 
				QMS_CorrectiveAction.CAReason,
				QMS_CorrectiveAction.CARequired, 
				QMS_CorrectiveAction.DateLogged, 
				QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
				APP_PriorityLevel.PriorityLevel, 
				QMS_CorrectiveAction.DateDeadline, 
				QMS_CorrectiveAction.ActionTaken,
				convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
				@CAStatus as [CAStatus],
				QMS_User.FullName AS CompletedByUser,
				QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction 
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		LEFT OUTER JOIN QMS_User ON QMS_CorrectiveAction.Completed_UserID = QMS_User.UserID	
		WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	ELSE IF @CAStatusID IN (5) --Signed-off CA
	BEGIN
			--Get Signed-off CA details for message body
			SELECT		QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CASubTitle, 
						QMS_CorrectiveAction.CAReason, 
						QMS_CorrectiveAction.CARequired, 
						QMS_CorrectiveAction.DateLogged, 
						QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
						APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline, 
						QMS_CorrectiveAction.ActionTaken,
						QMS_User.UserName, -- Signed off user
						@CAStatus as [CAStatus],
						convert(nvarchar(255), NULL) AS CompletedByUser,
						QMS_CorrectiveAction.UTCOffset
			FROM			QMS_CorrectiveAction 
			INNER JOIN		QMS_User ON QMS_CorrectiveAction.SignOff_UserID = QMS_User.UserID 
			LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
			LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
			WHERE		(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
			AND			(@IsNotificationAlreadySent = 0)
	END
	ELSE -- Not Completed or Signed-off CA
	BEGIN
		--Get New CA details for message body
		SELECT      QMS_CorrectiveAction.CATitle, 
					QMS_CorrectiveAction.CASubTitle, 
					QMS_CorrectiveAction.CAReason, 
					QMS_CorrectiveAction.CARequired, 
					QMS_CorrectiveAction.DateLogged, 
					QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
					APP_PriorityLevel.PriorityLevel, 
					QMS_CorrectiveAction.DateDeadline,
					QMS_CorrectiveAction.ActionTaken,
					convert(nvarchar(255), NULL) AS UserName, -- Signed Off user should be null
					@CAStatus as [CAStatus],
					convert(nvarchar(255), NULL) AS CompletedByUser,
					QMS_CorrectiveAction.UTCOffset
		FROM			QMS_CorrectiveAction
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		WHERE   (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		--AND		(QMS_CorrectiveAction.CAStatusID = 1) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	SET NOCOUNT OFF


	DECLARE @UserList TABLE (
		FullName nvarchar(256),
		Email nvarchar(256)
	)
	SET NOCOUNT ON

	IF @AssignUserID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) -- Individual user emails (New, In Progress, Signed-off, Rejected)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT		QMS_User.FullName, QMS_User.EMail
		FROM		QMS_User 
		WHERE   (QMS_User.UserID = @AssignUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	--Get list of users to include in alert (groupwise)
	IF @NotificationGroupID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --By group (not applicable for Signed-off CA)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT QMS_User.FullName,QMS_User.EMail
		FROM         QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @NotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	-- Suppliers get their own emails.
	IF @AssignSupplierID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --List of Suppliers linked to AssignSupplierID (everything except Completed)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User 
		INNER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID 
		WHERE	(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
		AND		(dbo.FNC_GetUserLevel(QMS_User.UserID) = 9) -- suppliers only.
		AND     (QMS_UserPermissions.PermissionTitle = @AssignSupplierID)
		AND		(QMS_UserPermissions.PermissionType = 101) 
		AND		(QMS_UserPermissions.PermissionAllow = 1)
	END

	--Get extra users to include in alert (owners of the CA alert (failure notification group))
	IF @FailureNotificationGroupID IS NOT NULL AND @CAStatusID IN (3, 4, 7) -- Failed, Completed, Failed (escalated)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT	QMS_User.FullName,QMS_User.EMail
		FROM        QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @FailureNotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	--get user who originally logged CA to include in notification list if CA is pending sign off (i.e. Completed)
	IF @LoggedUserID IS NOT NULL AND @CAStatusID = 4
	BEGIN
		INSERT INTO @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User
		WHERE	(QMS_User.UserID = @LoggedUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	SET NOCOUNT OFF

	SELECT FullName, Email FROM @UserList
END
GO



/****** Object:  StoredProcedure [dbo].[CUST_UNVBE_INT_Inbound_ProductSensitivity]    Script Date: 23/05/2018 11:48:36 ******/
SET ANSI_NULLS ON
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		17
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- PH TFS 13-21031: 10/06/2015 - Got rid of code smell that may have been causing bug.  New CorrectiveActionID obtained OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
-- PH TFS 13-23902: 15/07/2015 - SourceObjectID is nullable, so parameter should not be mandatory when saving an Ad Hoc corrective action
-- JT TFS 13-59936: 25/04/2017 - Allow 100 characters for CATitle (to reflect underlying table)
-- TS TFS 13-88643: 05/06/18 - Capture UTCOFfset
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int = NULL,
	@CATitle nvarchar(100),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		DECLARE @caIdTable TABLE (CorrectiveActionID int)

		DECLARE @UTCOffset FLOAT
		SET @UTCOffset = DATEDIFF(mi, GETUTCDATE(), GETDATE()) / 60

		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID, UTCOffset)
				OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID, @UTCOffset)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         @caIdTable
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Download_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Download_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/12/2008
-- Description:	Gets data to download for QMS_CorrectiveAction table
-- Version:		5
-- =============================================
-- JE TFS 7396 - added extra params for Sync process improvements
-- MP TFS 14225 - made SP more efficient and changed logic so that only CA's from that device are downloaded
-- JM TFS 88643 - Added UTC offset column
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Download_CorrectiveAction] 
	@ClientID int = NULL,
	@LastReceived bigint,
	@GetRecordCountOnly bit = 0,
	@TotalRecordCount int OUTPUT
AS

--DECLARE @ClientID int = 175, @LastReceived BIGINT=0,@GetRecordCountOnly bit = 0,@TotalRecordCount int 

--For new CA, only download from last 7 days
DECLARE @DateFrom datetime
SET @DateFrom = DATEADD(day, - 7, GETDATE())

--create temp table to hold filtered Corrective Actions
IF NULLIF(object_id('tempdb..#tmpCorrectiveAction'), 0) IS NOT NULL DROP TABLE #tmpCorrectiveAction
CREATE TABLE #tmpCorrectiveAction (CorrectiveActionID int)

INSERT INTO #tmpCorrectiveAction (CorrectiveActionID)
SELECT CorrectiveActionID
FROM     dbo.QMS_CorrectiveAction
WHERE  (@LastReceived > 0) AND (RowVersion > @LastReceived) AND (ClientID = @ClientID) OR
                  (ClientID = @ClientID) AND (Created > @LastReceived) AND (RecordStatus < 201) AND (Inserted > @DateFrom)

SET @TotalRecordCount = (SELECT	COUNT(CorrectiveActionID)
							FROM #tmpCorrectiveAction)

IF @GetRecordCountOnly = 0
	BEGIN

		SET NOCOUNT ON

		--Populate temp table with CorrectiveActions to download so that source GUID can be looked up
		DECLARE @UserID int
		SET @UserID = 9999

		DELETE FROM TEMP_Selected
		WHERE     (UserID = @UserID)

		INSERT INTO TEMP_Selected
							  (UserID, SelectedID)
		SELECT     @UserID AS UserID, CorrectiveActionID
		FROM         QMS_CorrectiveAction
		WHERE     CorrectiveActionID IN (SELECT	CorrectiveActionID
							FROM #tmpCorrectiveAction)

		SET NOCOUNT OFF

		SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CASourceID, QMS_CorrectiveAction.SourceObjectID, SourceGUID.SourceObject_GUID, 
							  QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, QMS_CorrectiveAction.CAStatusID, 
							  QMS_CorrectiveAction.CorrectiveActionTypeID, QMS_CorrectiveAction.CorrectiveActionEscalationID, QMS_CorrectiveAction.NotificationGroupID, 
							  QMS_CorrectiveAction.PriorityLevelID, QMS_CorrectiveAction.DateLogged, QMS_CorrectiveAction.DateOccurred, QMS_CorrectiveAction.DateDeadline, 
							  QMS_CorrectiveAction.Logged_UserID, QMS_CorrectiveAction.Logged_MachineName, QMS_CorrectiveAction.NotificationSent, QMS_CorrectiveAction.ActionTaken, 
							  QMS_CorrectiveAction.Comments, QMS_CorrectiveAction.DateCompleted, QMS_CorrectiveAction.Completed_UserID, QMS_CorrectiveAction.Completed_MachineName, 
							  QMS_CorrectiveAction.DateSignedOff, QMS_CorrectiveAction.SignOff_UserID, QMS_CorrectiveAction.SignOff_MachineName, QMS_CorrectiveAction.DateFailed, 
							  QMS_CorrectiveAction.CASubTitle, QMS_CorrectiveAction.AssignUserID, QMS_CorrectiveAction.AssignSupplierID, QMS_CorrectiveAction.ReminderDate, 
							  QMS_CorrectiveAction.ReminderSent, dbo.QMS_CorrectiveAction.LocationID, QMS_CorrectiveAction.UTCOffset,QMS_CorrectiveAction.RecordStatus, QMS_CorrectiveAction.Inserted, QMS_CorrectiveAction.Updated,
							  QMS_CorrectiveAction.Deleted, QMS_CorrectiveAction.GUID, QMS_CorrectiveAction.RowVersion, QMS_CorrectiveAction.Created
		FROM        #tmpCorrectiveAction AS FilteredCAs INNER JOIN 
						QMS_CorrectiveAction ON FilteredCAs.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID LEFT OUTER JOIN
							  dbo.FNC_CorrectiveAction_SourceGUID(@UserID) AS SourceGUID ON QMS_CorrectiveAction.CorrectiveActionID = SourceGUID.CorrectiveActionID
	END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	5 Jun 2018
-- Description:	[insert description here]
-- Version:		1
-- ===================================================
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_CorrectiveAction] 
	@CASourceID int,
	@SourceObject_GUID uniqueidentifier,
	@CATitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateOccurred datetime = NULL,
	@DateDeadline datetime,
	@Logged_UserID int,
	@Logged_MachineName nvarchar(50),
	@NotificationSent bit,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@DateFailed datetime,
	@CASubTitle nvarchar(50),
	@AssignUserID int,
	@AssignSupplierID int = NULL,
	@ReminderDate datetime = NULL,
	@ReminderSent bit = NULL,
	@LocationID INT = NULL,
	@UTCOffset float = NULL,
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

--Lookup SourceObjectID from GUID
DECLARE @SourceObjectID int
IF @CASourceID = 1 --Response
	SELECT @SourceObjectID = ResponseID FROM QMS_Response WHERE (GUID = @SourceObject_GUID)
IF @CASourceID = 2 --ResponseQuestion
	SELECT @SourceObjectID = ResponseQuestionID FROM QMS_ResponseQuestion WHERE (GUID = @SourceObject_GUID)
IF @CASourceID = 3 --CorrectiveAction
	SELECT @SourceObjectID = CorrectiveActionID FROM QMS_CorrectiveAction WHERE (GUID = @SourceObject_GUID)

IF @ReminderSent IS NULL
	SET @ReminderSent = 0

IF NOT EXISTS(SELECT * FROM QMS_CorrectiveAction WHERE (GUID = @GUID))
BEGIN --Append record
	IF @RecordStatus < 201 AND @CAStatusID < 3 --Dont append closed actions
	BEGIN
		INSERT INTO QMS_CorrectiveAction
                      (CASourceID, SourceObjectID, CATitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, PriorityLevelID, 
                      DateLogged, DateOccurred, DateDeadline, Logged_UserID, Logged_MachineName, NotificationSent, ActionTaken, Comments, DateCompleted, Completed_UserID, 
                      Completed_MachineName, DateSignedOff, SignOff_UserID, SignOff_MachineName, DateFailed, CASubTitle, AssignUserID, AssignSupplierID, ReminderDate, 
                      ReminderSent, LocationID, UTCOffset, RecordStatus, Inserted, Updated, Deleted, GUID)
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,@CorrectiveActionEscalationID,@NotificationGroupID,@PriorityLevelID,@DateLogged,@DateOccurred,@DateDeadline,@Logged_UserID,@Logged_MachineName,@NotificationSent,@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@DateSignedOff,@SignOff_UserID,@SignOff_MachineName,@DateFailed,@CASubTitle,@AssignUserID,@AssignSupplierID,@ReminderDate,@ReminderSent,@LocationID,
                       @UTCOffset, 30,@Inserted,@Updated,@Deleted,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_CorrectiveAction
	SET              CATitle = @CATitle, CAReason = @CAReason, CARequired = @CARequired, CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, 
                      CorrectiveActionEscalationID = @CorrectiveActionEscalationID, NotificationGroupID = @NotificationGroupID, PriorityLevelID = @PriorityLevelID, 
                      DateLogged = @DateLogged, DateOccurred = @DateOccurred, DateDeadline = @DateDeadline, Logged_UserID = @Logged_UserID, 
                      Logged_MachineName = @Logged_MachineName, NotificationSent = @NotificationSent, ActionTaken = @ActionTaken, Comments = @Comments, 
                      DateCompleted = @DateCompleted, Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, 
                      DateSignedOff = @DateSignedOff, SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, DateFailed = @DateFailed, 
                      CASubTitle = @CASubTitle, AssignUserID = @AssignUserID, AssignSupplierID = @AssignSupplierID, ReminderDate = @ReminderDate, 
                      ReminderSent = @ReminderSent, RecordStatus = CASE WHEN @RecordStatus < 30 THEN 30 ELSE @RecordStatus END, LocationID = @LocationID, 
                      UTCOffset = @UTCOffset, Inserted = @Inserted, Updated = @Updated, Deleted = @Deleted
	WHERE     (GUID = @GUID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Upload_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Upload_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	5 Jun 2018
-- Description:	[insert description here]
-- Version:		1
-- ===================================================
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Upload_CorrectiveAction] 
	@LastSent bigint,
	@MaxSent bigint OUTPUT
AS

--Get anchor value
SET NOCOUNT ON
DECLARE @MaxCreated bigint, @MaxRowVersion bigint

SELECT     @MaxCreated = MAX(Created), @MaxRowVersion = MAX(CAST(RowVersion AS bigint))
FROM         QMS_CorrectiveAction

IF @MaxRowVersion > @MaxCreated
	SET @MaxSent = @MaxRowVersion
ELSE
	SET @MaxSent = @MaxCreated

--Populate temp table with CorrectiveActions to download so that source GUID can be looked up
DECLARE @UserID int
SET @UserID = 9999

DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

INSERT INTO TEMP_Selected
                      (UserID, SelectedID)
SELECT     @UserID AS UserID, CorrectiveActionID
FROM         QMS_CorrectiveAction
WHERE     (RowVersion > @LastSent) OR
                      (Created > @LastSent) AND (RecordStatus < 201)

SET NOCOUNT OFF

SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CASourceID, QMS_CorrectiveAction.SourceObjectID, SourceGUID.SourceObject_GUID, 
                      QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, QMS_CorrectiveAction.CAStatusID, 
                      QMS_CorrectiveAction.CorrectiveActionTypeID, QMS_CorrectiveAction.CorrectiveActionEscalationID, QMS_CorrectiveAction.NotificationGroupID, 
                      QMS_CorrectiveAction.PriorityLevelID, QMS_CorrectiveAction.DateLogged, QMS_CorrectiveAction.DateDeadline, QMS_CorrectiveAction.Logged_UserID, 
                      QMS_CorrectiveAction.Logged_MachineName, QMS_CorrectiveAction.NotificationSent, QMS_CorrectiveAction.ActionTaken, QMS_CorrectiveAction.Comments, 
                      QMS_CorrectiveAction.DateCompleted, QMS_CorrectiveAction.Completed_UserID, QMS_CorrectiveAction.Completed_MachineName, 
                      QMS_CorrectiveAction.DateSignedOff, QMS_CorrectiveAction.SignOff_UserID, QMS_CorrectiveAction.SignOff_MachineName, QMS_CorrectiveAction.DateFailed, 
                      QMS_CorrectiveAction.CASubTitle, QMS_CorrectiveAction.AssignUserID, QMS_CorrectiveAction.DateOccurred, QMS_CorrectiveAction.AssignSupplierID, 
                      QMS_CorrectiveAction.ReminderDate, QMS_CorrectiveAction.ReminderSent, QMS_CorrectiveAction.LocationID, QMS_CorrectiveAction.UTCOffset, QMS_CorrectiveAction.RecordStatus, 
                      QMS_CorrectiveAction.Inserted, QMS_CorrectiveAction.Updated, QMS_CorrectiveAction.Deleted, QMS_CorrectiveAction.GUID, QMS_CorrectiveAction.RowVersion, 
                      QMS_CorrectiveAction.Created
FROM         QMS_CorrectiveAction LEFT OUTER JOIN
                      dbo.FNC_CorrectiveAction_SourceGUID(@UserID) AS SourceGUID ON QMS_CorrectiveAction.CorrectiveActionID = SourceGUID.CorrectiveActionID
WHERE     (QMS_CorrectiveAction.RowVersion > @LastSent) AND (QMS_CorrectiveAction.RecordStatus <> 30) OR
                      (QMS_CorrectiveAction.RecordStatus <> 30) AND (QMS_CorrectiveAction.Created > @LastSent)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_List] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	20/5/2014
-- Description:	Lists all corrective actions for corrective action manager screen.
-- Version:		6
-- ===================================================
-- JT TFS 13-3845: Created
-- JT TFS 13-7000: Order by DateOccurred DESC, so that any truncations chop off old CAs first.
-- JT TFS 13-8870: Add source column.
-- JE TFS 13-12640: use new function to get corrective actions from QMS_CorrectiveActionUser
-- JT TFS 13-55914: 08/09/2016 - Performance: Inline reviewers function, prepopulate CAStatus, CAResponses and AssignUsers.
-- JM TFS 88643: Include UTC offset
-- ===================================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_List]
	@UserID int = 1,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@IsFilterApplied bit = 0
AS
BEGIN
	/* NOTE: Supplier and location filters work differently. All other filters are response filters. */

	-- NOTE: DateDeadline is the first sort order for completed.
	--       DateFailed is the first sort order for failed.
	--       DateCompleted is the first sort order for signed off.

	BEGIN -- setup temp tables 
		SET NOCOUNT ON 
		
		IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
		CREATE TABLE #tmpUserCAs (
			CorrectiveActionID int
		)
		
		IF @IsFilterApplied = 1
		BEGIN
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT CorrectiveActionID FROM TEMP_CorrectiveActionFilter
			WHERE UserID = @UserID
		
		END ELSE BEGIN
		
			--temp table containing all CAs (i.e. all statuses) user has permission to see
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	dbo.FNC_CorrectiveActionUser_CAList(@UserID)
			
		END

		--populate temp table with CA refs and their Reviewers' names (inline FNC_CorrectiveAction_ReviewList for all CAs)
		IF nullif(object_id('tempdb..#tmpCAReviewers'), 0) IS NOT NULL DROP TABLE #tmpCAReviewers
		CREATE TABLE #tmpCAReviewers (
			CorrectiveActionID int,
			Reviewers nvarchar(500)
		)
		INSERT INTO #tmpCAReviewers (CorrectiveActionID, Reviewers)
		SELECT outerquery.CorrectiveActionID, results = substring((
			SELECT DISTINCT ', ' + FullName
			FROM QMS_RecordLock 
			INNER JOIN QMS_User ON QMS_RecordLock.UserID = QMS_User.UserID
			WHERE	(ObjectName = N'QMS_CorrectiveAction') 
			AND		(LockStatus = 100)
			AND		(RowGUID = outerquery.GUID)
			FOR XML PATH(''), type
		).value('/', 'nvarchar(max)'), 3, 99999)
		FROM QMS_CorrectiveAction outerquery
		GROUP BY outerquery.CorrectiveActionID, outerquery.GUID
		
		-- Lookup responseIDs for all corrective actions.
		IF NULLIF(object_id('tempdb..#tmpCAResponses'), 0) IS NOT NULL DROP TABLE #tmpCAResponses;
		CREATE TABLE #tmpCAResponses (
			CorrectiveActionID int,
			ResponseID int
		)
		INSERT #tmpCAResponses (CorrectiveActionID, ResponseID)
		SELECT CorrectiveActionID, ResponseID FROM dbo.FNC_CorrectiveAction_Response()

		-- prepopulate status lookups.
		IF NULLIF(object_id('tempdb..#tmpCAStatus'), 0) IS NOT NULL DROP TABLE #tmpCAStatus;
		SELECT	APP_CorrectiveActionStatus.CAStatusID,
				ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS [Status],
				IsOutstanding = CASE WHEN APP_CorrectiveActionStatus.CAStatusID < 3 THEN 1 ELSE 0 END,
				IsCompleted = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 4 THEN 1 ELSE 0 END,
				IsFailed = CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (3,6,7) THEN 1 ELSE 0 END,
				IsSignedOff = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 5 THEN 1 ELSE 0 END,
				CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (1,2) THEN 'new'
					 WHEN APP_CorrectiveActionStatus.CAStatusID IN (4,5) THEN 'completed'
																		 ELSE 'failed' END AS [StatusClass]
		INTO #tmpCAStatus
		FROM APP_CorrectiveActionStatus;


		-- Prepopulate IsAssignedToMe list (for easier lookup)
		IF NULLIF(object_id('tempdb..#tmpCAAssignUsers'), 0) IS NOT NULL DROP TABLE #tmpCAAssignUsers;
		SELECT CorrectiveActionID, UserID
		INTO #tmpCAAssignUsers
		FROM dbo.FNC_CorrectiveAction_AssignUsers() AssignUser 
		WHERE AssignUser.UserID = @UserID

		SET NOCOUNT OFF
	END 

	SELECT 
			QMS_CorrectiveAction.CorrectiveActionID,
			dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) AS CARef,
			CAResponseList.ResponseID,
			QMS_CorrectiveAction.CATitle,
			QMS_CorrectiveAction.CASubTitle,
			QMS_CorrectiveAction.CAReason,
			QMS_CorrectiveAction.CARequired,
			QMS_CorrectiveAction.ActionTaken,
			QMS_CorrectiveAction.Comments,
			APP_CorrectiveActionStatus.[Status],
			APP_CorrectiveActionStatus.[StatusClass],
			APP_PriorityLevel.PriorityLevel,
			QMS_CorrectiveAction.DateOccurred,
			QMS_CorrectiveAction.DateLogged,
			QMS_CorrectiveAction.DateDeadline,
			QMS_CorrectiveActionType.CorrectiveActionType,
			QMS_CorrectiveActionEscalation.ListIndex AS [EscalationLevel],
			PM_VW_Location.LocationName AS Location,
			ISNULL(QMS_NotificationGroup.NotificationGroup, ISNULL(QMS_User_Assign.FullName, Supplier_Assign.SupplierName)) AS [AssignedTo],
			QMS_User_Logged.FullName AS [LoggedBy],
			QMS_CorrectiveAction.DateFailed,
			QMS_CorrectiveAction.DateCompleted,
			QMS_User_Completed.FullName AS [CompletedBy],
			CAReviewers.Reviewers AS [ReviewedBy],
			QMS_User_SignedOff.FullName AS [SignedOffBy],
			QMS_CorrectiveAction.DateSignedOff,
			QMS_CorrectiveAction.CAStatusID,

			CASE WHEN QMS_CorrectiveAction.CASourceID = 4 THEN N'Ad-Hoc'
					 WHEN QMS_CorrectiveAction.CASourceID = 3 THEN N'CA: ' + dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.SourceObjectID)
					 WHEN QMS_CorrectiveAction.CASourceID = 2 THEN 'Question'
					 WHEN QMS_CorrectiveAction.CASourceID = 1 THEN 'Check'
			END AS [Source],

			APP_CorrectiveActionStatus.IsOutstanding,
			IsLoggedByMe = CASE WHEN QMS_CorrectiveAction.Logged_UserID = @UserID THEN 1 ELSE 0 END,
			IsAssignedToMe = CASE WHEN EXISTS (	SELECT * FROM #tmpCAAssignUsers AssignUser 
												WHERE AssignUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
												AND AssignUser.UserID = @UserID) THEN 1 ELSE 0 END,
			APP_CorrectiveActionStatus.IsCompleted,
			APP_CorrectiveActionStatus.IsFailed,
			APP_CorrectiveActionStatus.IsSignedOff,
			QMS_CorrectiveAction.UTCOffset
		
	FROM QMS_CorrectiveAction
	INNER JOIN #tmpUserCAs AS UserCAList ON QMS_CorrectiveAction.CorrectiveActionID = UserCAList.CorrectiveActionID
	INNER JOIN #tmpCAReviewers AS CAReviewers ON UserCAList.CorrectiveActionID = CAReviewers.CorrectiveActionID
	INNER JOIN #tmpCAResponses AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
	INNER JOIN #tmpCAStatus AS APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	INNER JOIN QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID
	LEFT OUTER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
	LEFT OUTER JOIN QMS_CorrectiveActionType ON QMS_CorrectiveActionType.CorrectiveActionTypeID = QMS_CorrectiveAction.CorrectiveActionTypeID 
	LEFT OUTER JOIN QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID
	LEFT OUTER JOIN QMS_User AS QMS_User_SignedOff ON QMS_CorrectiveAction.SignOff_UserID = QMS_User_SignedOff.UserID
	LEFT OUTER JOIN APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
	LEFT OUTER JOIN PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
	LEFT OUTER JOIN PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID 
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR QMS_CorrectiveAction.DateOccurred > @DateFrom)
	AND (@DateTo IS NULL OR QMS_CorrectiveAction.DateOccurred <= @DateTo)
	ORDER BY	QMS_CorrectiveAction.DateOccurred DESC,
				QMS_CorrectiveAction.CorrectiveActionID DESC

	--get list of columns that need to be hidden in Excel export
	--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
	SELECT	1 AS TableIndex, convert(bit, 1) as ExportSetupTable, 'Portrait/Landscape' AS Orientation, 'n/a' AS SheetName, 'n/a' AS HiddenColumns
	UNION SELECT 0, 0, 'Landscape', 'Corrective Actions', 'CAStatusID,StatusClass,IsOutstanding,IsLoggedByMe,IsAssignedToMe,IsCompleted,IsFailed,IsSignedOff'
	ORDER BY TableIndex ASC

END
GO




PRINT 'Database updated successfully!'
GO

