-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_SupplierSitePermissions_Any')
	EXEC('CREATE FUNCTION [dbo].[FNC_SupplierSitePermissions_Any]() RETURNS bit AS BEGIN RETURN 0 END')
GO
--=============================================
-- Author:		MBS\phil.harding
-- Create date: 26 OCT 2015
-- Version:		4
-- Description: Indicates whether the specified user has any active Supplier permissions
--=============================================
-- PH TFS 13-28779: First iteration (Helps hide/show "Edit Check" icon)
-- PH TFS 13-28779: Removed relationship to location table as user can have permission to non-existant / deleted / hidden supplier.
-- PH TFS 13-35326: changed bit return value to int
-- MP TFS 89649: Added join to Locations to ensure filter on LocationType=3 for supplier sites
--=============================================
ALTER FUNCTION [dbo].[FNC_SupplierSitePermissions_Any] ( @UserID int )
RETURNS int

AS
BEGIN
	DECLARE @_userID int = @UserID;
	DECLARE @any int = 0;

	SET @any = CASE WHEN (
		(
			SELECT COUNT(UserPermissionID) 
			FROM QMS_UserPermissions AS userPermissions
			INNER JOIN PM_VW_Location AS Location ON LocationID = CAST(PermissionTitle AS int)

			WHERE (userPermissions.PermissionType = 103)
				AND (userPermissions.UserID = @_userId)
				AND (userPermissions.PermissionAllow = 1)
				AND (Location.LocationType = 3)

		) = 0) THEN 0 ELSE 1 END;

	RETURN @any;
END


GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_NotificationSetup_TimePending')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_NotificationSetup_TimePending] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 19/01/2011
-- Description:	Gets list of alerts waiting to be sent based on alert time
-- Version:		2
-- =============================================
-- DC TFS 89387: Corrected issue with different time zones not being supported
-- =============================================
ALTER PROCEDURE [dbo].[QRY_NotificationSetup_TimePending] 
	
AS

DECLARE @ServerUTCOffset float

SET @ServerUTCOffset = convert(float,ISNULL(dbo.FNC_GetOptionValue(28), 0))

SELECT	NotificationSetupID, LastSent, Frequency, AlertTime

FROM	QMS_NotificationSetup

WHERE	(RecordStatus < 201) AND (AlertTime IS NOT NULL) AND (Frequency = 2) AND
		(dbo.FNC_TrimDate(LastSent) IS NULL)

OR		(RecordStatus < 201) AND (AlertTime IS NOT NULL) AND (Frequency = 2) AND
		dbo.FNC_TrimDate(DATEADD(hour, @ServerUTCOffset, LastSent)) < dbo.FNC_TrimDate(dbo.FNC_GetDate()) AND										
		(DATEDIFF(mi, dbo.FNC_TrimDate(AlertTime), AlertTime) < DATEDIFF(mi, dbo.FNC_TrimDate(dbo.FNC_GetDate()), dbo.FNC_GetDate()))

OR		(RecordStatus < 201) AND (AlertTime IS NOT NULL) AND (Frequency = 6) AND
		(dbo.FNC_TrimDate(LastSent) IS NULL) AND		
		(DATEPART(weekday, dbo.FNC_GetDate()) BETWEEN 2 AND 6)

OR		(RecordStatus < 201) AND (AlertTime IS NOT NULL) AND (Frequency = 6) AND		
		dbo.FNC_TrimDate(DATEADD(hour, @ServerUTCOffset, LastSent)) < dbo.FNC_TrimDate(dbo.FNC_GetDate()) AND		
		(DATEDIFF(mi, dbo.FNC_TrimDate(AlertTime), AlertTime) < DATEDIFF(mi, dbo.FNC_TrimDate(dbo.FNC_GetDate()), dbo.FNC_GetDate())) AND
		(DATEPART(weekday, dbo.FNC_GetDate()) BETWEEN 2 AND 6)
GO




PRINT 'Database updated successfully!'
GO

