-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	18
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- SS TFS 13-49897: Added ISNULL(Uploaded, EndDate) so that EndDate will be used if Uploaded contains a NULL Value
-- PH TSF 13-61027 : v16 18/11/2016 - Bug Fix.  When including checks from the datawarehouse for todays date, an assumption was made that the datawarehouse had been updated before @DateFrom.  
--                   However, if this was not the case then checks were included from the past (but after the warehouse had been updated).  The greater of the datawarehouse update time and @DateFrom is now used.
-- JT TFS 13-82627 : Fix issue of Uploaded results appearing on QC Checks screen not in the date range specified.
-- JT TFS 13-88313 : Only merge results from warehouse within the date range specified.
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	-- This will contain responses which are not in the warehouse, typically those with today's date.
	DECLARE @UnfilteredResponseNotInWarehouse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	-- The datawarehouse can still be used when the user filters after the last warehouse build, but it will not contain much (if any) useful checks.
	-- We insert all the recent checks into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date.
	-- Just because the date range in entirely contained within the warehouse, doesn't mean that we only search in the warehouse. 
	-- Checks uploaded after the last warehouse build, but whose EndDate is within that range need to be included, as do incomplete checks (ResponseStatus 0)
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
	BEGIN
		DECLARE @override bit 
		SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

		DECLARE @ResponseFromDate datetime
		SELECT @ResponseFromDate = CASE WHEN @WarehouseBuildDate > @DateFrom THEN @WarehouseBuildDate ELSE @DateFrom END
			
		-- Get the majority of checks which will not be in the warehouse - the ones added after the warehouse has been built.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND EndDate BETWEEN @ResponseFromDate AND @DateTo


		-- Make sure we include the checks uploaded after the warehouse was last built, but within the entire date range. They will not yet be in the warehouse.
		-- Also, we have to make sure that incomplete checks get included, since they are never put in the warehouse.
		INSERT INTO @UnfilteredResponseNotInWarehouse (ResponseID, ResponseStatus, QAFlagID) 
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM QMS_Response
		WHERE	(RecordStatus < @RecordStatus) 
		AND (Uploaded > @WarehouseBuildDate OR ResponseStatus = 0)
		AND EndDate BETWEEN @DateFrom AND @DateTo
		AND ResponseID NOT IN (SELECT ResponseID FROM @UnfilteredResponseNotInWarehouse)


		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponseTodaysDate
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponseTodaysDate
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
			UPDATE	UnfilteredResponseTodaysDate
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE ISNULL(UnfilteredResponseTodaysDate.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponseTodaysDate
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)


		-- Include checks from the warehouse.
		INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
		FROM		RPT_Warehouse_Response 
		INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
		WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
		AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
		AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseNotInWarehouse UnfilteredResponseTodaysDate
						WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET	LocationID = RPT_Warehouse_Response.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = RPT_Warehouse_Response.SupplierID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
						PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
			WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

		INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
		SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseNotInWarehouse
	END
	ELSE --don't use warehouse table
	BEGIN
		DECLARE @OverrideOption bit 
		SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
		INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
		SELECT ResponseID, ResponseStatus,
				--check config value to use Actual or Override QAFlagID
				CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
		FROM	QMS_Response
		WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
			UPDATE	UnfilteredResponse
			SET		LocationID = Location.LocationID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
						PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
			ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
			UPDATE	UnfilteredResponse
			SET		SupplierID = QMS_ResponseHeader.Header_SourceID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
			ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
		IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
			UPDATE	UnfilteredResponse
			SET		CustomerID = PM_VW_StockCode.CustomerID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
						PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
			WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

		IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
			UPDATE	UnfilteredResponse
			SET		StockCodeID = HeaderStockCode.StockCodeID
			FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
						dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
			WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ProductProfile_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ProductProfile_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 04/04/2011
-- Description:	Fills TEMP_Selected with ResponseID for data to show on product profile report
-- Version:		10
-- =============================================
-- JE TFS 3061 - moved SelectedText population to separate UPDATE statement
-- JT TFS 3806 - Reinstated filtering based on ProductId and ProductText
-- JE TFS 4317 - amended filter reinstatement for reporting on PT
-- JE TFS 4668 - updated to filter by list of AssessmentTypeIDs and to handle two tier filtering
-- JT TFS 8117 - added offline reporting
-- JT TFS 13-1076 - Offline only uses SupplierResponse table (and ignores QMS_Response entries)
-- JT TFS 13-3246: Filtering matches on ID for stockcode if present.
-- JT TFS 13-28909: Remove NULL SelectedValue when filtering by Stockcode.
-- JT TFS 13-88169: Include grouping information if available.
-- =============================================
ALTER PROCEDURE RPT_ProductProfile_FillSelected 
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@ReportOn tinyint,
    @ProductID int,
    @ProductText nvarchar(255),
    @FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
    @AssessmentTypeID_LIST nvarchar(100),
    @Offline bit = 0
AS
BEGIN
	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	-- Always assume that the filtering has been done (offline and online check live happily side by side in here)
	INSERT INTO TEMP_Selected (SelectedID, UserID)
	SELECT ResponseID, UserID FROM TEMP_ResponseFilter
	WHERE UserID = @UserID
	
	-- Don't do this filtering bit for stockcode directly.
	IF NOT (@ReportOn = 2 AND @ProductID > 0)
	BEGIN
		UPDATE selected
		SET SelectedText = GroupByText
		FROM TEMP_Selected as selected 
		INNER JOIN TEMP_ResponseGroupBy groupby ON selected.SelectedID = groupby.ResponseID AND groupby.UserID = @UserID
		WHERE selected.UserID = @UserID
		AND NULLIF(GroupByText, '') IS NOT NULL -- don't put blank entries in.
	END

	IF @Offline = 1
	BEGIN
		UPDATE TEMP_Selected
		SET		SelectedText = GroupBy.GroupByText, 
				SelectedValue = GroupBy.GroupByID
		FROM TEMP_Selected
		INNER JOIN dbo.FNC_ReportGrouping_Response_Offline(@UserID, @ReportOn) 
					AS GroupBy ON TEMP_Selected.SelectedID = GroupBy.ResponseID
		WHERE UserID = @UserID
		AND SelectedText IS NULL
		

	END ELSE BEGIN -- @Offline = 0
		-- will only work on non-custom filters, but that's ok because we restrict what @ReportOn can be.
		--TFS 3060 - update table with grouping titles
		UPDATE TEMP_Selected
		SET SelectedText = GroupBy.GroupByText,
			SelectedValue = GroupBy.GroupByID 
		FROM TEMP_Selected
		INNER JOIN dbo.FNC_ReportGrouping_Response(@UserID, @ReportOn) 
				AS GroupBy ON TEMP_Selected.SelectedID = GroupBy.ResponseID
		WHERE UserID = @UserID 
		AND SelectedText IS NULL
					
	END

	IF @ReportOn = 2 AND @ProductID > 0 -- Reporting by stockcode always supplies ProductID.
	BEGIN
		DELETE TEMP_Selected
		WHERE UserID = @UserID
		AND (SelectedValue <> @ProductID OR SelectedValue IS NULL)
			
	END ELSE BEGIN
		-- TFS 3806 - reinstate filters
		DELETE TEMP_Selected 
		WHERE	UserID = @UserID 
		AND		((@ReportOn <> 16 AND ISNULL(SelectedText, '') <> @ProductText)
				  OR --for PT reporting, SelectedText will contain a list of PTs, so need to use LIKE
				 (@ReportOn = 16 AND ISNULL(SelectedText, '') NOT LIKE '%' + @ProductText + '%'))
	END
END
GO






PRINT 'Database updated successfully!'
GO

