-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

-- BEGIN DATA APP_AssessmentType_Add_FilterCheckAlertsOlderThan
BEGIN TRY
IF NOT EXISTS (SELECT Column_Name FROM INFORMATION_SCHEMA.COLUMNS WHERE Table_Name = 'APP_AssessmentType' AND Column_Name = 'FilterCheckAlertsOlderThan')
BEGIN
	ALTER TABLE APP_AssessmentType
	ADD FilterCheckAlertsOlderThan INT
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA APP_AssessmentType_Add_FilterCheckAlertsOlderThan', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA APP_AssessmentType_Add_FilterCheckAlertsOlderThan


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_AssessmentType')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_AssessmentType] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	21 Apr 2015
-- Description:	Imports APP_AssessmentType into mobile.
-- Version:		3
-- ===================================================
-- JT TFS 13-17398 - CanLinkAQC column added.
-- MartinP TFS 13-74325 - FilterCheckAlertsOlderThan column added.
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_AssessmentType] 
	@AssessmentTypeID int,
	@AssessmentType nvarchar(50),
	@ResourceName nvarchar(50),
	@ListIndex int,
	@Hide int,
	@CompleteActionType int,
	@CompleteAction nvarchar(255),
	@CompleteSuppressMsg bit,
	@ImmediateSupplierReport tinyint,
	@DailySupplierReport tinyint,
	@RequireSignOff bit,
	@ShowAssessmentAction bit,
	@ProcedureURL nvarchar(255) = NULL,
	@ValidateAttachment tinyint = NULL,
	@SaveActionType int = NULL,
	@SaveAction nvarchar(255) = NULL,
	@SaveSuppressMsg bit = 0,
	@QCActionActionType int = NULL,
	@QCActionAction nvarchar(255) = NULL,
	@QCActionSuppressMsg bit = 0,
	@ValidateHeaderSP nvarchar(50) = NULL,
	@AssessmentFormat tinyint = NULL,
	@EnableBackfill bit = 0,
	@StartAction TINYINT = NULL,
	@NewAssessmentAlert bit = NULL,
	@AllowCompletionWithNoAssessment BIT = NULL,
	@CanLinkAQC BIT = NULL,
	@FilterCheckAlertsOlderThan INT = NULL,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @AssessmentFormat IS NULL
	SET @AssessmentFormat = 0

IF @StartAction IS NULL
	SET @StartAction = 0
	
IF @NewAssessmentAlert IS NULL
	SET @NewAssessmentAlert = 0
	
IF @AllowCompletionWithNoAssessment IS NULL
	SET @AllowCompletionWithNoAssessment = 0

IF @CanLinkAQC IS NULL
	SET @CanLinkAQC = 0
	
IF NOT EXISTS(SELECT * FROM APP_AssessmentType WHERE (AssessmentTypeID = @AssessmentTypeID))
BEGIN --Append record
	SET IDENTITY_INSERT APP_AssessmentType ON
	INSERT INTO APP_AssessmentType
                      (AssessmentTypeID, AssessmentType, ResourceName, ListIndex, Hide, CompleteActionType, CompleteAction, CompleteSuppressMsg, ImmediateSupplierReport, 
                      DailySupplierReport, RequireSignOff, ShowAssessmentAction, ProcedureURL, ValidateAttachment, SaveActionType, SaveAction, SaveSuppressMsg, 
                      QCActionActionType, QCActionAction, QCActionSuppressMsg, ValidateHeaderSP, AssessmentFormat, EnableBackfill, StartAction, NewAssessmentAlert, 
                      AllowCompletionWithNoAssessment, CanLinkAQC, FilterCheckAlertsOlderThan, Updated, GUID)
	VALUES     (@AssessmentTypeID,@AssessmentType,@ResourceName,@ListIndex,@Hide,@CompleteActionType,@CompleteAction,@CompleteSuppressMsg,@ImmediateSupplierReport,
				@DailySupplierReport,@RequireSignOff,@ShowAssessmentAction,@ProcedureURL,@ValidateAttachment,@SaveActionType,@SaveAction,@SaveSuppressMsg,
				@QCActionActionType,@QCActionAction,@QCActionSuppressMsg,@ValidateHeaderSP,@AssessmentFormat,@EnableBackfill,@StartAction,@NewAssessmentAlert,
				@AllowCompletionWithNoAssessment, @CanLinkAQC, @FilterCheckAlertsOlderThan, @Updated,@GUID)
	SET @InsertCount = @@rowcount
	SET IDENTITY_INSERT APP_AssessmentType OFF
END

ELSE
BEGIN --Update record
	UPDATE    APP_AssessmentType
	SET              AssessmentType = @AssessmentType, ResourceName = @ResourceName, ListIndex = @ListIndex, Hide = @Hide, CompleteActionType = @CompleteActionType, 
                      CompleteAction = @CompleteAction, CompleteSuppressMsg = @CompleteSuppressMsg, ImmediateSupplierReport = @ImmediateSupplierReport, 
                      DailySupplierReport = @DailySupplierReport, RequireSignOff = @RequireSignOff, ShowAssessmentAction = @ShowAssessmentAction, Updated = @Updated, 
                      ProcedureURL = @ProcedureURL, ValidateAttachment = @ValidateAttachment, SaveActionType = @SaveActionType, SaveAction = @SaveAction, 
                      SaveSuppressMsg = @SaveSuppressMsg, QCActionActionType = @QCActionActionType, QCActionAction = @QCActionAction, 
                      QCActionSuppressMsg = @QCActionSuppressMsg, ValidateHeaderSP = @ValidateHeaderSP, AssessmentFormat = @AssessmentFormat, 
                      EnableBackfill = @EnableBackfill, StartAction = @StartAction, NewAssessmentAlert = @NewAssessmentAlert, 
                      AllowCompletionWithNoAssessment = @AllowCompletionWithNoAssessment, CanLinkAQC = @CanLinkAQC, FilterCheckAlertsOlderThan = @FilterCheckAlertsOlderThan
	WHERE     (AssessmentTypeID = @AssessmentTypeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_NotificationPending')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_NotificationPending] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/06/2010
-- Description:	Gets responses that haven't been notified
-- Version:		6
-- =============================================
-- TFS 4021: Linking checks to company
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JE TFS 13-4124: updated to handle AQC Multi Check format
-- MartinP TFS 13-24454: Added clause so that data is not returned from QMS_Attachment when SourceObjectID IS NULL
-- MartinP TFS 13-43361: Changed comparison on QMS_Response.Inserted to look up from APP_AssessmentType.FilterCheckAlertsOlderThan or APPConfig ID 140 if FilterCheckAlertsOlderThan is null
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_NotificationPending] 
AS

EXEC [dbo].[UP_Response_SetCompany]

DECLARE @FilterCheckAlertsOlderThan INT = dbo.FNC_GetOptionValue(140) 

SELECT     QMS_Response.ResponseID
FROM         QMS_Response INNER JOIN
				(SELECT	COUNT(ResponseQuestionID) AS QuestionCount, ResponseID
				 FROM	QMS_ResponseQuestion
				 GROUP BY ResponseID) AS ResponseQuestions ON QMS_Response.ResponseID = ResponseQuestions.ResponseID INNER JOIN
			 APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID
WHERE	(QMS_Response.ResponseStatus = 1) AND (QMS_Response.RecordStatus < 100) AND
			(QMS_Response.NotificationSent = 0) AND	(QMS_Response.Inserted > DATEADD(day, - ISNULL(FilterCheckAlertsOlderThan,@FilterCheckAlertsOlderThan), GETDATE())) AND
			(QMS_Response.ResponseID NOT IN
                          (SELECT  SourceObjectID
                            FROM	QMS_Attachment
                            WHERE	(AttachmentSourceID = 1) 
                            AND		(RecordStatus = 100)
							AND SourceObjectID IS NOT NULL)) AND
			--if AssessmentFormat = 5 return Child checks only, if = 6 or 7 return ParentChecks only, else return everything
			((APP_AssessmentType.AssessmentFormat = 5 AND (QMS_Response.ParentResponseGUID IS NOT NULL)) OR
			 (APP_AssessmentType.AssessmentFormat IN (6,7) AND (QMS_Response.ParentResponseGUID IS NULL)) OR
				(APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) AND (QMS_Response.ParentResponseGUID IS NULL OR QMS_Response.ParentResponseGUID IS NOT NULL)))
GO






PRINT 'Database updated successfully!'
GO

