-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_AttachmentImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_AttachmentImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 12/03/2009  
-- Description: Gets attachment data for check images  
-- Version:  5 
-- =============================================  
-- MP TFS 5658 - added images linked to corrective actions  
-- MartinP TFS 13-45992 - Removed CROSS JOIN by splitting out into temporary tables
-- MartinP TFS 13- 72418 - Added ORDER BY QMS_Attachment.Inserted DESC to final select statement 
-- MartinP TFS 13 - 72826 - Corrected ORDER BY Statement to sort by ASC (default behaviour of ORDER BY)
-- =============================================  
ALTER PROCEDURE [dbo].[RPT_Response_AttachmentImages]   
 @UserID int   
AS  
BEGIN  
  
 SET NOCOUNT ON  
  
 DECLARE @ResponseCATable TABLE (ResponseID INT, CorrectiveActionID INT)  
  
 INSERT INTO @ResponseCATable (ResponseID, CorrectiveActionID)  
  SELECT SelectedID,NULL   
  FROM TEMP_Selected  
  WHERE UserID = @UserID  
  
 UPDATE    ResponseCATable  
 SET          CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID  
 FROM         QMS_CorrectiveAction   
     INNER JOIN @ResponseCATable AS ResponseCATable ON QMS_CorrectiveAction.SourceObjectID = ResponseCATable.ResponseID  
 WHERE     (QMS_CorrectiveAction.CASourceID = 1)   
  
 DECLARE @ResponseAttachTable TABLE (ResponseID INT, AttachmentID INT)  
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)  
 SELECT ResponseCATable.ResponseID, AttachmentID  
 FROM @ResponseCATable AS ResponseCATable  
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID  
 WHERE      (QMS_Attachment.AttachmentSourceID = 1)   
    AND (QMS_Attachment.RecordStatus < 201)   
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)   
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 3)) IN ('jpg', 'bmp', 'gif', 'png'))   
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.ResponseID)  
     
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)  
 SELECT ResponseCATable.ResponseID, AttachmentID  
 FROM @ResponseCATable AS ResponseCATable  
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID  
    AND (QMS_Attachment.AttachmentSourceID = 2)   
    AND (QMS_Attachment.RecordStatus < 201)  
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)   
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 3)) IN ('jpg', 'bmp', 'gif', 'png'))   
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.CorrectiveActionID)  
  
 SET NOCOUNT OFF  
  
 SELECT     ResponseAttachTable.ResponseID,  
      QMS_Attachment.AttachmentTitle,   
      QMS_Attachment.AttachmentFileName,   
      QMS_Attachment.Attachment,    
      QMS_Attachment.AttachmentURL  
 FROM @ResponseAttachTable AS ResponseAttachTable  
 INNER JOIN QMS_Attachment ON ResponseAttachTable.AttachmentID = QMS_Attachment.AttachmentID
 ORDER BY QMS_Attachment.Inserted  
  
  
END  
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Client_UpdateDetail')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Client_UpdateDetail] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 19/02/2015
-- Description:	Gets sync client data
-- Version:		3
-- ==============================================
-- JT TFS 14911: Update machine name on each Sync
-- JT TFS 69195: Update version number on each Sync (renamed from SYNC_Client_UpdateMachineName)
-- MartinP TFS 72791: 22/05/2017 - Corrected @Version input parameter to default to null 
-- ==============================================
ALTER PROCEDURE SYNC_Client_UpdateDetail
	@ClientGuid as uniqueidentifier,
	@MachineName nvarchar(50) = NULL,
    @Version nvarchar(100) = NULL
AS
BEGIN
	DECLARE @ClientID int, @ClientType int
	SELECT TOP 1 @ClientID = ClientID, @ClientType = ClientType
	FROM SYNC_Client 
	WHERE @ClientGuid = ClientGuid
	ORDER BY [Enabled] DESC, LastSync DESC, Inserted DESC -- Most recently synched and enabled one first (in case there are more than one)

	UPDATE SYNC_Client
	SET Version = @Version
	WHERE ClientID = @ClientID 
	AND @Version IS NOT NULL
	AND @Version <> ISNULL(Version, '') -- Avoid a write unless we have to.

	UPDATE SYNC_Client
	SET MachineName = @MachineName
	WHERE ClientID = @ClientID 
	AND @MachineName IS NOT NULL
	AND @MachineName <> ISNULL(MachineName, '') -- Avoid a write unless we have to.

	IF @MachineName IS NOT NULL
	BEGIN
	-- disable other enabled devices which have the same name, which have not been synchronised in the last 7 days.
		UPDATE SYNC_Client
		SET Enabled = 0 
		WHERE MachineName = @MachineName
		AND ClientType = @ClientType
		AND LastSync < dateadd(day, -7, getutcdate()) -- Has *NOT* been synchronised in the last 7 days.
		AND @ClientID <> ClientID -- Not the one we just updated above.
		AND Enabled <> 0 -- Avoid a write unless we have to.
	END
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_Assessment_AddLockStatus')
	EXEC ('CREATE PROCEDURE [dbo].[UP_Assessment_AddLockStatus] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 30/05/2017
-- Description:	Add complete lock status entry.
-- Version:		1
-- =============================================
-- JT TFS 13-72321: Mechanism to add a single lockstatus entry (checking in previous locks)
-- =============================================
ALTER PROCEDURE dbo.UP_Assessment_AddLockStatus
	@AssessmentID int,
	@LockStatus int,
	@UserID int
AS
BEGIN
	DECLARE @RowGUID uniqueidentifier
	SELECT @RowGUID = GUID FROM QMS_Assessment WHERE AssessmentID = @AssessmentID
	IF @RowGUID IS NULL
	BEGIN
		RAISERROR('No such assessment exists', 11, 1);
		RETURN;
	END

	DECLARE @RecordLockID int;

	-- If there is a checkout, check it in.
	SELECT @RecordLockID = RecordLockID FROM QMS_RecordLock
	WHERE ObjectName = 'QMS_Assessment' 
	AND RowGUID = @RowGUID
	AND LockFinish IS NULL

	IF @RecordLockID IS NOT NULL
	BEGIN
		EXEC UP_RecordLock_Status @RecordLockID, 101 -- Check In
	END

	-- Calling other SPs to handle the entry in case they change behaviour.
	EXEC APP_RecordLock_Checkout 'QMS_Assessment', @RowGUID, @UserID

	SELECT @RecordLockID = RecordLockID FROM QMS_RecordLock
	WHERE ObjectName = 'QMS_Assessment' 
	AND RowGUID = @RowGUID
	AND LockFinish IS NULL

	IF @RecordLockID IS NOT NULL
	BEGIN
		EXEC UP_RecordLock_Status @RecordLockID, @LockStatus -- End up with a row that is finished.
	END
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Guidance')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Guidance] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Adds and edits guidance
-- Version:		2
-- =============================================
-- SS TFS 13-73468: 24/05/2017 - Added Global column into returned results
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Guidance] 
	@GuidanceID int,
	@GuidanceDesc nvarchar(255),
	@GuidanceString nvarchar(4000),
	@GuidanceURL nvarchar(255),
	@ProcedureURL nvarchar(255),
	@SpecificationURL nvarchar(255),
	@Hide bit,
	@Global int,
	@UserID int,
	@Assessment nvarchar(120) = NULL --Only a placeholder as this is in select statment for admin list
AS

SET NOCOUNT ON

IF ISNULL(@GuidanceID,0)=0 --New guidance
BEGIN
	INSERT INTO QMS_Guidance
                      (GuidanceDesc, GuidanceString, GuidanceURL, ProcedureURL, SpecificationURL, Hide, Global, UserID)
	VALUES     (@GuidanceDesc,@GuidanceString,@GuidanceURL,@ProcedureURL,@SpecificationURL,@Hide,@Global,@UserID)
	--Get new QuestionID
	SELECT     @GuidanceID = MAX(GuidanceID)
	FROM         QMS_Guidance
END
ELSE --Update guidance
	UPDATE    QMS_Guidance
	SET              GuidanceDesc = @GuidanceDesc, GuidanceString = @GuidanceString, GuidanceURL = @GuidanceURL, ProcedureURL = @ProcedureURL, 
                      SpecificationURL = @SpecificationURL, Hide = @Hide, Global =@Global, UserID = @UserID, MachineName = HOST_NAME(), Updated = GETUTCDATE()
	WHERE     (GuidanceID = @GuidanceID)

SET NOCOUNT OFF

SELECT @GuidanceID
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Guidance_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Guidance_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Gets list of guidance for admin
-- Version:		2
-- =============================================
-- MP TFS 5981 - Hide RecordStatus 80 records downloaded from AQC
-- SS TFS 13-73467: 24/05/2017 - Added Global column into returned results
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Guidance_AdminList] 

AS

SET NOCOUNT ON

--Build temp table of guidance useage in assessments
DECLARE @Table_GuidanceAssessments AS TABLE (GuidanceID int,  AssessmentID int)

--Add assessment guidance
INSERT INTO @Table_GuidanceAssessments (GuidanceID, AssessmentID)
SELECT     GuidanceID, AssessmentID
FROM         QMS_Assessment
WHERE     (GuidanceID IS NOT NULL) AND (RecordStatus < 201)

--Add question guidance
INSERT INTO @Table_GuidanceAssessments (GuidanceID, AssessmentID)
SELECT     DISTINCT QMS_AssessmentQuestion.GuidanceID, QMS_Assessment.AssessmentID
FROM         QMS_Assessment INNER JOIN
                      QMS_AssessmentQuestion ON QMS_Assessment.AssessmentID = QMS_AssessmentQuestion.AssessmentID
WHERE     (QMS_Assessment.RecordStatus < 201) AND (QMS_AssessmentQuestion.GuidanceID IS NOT NULL) AND (QMS_AssessmentQuestion.RecordStatus < 201)

--Add question constraint guidance
INSERT INTO @Table_GuidanceAssessments (GuidanceID, AssessmentID)
SELECT     DISTINCT QMS_AssessmentQuestionConstraint.GuidanceID, QMS_Assessment.AssessmentID
FROM         QMS_Assessment INNER JOIN
                      QMS_AssessmentQuestion ON QMS_Assessment.AssessmentID = QMS_AssessmentQuestion.AssessmentID INNER JOIN
                      QMS_AssessmentQuestionConstraint ON QMS_AssessmentQuestion.AssessmentQuestionID = QMS_AssessmentQuestionConstraint.AssessmentQuestionID
WHERE     (QMS_Assessment.RecordStatus < 201) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_AssessmentQuestionConstraint.GuidanceID IS NOT NULL) 
                      AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201)

--Add assessment constraint guidance
INSERT INTO @Table_GuidanceAssessments (GuidanceID, AssessmentID)
SELECT DISTINCT QMS_AssessmentConstraint.GuidanceID, QMS_Assessment.AssessmentID
FROM         QMS_Assessment INNER JOIN
                      QMS_AssessmentConstraint ON QMS_Assessment.AssessmentID = QMS_AssessmentConstraint.AssessmentID
WHERE     (QMS_Assessment.RecordStatus < 201) AND (QMS_AssessmentConstraint.GuidanceID IS NOT NULL) AND (QMS_AssessmentConstraint.RecordStatus < 201)

SET NOCOUNT OFF

SELECT     QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, CAST(CASE WHEN isnull(NumAttachments, 0) 
                      = 0 THEN 0 ELSE 1 END AS bit) AS HasAttachment, QMS_Guidance.GuidanceURL, QMS_Guidance.ProcedureURL, QMS_Guidance.SpecificationURL, QMS_Guidance.Global,
                      QMS_Guidance.Hide, CASE WHEN ISNULL(Assessments.AssessmentCount,0) = 1 THEN Assessments.AssessmentName + CASE WHEN Assessments.Version IS NULL THEN '' ELSE N' v' + Assessments.Version END WHEN ISNULL(Assessments.AssessmentCount,0) > 

1 THEN N'(Multiple)' ELSE NULL END AS Assessment,
                      ISNULL(Assessments.ActiveCount, 0) AS ActiveQuestionCount
FROM         QMS_Guidance LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS GuidanceID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Guidance.GuidanceID = Attachments.GuidanceID LEFT OUTER JOIN
                          (SELECT     AssessmentGuidance.GuidanceID, COUNT(QMS_Assessment.AssessmentID) AS AssessmentCount, SUM(CAST(APP_AssessmentStatus.Active AS int)) 
                                                   AS ActiveCount, MAX(QMS_Assessment.AssessmentName) AS AssessmentName, MAX(QMS_Assessment.Version) AS Version
FROM          QMS_Assessment INNER JOIN
                                                       (SELECT DISTINCT GuidanceID, AssessmentID
                                                         FROM          @Table_GuidanceAssessments) AS AssessmentGuidance ON QMS_Assessment.AssessmentID = AssessmentGuidance.AssessmentID INNER JOIN
                                                   APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID
                            WHERE      (QMS_Assessment.RecordStatus < 201)
                            GROUP BY AssessmentGuidance.GuidanceID) AS Assessments ON QMS_Guidance.GuidanceID = Assessments.GuidanceID
WHERE     (QMS_Guidance.RecordStatus < 201) AND (QMS_Guidance.RecordStatus <> 80)
ORDER BY QMS_Guidance.GuidanceDesc
GO



PRINT 'Database updated successfully!'
GO

