-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


-- BEGIN DATA Add_HashType_ColumnTo_QMS_User_65936
BEGIN TRY
-- Add_HashType_ColumnTo_QMS_User_65936
IF NOT EXISTS
(
	SELECT *
	FROM sys.columns 
	WHERE Name      = N'HashType'
    AND Object_ID = Object_ID(N'QMS_User')
)
BEGIN
	EXECUTE('ALTER TABLE [dbo].[QMS_User] ADD HashType int')
		
	EXECUTE('
		UPDATE [dbo].[QMS_User]
		SET [HashType] = 
		(
			SELECT CASE WHEN [Password] IS NOT NULL AND [Password] LIKE ''$%'' THEN 3 ELSE 
			(
				SELECT CASE WHEN [Password] IS NOT NULL THEN 0 
				END
			)
			END
		)
	')
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_HashType_ColumnTo_QMS_User_65936', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add_HashType_ColumnTo_QMS_User_65936


-- BEGIN DATA  Add_HashType_ColumnTo_QMS_UserPassword_66015
BEGIN TRY
-- Add_HashType_ColumnTo_QMS_UserPassword_66015
IF NOT EXISTS
(
	SELECT *
	FROM sys.columns 
	WHERE Name      = N'HashType'
    AND Object_ID = Object_ID(N'QMS_UserPassword')
)
BEGIN
	EXECUTE('ALTER TABLE [dbo].[QMS_UserPassword] ADD HashType int')
		
	EXECUTE('
		UPDATE [dbo].[QMS_UserPassword]
		SET [HashType] = 
		(
			SELECT CASE WHEN [Password] IS NOT NULL AND [Password] LIKE ''$%'' THEN 3 ELSE 
			(
				SELECT CASE WHEN [Password] IS NOT NULL THEN 0 
				END
			)
			END
		)
	')
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA  Add_HashType_ColumnTo_QMS_UserPassword_66015', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA  Add_HashType_ColumnTo_QMS_UserPassword_66015

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ReportFilter_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ReportFilter_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 06/07/2010
-- Description:	Gets list of available report filters
-- Version:		6
-- =============================================
-- j.toolan: 23/4/2012 TFS 3216 - Added StockCode filter for stockcode reports.
-- j.toolan: 31/7/2012 TFS 4242 - Added extra report types (can remove @IsStockCodeFilter after release).
-- JE TFS 4050 - Added CA report type
-- JE TFS 5025 - amended option 0
-- TH TFS 13-65157: 31/01/2017 - Add default parameter to determine if we use database translations or not.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ReportFilter_Combo] 
	@UserID int,
	@IsStockCodeFilter bit = 0,
	@ReportFilterType int = NULL,
	@DoNotTranslate bit = 0
AS
BEGIN
	SET NOCOUNT ON
	SELECT @ReportFilterType = CASE WHEN @ReportFilterType IS NOT NULL THEN @ReportFilterType
									WHEN @IsStockCodeFilter = 0 THEN 0
									ELSE 1 END
	SET NOCOUNT OFF

	SELECT  ReportFilterID,
			CASE WHEN @DoNotTranslate = 0
				THEN ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), ReportFilter)
				ELSE ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), ReportFilter)
			END AS ReportFilter
	FROM    APP_ReportFilter
	WHERE	(Hide = 0)
	AND (
			(@ReportFilterType = 0 AND IsResponseFilter = 1)
			OR
			(@ReportFilterType = 1 AND IsStockCodeFilter = 1)
			OR 
			(@ReportFilterType = 2 AND IsAssessmentFilter = 1)
			OR
			(@ReportFilterType = 3 AND IsCorrectiveActionFilter = 1)
	)
	ORDER BY ListIndex
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_Details_ByUsername')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_Details_ByUsername] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 03/02/2017
-- Description	: Procedure to get user details (no longer performed by QRY_User_Validate)
-- Version		: 1
-- =============================================
-- PH TFS 13-65973 : v1 03/02/2017
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_Details_ByUsername] 
	@Username nvarchar(255)
AS

SELECT
	[user].UserID,
	[user].FullName,
	ISNULL(userGroup.UserLevel, [user].UserLevel) AS UserLevel,
	countryLocale.CountryLocaleID,
	countryLocale.StringCode
FROM	QMS_User AS [user]
LEFT OUTER JOIN APP_CountryLocales AS countryLocale
	ON [user].LocaleID = countryLocale.CountryLocaleID
LEFT OUTER JOIN
(
	SELECT
		UserID,
		FullName,
		UserLevel
	FROM	QMS_User
	WHERE
		IsUserGroup = 1
		AND RecordStatus < 201
		AND LeftCompany = 0
) AS userGroup
	ON [user].ParentUserID = UserGroup.UserID
WHERE
	[user].UserName = @Username 
	AND [user].RecordStatus < 201
	AND [user].IsUserGroup = 0;
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_HashedPassword_ByUserName')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_HashedPassword_ByUserName] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 03/02/2017
-- Description	: Gets a specified users hashed password by user name. This is required for bcrypt validation.
-- Version		: 4
-- =============================================
-- PH TFS 13-65967 : v1 03/02/2017 - Created
-- PH TFS 13-65967 : v2 03/02/2017 - Removed invalid users
-- PH TFS 13-65967 : v3 03/02/2017 - Removed user groups
-- PH TFS 13-65967 : v4 03/02/2017 - Include HashType
-- =============================================

ALTER PROCEDURE [dbo].[QRY_User_HashedPassword_ByUserName] 
	@Username nvarchar(255)
AS
SET NOCOUNT ON

SELECT Password, HashType
FROM [dbo].[QMS_User]
WHERE
	UserName = @Username
	AND LeftCompany = 0
	AND RecordStatus < 201
	AND IsUserGroup = 0;
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_RecentPasswords')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_RecentPasswords] AS SELECT ''stub version, to be replaced''')
GO
-- =========================================================
-- Author:		Jon Edwards
-- Create date: 18/05/2011
-- Description:	Returns a user's passwords for last 6 months
--				or specified number of password changes
-- Version		: 2
-- =========================================================
-- PH TFS 13-66017 : v2 03/02/2017 - Return HashType to validate against previous passwords.
-- =========================================================
ALTER PROCEDURE [dbo].[QRY_User_RecentPasswords]

	@UserID int

AS
BEGIN

	DECLARE @CurrentPassword nvarchar(255)
	DECLARE @PasswordCount int

	SET NOCOUNT ON;

	--get current password
	SELECT @CurrentPassword = Password FROM QMS_User WHERE UserID = @UserID

	--get count of passwords over last x days
	SELECT @PasswordCount = COUNT(Password)
							FROM QMS_UserPassword
							WHERE UserID = @UserID AND CreationDate > DATEADD(day, -CAST(ISNULL(dbo.FNC_GetOptionValue(48),0) AS int), GETDATE())

	--if passwords over last x days less than specified number of passwords
	IF @PasswordCount < CAST(ISNULL(dbo.FNC_GetOptionValue(50),0) AS int)

		SELECT Password, HashType
		FROM QMS_UserPassword
		WHERE UserID = @UserID AND CreationDate > DATEADD(day, -CAST(ISNULL(dbo.FNC_GetOptionValue(48),0) AS int), GETDATE()) AND
				(@CurrentPassword IS NULL OR @CurrentPassword <> Password)
		ORDER BY CreationDate DESC
	--else specified number of recent passwords
	ELSE
	
		SELECT TOP (CAST(ISNULL(dbo.FNC_GetOptionValue(50),0) AS int)) Password, HashType
		FROM QMS_UserPassword
		WHERE UserID = @UserID AND (@CurrentPassword IS NULL OR @CurrentPassword <> Password)
		ORDER BY CreationDate DESC
	
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_Validate')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_Validate] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 26/06/2008
-- Description	: Procedure to validate user credentials
-- Version		: 6
-- =============================================
-- j.toolan 8/3/2012 Added code to allow password to be sent using md5 or sha2
-- j.toolan 11/1/2013 Code to always allow RC4 (for sync server) authentication.
-- JT TFS 6792: Added code to make sure that locked accounts cannot log in.
-- S Irving: Removed ', *' from the SELECT list
-- PH TFS 13-65862 : v5 02/02/2017 - Sync hashes will be stored according to the customers config setting only.  AQC will not be allowed to deviate from this.
-- PH TFS 13-65862 : v6 02/02/2017 - Sync hashes will now onmly be held in a single column.  Will no longer use @PIN.  Will leave as backward compatible interface.
-- =============================================

ALTER PROCEDURE [dbo].[QRY_User_Validate] 
	@Username nvarchar(255), 
	@Password nvarchar(255),
	@PIN nvarchar(10) = NULL
AS

-- RC4  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = 'E1A2F3931A22B9A3235E880DF6FD0137', @PIN nvarchar(10) = NULL
-- MD5  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = '1c952787aef6aed213e3e7764556dd', @PIN nvarchar(10) = NULL
-- SHA2 -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = 'pyj5ztrNCr0/VoXgKWpln2DpQZSoBoLNCZM+yq/srj8=', @PIN nvarchar(10) = NULL
-- PIN  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = NULL, @PIN nvarchar(10) = '1234'

-- AQC user: -- declare @Username nvarchar(255) = 'wealmoor.AQC', @Password nvarchar(255) = '4F5DD615F790EDC53514816DB90CB6D83400D082', @PIN nvarchar(10) = NULL

SELECT
	QMS_User.UserID,
	QMS_User.FullName,
	ISNULL(UserGroup.UserLevel, QMS_User.UserLevel) AS UserLevel,
	APP_CountryLocales.CountryLocaleID,
	APP_CountryLocales.StringCode
FROM	QMS_User
LEFT OUTER JOIN APP_CountryLocales
	ON QMS_User.LocaleID = APP_CountryLocales.CountryLocaleID
LEFT OUTER JOIN
(
	SELECT
		UserID,
		FullName,
		UserLevel
	FROM QMS_User
	WHERE
		IsUserGroup = 1
		AND RecordStatus < 201
		AND LeftCompany = 0
) AS UserGroup
	ON QMS_User.ParentUserID = UserGroup.UserID
WHERE 
	QMS_User.UserName = @Username
	AND QMS_User.RecordStatus < 201
	AND QMS_User.IsUserGroup = 0
	AND QMS_User.Password IS NOT NULL -- Stop locked accounts getting in.
	AND QMS_User.Password = @Password;

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_User')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 30/06/2008
-- Description	: Adds and edits user details
-- Version		: 11
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- JT TFS 13-17956 - Creating a user or updating and changing the supplier should trigger a corrective action rebuild.
-- JT TFS 13-21321 - Only trigger a ca rebuild on new user or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
-- PH TFS 13-66014 : v11 03/02/2017 - Remove extraneous password parameters and add HashType parameter
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@HashType int
AS
BEGIN 
	SET NOCOUNT ON

	-- Find out if a CA rebuild is required or not (it's a very expensive operation)
	-- only trigger on new user, or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
	DECLARE @IsCARebuildRequired bit
	BEGIN
		DECLARE @originalSupplier TABLE (SupplierID int)
		INSERT @originalSupplier (SupplierID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 101) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalCustomer TABLE (CustomerID int)
		INSERT @originalCustomer (CustomerID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 102) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalParentUserID int, @originalUserLevel int, @originalLeftCompany bit
		SELECT @originalParentUserID = ParentUserID, @originalUserLevel = UserLevel, @originalLeftCompany = LeftCompany
		FROM QMS_User
		WHERE UserID = @UserID

		DECLARE @originalSupplierID int 
		SELECT @originalSupplierID = CASE	WHEN (SELECT count(*) FROM @originalSupplier) > 1 THEN -1
											ELSE (SELECT TOP 1 SupplierID FROM @originalSupplier) END

		DECLARE @originalCustomerID int 
		SELECT @originalCustomerID = CASE	WHEN (SELECT count(*) FROM @originalCustomer) > 1 THEN -1
											ELSE (SELECT TOP 1 CustomerID FROM @originalCustomer) END

		SELECT @IsCARebuildRequired = CASE	WHEN ISNULL(@UserID,0) = 0 THEN 1 -- yes for new users.
											WHEN ISNULL(@SupplierID, 0) <> ISNULL(@originalSupplierID, 0) THEN 1
											WHEN ISNULL(@CustomerID, 0) <> ISNULL(@originalCustomerID, 0) THEN 1
											WHEN ISNULL(@ParentUserID, 0) <> ISNULL(@originalParentUserID, 0) THEN 1
											WHEN ISNULL(@UserLevel, 0) <> ISNULL(@originalUserLevel, 0) THEN 1
											WHEN ISNULL(@LeftCompany, 0) <> ISNULL(@originalLeftCompany, 0) THEN 1
											ELSE 0 END
	END

	IF ISNULL(@UserID,0)=0 --New user
	BEGIN
		IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
		BEGIN
			INSERT INTO QMS_User
			(
				FullName,
				UserName,
				Position,
				EMail,
				Mobile,
				PIN,
				LeftCompany,
				UserLevel,
				LocaleID,
				IsUserGroup,
				ParentUserID,
				Company,
				HashType
			)
			VALUES
			(
				@FullName,
				@UserName,
				@Position,
				@EMail,
				@Mobile,
				@PIN,
				@LeftCompany,
				@UserLevel,
				@LocaleID,
				@IsUserGroup,
				@ParentUserID,
				@Company,
				@HashType
			)
			--Get new UserID
			SELECT @UserID = SCOPE_IDENTITY()
		
			EXEC UP_User_Password @UserName, @Password, @HashType

			-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

			DECLARE @NotificationGroupID int
			SELECT @NotificationGroupID = NotificationGroupID
			FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

			INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
			SELECT @NotificationGroupID, UserID, 2
			FROM QMS_User 
			WHERE dbo.FNC_GetUserLevel(UserID) = 1 
			AND RecordStatus < 201
			AND UserID = @UserID
			AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
							WHERE NotificationGroupID = @NotificationGroupID 
							AND UserID = QMS_User.UserID
							AND RecordStatus < 201)

			-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

		END
	END
	ELSE --Update user
	BEGIN
	-- Don't change the username to an existing other username. It violates the single username principle of logging in.
		IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
		BEGIN
			SET @UserID = 0 -- This should cause the save procedure to fail.
		END
		ELSE
		BEGIN -- Username is still unique on all undeleted records.
			--JE - update passwords table (TFS 973)
			IF @Password IS NOT NULL
			BEGIN
				EXEC UP_User_Password @UserName, @Password, @HashType
			END

			UPDATE    QMS_User
			SET
				FullName = @FullName,
				UserName = @UserName,
				Position = @Position,
				EMail = @EMail,
				Mobile = @Mobile,
				PIN = @PIN,
				LeftCompany = @LeftCompany,
				UserLevel = @UserLevel,
				LocaleID = @LocaleID,
				IsUserGroup = @IsUserGroup,
				ParentUserID = @ParentUserID,
				Company = @Company,
				Updated = GETUTCDATE(),
				HashType = HashType
			WHERE UserID = @UserID;
		END
	END

	DECLARE @PermissionID int = NULL
	IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked supplier
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 101,@SupplierID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
	END


	-- Setup CustomerID Link
	SET @PermissionID = NULL -- in case it has a previous value
	IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked customer
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 102,@CustomerID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
	END

	IF @IsCARebuildRequired = 1
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID

	SET NOCOUNT OFF

	SELECT @UserID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_User')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: unknown
-- Description:	Imports downloaded user XML row into table.
-- Version:		2
-- =============================================
-- PH TFS 13-66031 : v2 06/02/2017 - Added HashType column.  Table will still be backward compatible.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255),
	@Position nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@SubscriberID nvarchar(50),
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@Company nvarchar(255),
	@Password_MD5 nvarchar(255) = NULL,
	@Password_SHA2 nvarchar(255) = NULL,
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT,
	@HashType int = NULL
AS

IF NOT EXISTS(SELECT * FROM QMS_User WHERE (UserID = @UserID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		SET IDENTITY_INSERT QMS_User ON
		INSERT INTO QMS_User
		(
			UserID,
			FullName,
			UserName,
			Password,
			Position,
			EMail,
			Mobile,
			PIN,
			LeftCompany,
			UserLevel,
			SubscriberID,
			LocaleID,
			IsUserGroup,
			ParentUserID,
			Company,
			Password_MD5,
			Password_SHA2,
			RecordStatus,
			Inserted,
			Updated,
			GUID,
			HashType
		)
		VALUES
		(
			@UserID,
			@FullName,
			@UserName,
			@Password,
			@Position,
			@EMail,
			@Mobile,
			@PIN,
			@LeftCompany,
			@UserLevel,
			@SubscriberID,
			@LocaleID,
			@IsUserGroup,
			@ParentUserID,
			@Company,
			@Password_MD5,
			@Password_SHA2,
			@RecordStatus,
			@Inserted,
			@Updated,
			@GUID,
			@HashType
		)
		SET @InsertCount = @@rowcount
		SET IDENTITY_INSERT QMS_User OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_User
	SET
		FullName = @FullName,
		UserName = @UserName,
		Password = @Password,
		Position = @Position,
		EMail = @EMail,
		Mobile = @Mobile,
		PIN = @PIN,
		LeftCompany = @LeftCompany,
		UserLevel = @UserLevel,
		SubscriberID = @SubscriberID,
		LocaleID = @LocaleID,
		IsUserGroup = @IsUserGroup,
		ParentUserID = @ParentUserID,
		Company = @Company,
		Password_MD5 = @Password_MD5,
		Password_SHA2 = @Password_SHA2,
		RecordStatus = @RecordStatus,
		Inserted = @Inserted,
		Updated = @Updated,
		HashType = @HashType
	WHERE     (UserID = @UserID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created

--Reset Sync anchor so changes downloaded dont get uploaded
SET NOCOUNT ON
DECLARE @MaxCreated bigint, @MaxRowVersion bigint, @MaxSent bigint

SELECT     @MaxCreated = MAX(Created), @MaxRowVersion = MAX(CAST(RowVersion AS bigint))
FROM         QMS_User

IF @MaxRowVersion > @MaxCreated
	SET @MaxSent = @MaxRowVersion
ELSE
	SET @MaxSent = @MaxCreated

UPDATE    SYNC_ClientAnchor
SET              LastSent = @MaxSent
WHERE     (TableName = N'QMS_User') AND (LastSent IS NULL OR
                      LastSent < @MaxSent)

SET NOCOUNT OFF
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_UserPassword')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_UserPassword] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: unknown
-- Description:	Imports downloaded user password XML row into table.
-- Version:		2
-- =============================================
-- PH TFS 13-66059 : v2 06/02/2017 - Added HashType column.  Table will still be backward compatible.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_UserPassword] 
	@UserID int,
	@Password nvarchar(255),
	@CreationDate datetime,
	@ExpiryDate datetime,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@HashType int = NULL,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM QMS_UserPassword WHERE (GUID = @GUID))
BEGIN --Append record
	IF EXISTS(SELECT UserID FROM QMS_User WHERE (UserID = @UserID))
	BEGIN
		INSERT INTO QMS_UserPassword
		(
			UserID,
			Password,
			CreationDate,
			ExpiryDate,
			Inserted,
			Updated,
			Deleted,
			GUID,
			HashType
		)
		VALUES
		(
			@UserID,
			@Password,
			@CreationDate,
			@ExpiryDate,
			@Inserted,
			@Updated,
			@Deleted,
			@GUID,
			@HashType
		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_UserPassword
	SET
		Password = @Password,
		CreationDate = @CreationDate,
		ExpiryDate = @ExpiryDate,
		Inserted = @Inserted,
		Updated = @Updated,
		Deleted = @Deleted
	WHERE GUID = @GUID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Upload_User')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Upload_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: unknown
-- Description:	Gets user data to upload
-- Version:		2
-- =============================================
-- PH TFS 13-66030 : v2 06/02/2017 - Added HashType column.  Table will still be backward compatible.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Upload_User] 
	@LastSent bigint,
	@MaxSent bigint OUTPUT
AS

--Get anchor value
SET NOCOUNT ON
DECLARE @MaxCreated bigint, @MaxRowVersion bigint

SELECT     @MaxCreated = MAX(Created), @MaxRowVersion = MAX(CAST(RowVersion AS bigint))
FROM         QMS_User

IF @MaxRowVersion > @MaxCreated
	SET @MaxSent = @MaxRowVersion
ELSE
	SET @MaxSent = @MaxCreated

SET NOCOUNT OFF

SELECT
	UserID,
	FullName,
	UserName,
	Password,
	Position,
	EMail,
	Company,
	Mobile,
	PIN,
	LeftCompany,
	UserLevel,
	SubscriberID,
	LocaleID,
	IsUserGroup,
	ParentUserID,
	Password_MD5,
	Password_SHA2,
	RecordStatus,
	Inserted,
	Updated,
	Deleted, 
	GUID,
	RowVersion,
	Created,
	HashType
FROM	QMS_User
WHERE
	RowVersion > @LastSent
	OR Created > @LastSent;
GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Upload_UserPassword')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Upload_UserPassword] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 24/05/2011
-- Description:	Get data to upload for QMS_UserPassword
-- Version:		3
-- =============================================
-- MP TFS 6730: Made upload send 5000 records at a time
-- PH TFS 13-66096 : v3 06/02/2017 - Added HashType column.  Table will still be backward compatible.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Upload_UserPassword] 
	@LastSent bigint,
	@MaxSent bigint OUTPUT
AS

--Get anchor value
SET NOCOUNT ON
DECLARE @MaxCreated bigint, @MaxRowVersion bigint

SELECT     @MaxCreated = MAX(Created), @MaxRowVersion = MAX(RowVersion)
FROM         (SELECT     TOP (5000) CAST(RowVersion AS bigint) AS RowVersion, Created
                       FROM          QMS_UserPassword
                       WHERE      (RowVersion > @LastSent) OR
                                              (Created > @LastSent)
                       ORDER BY CASE WHEN Created > CAST(RowVersion AS bigint) THEN Created ELSE CAST(RowVersion AS bigint) END) AS UserPassword;

IF @MaxRowVersion > @MaxCreated
	SET @MaxSent = @MaxRowVersion;
ELSE
	SET @MaxSent = @MaxCreated;

SET NOCOUNT OFF

SELECT   TOP (5000)
	PasswordID,
	UserID,
	Password,
	CreationDate,
	ExpiryDate,
	Inserted,
	Updated,
	Deleted,
	GUID,
	RowVersion,
	Created,
	HashType
FROM	QMS_UserPassword
WHERE
	RowVersion > @LastSent
	OR Created > @LastSent
ORDER BY CASE WHEN Created > CAST(RowVersion AS bigint) 
                      THEN Created ELSE CAST(RowVersion AS bigint) END;
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_User_Password')
	EXEC ('CREATE PROCEDURE [dbo].[UP_User_Password] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author		: Jon Edwards
-- Create date	: 23/05/2011
-- Description	: Updates password when changed at login
-- Version		: 7
-- ===================================================
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update
-- JT TFS 6629 - Expire old userpassword entries before adding a new one.
-- JT TFS 6791 - Handle cases where there are more than one username in the QMS_User table (and exclude deleted people)
-- Martin P TFS 13 - 42414 - Changed any GTEDATE() to GETUTCDATE()
-- PH TFS 13-66014 : v6 03/02/2017 - Now only storing single password and must use HashType.
-- PH TFS 13-66163 : v7 03/02/2017 - Make extraneous password columns null for row, if password updated.
-- ===================================================
ALTER PROCEDURE [dbo].[UP_User_Password]
	@UserName nvarchar(255),
	@Password nvarchar(255),
	@HashType int
AS
BEGIN

	SET NOCOUNT ON;

	-- #tmpUser should only contain one username, but historically it sometimes has more.
	IF NULLIF(object_id('tempdb..#tmpUser'), 0) IS NOT NULL DROP TABLE #tmpUser
	SELECT UserID
	INTO #tmpUser
	FROM QMS_User
	WHERE UserName = @UserName 
	AND RecordStatus < 201
	
	-- update User table
	UPDATE QMS_User
	SET
		[Password] = @Password,
		Password_MD5 = NULL,
		Password_SHA2 = NULL,
		HashType = @HashType,
        Updated = GETUTCDATE()
	WHERE UserID IN (SELECT UserID FROM #tmpUser)
	
	UPDATE QMS_UserPassword 
	SET ExpiryDate = getutcdate()
	WHERE UserID IN (SELECT UserID FROM #tmpUser)
	AND ISNULL(ExpiryDate, '31 Dec 9999') > getutcdate()
	
	-- add new row to passwords table
	INSERT INTO QMS_UserPassword
	(
		UserID,
		Password,
		CreationDate,
		ExpiryDate,
		HashType
	)
	SELECT
		UserID,
		@Password,
		GETUTCDATE(),
		DATEADD(day, CAST(dbo.FNC_GetOptionValue(46) AS int), GETUTCDATE()),
		@HashType
	FROM QMS_User
	WHERE UserID IN (SELECT UserID FROM #tmpUser)
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_User_PasswordToNULL')
	EXEC ('CREATE PROCEDURE [dbo].[UP_User_PasswordToNULL] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Jon Edwards
-- Create date	: 25/05/2011
-- Description	: Sets user's password to NULL
-- Version		: 3
-- =============================================
-- PH TFS 13-66014 : v2 03/02/2017 - Sets HashType to null too.
-- PH TFS 13-66163 : v3 03/02/2017 - Make extraneous password columns null for row, if password updated.
-- =============================================
ALTER PROCEDURE [dbo].[UP_User_PasswordToNULL]

	@UserID int

AS
BEGIN

	SET NOCOUNT ON;

    UPDATE QMS_User
    SET
		Password = NULL,
		Password_MD5 = NULL,
		Password_SHA2 = NULL,
		HashType = NULL
    WHERE UserID = @UserID
     
END
GO





PRINT 'Database updated successfully!'
GO

