-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_QuestionResponse_RemoveSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_QuestionResponse_RemoveSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Adam C
-- Create date: 26/02/15
-- Description:	Further filters down the TEMP_Selected for the
--				question response report so the max allowed count 
--				check is more accurate
-- Version:		3
-- =============================================
-- JT TFS 13-17901: 1 Jun 2015 - Don't remove responses which don't have any recommended flags at all.
-- JF TFS 63605 - make sure the assessmenttype comes from the Response and not the assessment
-- =============================================
ALTER PROCEDURE [dbo].[RPT_QuestionResponse_RemoveSelected]
(
	@UserID INTEGER,
    @ShowGreen BIT,
	@ShowAmber BIT,
	@ShowRed BIT,
	@AssessmentType INTEGER
) 
AS
BEGIN

	DECLARE @ValidSelectedID TABLE (SelectedID INTEGER)
	INSERT INTO @ValidSelectedID
	SELECT DISTINCT SelectedID FROM TEMP_Selected 
	INNER JOIN QMS_Response ON TEMP_Selected.SelectedID = QMS_Response.ResponseID 
	INNER JOIN QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID 
	INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID
	WHERE TEMP_Selected.UserID = @UserID
	AND (QMS_ResponseQuestion.Response_Text IS NOT NULL)
	AND (	(@ShowGreen = 1 AND QMS_ResponseQuestion.Recommended_QAFlagID = 1)
		OR	(@ShowAmber = 1 AND QMS_ResponseQuestion.Recommended_QAFlagID = 2)
		OR	(@ShowRed = 1   AND QMS_ResponseQuestion.Recommended_QAFlagID = 3)
		OR	(@ShowGreen = 1 AND @ShowAmber = 1 AND @ShowRed = 1) -- Ensure logic for inlcuding responses is the same as in RPT_QuestionResponse.
	)
	--AND QMS_Assessment.AssessmentTypeId = @AssessmentType
	AND QMS_Response.AssessmentTypeId = @AssessmentType

	DELETE FROM TEMP_Selected
	WHERE UserID = @UserID
	AND NOT EXISTS (SELECT SelectedID FROM @ValidSelectedID VS WHERE VS.SelectedID = TEMP_Selected.SelectedID)

END
GO


PRINT 'Database updated successfully!'
GO
