-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_QuestionPool')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_QuestionPool] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf
-- Create date: 4/12/00
-- Description:	Mobile only SP: Imports question pool
-- Version:		2
-- =============================================
-- JF tfs 52056 - Questions are cut off at 50 characters in offline mobile even though questions can be up to 255 characters in length
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_QuestionPool] 
	@QuestionID int,
	@Question nvarchar(255),
	@IsQuestionGroup bit,
	@DataTypeID int,
	@DataLookupID int,
	@CustomLookupID int,
	@QuestionLevelID int,
	@ShortGuidance nvarchar(255),
	@AssessmentTypeID int,
	@QuestionTag nvarchar(1000),
	@Sys_Question nvarchar(50),
	@DefaultQuestion bit,
	@CopyRepeatCheck bit = 0,
	@QuestionGroup NVARCHAR(100) = NULL,
	@QuestionSubGroup NVARCHAR(100) = NULL,
	@Hide bit,
	@UserID int,
	@MachineName nvarchar(255),
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM QMS_QuestionPool WHERE (QuestionID = @QuestionID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		SET IDENTITY_INSERT QMS_QuestionPool ON
		INSERT INTO QMS_QuestionPool
                      (QuestionID, Question, IsQuestionGroup, DataTypeID, DataLookupID, CustomLookupID, QuestionLevelID, ShortGuidance, AssessmentTypeID, QuestionTag, 
                      Sys_Question, DefaultQuestion, CopyRepeatCheck, QuestionGroup, QuestionSubGroup, Hide, UserID, MachineName, RecordStatus, Inserted, Updated, Deleted, GUID)
		VALUES     (@QuestionID,@Question,@IsQuestionGroup,@DataTypeID,@DataLookupID,@CustomLookupID,@QuestionLevelID,@ShortGuidance,@AssessmentTypeID,@QuestionTag,@Sys_Question,@DefaultQuestion,@CopyRepeatCheck,@QuestionGroup,@QuestionSubGroup,@Hide,@UserID,@MachineName,@RecordStatus,@Inserted,@Updated,@Deleted,@GUID)
		SET @InsertCount = @@rowcount
		SET IDENTITY_INSERT QMS_QuestionPool OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_QuestionPool
	SET              Question = @Question, IsQuestionGroup = @IsQuestionGroup, DataTypeID = @DataTypeID, DataLookupID = @DataLookupID, CustomLookupID = @CustomLookupID, 
                      QuestionLevelID = @QuestionLevelID, ShortGuidance = @ShortGuidance, AssessmentTypeID = @AssessmentTypeID, QuestionTag = @QuestionTag, 
                      Sys_Question = @Sys_Question, DefaultQuestion = @DefaultQuestion, CopyRepeatCheck = @CopyRepeatCheck, QuestionGroup = @QuestionGroup, 
                      QuestionSubGroup = @QuestionSubGroup, Hide = @Hide, UserID = @UserID, MachineName = @MachineName, RecordStatus = @RecordStatus, 
                      Inserted = @Inserted, Updated = @Updated, Deleted = @Deleted
	WHERE     (QuestionID = @QuestionID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_SupplierComparison_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_SupplierComparison_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 08/04/2011  
-- Description: Fills TEMP_Selected with ResponseID for data to show on supplier comparison report  
-- Version: 9
-- =============================================  
-- JE TFS 4673: updated with Assessment Types param  
-- JT TFS 4776: Use IQCFilteredReport filtering mechanism.  
-- MP CAS-17627-T0K1M5: Added select distinct to both inserts  
-- JE TFS 5909: updated to use warehouse table  
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.  
-- JT TFS 13-56851: 22/09/2016 - Precalculate functions and inline queries temp tables, and join directly on them.
-- JF TFS 60856 Supplier Comparison Report - Unable to filter by Location - Sorted temp table insert for #tmpFilteredResponse
-- =============================================  
ALTER PROCEDURE [dbo].[RPT_SupplierComparison_FillSelected]   
	@UserID int,  
	@DateFrom datetime,
	@DateTo datetime,
	@ShowAllSuppliers bit = 0,
	@IsFilterApplied bit = 0,
    @AssessmentTypeID_LIST nvarchar(100)
AS  
BEGIN
	SET NOCOUNT ON
	IF NULLIF(object_id('tempdb..#tmpAssessmentType'), 0) IS NOT NULL DROP TABLE #tmpAssessmentType;
	CREATE TABLE #tmpAssessmentType (AssessmentTypeID int)
	INSERT #tmpAssessmentType (AssessmentTypeID)
	SELECT CAST(Token AS int) AS AssessmentTypeID  
	FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',');

	IF NULLIF(object_id('tempdb..#tmpResponse'), 0) IS NOT NULL DROP TABLE #tmpResponse;
	CREATE TABLE #tmpResponse (ResponseID int)
	INSERT #tmpResponse (ResponseID) 
	SELECT ResponseID FROM dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo);
	
	IF NULLIF(object_id('tempdb..#tmpFilteredResponse'), 0) IS NOT NULL DROP TABLE #tmpFilteredResponse;
	CREATE TABLE #tmpFilteredResponse (ResponseID int)
	--INSERT #tmpResponse (ResponseID)
	INSERT #tmpFilteredResponse (ResponseID)
	SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID;

	IF NULLIF(object_id('tempdb..#tmpSupplier'), 0) IS NOT NULL DROP TABLE #tmpSupplier;
	CREATE TABLE #tmpSupplier (SupplierID int, SupplierName nvarchar(100))
	INSERT #tmpSupplier
	SELECT	SelectedItemID AS SupplierID, SelectedItemText AS SupplierName  
	FROM	TEMP_SelectedItem  
	WHERE   (UserID = @UserID);

	-- Clear temp selected  
	DELETE FROM TEMP_Selected  
	WHERE     (UserID = @UserID);
  
	SET NOCOUNT OFF;

	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1 --use warehouse table  
	BEGIN  
		IF @ShowAllSuppliers = 1 --Insert all responses into temp selected  
		BEGIN  
			INSERT INTO TEMP_Selected (SelectedID, UserID, SelectedText)  
			SELECT DISTINCT RPT_Warehouse_Response.ResponseID, @UserID AS UserID, Supplier.SupplierName  
			FROM RPT_Warehouse_Response 
			INNER JOIN  #tmpResponse AS User_ResponseList ON RPT_Warehouse_Response.ResponseID = User_ResponseList.ResponseID 
			INNER JOIN #tmpAssessmentType AS AssessmentType ON RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
			LEFT OUTER JOIN  #tmpSupplier AS Supplier ON RPT_Warehouse_Response.SupplierID = Supplier.SupplierID  
			WHERE (@IsFilterApplied = 0 OR RPT_Warehouse_Response.ResponseID IN (SELECT ResponseID FROM #tmpFilteredResponse))  
		END  
		ELSE --Insert only supplier responses into temp selected  
		BEGIN  
			INSERT INTO TEMP_Selected  (SelectedID, UserID, SelectedText)  
			SELECT DISTINCT RPT_Warehouse_Response.ResponseID, @UserID As UserID, Supplier.SupplierName AS SelectedItemText  
			FROM RPT_Warehouse_Response 
			INNER JOIN  #tmpResponse AS User_ResponseList  ON RPT_Warehouse_Response.ResponseID = User_ResponseList.ResponseID 
			INNER JOIN  #tmpSupplier AS Supplier ON RPT_Warehouse_Response.SupplierID = Supplier.SupplierID  
			INNER JOIN #tmpAssessmentType AS AssessmentType ON RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
			WHERE (@IsFilterApplied = 0 OR RPT_Warehouse_Response.ResponseID IN (SELECT ResponseID FROM #tmpFilteredResponse))  
		END  
	END  
	ELSE  
	BEGIN  
		IF @ShowAllSuppliers = 1 --Insert all responses into temp selected  
		BEGIN  
			INSERT INTO TEMP_Selected  (SelectedID, UserID, SelectedText)  
			SELECT DISTINCT     QMS_Response.ResponseID, @UserID AS UserID, Supplier.SupplierName  
			FROM         QMS_Response 
			INNER JOIN  #tmpResponse AS User_ResponseList ON  QMS_Response.ResponseID = User_ResponseList.ResponseID 
			INNER JOIN	QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID 
			INNER JOIN  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID 
			INNER JOIN #tmpAssessmentType AS AssessmentType ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
			LEFT OUTER JOIN #tmpSupplier AS Supplier ON QMS_ResponseHeader.Header_SourceID = Supplier.SupplierID  
			WHERE	(QMS_Response.ResponseStatus = 1) 
			AND		(QMS_AssessmentHeader.DataTypeID = 9) 
			AND		(QMS_AssessmentHeader.DataLookupID = 1) 
			AND		(@IsFilterApplied = 0 OR QMS_Response.ResponseID IN (SELECT ResponseID FROM #tmpFilteredResponse))  
  		END  
		ELSE --Insert only supplier responses into temp selected  
		BEGIN  
			INSERT INTO TEMP_Selected (SelectedID, UserID, SelectedText)  
			SELECT DISTINCT     QMS_Response.ResponseID, @UserID, Supplier.SupplierName AS SelectedText  
			FROM         QMS_Response 
			INNER JOIN  #tmpResponse AS User_ResponseList ON   QMS_Response.ResponseID = User_ResponseList.ResponseID 
			INNER JOIN  QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID 
			INNER JOIN	QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID 
			INNER JOIN  #tmpSupplier AS Supplier ON QMS_ResponseHeader.Header_SourceID = Supplier.SupplierID
			INNER JOIN #tmpAssessmentType AS AssessmentType ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
			WHERE	(QMS_Response.ResponseStatus = 1) 
			AND		(QMS_AssessmentHeader.DataTypeID = 9) 
			AND		(QMS_AssessmentHeader.DataLookupID = 1) 
			AND		(@IsFilterApplied = 0 OR QMS_Response.ResponseID IN (SELECT ResponseID FROM #tmpFilteredResponse))  
		END  
	END  
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Guidance_IndividualList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Guidance_IndividualList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 22/10/2009  
-- Description: Get individual guidance details  
-- Version:		2
-- =============================================  
-- JT TFS 13-62454: 07/12/2016 - Including Sys_guidanceId so that view assessment can decide whether to display that guidance or not for temp specs.
-- =============================================  
ALTER PROCEDURE QRY_Guidance_IndividualList  
	@GuidanceID int  
AS  
  
SELECT     GuidanceDesc, GuidanceString, GuidanceURL, ProcedureURL, SpecificationURL, Sys_GuidanceID 
FROM         QMS_Guidance  
WHERE     (RecordStatus < 201) AND (GuidanceID = @GuidanceID) 
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_GetGuidance')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author		: Markp  
-- Create date	: 16/03/2010  
-- version		: 5
-- Description	: Gets the guidance detail for the selected assessment question  
--==============================================  
-- TFS 10889 - Mobile guidance should be reordered in Guidance popup  
-- SS TFS 13-53805: Removed join within constraint guidance which joined on created date (created is not always unique AND was causing multiple images to show when they shouldn't have)  
-- JT TFS 13-57727: 04/10/2016 - Added AttachmentFilename column to top query, and GuidanceID to lower query so that both tables return the same columns.  
-- JT TFS 13-57727: v5 19/12/2016 - Reformatted to make more understandable and put in semi-colons.
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance]   
	@AssessmentQuestionID int  
AS  

--Constraint guidance  
SELECT
	ISNULL(QMS_CustomLookupItem.LookupText, APP_QAFlag.QAFlag) AS Title,
	CAST(NULL AS image) AS AttachmentImage,
	Constraint_Guidance.Attachment,
	Constraint_Guidance.AttachmentFileName,
	Constraint_Guidance.AttachmentTitle,
	QMS_AssessmentQuestionConstraint.ShortGuidance,
	Constraint_Guidance.GuidanceDesc,
	Constraint_Guidance.GuidanceString,
	Constraint_Guidance.GuidanceURL,
	QMS_AssessmentQuestionConstraint.QAFlagID,
	Constraint_Guidance.GuidanceID
FROM	APP_QAFlag
RIGHT OUTER JOIN	QMS_AssessmentQuestionConstraint
	ON APP_QAFlag.QAFlagID = QMS_AssessmentQuestionConstraint.QAFlagID 
LEFT OUTER JOIN
(
	SELECT
		QMS_Guidance.GuidanceID,
		QMS_Guidance.GuidanceDesc,
		QMS_Guidance.GuidanceString,
		QMS_Guidance.GuidanceURL,
		Attachments.Attachment,
		Attachments.AttachmentFileName,
		Attachments.AttachmentTitle
	FROM	QMS_Guidance
	LEFT OUTER JOIN
	(
		SELECT
			guidance.Sys_GuidanceID,
			Attachment_Linked.AttachmentID
		FROM
		(
			SELECT
				Sys_GuidanceID,
				AttachmentID,
				row
			FROM
			(
				SELECT
					guidance.Sys_GuidanceID,
					attachment.AttachmentID,
					ROW_NUMBER()
				OVER
				(
					PARTITION BY Sys_GuidanceID ORDER BY attachment.Created DESC,
					attachment.AttachmentID DESC
				) as row  
				FROM QMS_Guidance guidance
				INNER JOIN QMS_Attachment attachment
					ON guidance.GuidanceID = attachment.SourceObjectID
					AND attachment.AttachmentSourceID = 3
				WHERE
					guidance.RecordStatus < 201
					AND attachment.RecordStatus < 201
			) AS GuidanceAttachment
			WHERE row = 1
		) AS LastGuidanceAttachment
		INNER JOIN  QMS_Attachment AS Attachment_Linked
			ON LastGuidanceAttachment.AttachmentID = Attachment_Linked.AttachmentID 
		INNER JOIN  QMS_Guidance AS Guidance
			ON LastGuidanceAttachment.Sys_GuidanceID = Guidance.Sys_GuidanceID
			AND Attachment_Linked.SourceObjectID = Guidance.GuidanceID
		WHERE
			Attachment_Linked.AttachmentSourceID = 3
			AND Attachment_Linked.RecordStatus < 201
	) AS Linked_Attachments
		ON QMS_Guidance.Sys_GuidanceID = Linked_Attachments.Sys_GuidanceID
	LEFT OUTER JOIN
	(
		SELECT
			SourceObjectID AS GuidanceID,
			AttachmentTitle,
			Attachment,
			AttachmentFileName
		FROM	QMS_Attachment
		WHERE
			AttachmentSourceID = 3
			AND RecordStatus < 201
	) AS Attachments
		ON QMS_Guidance.GuidanceID = Attachments.GuidanceID  
	WHERE
		QMS_Guidance.RecordStatus < 201
		AND QMS_Guidance.Hide = 0
) AS Constraint_Guidance
	ON QMS_AssessmentQuestionConstraint.GuidanceID = Constraint_Guidance.GuidanceID   
LEFT OUTER JOIN QMS_CustomLookupItem
	ON QMS_AssessmentQuestionConstraint.Constraint_SourceID = QMS_CustomLookupItem.CustomLookupItemID  
WHERE
	(
		ISNULL(LEN(QMS_AssessmentQuestionConstraint.ShortGuidance), 0) > 0  
		AND QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID  
		AND QMS_AssessmentQuestionConstraint.RecordStatus < 201
	)
	OR
	(
		QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID  
		AND	QMS_AssessmentQuestionConstraint.RecordStatus < 201 
		AND Constraint_Guidance.GuidanceID IS NOT NULL
	)
ORDER BY QMS_AssessmentQuestionConstraint.QAFlagID;

--Question guidance  ** THIS MUST HAVE SAME COLUMNS AS ABOVE QUERY **
SELECT 
	QMS_QuestionPool.Question AS Title,
	CAST(NULL AS image) AS AttachmentImage,
	Question_Guidance.Attachment,
	Question_Guidance.AttachmentFileName,
	Question_Guidance.AttachmentTitle,
	QMS_AssessmentQuestion.ShortGuidance,
	Question_Guidance.GuidanceDesc,
	Question_Guidance.GuidanceString,
	Question_Guidance.GuidanceURL,
	CAST(NULL AS int) AS QAFlagID,
	Question_Guidance.GuidanceID
FROM	QMS_AssessmentQuestion 
INNER JOIN	QMS_QuestionPool
	ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID 
LEFT OUTER JOIN
(
	SELECT
		QMS_Guidance.GuidanceID,
		QMS_Guidance.GuidanceDesc,
		QMS_Guidance.GuidanceString,
		QMS_Guidance.GuidanceURL,
		Attachments.AttachmentTitle,
		Attachments.Attachment,
		Attachments.AttachmentFileName
	FROM	QMS_Guidance
	LEFT OUTER JOIN 
	(
		SELECT
			SourceObjectID AS GuidanceID,
			AttachmentTitle,
			Attachment,
			AttachmentFileName
		FROM	QMS_Attachment
		WHERE
			AttachmentSourceID = 3
			AND RecordStatus < 201
	) AS Attachments
		ON QMS_Guidance.GuidanceID = Attachments.GuidanceID
	WHERE
		QMS_Guidance.RecordStatus < 201
		AND QMS_Guidance.Hide = 0
) AS Question_Guidance
	ON QMS_AssessmentQuestion.GuidanceID = Question_Guidance.GuidanceID  
WHERE
	(
		QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID 
		AND ISNULL(LEN(QMS_AssessmentQuestion.ShortGuidance), 0) > 0 
	)
	OR
	(
		QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID
		AND Question_Guidance.GuidanceID IS NOT NULL
	);

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ApplicationUpdate_AppList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ApplicationUpdate_AppList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/11/2011
-- Description:	Gets the current version of the application
-- Version:		4
-- =============================================
-- MP TFS 4704: Made sure hidden records still shown in Office for new device log screen
-- MP TFS 7998: Change IsMobile parameter so that it is not set as default
-- JT TFS 13-49665: 14/12/2016 - Remove concept of "offline/online" mobile from update. There is only one executable.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ApplicationUpdate_AppList] 
	@ApplicationEXE nvarchar(50),
	@Offline bit = NULL -- We ignore this value.
AS

SELECT     ApplicationVersion, InstallPath
FROM         APP_ApplicationUpdate
WHERE   (Hide = 0) 
AND		(ApplicationEXE = @ApplicationEXE)
ORDER BY ApplicationVersion DESC
GO


PRINT 'Database updated successfully!'
GO
