-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


-- BEGIN DATA 01_UserScorecard_Warehouse_Table_33032
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'RPT_Warehouse_Response' AND c.name = 'NumHotsheetItems' )
	ALTER TABLE RPT_Warehouse_Response 
	ADD NumHotsheetItems int,
		NumResponseQuestions int
GO
-- END DATA 01_UserScorecard_Warehouse_Table_33032



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Scorecard')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Scorecard] AS SELECT ''stub version, to be replaced''')
GO

-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets data for scorecard report
-- Version:		15
-- =============================================
-- JE TFS 3060 - added dynamic grouping using FNC_PerformanceReport_ResponseHeader
-- JT TFS 3500 - Made dates more location agnostic.
-- MP TFS 3932 - Corrected join on ResponseQuestion as light checks were not being returned
-- JE TFS 4861 - added QA Flag override config check, QA Flag colour cols and new filtering method
-- JT TFS 4927 - Added SupplierSite and Store
-- JT TFS 5318 - Added code to allow non-product checks to appear.
-- JT TFS 5358 - Added custom grouping.
-- JT TFS 5316 - Sorting by Region to allow grouping of regions together on report.
-- MP CAS-18564-Z8C8P5 - moved option values to variables
-- MP TFS 6633 - now filters out when group by test is null
-- JE TFS 8590 - updated to use reporting warehouse and reduced overall complexity
-- MP TFS 13-33032 - Use precalculated datawarehouse values for Number of ResponseQuestions and Hotsheet items
-- SS TFS 13-44875 - Added case statement within IF @UseDataWarehouse = 1 so that null values within RPT_Warehouse_Response.NumHotsheetItems are handled (converted to 0)
-- jf TFS 13-57933 - added alternative TargetHotsheets as a config value which can be used instead of 0.5xNumChecks
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Scorecard] 
	@UserID int, 
	@DateFrom datetime,
	@DateTo datetime,
	@ReportBy tinyint,
	@GroupDatesBy tinyint,
	@GroupDetailBy int
AS

-- TEST DATA:	DECLARE @UserID int = 1, @DateFrom datetime = '1 Jan 2011',	@DateTo datetime = '31 Dec 2012', @ReportBy tinyint = 53, @GroupDatesBy tinyint = 1, @GroupDetailBy int = 4 

	--get reporting warehouse config option
	DECLARE @UseDataWarehouse bit
	SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)


	DECLARE @TargetAmber TINYINT, @TargetChecks TINYINT, @UserScorecardMode TINYINT, @ReportQAFlag BIT,@TargetHotSheets TINYINT

	SELECT @UserScorecardMode = ISNULL(dbo.FNC_GetOptionValue(7),0)
	SELECT @TargetChecks = ISNULL(dbo.FNC_GetOptionValue(14),0)
	SELECT @TargetHotSheets = ISNULL(dbo.FNC_GetOptionValue(135),0)
	SELECT @TargetAmber = ISNULL(dbo.FNC_GetOptionValue(54),0)
	SELECT @ReportQAFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	IF @UseDataWarehouse = 1 --use reporting warehouse
	BEGIN
		SELECT  @DateFrom AS DateFrom, @DateTo AS DateTo, @ReportBy AS ReportBy, 
				CASE	WHEN @ReportBy = 1 THEN QMS_User.UserID 
						WHEN @ReportBy = 2 THEN ISNULL(Location.LocationID, 0) 
						WHEN @ReportBy = 3 THEN ISNULL(PM_VW_Region.RegionID, 0) 
						WHEN @ReportBy = 53 THEN ISNULL(SupplierSite.LocationID, 0) 
						WHEN @ReportBy = 54 THEN ISNULL(Store.LocationID, 0) 
						ELSE 0 END AS GroupID, 
				CASE WHEN @ReportBy = 1 THEN FullName ELSE '(All)' END AS QAName,
				ISNULL(CASE WHEN @ReportBy <= 2 THEN Location.LocationName 
							WHEN @ReportBy = 53 THEN SupplierSite.LocationName 
							WHEN @ReportBy = 54 THEN Store.LocationName
							ELSE '(All)' END, '(Unknown)') AS LocationName, 
				ISNULL(PM_VW_Region.RegionName, N'(Unknown)') AS RegionName, 
				CASE	WHEN @GroupDatesBy = 1 THEN CONVERT(nvarchar, RPT_Warehouse_Response.EndDate, 106) 
						WHEN @GroupDatesBy = 2 THEN CAST(dbo.FNC_ISOWeek(RPT_Warehouse_Response.EndDate) AS nvarchar) 
						ELSE CAST(NULL AS nvarchar) END AS CheckDate, 
				MIN(RPT_Warehouse_Response.EndDate) AS SortDate, 
				@GroupDatesBy AS GroupDatesBy, 
				GroupDetailBy.GroupByText AS GroupDetail, 
				@GroupDetailBy AS GroupDetailBy, 
				COUNT(RPT_Warehouse_Response.ResponseID) AS NumChecks,
				SUM(CASE WHEN APP_QAFlag.QAFlagID = 1 THEN 1 ELSE 0 END) AS NumGreen, 
				SUM(CASE WHEN APP_QAFlag.QAFlagID = 2 THEN 1 ELSE 0 END) AS NumAmber,
				SUM(CASE WHEN APP_QAFlag.QAFlagID = 3 THEN 1 ELSE 0 END) AS NumRed,
				SUM(CASE WHEN RPT_Warehouse_Response.NumResponseQuestions > 0 THEN 1 ELSE 0 END) AS NumFullChecks,
				SUM(CASE WHEN RPT_Warehouse_Response.NumResponseQuestions = 0 THEN 1 ELSE 0 END) AS NumQuickChecks, 
				SUM(CASE WHEN RPT_Warehouse_Response.NumResponseQuestions > 0 AND APP_QAFlag.QAFlagID = 1 THEN 1 ELSE 0 END) AS NumFullGreen, 
				SUM(CASE WHEN RPT_Warehouse_Response.NumResponseQuestions > 0 AND APP_QAFlag.QAFlagID = 2 THEN 1 ELSE 0 END) AS NumFullAmber, 
				SUM(CASE WHEN RPT_Warehouse_Response.NumResponseQuestions > 0 AND APP_QAFlag.QAFlagID = 3 THEN 1 ELSE 0 END) AS NumFullRed, 
				SUM(RPT_Warehouse_Response.QuantityReceived) AS QuantityReceived,
				SUM(RPT_Warehouse_Response.QuantityChecked) AS QuantityChecked, 
				SUM(CASE WHEN ISNULL(RPT_Warehouse_Response.NumHotsheetItems, 0) = 1 THEN 1 ELSE 0 END) AS NumHotsheet, 
				@UserScorecardMode AS UserScorecardMode, 
				SUM(DATEDIFF(mi, RPT_Warehouse_Response.StartDate, RPT_Warehouse_Response.EndDate)) AS TotalTime, 
				@TargetChecks AS TargetChecks,
				@TargetHotSheets as TargetHotSheets,
				@TargetAmber AS TargetAmber,
				--return QAS Flag colours as separate cols so these can be used to set text colours in report
				(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 1) AS GreenColour,
				(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 2) AS AmberColour,
				(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 3) AS RedColour 
		FROM	TEMP_ResponseGroupBy AS GroupDetailBy 
					INNER JOIN	RPT_Warehouse_Response ON GroupDetailBy.ResponseID = RPT_Warehouse_Response.ResponseID 
					INNER JOIN	QMS_User ON QMS_User.UserID = RPT_Warehouse_Response.UserID 
					INNER JOIN	APP_QAFlag ON RPT_Warehouse_Response.QAFlagID = APP_QAFlag.QAFlagID 
					LEFT OUTER JOIN	PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID 
					LEFT OUTER JOIN	PM_VW_Location AS Location ON Location.LocationID = RPT_Warehouse_Response.LocationID 
					LEFT OUTER JOIN	PM_VW_Region ON Location.RegionID = PM_VW_Region.RegionID
					-- TFS 4927 : Supplier Site
					LEFT OUTER JOIN	PM_VW_Location AS SupplierSite ON RPT_Warehouse_Response.SupplierSiteID = SupplierSite.LocationID
					-- TFS 4927 : Store
					LEFT OUTER JOIN	PM_VW_Location AS Store ON RPT_Warehouse_Response.StoreID = Store.LocationID
		WHERE	(RPT_Warehouse_Response.RecordStatus < 180) 
		AND		(RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
		AND		(GroupDetailBy.UserID = @UserID)
		AND		(GroupDetailBy.GroupByText IS NOT NULL)
		GROUP BY 	CASE	WHEN @ReportBy = 1 THEN QMS_User.UserID 
							WHEN @ReportBy = 2 THEN ISNULL(Location.LocationID, 0) 
							WHEN @ReportBy = 3 THEN ISNULL(PM_VW_Region.RegionID, 0) 
							WHEN @ReportBy = 53 THEN ISNULL(SupplierSite.LocationID, 0) 
							WHEN @ReportBy = 54 THEN ISNULL(Store.LocationID, 0) 
							ELSE 0 END, 
					CASE	WHEN @ReportBy = 1 THEN FullName ELSE '(All)' END, 
					ISNULL(CASE WHEN @ReportBy <= 2 THEN Location.LocationName 
								WHEN @ReportBy = 53 THEN SupplierSite.LocationName 
								WHEN @ReportBy = 54 THEN Store.LocationName
								ELSE '(All)' END, '(Unknown)'), 
					ISNULL(PM_VW_Region.RegionName, N'(Unknown)'), 
					CASE	WHEN @GroupDatesBy = 1 THEN CONVERT(nvarchar, RPT_Warehouse_Response.EndDate, 106) 
							WHEN @GroupDatesBy = 2 THEN CAST(dbo.FNC_ISOWeek(RPT_Warehouse_Response.EndDate) AS nvarchar) 
							ELSE CAST(NULL AS nvarchar) END, 
					GroupDetailBy.GroupByText
		ORDER BY QAName, GroupID, LocationName, RegionName, SortDate, GroupDetail
	END
	ELSE --don't use reporting warehouse
	BEGIN
		SELECT  @DateFrom AS DateFrom, @DateTo AS DateTo, @ReportBy AS ReportBy, 
					CASE	WHEN @ReportBy = 1 THEN QMS_User.UserID 
							WHEN @ReportBy = 2 THEN ISNULL(Location.LocationID, 0) 
							WHEN @ReportBy = 3 THEN ISNULL(PM_VW_Region.RegionID, 0) 
							WHEN @ReportBy = 53 THEN ISNULL(SupplierSite.SupplierSiteID, 0) 
							WHEN @ReportBy = 54 THEN ISNULL(Store.StoreID, 0) 
							ELSE 0 END AS GroupID, 
					CASE WHEN @ReportBy = 1 THEN FullName ELSE '(All)' END AS QAName,
					ISNULL(CASE WHEN @ReportBy <= 2 THEN Location.LocationName 
								WHEN @ReportBy = 53 THEN SupplierSite.SupplierSite 
								WHEN @ReportBy = 54 THEN Store.Store
								ELSE '(All)' END, '(Unknown)') AS LocationName, 
					ISNULL(PM_VW_Region.RegionName, N'(Unknown)') AS RegionName, 
					CASE	WHEN @GroupDatesBy = 1 THEN CONVERT(nvarchar, QMS_Response.EndDate, 106) 
							WHEN @GroupDatesBy = 2 THEN CAST(dbo.FNC_ISOWeek(QMS_Response.EndDate) AS nvarchar) 
							ELSE CAST(NULL AS nvarchar) END AS CheckDate, 
					MIN(QMS_Response.EndDate) AS SortDate, 
					@GroupDatesBy AS GroupDatesBy, 
					GroupDetailBy.GroupByText AS GroupDetail, 
					@GroupDetailBy AS GroupDetailBy, 
					COUNT(QMS_Response.ResponseID) AS NumChecks,
					SUM(CASE WHEN APP_QAFlag.QAFlagID = 1 THEN 1 ELSE 0 END) AS NumGreen, 
					SUM(CASE WHEN APP_QAFlag.QAFlagID = 2 THEN 1 ELSE 0 END) AS NumAmber,
					SUM(CASE WHEN APP_QAFlag.QAFlagID = 3 THEN 1 ELSE 0 END) AS NumRed,
					SUM(CASE WHEN ISNULL(ResponseQuestion.NumResponses, 0) > 0 THEN 1 ELSE 0 END) AS NumFullChecks,
					SUM(CASE WHEN ISNULL(ResponseQuestion.NumResponses, 0) = 0 THEN 1 ELSE 0 END) AS NumQuickChecks, 
					SUM(CASE WHEN ISNULL(ResponseQuestion.NumResponses, 0) > 0 AND APP_QAFlag.QAFlagID = 1 THEN 1 ELSE 0 END) AS NumFullGreen, 
					SUM(CASE WHEN ISNULL(ResponseQuestion.NumResponses, 0) > 0 AND APP_QAFlag.QAFlagID = 2 THEN 1 ELSE 0 END) AS NumFullAmber, 
					SUM(CASE WHEN ISNULL(ResponseQuestion.NumResponses, 0) > 0 AND APP_QAFlag.QAFlagID = 3 THEN 1 ELSE 0 END) AS NumFullRed, 
					SUM(QMS_Response.QuantityReceived) AS QuantityReceived, SUM(QMS_Response.QuantityChecked) AS QuantityChecked, 
					SUM(CASE WHEN ISNULL(ResponseHeader_Hotsheet.Response, 0) = 1 THEN 1 ELSE 0 END) AS NumHotsheet, @UserScorecardMode AS UserScorecardMode, 
					SUM(DATEDIFF(mi, QMS_Response.StartDate, QMS_Response.EndDate)) AS TotalTime, @TargetChecks AS TargetChecks,
					@TargetAmber AS TargetAmber,@TargetHotSheets as TargetHotSheets,
					--return QAS Flag colours as separate cols so these can be used to set text colours in report
					(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 1) AS GreenColour,
					(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 2) AS AmberColour,
					(SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 3) AS RedColour 
		FROM	TEMP_ResponseGroupBy AS GroupDetailBy 
					INNER JOIN	QMS_Response ON GroupDetailBy.ResponseID = QMS_Response.ResponseID 
					INNER JOIN	QMS_User ON QMS_User.UserID = QMS_Response.UserID 
					INNER JOIN	APP_QAFlag ON --check config value to join on Actual or Override QAFlagID
											(CASE WHEN @ReportQAFlag = 0 THEN QMS_Response.Actual_QAFlagID
												ELSE ISNULL(QMS_Response.Override_QAFlagID, QMS_Response.Actual_QAFlagID) END)
											= APP_QAFlag.QAFlagID 
					LEFT OUTER JOIN	dbo.FNC_ResponseHeader_StockCodeID_Selected(@UserID) AS ResponseHeader_StockCodeID 
							ON QMS_Response.ResponseID = ResponseHeader_StockCodeID.ResponseID 
					LEFT OUTER JOIN	PM_VW_StockCode ON ResponseHeader_StockCodeID.StockCodeID = PM_VW_StockCode.StockCodeID 
					LEFT OUTER JOIN			(	SELECT     QMS_ResponseQuestion.ResponseID, COUNT(QMS_ResponseQuestion.ResponseQuestionID) AS NumResponses
												FROM          QMS_ResponseQuestion 
												INNER JOIN	TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID
												WHERE   (QMS_ResponseQuestion.Response_Text IS NOT NULL) 
												AND		(TEMP_Selected.UserID = @UserID)
												GROUP BY QMS_ResponseQuestion.ResponseID) AS ResponseQuestion 
									ON QMS_Response.ResponseID = ResponseQuestion.ResponseID 
					LEFT OUTER JOIN	PM_VW_Location AS Location 
					INNER JOIN		(	SELECT     QMS_ResponseHeader_1.ResponseID, QMS_ResponseHeader_1.Header_SourceID AS LocationID
										FROM          QMS_ResponseHeader AS QMS_ResponseHeader_1 
										INNER JOIN	QMS_AssessmentHeader AS QMS_AssessmentHeader_1 
															ON QMS_ResponseHeader_1.AssessmentHeaderID = QMS_AssessmentHeader_1.AssessmentHeaderID
										WHERE   (QMS_AssessmentHeader_1.DataTypeID = 9) 
										AND		(QMS_AssessmentHeader_1.DataLookupID = 4) 
										AND		(QMS_ResponseHeader_1.Header_SourceID IS NOT NULL)) AS Response_Location 
									ON Location.LocationID = Response_Location.LocationID 
					LEFT OUTER JOIN	PM_VW_Region ON Location.RegionID = PM_VW_Region.RegionID ON QMS_Response.ResponseID = Response_Location.ResponseID 
					LEFT OUTER JOIN	(	SELECT     QMS_ResponseHeader.ResponseID, QMS_ResponseHeader.Header_Boolean AS Response, QMS_AssessmentHeader.HeaderText
										FROM		QMS_ResponseHeader 
										INNER JOIN	QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
										WHERE   (QMS_ResponseHeader.Header_Boolean IS NOT NULL) 
										AND		(QMS_AssessmentHeader.DataLookupID = 33)) AS ResponseHeader_Hotsheet 
									ON QMS_Response.ResponseID = ResponseHeader_Hotsheet.ResponseID
					-- TFS 4927 : Supplier Site
					LEFT OUTER JOIN	(	SELECT		QMS_ResponseHeader.ResponseID, 
												PM_VW_Location.LocationID AS SupplierSiteID,
												PM_VW_Location.LocationName AS SupplierSite
										FROM		QMS_ResponseHeader
										INNER JOIN	QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID 
										INNER JOIN	TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
										INNER JOIN PM_VW_Location ON QMS_ResponseHeader.Header_SourceID = PM_VW_Location.LocationID
										WHERE   (QMS_AssessmentHeader.DataTypeID = 9) 
										AND		(QMS_AssessmentHeader.DataLookupID = 53)
										AND		(TEMP_Selected.UserID = @UserID) 
										) AS SupplierSite
									ON QMS_Response.ResponseID = SupplierSite.ResponseID
					-- TFS 4927 : Store
					LEFT OUTER JOIN	(	SELECT		QMS_ResponseHeader.ResponseID, 
													QMS_ResponseHeader.Header_SourceID AS StoreID,
													PM_VW_Location.LocationName AS Store
										FROM		QMS_ResponseHeader
										INNER JOIN	QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID 
										INNER JOIN	TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
										INNER JOIN PM_VW_Location ON QMS_ResponseHeader.Header_SourceID = PM_VW_Location.LocationID
										WHERE   (QMS_AssessmentHeader.DataTypeID = 9) 
										AND		(QMS_AssessmentHeader.DataLookupID = 54)
										AND		(TEMP_Selected.UserID = @UserID) 
										) AS Store
									ON QMS_Response.ResponseID = Store.ResponseID
		WHERE	(QMS_Response.ResponseStatus = 1) 
		AND		(QMS_Response.RecordStatus < 180) 
		AND		(QMS_Response.EndDate BETWEEN @DateFrom AND @DateTo)
		AND		(GroupDetailBy.UserID = @UserID)
		AND		(GroupDetailBy.GroupByText IS NOT NULL)
		GROUP BY 	CASE	WHEN @ReportBy = 1 THEN QMS_User.UserID 
							WHEN @ReportBy = 2 THEN ISNULL(Location.LocationID, 0) 
							WHEN @ReportBy = 3 THEN ISNULL(PM_VW_Region.RegionID, 0) 
							WHEN @ReportBy = 53 THEN ISNULL(SupplierSite.SupplierSiteID, 0) 
							WHEN @ReportBy = 54 THEN ISNULL(Store.StoreID, 0) 
							ELSE 0 END, 
					CASE	WHEN @ReportBy = 1 THEN FullName ELSE '(All)' END, 
					ISNULL(CASE WHEN @ReportBy <= 2 THEN Location.LocationName 
								WHEN @ReportBy = 53 THEN SupplierSite.SupplierSite 
								WHEN @ReportBy = 54 THEN Store.Store
								ELSE '(All)' END, '(Unknown)'), 
					ISNULL(PM_VW_Region.RegionName, N'(Unknown)'), 
					CASE	WHEN @GroupDatesBy = 1 THEN CONVERT(nvarchar, QMS_Response.EndDate, 106) 
							WHEN @GroupDatesBy = 2 THEN CAST(dbo.FNC_ISOWeek(QMS_Response.EndDate) AS nvarchar) 
							ELSE CAST(NULL AS nvarchar) END, 
					GroupDetailBy.GroupByText
		ORDER BY QAName, GroupID, LocationName, RegionName, SortDate, GroupDetail
	END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Scorecard]') AND type in (N'P', N'PC'))
	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Failed to create [dbo].[RPT_Scorecard]', ERROR_MESSAGE()
	FROM #tmpScriptName
GO
-- END [dbo].[RPT_Scorecard]






-- BEGIN DATA Add1_Table_APP_ResourceArea_59591
BEGIN TRY
-- Add_Table_APP_ResourceArea_59591
IF NOT EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceArea'
)
BEGIN
    CREATE TABLE [dbo].[APP_ResourceArea](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
	CONSTRAINT [PK_APP_ResourceArea] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Table_APP_ResourceArea_59591', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add1_Table_APP_ResourceArea_59591

-- BEGIN DATA Add2_Table_APP_ResourceKey_59642
BEGIN TRY
-- Add_Table_APP_ResourceKey_59642
IF NOT EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceKey'
)
BEGIN
    CREATE TABLE [dbo].[APP_ResourceKey](
		[ID] [int] IDENTITY(1,1) NOT NULL,
		[ResourceAreaID] [int] NOT NULL,
		[Name] [nvarchar](255) NOT NULL,
		CONSTRAINT [PK_APP_ResourceKey] PRIMARY KEY CLUSTERED 
		(
			[ID] ASC
		) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Table_APP_ResourceKey_59642', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add2_Table_APP_ResourceKey_59642

-- BEGIN DATA Add3_Table_APP_ResourceString_59643
BEGIN TRY
-- Add_Table_APP_ResourceString_59643
IF NOT EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceString'
)
BEGIN
    CREATE TABLE [dbo].[APP_ResourceString](
		[ID] [int] IDENTITY(1,1) NOT NULL,
		[ResourceKeyID] [int] NOT NULL,
		[CountryLocaleID] [int] NOT NULL,
		[ResourceString] [nvarchar](255) NULL,
		CONSTRAINT [PK_APP_ResourceString] PRIMARY KEY CLUSTERED 
		(
			[ID] ASC
		) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Table_APP_ResourceString_59643', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add3_Table_APP_ResourceString_59643

-- BEGIN DATA AssessmentType_Add_Column_ResourceKeyID_60636
-- AssessmentType_Add_Column_ResourceKeyID_60636
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA ='dbo'
		AND TABLE_NAME='APP_AssessmentType'
)
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE
			TABLE_SCHEMA ='dbo'
			AND TABLE_NAME = 'APP_AssessmentType'
            AND COLUMN_NAME = 'ResourceKeyID'
	)
	BEGIN
		-- Add column
		ALTER TABLE dbo.APP_AssessmentType
			ADD ResourceKeyID int NULL;

		-- Add relationship
		ALTER TABLE [dbo].[APP_AssessmentType]  WITH CHECK ADD  CONSTRAINT [FK_APP_AssessmentType_APP_ResourceKey] FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END
END
GO
-- END DATA AssessmentType_Add_Column_ResourceKeyID_60636

-- BEGIN DATA Add4_Relationship_APP_ResourceKey_To_APP_ResourceArea_59663
BEGIN TRY
-- Add_Relationship_APP_ResourceKey_To_APP_ResourceArea_59663
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceArea'
)
AND EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceKey'
)
BEGIN
	IF NOT EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceKey_APP_ResourceArea'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceKey]
			WITH CHECK
			ADD CONSTRAINT [FK_APP_ResourceKey_APP_ResourceArea]
			FOREIGN KEY([ResourceAreaID])
			REFERENCES [dbo].[APP_ResourceArea] ([ID])
	END

	IF EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceKey_APP_ResourceArea'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceKey] CHECK CONSTRAINT [FK_APP_ResourceKey_APP_ResourceArea]
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Relationship_APP_ResourceKey_To_APP_ResourceArea_59663', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add4_Relationship_APP_ResourceKey_To_APP_ResourceArea_59663

-- BEGIN DATA Add5_Relationship_APP_ResourceString_To_APP_ResourceKey_59664
BEGIN TRY
-- Add_Relationship_APP_ResourceString_To_APP_ResourceKey_59664
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceKey'
)
AND EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceString'
)
BEGIN
	IF NOT EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceString_APP_ResourceKey'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceString] 
			WITH CHECK
			ADD CONSTRAINT [FK_APP_ResourceString_APP_ResourceKey]
			FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END

	IF EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceString_APP_ResourceKey'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceString] CHECK CONSTRAINT [FK_APP_ResourceString_APP_ResourceKey]
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Relationship_APP_ResourceString_To_APP_ResourceKey_59664', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add5_Relationship_APP_ResourceString_To_APP_ResourceKey_59664

-- BEGIN DATA Add6_Relationship_APP_ResourceString_To_APP_CountryLocales_59671
BEGIN TRY
-- Add_Relationship_APP_ResourceString_To_APP_CountryLocales_59671
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_ResourceString'
)
AND EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA = 'dbo'
		AND TABLE_NAME = 'APP_CountryLocales'
)
BEGIN
	IF NOT EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceString_APP_CountryLocales'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceString]
			WITH CHECK
			ADD CONSTRAINT [FK_APP_ResourceString_APP_CountryLocales]
			FOREIGN KEY([CountryLocaleID])
			REFERENCES [dbo].[APP_CountryLocales] ([CountryLocaleID])
	END

	IF EXISTS
	(
	SELECT *
	FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS
	WHERE
		CONSTRAINT_SCHEMA = 'dbo'
		AND CONSTRAINT_NAME = 'FK_APP_ResourceString_APP_CountryLocales'
	)
	BEGIN
		ALTER TABLE [dbo].[APP_ResourceString] CHECK CONSTRAINT [FK_APP_ResourceString_APP_CountryLocales]
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Relationship_APP_ResourceString_To_APP_CountryLocales_59671', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add6_Relationship_APP_ResourceString_To_APP_CountryLocales_59671

-- BEGIN DATA DataLookup_Add_Column_ResourceKeyID_60634
BEGIN TRY
-- DataLookup_Add_Column_ResourceKeyID_60634
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA ='dbo'
		AND TABLE_NAME='APP_DataLookup'
)
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE
			TABLE_SCHEMA ='dbo'
			AND TABLE_NAME = 'APP_DataLookup'
            AND COLUMN_NAME = 'ResourceKeyID'
	)
	BEGIN
		-- Add column
		ALTER TABLE dbo.APP_DataLookup
			ADD ResourceKeyID int NULL;

		-- Add relationship
		ALTER TABLE [dbo].[APP_DataLookup]  WITH CHECK ADD  CONSTRAINT [FK_APP_DataLookup_APP_ResourceKey] FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA -- DataLookup_Add_Column_ResourceKeyID_60634', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA -- DataLookup_Add_Column_ResourceKeyID_60634

-- BEGIN DATA DataType_Add_Column_ResourceKeyID_60630
BEGIN TRY
-- DataType_Add_Column_ResourceKeyID_60630
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA ='dbo'
		AND TABLE_NAME='APP_DataType'
)
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE
			TABLE_SCHEMA ='dbo'
			AND TABLE_NAME = 'APP_DataType'
            AND COLUMN_NAME = 'ResourceKeyID'
	)
	BEGIN
		-- Add column
		ALTER TABLE dbo.APP_DataType
			ADD ResourceKeyID int NULL;

		-- Add relationship
		ALTER TABLE [dbo].[APP_DataType]  WITH CHECK ADD  CONSTRAINT [FK_APP_DataType_APP_ResourceKey] FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA DataType_Add_Column_ResourceKeyID_60630', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA DataType_Add_Column_ResourceKeyID_60630

-- BEGIN DATA Menu_Add_Column_ResourceKeyID_60735
BEGIN TRY
-- Menu_Add_Column_ResourceKeyID_60735
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA ='dbo'
		AND TABLE_NAME='APP_Menu'
)
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE
			TABLE_SCHEMA ='dbo'
			AND TABLE_NAME = 'APP_Menu'
            AND COLUMN_NAME = 'ResourceKeyID'
	)
	BEGIN
		-- Add column
		ALTER TABLE dbo.APP_Menu
			ADD ResourceKeyID int NULL;

		-- Add relationship
		ALTER TABLE [dbo].[APP_Menu]  WITH CHECK ADD  CONSTRAINT [FK_APP_Menu_APP_ResourceKey] FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Menu_Add_Column_ResourceKeyID_60735', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Menu_Add_Column_ResourceKeyID_60735

-- BEGIN DATA QuestionLevel_Add_Column_ResourceKeyID_60635
BEGIN TRY
-- QuestionLevel_Add_Column_ResourceKeyID_60635
IF EXISTS
(
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE
		TABLE_SCHEMA ='dbo'
		AND TABLE_NAME='APP_QuestionLevel'
)
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE
			TABLE_SCHEMA ='dbo'
			AND TABLE_NAME = 'APP_QuestionLevel'
            AND COLUMN_NAME = 'ResourceKeyID'
	)
	BEGIN
		-- Add column
		ALTER TABLE dbo.APP_QuestionLevel
			ADD ResourceKeyID int NULL;

		-- Add relationship
		ALTER TABLE [dbo].[APP_QuestionLevel]  WITH CHECK ADD  CONSTRAINT [FK_APP_QuestionLevel_APP_ResourceKey] FOREIGN KEY([ResourceKeyID])
			REFERENCES [dbo].[APP_ResourceKey] ([ID])
	END
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA QuestionLevel_Add_Column_ResourceKeyID_60635', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA QuestionLevel_Add_Column_ResourceKeyID_60635

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResourceString')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResourceString]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author		: MBS\QC.Team
-- Create date	: 11/11/2016
-- Description	: Gets resource string for specified user
-- Version		: 1
-- =============================================
-- PH TFS 13-60629 : v1 11/11/2016 - Created
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResourceString]
(
	@ResourceKeyID int,
	@UserID int
)
RETURNS nvarchar(255)
AS
BEGIN
	
	DECLARE @countryLocaleId INT;
	DECLARE @defaultConfigLocaleId INT;

	SELECT @defaultConfigLocaleId = CountryLocaleID
	FROM [dbo].APP_CountryLocales
	WHERE StringCode = dbo.FNC_GetOptionValue(66);

	SELECT @countryLocaleId = ISNULL(ISNULL(LocaleID, @defaultConfigLocaleId), 46)
	FROM [dbo].[QMS_User]
	WHERE UserID = @UserID;

	DECLARE @resourceString nvarchar(255) = NULL;

	SELECT @resourceString = resourceString.ResourceString
	FROM [dbo].[APP_ResourceKey] AS resourceKey
	INNER JOIN [dbo].[APP_ResourceString] AS resourceString
		ON resourceString.ResourceKeyID = resourceKey.ID
		AND resourceString.CountryLocaleID  = @countryLocaleId
	WHERE resourceKey.ID = @ResourceKeyID;

	RETURN @resourceString;

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_DataLookup_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_DataLookup_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 07/07/2008
-- Description	: Gets list of data lookups
-- Version		: 3
-- =============================================
-- JTTFS 4927 - Resource name looked up and returned.
-- PH TFS 13-60653 : Include new translations
-- =============================================
ALTER PROCEDURE [dbo].[QRY_DataLookup_Combo] 
	@UserID int = NULL
AS
	SELECT
		DataLookupID,
		ISNULL
		(
			dbo.FNC_ResourceString(APP_DataLookup.ResourceKeyID, @UserID),
			ISNULL
			(
				dbo.FNC_ResourceString_User(APP_DataLookup.ResourceKeyID, @UserID),
				DataLookup
			)
		)
		AS DataLookup
	FROM         APP_DataLookup
	WHERE     (Hide = 0)
	ORDER BY ListIndex
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_DataType_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_DataType_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author  : MBS\Phil.Harding  
-- Create date : 11/11/2016  
-- Description : Gets list of data types  
-- Version  : 3  
-- =============================================  
-- PH TFS 13-60652 : v2 11/11/2016 - Translated data type name
-- Martin P TFS 13-61120 :v3 22/11/2016 - Added DataType Column Name   
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_DataType_Combo]   
 @UserID int = NULL  
AS  
  
SELECT  
 DataTypeID,  
 ISNULL(dbo.FNC_ResourceString(APP_DataType.ResourceKeyID, @UserID), DataType) AS DataType 
FROM APP_DataType  
WHERE (Hide = 0)  
ORDER BY ListIndex  
  
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Menu')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Menu] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 26/06/2008
-- Description	: Gets menu structure for specified application
-- Version		: 2
-- =============================================
-- PH TFS 13-60735 : v2 14/11/2016 - include new translations logic.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Menu] 
	@AppID int,
	@UserID int = NULL
AS

SELECT
	MenuID,
	MenuIndex,
	ParentID,
	ISNULL(ISNULL(dbo.FNC_ResourceString(APP_Menu.ResourceKeyID, @UserID), dbo.FNC_ResourceString_User(APP_Menu.ResourceName, @UserID)),  Description) AS Description,
	ResourceName,
	IconName,
	SeperatorBefore,
	MenuAction
FROM	APP_Menu
WHERE
	AppID = @AppID
	AND Visible = 1
ORDER BY CASE WHEN @AppID = 3 THEN MenuIndex ELSE ParentID END, MenuIndex;
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_MenuAdmin')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_MenuAdmin] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================    
-- Author		: j.toolan    
-- Create date	: 7/11/2012  
-- Description	: Gets menu structure for specified application (for admin purposes, so include invisible ones)  
-- Version		: 2
-- =============================================  
-- MartinP TFS 13-60735 : v2 14/11/2016 - Added FNC_ResourceString call for ResourceValue column
-- =============================================    
ALTER PROCEDURE QRY_MenuAdmin  
 @AppID int,  
 @UserID int = 1  
AS    
BEGIN  
 SELECT APP_Menu.MenuID,   
   APP_Menu.AppID,   
   APP_Menu.MenuIndex,   
   APP_Menu.ParentID,   
   APP_Menu.[Description],   
   APP_Menu.ResourceName,   
   APP_Menu.IconName,   
   APP_Menu.SeperatorBefore,  
   APP_Menu.MenuAction,  
   APP_Menu.Visible,  
   ISNULL(dbo.FNC_ResourceString(APP_Menu.ResourceKeyID, @UserID), dbo.FNC_ResourceString_User(APP_Menu.ResourceName, @UserID)) AS ResourceValue  
 FROM APP_Menu   
 WHERE APP_Menu.AppID = @AppID  
END  
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionLevel_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionLevel_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author  : Markp  
-- Create date : 18/07/2008  
-- Description : Question level combo  
-- Version  : 3  
-- =============================================  
-- PH TFS 13-60656 : v2 11/11/2026 - Added new tranlations to question level names.
-- Martin P TFS 13-61120 :v3 22/11/2016 - Added QuestionLevel Column Name   
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_QuestionLevel_Combo]  
 @UserID int = NULL  
AS  
  
SELECT  
 QuestionLevelID,  
 ISNULL(dbo.FNC_ResourceString(APP_QuestionLevel.ResourceKeyID, @UserID), QuestionLevel) AS QuestionLevel   
FROM APP_QuestionLevel  
ORDER BY ListIndex  
  
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionPool_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionPool_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Gets list of questions for admin
-- Version:		5
-- =============================================
-- J.Toolan 11/10/2011: Added hideExternal parameter to prevent editing external questions.
-- JT TFS 4033: Added Section Columns
-- JT TFS 13-14079: Procedure seems to suffer from parameter sniffing. Removing direct links to parameters.
-- PH TFS 13-60633: v5 11/11/2016 - New translations of DataType, DataLookup, QuestionLevel and AssessmentType names.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_QuestionPool_AdminList] 
	@ShowSystem bit = 0,
	@hideExternal bit = 0, -- Hide imported questions from higher up the food chain (Active Quality Chain)
	@UserID int = null
AS
BEGIN
	SET NOCOUNT ON 

	DECLARE @m_ShowSystem bit,
			@m_HideExternal bit
	SELECT @m_ShowSystem = @ShowSystem,
			@m_HideExternal = @hideExternal

	SET NOCOUNT OFF

	SELECT	QMS_QuestionPool.QuestionID, 
			QMS_QuestionPool.Question,
			QMS_QuestionPool.IsQuestionGroup, 
			QMS_QuestionPool.DataTypeID,
			(	SELECT	ISNULL(dbo.FNC_ResourceString(APP_DataType.ResourceKeyID, @UserID), DataType)
				FROM	APP_DataType
				WHERE	(DataTypeID = QMS_QuestionPool.DataTypeID)) AS Lookup_DataTypeID, 
			QMS_QuestionPool.DataLookupID,
			(	SELECT	ISNULL(dbo.FNC_ResourceString(APP_DataLookup.ResourceKeyID, @UserID), DataLookup)
				FROM	APP_DataLookup
				WHERE	(DataLookupID = QMS_QuestionPool.DataLookupID)) AS Lookup_DataLookupID, 
			QMS_QuestionPool.CustomLookupID,
			(	SELECT	LookupName
				FROM	QMS_CustomLookup
				WHERE	(CustomLookupID = QMS_QuestionPool.CustomLookupID)) AS Lookup_CustomLookupID, 
			QMS_QuestionPool.QuestionLevelID,
			(	SELECT	ISNULL(dbo.FNC_ResourceString(APP_QuestionLevel.ResourceKeyID, @UserID), QuestionLevel)
				FROM	APP_QuestionLevel
				WHERE	(QuestionLevelID = QMS_QuestionPool.QuestionLevelID)) AS Lookup_QuestionLevelID, 
			QMS_QuestionPool.QuestionGroup,
			QMS_QuestionPool.QuestionSubGroup,
			QMS_QuestionPool.ShortGuidance, 
			QMS_QuestionPool.QuestionTag, 
			QMS_QuestionPool.AssessmentTypeID,
			(	SELECT	ISNULL(dbo.FNC_ResourceString(APP_AssessmentType.ResourceKeyID, @UserID), AssessmentType)
				FROM	APP_AssessmentType
				WHERE	(AssessmentTypeID = QMS_QuestionPool.AssessmentTypeID)) AS Lookup_AssessmentTypeID, 
			QMS_QuestionPool.DefaultQuestion, 
			QMS_QuestionPool.CopyRepeatCheck, 
			QMS_QuestionPool.Hide, 
			ISNULL(ActiveAssessmentQuestion.QuestionCount, 0) AS ActiveQuestionCount, 
			CAST(CASE WHEN Sys_Question IS NULL THEN 0 ELSE 1 END AS bit) AS SystemQuestion
	FROM         QMS_QuestionPool 
	LEFT OUTER JOIN	(	SELECT		QMS_AssessmentQuestion.QuestionID, COUNT(QMS_AssessmentQuestion.AssessmentQuestionID) AS QuestionCount
						FROM        QMS_Assessment 
						INNER JOIN	APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID 
						INNER JOIN	QMS_AssessmentQuestion ON QMS_Assessment.AssessmentID = QMS_AssessmentQuestion.AssessmentID
						WHERE      (QMS_Assessment.RecordStatus < 201) AND (APP_AssessmentStatus.Active = 1) AND (QMS_AssessmentQuestion.RecordStatus < 201)
						GROUP BY QMS_AssessmentQuestion.QuestionID) AS ActiveAssessmentQuestion ON 
												  QMS_QuestionPool.QuestionID = ActiveAssessmentQuestion.QuestionID
	WHERE   (QMS_QuestionPool.RecordStatus < 201) 
	AND		(	QMS_QuestionPool.AssessmentTypeID IS NULL 
			OR
				NOT (QMS_QuestionPool.AssessmentTypeID IN
							  (SELECT     AssessmentTypeID
								FROM          APP_AssessmentType AS APP_AssessmentType_2
								WHERE      (Hide = 1)))) 
	AND		( (@m_ShowSystem = 1)		OR (QMS_QuestionPool.Sys_Question IS NULL) )
	AND     ( (@m_HideExternal = 0)	OR (dbo.FNC_Question_IsControlledExternally (QMS_QuestionPool.QuestionID) = 0) )
	ORDER BY QMS_QuestionPool.Question
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ResourceStrings')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ResourceStrings] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Taj.Sehdev
-- Create date	: 07/11/2016
-- Description	: Gets resources for current locale
-- Version		: 3
-- =============================================
-- TS TFS 13-60155 : v1 07/11/2016 - Created
-- TS TFS 13-60155 : v2 07/11/2016 - Fixed column names
-- TS TFS 13-60155 : v3 11/11/2016 - Put in default language, for when user locale not set
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ResourceStrings] @UserID INT
AS
BEGIN
	DECLARE @countryLocaleId INT
	DECLARE @defaultConfigLocaleId INT

	SELECT @defaultConfigLocaleId = CountryLocaleID
	FROM [dbo].APP_CountryLocales
	WHERE StringCode = dbo.FNC_GetOptionValue(66);

	SELECT @countryLocaleId = ISNULL(ISNULL(LocaleID, @defaultConfigLocaleId), 46)
	FROM [dbo].[QMS_User]
	WHERE UserID = @UserID

	SELECT
		resourceString.ID,
		resourceArea.ID AS ResourceAreaID,
		resourceArea.Name AS ResourceAreaName,
		resourceString.ResourceKeyID,
		resourceKey.Name AS ResourceKeyName,
		resourceString.ResourceString
	FROM [dbo].[APP_ResourceArea] AS resourceArea
	INNER JOIN [dbo].[APP_ResourceKey] AS resourceKey
		ON resourceKey.ResourceAreaID = resourceArea.ID
	INNER JOIN [dbo].[APP_ResourceString] AS resourceString
		ON resourceString.ResourceKeyID = resourceKey.ID
	WHERE resourceString.CountryLocaleID = @countryLocaleId;
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_UserPermissions_GetFavouredReports')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_UserPermissions_GetFavouredReports] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Stephen Ford
-- Create date: 04.09.2013
-- Description:	Gets the reports a user has marked
--              as favoured.
-- Version:		3
-- =============================================
-- JT TFS 8092: Add normal page favourites to the SP.
-- MartinP TFS 13-60735 : v3 14/11/2016 - Added FNC_ResourceString call for ResourceValue column
-- =============================================
ALTER PROCEDURE [dbo].[QRY_UserPermissions_GetFavouredReports]
@UserID int,
@PermissionType int = 4 --4=reports, 21=generic pages
AS
BEGIN
SET NOCOUNT ON;

SELECT QMS_UserPermissions.UserPermissionID,
	   QMS_UserPermissions.PermissionTitle,
	   QMS_UserPermissions.PermissionAllow,
	   ISNULL(ISNULL(dbo.FNC_ResourceString(APP_Menu.ResourceKeyID, @UserID), dbo.FNC_ResourceString_User(APP_Menu.ResourceName, @UserID)), dbo.APP_Menu.Description) AS ReportName,
	   APP_Menu.MenuAction,
	   QMS_UserPermissions.PermissionType
FROM   dbo.QMS_UserPermissions
INNER JOIN dbo.APP_Menu ON QMS_UserPermissions.PermissionTitle = APP_Menu.MenuID
WHERE QMS_UserPermissions.UserID = @UserID 
AND QMS_UserPermissions.PermissionType = @PermissionType

END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	16
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- SS TFS 13-49897: Added ISNULL(Uploaded, EndDate) so that EndDate will be used if Uploaded contains a NULL Value
-- PH TSF 13-61027 : v16 18/11/2016 - Bug Fix.  When including checks from the datawarehouse for todays date, an assumption was made that the datawarehouse had been updated before @DateFrom.  However, if this was not the case then checks were included from the past (but after the warehouse had been updated).  The greater of the datawarehouse update time and @DateFrom is now used.
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	DECLARE @UnfilteredResponseTodaysDate TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	BEGIN
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1 AND @DateTo <= @WarehouseBuildDate
		BEGIN
			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response INNER JOIN
							QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			END
			
	--Logic for inserting today's date data into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date
	ELSE IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
		BEGIN
			DECLARE @override bit 
			SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND ISNULL(Uploaded,EndDate) BETWEEN (CASE WHEN @WarehouseBuildDate > @DateFrom THEN @WarehouseBuildDate ELSE @DateFrom END) AND @DateTo

	--Logic for getting incomplete checks before today's date
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND (EndDate BETWEEN @DateFrom AND @DateTo)
			AND ResponseStatus = 0
			AND ResponseID  NOT IN (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = UnfilteredResponseTodaysDate.ResponseID) 

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponseTodaysDate
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponseTodaysDate
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponseTodaysDate.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponseTodaysDate
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)

			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response 
			INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
			AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @WarehouseBuildDate)
			AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

			INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
			SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseTodaysDate
		END
	ELSE --don't use warehouse table
		BEGIN
			DECLARE @OverrideOption bit 
			SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
		END
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO







PRINT 'Database updated successfully!'
GO
