-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_GetGuidance')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 16/03/2010  
-- version:		4
-- Description: Gets the guidance detail for the selected assessment question  
--==============================================  
-- TFS 10889 - Mobile guidance should be reordered in Guidance popup  
-- SS TFS 13-53805: Removed join within constraint guidance which joined on created date (created is not always unique AND was causing multiple images to show when they shouldn't have)  
-- JT TFS 13-57727: 04/10/2016 - Added AttachmentFilename column to top query, and GuidanceID to lower query so that both tables return the same columns.
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance]   
	@AssessmentQuestionID int  
AS  

--Constraint guidance  
SELECT		ISNULL(QMS_CustomLookupItem.LookupText, APP_QAFlag.QAFlag) AS Title,  
			CAST(NULL AS image) AS AttachmentImage, 
			Constraint_Guidance.Attachment,
			Constraint_Guidance.AttachmentFileName,
			Constraint_Guidance.AttachmentTitle,   
			QMS_AssessmentQuestionConstraint.ShortGuidance,   
            Constraint_Guidance.GuidanceDesc, 
			Constraint_Guidance.GuidanceString, 
			Constraint_Guidance.GuidanceURL, 
			QMS_AssessmentQuestionConstraint.QAFlagID, 
			Constraint_Guidance.GuidanceID
FROM         APP_QAFlag 
RIGHT OUTER JOIN  QMS_AssessmentQuestionConstraint ON APP_QAFlag.QAFlagID = QMS_AssessmentQuestionConstraint.QAFlagID 
LEFT OUTER JOIN	(	SELECT	QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL,   
							Attachments.Attachment, Attachments.AttachmentFileName, Attachments.AttachmentTitle             
					FROM      QMS_Guidance   
					LEFT OUTER JOIN (	SELECT guidance.Sys_GuidanceID, Attachment_Linked.AttachmentID   
										FROM (	SELECT Sys_GuidanceID, AttachmentID, row   
												FROM (	SELECT guidance.Sys_GuidanceID, attachment.AttachmentID,  
														ROW_NUMBER() OVER (PARTITION BY Sys_GuidanceID ORDER BY attachment.Created DESC, attachment.AttachmentID DESC) as row  
														FROM QMS_Guidance guidance  
														INNER JOIN QMS_Attachment attachment ON guidance.GuidanceID = attachment.SourceObjectID 
																							AND attachment.AttachmentSourceID = 3  
														WHERE guidance.RecordStatus < 201  
														AND attachment.RecordStatus < 201  
												) AS GuidanceAttachment  
												WHERE row = 1  
										) AS LastGuidanceAttachment             
										INNER JOIN  QMS_Attachment AS Attachment_Linked ON LastGuidanceAttachment.AttachmentID = Attachment_Linked.AttachmentID 
										INNER JOIN  QMS_Guidance AS Guidance ON LastGuidanceAttachment.Sys_GuidanceID = Guidance.Sys_GuidanceID   
																			AND Attachment_Linked.SourceObjectID = Guidance.GuidanceID  
                                        WHERE	(Attachment_Linked.AttachmentSourceID = 3) 
										AND		(Attachment_Linked.RecordStatus < 201)  
					) AS Linked_Attachments ON QMS_Guidance.Sys_GuidanceID = Linked_Attachments.Sys_GuidanceID   
					LEFT OUTER JOIN (	SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName  
										FROM          QMS_Attachment  
										WHERE      (AttachmentSourceID = 3)
										AND		(RecordStatus < 201)  
					) AS Attachments ON QMS_Guidance.GuidanceID = Attachments.GuidanceID  
					WHERE   (QMS_Guidance.RecordStatus < 201) 
					AND		(QMS_Guidance.Hide = 0)
) AS Constraint_Guidance ON QMS_AssessmentQuestionConstraint.GuidanceID = Constraint_Guidance.GuidanceID   
LEFT OUTER JOIN QMS_CustomLookupItem ON QMS_AssessmentQuestionConstraint.Constraint_SourceID = QMS_CustomLookupItem.CustomLookupItemID  
WHERE   (ISNULL(LEN(QMS_AssessmentQuestionConstraint.ShortGuidance), 0) > 0)   
AND		(QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID)   
AND		(QMS_AssessmentQuestionConstraint.RecordStatus < 201)  
OR		(QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID)   
AND		(QMS_AssessmentQuestionConstraint.RecordStatus < 201)  
AND		(Constraint_Guidance.GuidanceID IS NOT NULL)  
ORDER BY QMS_AssessmentQuestionConstraint.QAFlagID  

--Question guidance  ** THIS MUST HAVE SAME COLUMNS AS ABOVE QUERY **
SELECT  QMS_QuestionPool.Question AS Title, 
		CAST(NULL AS image) AS AttachmentImage, 
		Question_Guidance.Attachment, 
		Question_Guidance.AttachmentFileName, 
		Question_Guidance.AttachmentTitle,   
        QMS_AssessmentQuestion.ShortGuidance, 
		Question_Guidance.GuidanceDesc, 
		Question_Guidance.GuidanceString, 
		Question_Guidance.GuidanceURL,   
        CAST(NULL AS int) AS QAFlagID,
		Question_Guidance.GuidanceID
FROM		QMS_AssessmentQuestion 
INNER JOIN	QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID 
LEFT OUTER JOIN	(	SELECT	QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL,   
							Attachments.AttachmentTitle, Attachments.Attachment, Attachments.AttachmentFileName  
                    FROM          QMS_Guidance 
					LEFT OUTER JOIN  (	SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName  
                                        FROM          QMS_Attachment  
                                        WHERE      (AttachmentSourceID = 3) 
										AND (RecordStatus < 201)
					) AS Attachments ON QMS_Guidance.GuidanceID = Attachments.GuidanceID  
                    WHERE	(QMS_Guidance.RecordStatus < 201) 
					AND		(QMS_Guidance.Hide = 0)
) AS Question_Guidance ON QMS_AssessmentQuestion.GuidanceID = Question_Guidance.GuidanceID  
WHERE	(QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) 
AND		(ISNULL(LEN(QMS_AssessmentQuestion.ShortGuidance), 0) > 0) 
OR	
		(QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) 
AND		(Question_Guidance.GuidanceID IS NOT NULL)  

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCode_FinalProduct_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCode_FinalProduct_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 26/10/2016
-- Description:	Gets a final stock code list
-- Version:		1
-- =============================================
-- tfs 56662
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_FinalProduct_Combo]
	@UserID int = NULL,
	@AssessmentTypeID int = NULL,
	@SearchText nvarchar(100) = NULL
AS

BEGIN
		
	IF @UserID IS NULL 
		SELECT		StockCodeID as FinalProductStockCodeID, DisplayText
		FROM         
			PM_VW_StockCode
		WHERE		
			StockTypeID = 3 AND 
			(@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID as FinalProductStockCodeID, PM_VW_StockCode.DisplayText
		FROM         
			PM_VW_StockCode INNER JOIN
			dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE 
			StockTypeID = 3 AND
			(Hide = 0) AND 
			(@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText) AND 
			(PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText

	ELSE IF @UserID IS NOT NULL  AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID as FinalProductStockCodeID, PM_VW_StockCode.DisplayText
		FROM         
			PM_VW_StockCode INNER JOIN
			dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
			AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
			AND StockTypeID = 3
		ORDER BY PM_VW_StockCode.DisplayText
		
	
END
GO



PRINT 'Database updated successfully!'
GO
