-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO




-- BEGIN DATA Add_Column_QMS_Response_HasAttachments_56706
BEGIN TRY
-- Add_Column_QMS_Response_HasAttachments_56706
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = 'HasAttachments' AND Object_ID = Object_ID('QMS_Response'))
BEGIN
	ALTER TABLE QMS_Response
		ADD HasAttachments bit NOT NULL DEFAULT 0 WITH VALUES;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Column_QMS_Response_HasAttachments_56706', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add_Column_QMS_Response_HasAttachments_56706




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Attachment')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Attachment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/09/2008
-- Description:	Saves attachment
-- Version:		8
-- =============================================
-- SF TFS 7843 - updated for Entity Framework
-- JT TFS 13-3861 - add ability to add temp attachments to an object. If they are left for 24 hours as temporary, then they will get removed.
                  -- and update SourceObjectId from zero to good value.
-- MartinP TFS 13 - 36259 - Changed the Update on QMS_Attachment to improve performance
-- PH TFS 13-56707: v6 20/09/2016 - Added functionality to update QMS_Response.HasAttachments
-- PH TFS 13-56707: v7 20/09/2016 - Add defensive code to capture SourceObjectID from update output
-- PH TFS 13-57025: v8 20/09/2016 - Make the previous version do what it should do.  Updates to OUPUT commands, did not include.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Attachment]
	@AttachmentID int = NULL,
	@AttachmentSourceID int,
	@SourceObjectID int,
	@AttachmentTitle nvarchar(255),
	@AttachmentFileName nvarchar(100),
	@Attachment image,
	@AttachmentURL nvarchar(255),
	@UserID int,
	@IsTemp bit = 0
AS

SET NOCOUNT ON;

-- remove (and empty out) old temp attachments
UPDATE QMS_Attachment 
SET RecordStatus = 201, Attachment = NULL, Updated = GETUTCDATE(), Deleted = GETUTCDATE()
WHERE AttachmentID IN (
	SELECT AttachmentID FROM (
		SELECT AttachmentID, DATALENGTH(Attachment) AS AttachmentLength
		FROM QMS_Attachment
		WHERE RecordStatus = 100						-- Only remove TEMP attachments
		AND Inserted < dateadd(hour, -24, getdate())	-- older than a day.
	) AS AttachmentTable
	WHERE AttachmentLength IS NOT NULL
)

DECLARE @update TABLE (AttachmentID int, AttachmentSourceID int, SourceObjectID int);

IF ISNULL(@AttachmentID,0)=0 --New record
BEGIN
	INSERT INTO QMS_Attachment	(AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, UserID, RecordStatus)
	OUTPUT
		INSERTED.AttachmentID,
		INSERTED.AttachmentSourceID,
		INSERTED.SourceObjectID
	INTO @update
	VALUES     (@AttachmentSourceID, @SourceObjectID, @AttachmentTitle, @AttachmentFileName, @Attachment, @AttachmentURL, @UserID, CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END);

	--Get new ID
	SELECT @AttachmentID = AttachmentID FROM @update;
END
ELSE --Update record
BEGIN
	UPDATE    QMS_Attachment
	SET         AttachmentTitle = @AttachmentTitle, 
				AttachmentFileName = @AttachmentFileName, 
				Attachment = @Attachment, 
				AttachmentURL = @AttachmentURL,
				RecordStatus = CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END,
				SourceObjectID = CASE WHEN SourceObjectID = 0 THEN @SourceObjectID ELSE SourceObjectID END, -- Only change from zero to good value, not backwards.
				UserID = @UserID, MachineName = HOST_NAME(), Updated = GETUTCDATE()
	OUTPUT
		INSERTED.AttachmentID,
		INSERTED.AttachmentSourceID,
		INSERTED.SourceObjectID
	INTO @update
	WHERE     (AttachmentID = @AttachmentID);
END

-- Update QMS_Response.HasAttachments
SELECT -- Re-assign parameters
	@AttachmentSourceID = AttachmentSourceID,
	@SourceObjectID = SourceObjectID
FROM @update

IF(@AttachmentSourceID = 1) -- Attachment source is a Response
BEGIN
	UPDATE QMS_Response
	SET
		HasAttachments = 1,
		Updated = GETUTCDATE()
	WHERE ResponseID = @SourceObjectID;
END

SET NOCOUNT OFF;

SELECT @AttachmentID as AttachmentID;

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_OfflineSpec_DownloadList')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_OfflineSpec_DownloadList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 26/09/2016
-- Description:	Update and download offline specifications.
-- Version: 	2
-- =============================================
-- JT TFS 13-56917: 26/09/2016 - Don't trigger the assessment for re-download unless the new state is active.
-- =============================================
ALTER PROCEDURE SYNC_OfflineSpec_DownloadList  
	@SpecStorageMode tinyint  
AS  
  
IF @SpecStorageMode = 1 OR @SpecStorageMode = 3 --Offline specs  
BEGIN  
	SET NOCOUNT ON  
	--Update assessments where assessment changed  
	UPDATE    SYNC_OfflineSpec  
	SET              Status = 20  
	FROM         SYNC_OfflineSpec 
	INNER JOIN  QMS_Assessment ON SYNC_OfflineSpec.AssessmentGUID = QMS_Assessment.GUID AND SYNC_OfflineSpec.LastUpdate < QMS_Assessment.Updated  
	INNER JOIN APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID
	WHERE	(SYNC_OfflineSpec.Status = 30) 
	AND		(SYNC_OfflineSpec.LastUpdate IS NOT NULL) 
	AND		(QMS_Assessment.RecordStatus < 201)  
	AND		(APP_AssessmentStatus.Active = 1)
  
	--Add new assessments  
	IF @SpecStorageMode = 1 -- add assessments included for selected stock codes  
		INSERT INTO SYNC_OfflineSpec  
			(AssessmentGUID, Status)  
		SELECT     DISTINCT QMS_Assessment.GUID, 2 AS NewStatus  
		FROM         QMS_Assessment 
		INNER JOIN  APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID 
		INNER JOIN  QMS_AssessmentTarget ON QMS_Assessment.AssessmentID = QMS_AssessmentTarget.AssessmentID 
		INNER JOIN  (	SELECT     PM_VW_StockCode.StockCodeID  
						FROM          SYNC_OfflineSpecStockCode 
						CROSS JOIN  PM_VW_StockCode  
						WHERE   (SYNC_OfflineSpecStockCode.RecordStatus < 201) 
						AND		(SYNC_OfflineSpecStockCode.StockCodeLevel = 0) 
						AND		(PM_VW_StockCode.BusinessGroup = SYNC_OfflineSpecStockCode.StockCodeGroup) 
						OR  
								(SYNC_OfflineSpecStockCode.RecordStatus < 201) 
						AND		(SYNC_OfflineSpecStockCode.StockCodeLevel = 1) 
						AND		(PM_VW_StockCode.StockCodeSubGroup = SYNC_OfflineSpecStockCode.StockCodeGroup) 
						OR  
								(SYNC_OfflineSpecStockCode.RecordStatus < 201) 
						AND		(SYNC_OfflineSpecStockCode.StockCodeLevel = 2) 
						AND		(PM_VW_StockCode.StockCodeID = SYNC_OfflineSpecStockCode.StockCodeID)
					) AS StockCode ON QMS_AssessmentTarget.SourceObjectID = StockCode.StockCodeID 
		LEFT OUTER JOIN	SYNC_OfflineSpec AS OfflineSpec ON QMS_Assessment.GUID = OfflineSpec.AssessmentGUID  
		WHERE   (OfflineSpec.AssessmentGUID IS NULL) 
		AND		(QMS_Assessment.AssessmentTypeID <> 1) 
		AND		(QMS_Assessment.RecordStatus < 201) 
		AND		(APP_AssessmentStatus.Active = 1) 
		AND		(QMS_AssessmentTarget.RecordStatus < 201) 
		AND		(QMS_Assessment.AssessmentTargetTypeID = 1)  
   
	ELSE -- add assessments which are included in AQC  
		INSERT INTO SYNC_OfflineSpec 
			(AssessmentGUID, Status)  
		SELECT DISTINCT assessment.GUID, 2 AS NewStatus  
		FROM	dbo.QMS_Assessment assessment
		INNER JOIN APP_AssessmentStatus ON assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID
		LEFT OUTER JOIN dbo.SYNC_OfflineSpec AS OfflineSpec ON assessment.GUID = OfflineSpec.AssessmentGUID  
		WHERE   (OfflineSpec.AssessmentGUID IS NULL) 
		AND		(assessment.RecordStatus < 201) 
		AND		(assessment.SyncServiceGUID IS NOT NULL)  
		AND		(APP_AssessmentStatus.Active = 1)
                                 
	SET NOCOUNT OFF  
END  
  
SELECT     QMS_Assessment.AssessmentID, SYNC_OfflineSpec.AssessmentGUID, SYNC_OfflineSpec.SpecReportFile, SYNC_OfflineSpec.LastUpdate,   
                      SYNC_OfflineSpec.Status  
FROM         SYNC_OfflineSpec INNER JOIN  
                      QMS_Assessment ON SYNC_OfflineSpec.AssessmentGUID = QMS_Assessment.GUID  
WHERE     (SYNC_OfflineSpec.Status < 30)  
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_Attachment_Delete')
	EXEC ('CREATE PROCEDURE [dbo].[UP_Attachment_Delete] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 01/09/2008
-- Description	: Deletes attachment
-- Version		: 3
-- =============================================
-- SF TFS 7843 Changed @UserID to be optional so it works with Entity Framework
-- PH TFS 13-56708: v3 20/09/2016 - If Response attachment, then check if all attachments removed, so that QMS_Response.HasAttachments can be updated.
-- =============================================
ALTER PROCEDURE [dbo].[UP_Attachment_Delete]
@AttachmentID int,
@UserID int = NULL
AS

UPDATE    QMS_Attachment
SET
	RecordStatus = 201,
	UserID = ISNULL(@UserID, UserID),
	MachineName = HOST_NAME(),
	Updated = GETUTCDATE(),
	Deleted = GETUTCDATE()
WHERE QMS_Attachment.AttachmentID = @AttachmentID;

-- Update QMS_Response.HasAttachments
DECLARE @attachmentSourceId int;
DECLARE @sourceObjectId int;

SELECT
	@attachmentSourceId = attachment.AttachmentSourceID,
	@sourceObjectId = attachment.SourceObjectID
FROM QMS_Attachment AS attachment

IF(@attachmentSourceId = 1) -- Attachment source is a Response
BEGIN
	IF NOT EXISTS
	(
		SELECT *
		FROM QMS_Attachment AS attachment
		WHERE
			attachment.AttachmentSourceID = 1
			AND attachment.SourceObjectID = @sourceObjectId
			AND attachment.RecordStatus < 201
	)
	BEGIN
		-- No more active attachments are related to the Response
		UPDATE QMS_Response
		SET
			HasAttachments = 0,
			Updated = GETUTCDATE()
		WHERE
			RecordStatus < 201
			AND ResponseID = @sourceObjectId;
	END
	ELSE
	BEGIN
		-- Defensive measure - HasAttachments may not have been set correctly previously, but required state has been determined here, so can fix.
		UPDATE QMS_Response
		SET
			HasAttachments = 1,
			Updated = GETUTCDATE()
		WHERE
			RecordStatus < 201
			AND ResponseID = @sourceObjectId;
	END
END


GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Response_HasAttachments')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Response_HasAttachments] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author            : MBS\Phil.Harding
-- Create date       : 20/09/2016
-- Description       : Sets HasAttachments flag on all responses that have been used.  This should be used when the HasAttachments column is added to APP_Responses. 
-- Version           : 1
-- =============================================
-- PH TFS 13-56714 : v1 20/09/2016 - Created
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Response_HasAttachments]
AS
BEGIN

UPDATE QMS_Response
SET
	QMS_Response.HasAttachments = 1,
	QMS_Response.Updated = GETUTCDATE()
FROM
(
	SELECT
		response.ResponseID
	FROM QMS_Response AS response
	INNER JOIN QMS_Attachment AS attachment
		ON attachment.AttachmentSourceID = 1 -- Attachment source is a Response
		AND attachment.SourceObjectID = response.ResponseID
		AND attachment.RecordStatus < 201
	WHERE
		response.RecordStatus < 201
	GROUP BY 
		response.ResponseID
) AS includedResponses
WHERE
	QMS_Response.ResponseID = includedResponses.ResponseID;

END
GO





PRINT 'Database updated successfully!'
GO
