-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_CorrectiveAction_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_List] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	20/5/2014
-- Description:	Lists all corrective actions for corrective action manager screen.
-- Version:		5
-- ===================================================
-- JT TFS 13-3845: Created
-- JT TFS 13-7000: Order by DateOccurred DESC, so that any truncations chop off old CAs first.
-- JT TFS 13-8870: Add source column.
-- JE TFS 13-12640: use new function to get corrective actions from QMS_CorrectiveActionUser
-- JT TFS 13-55914: 08/09/2016 - Performance: Inline reviewers function, prepopulate CAStatus, CAResponses and AssignUsers.
-- ===================================================
ALTER PROCEDURE dbo.QRY_CorrectiveAction_List
	@UserID int = 1,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@IsFilterApplied bit = 0
AS
BEGIN
	/* NOTE: Supplier and location filters work differently. All other filters are response filters. */

	-- NOTE: DateDeadline is the first sort order for completed.
	--       DateFailed is the first sort order for failed.
	--       DateCompleted is the first sort order for signed off.

	BEGIN -- setup temp tables 
		SET NOCOUNT ON 
		
		IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
		CREATE TABLE #tmpUserCAs (
			CorrectiveActionID int
		)
		
		IF @IsFilterApplied = 1
		BEGIN
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT CorrectiveActionID FROM TEMP_CorrectiveActionFilter
			WHERE UserID = @UserID
		
		END ELSE BEGIN
		
			--temp table containing all CAs (i.e. all statuses) user has permission to see
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	dbo.FNC_CorrectiveActionUser_CAList(@UserID)
			
		END

		--populate temp table with CA refs and their Reviewers' names (inline FNC_CorrectiveAction_ReviewList for all CAs)
		IF nullif(object_id('tempdb..#tmpCAReviewers'), 0) IS NOT NULL DROP TABLE #tmpCAReviewers
		CREATE TABLE #tmpCAReviewers (
			CorrectiveActionID int,
			Reviewers nvarchar(500)
		)
		INSERT INTO #tmpCAReviewers (CorrectiveActionID, Reviewers)
		SELECT outerquery.CorrectiveActionID, results = substring((
			SELECT DISTINCT ', ' + FullName
			FROM QMS_RecordLock 
			INNER JOIN QMS_User ON QMS_RecordLock.UserID = QMS_User.UserID
			WHERE	(ObjectName = N'QMS_CorrectiveAction') 
			AND		(LockStatus = 100)
			AND		(RowGUID = outerquery.GUID)
			FOR XML PATH(''), type
		).value('/', 'nvarchar(max)'), 3, 99999)
		FROM QMS_CorrectiveAction outerquery
		GROUP BY outerquery.CorrectiveActionID, outerquery.GUID
		
		-- Lookup responseIDs for all corrective actions.
		IF NULLIF(object_id('tempdb..#tmpCAResponses'), 0) IS NOT NULL DROP TABLE #tmpCAResponses;
		CREATE TABLE #tmpCAResponses (
			CorrectiveActionID int,
			ResponseID int
		)
		INSERT #tmpCAResponses (CorrectiveActionID, ResponseID)
		SELECT CorrectiveActionID, ResponseID FROM dbo.FNC_CorrectiveAction_Response()

		-- prepopulate status lookups.
		IF NULLIF(object_id('tempdb..#tmpCAStatus'), 0) IS NOT NULL DROP TABLE #tmpCAStatus;
		SELECT	APP_CorrectiveActionStatus.CAStatusID,
				ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS [Status],
				IsOutstanding = CASE WHEN APP_CorrectiveActionStatus.CAStatusID < 3 THEN 1 ELSE 0 END,
				IsCompleted = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 4 THEN 1 ELSE 0 END,
				IsFailed = CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (3,6,7) THEN 1 ELSE 0 END,
				IsSignedOff = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 5 THEN 1 ELSE 0 END,
				CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (1,2) THEN 'new'
					 WHEN APP_CorrectiveActionStatus.CAStatusID IN (4,5) THEN 'completed'
																		 ELSE 'failed' END AS [StatusClass]
		INTO #tmpCAStatus
		FROM APP_CorrectiveActionStatus;


		-- Prepopulate IsAssignedToMe list (for easier lookup)
		IF NULLIF(object_id('tempdb..#tmpCAAssignUsers'), 0) IS NOT NULL DROP TABLE #tmpCAAssignUsers;
		SELECT CorrectiveActionID, UserID
		INTO #tmpCAAssignUsers
		FROM dbo.FNC_CorrectiveAction_AssignUsers() AssignUser 
		WHERE AssignUser.UserID = @UserID

		SET NOCOUNT OFF
	END 

	SELECT 
			QMS_CorrectiveAction.CorrectiveActionID,
			dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) AS CARef,
			CAResponseList.ResponseID,
			QMS_CorrectiveAction.CATitle,
			QMS_CorrectiveAction.CASubTitle,
			QMS_CorrectiveAction.CAReason,
			QMS_CorrectiveAction.CARequired,
			QMS_CorrectiveAction.ActionTaken,
			QMS_CorrectiveAction.Comments,
			APP_CorrectiveActionStatus.[Status],
			APP_CorrectiveActionStatus.[StatusClass],
			APP_PriorityLevel.PriorityLevel,
			QMS_CorrectiveAction.DateOccurred,
			QMS_CorrectiveAction.DateLogged,
			QMS_CorrectiveAction.DateDeadline,
			QMS_CorrectiveActionType.CorrectiveActionType,
			QMS_CorrectiveActionEscalation.ListIndex AS [EscalationLevel],
			PM_VW_Location.LocationName AS Location,
			ISNULL(QMS_NotificationGroup.NotificationGroup, ISNULL(QMS_User_Assign.FullName, Supplier_Assign.SupplierName)) AS [AssignedTo],
			QMS_User_Logged.FullName AS [LoggedBy],
			QMS_CorrectiveAction.DateFailed,
			QMS_CorrectiveAction.DateCompleted,
			QMS_User_Completed.FullName AS [CompletedBy],
			CAReviewers.Reviewers AS [ReviewedBy],
			QMS_User_SignedOff.FullName AS [SignedOffBy],
			QMS_CorrectiveAction.DateSignedOff,
			QMS_CorrectiveAction.CAStatusID,

			CASE WHEN QMS_CorrectiveAction.CASourceID = 4 THEN N'Ad-Hoc'
					 WHEN QMS_CorrectiveAction.CASourceID = 3 THEN N'CA: ' + dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.SourceObjectID)
					 WHEN QMS_CorrectiveAction.CASourceID = 2 THEN 'Question'
					 WHEN QMS_CorrectiveAction.CASourceID = 1 THEN 'Check'
			END AS [Source],

			APP_CorrectiveActionStatus.IsOutstanding,
			IsLoggedByMe = CASE WHEN QMS_CorrectiveAction.Logged_UserID = @UserID THEN 1 ELSE 0 END,
			IsAssignedToMe = CASE WHEN EXISTS (	SELECT * FROM #tmpCAAssignUsers AssignUser 
												WHERE AssignUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
												AND AssignUser.UserID = @UserID) THEN 1 ELSE 0 END,
			APP_CorrectiveActionStatus.IsCompleted,
			APP_CorrectiveActionStatus.IsFailed,
			APP_CorrectiveActionStatus.IsSignedOff
		
	FROM QMS_CorrectiveAction
	INNER JOIN #tmpUserCAs AS UserCAList ON QMS_CorrectiveAction.CorrectiveActionID = UserCAList.CorrectiveActionID
	INNER JOIN #tmpCAReviewers AS CAReviewers ON UserCAList.CorrectiveActionID = CAReviewers.CorrectiveActionID
	INNER JOIN #tmpCAResponses AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
	INNER JOIN #tmpCAStatus AS APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	INNER JOIN QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID
	LEFT OUTER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
	LEFT OUTER JOIN QMS_CorrectiveActionType ON QMS_CorrectiveActionType.CorrectiveActionTypeID = QMS_CorrectiveAction.CorrectiveActionTypeID 
	LEFT OUTER JOIN QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID
	LEFT OUTER JOIN QMS_User AS QMS_User_SignedOff ON QMS_CorrectiveAction.SignOff_UserID = QMS_User_SignedOff.UserID
	LEFT OUTER JOIN APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
	LEFT OUTER JOIN PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
	LEFT OUTER JOIN PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID 
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR QMS_CorrectiveAction.DateOccurred > @DateFrom)
	AND (@DateTo IS NULL OR QMS_CorrectiveAction.DateOccurred <= @DateTo)
	ORDER BY	QMS_CorrectiveAction.DateOccurred DESC,
				QMS_CorrectiveAction.CorrectiveActionID DESC

	--get list of columns that need to be hidden in Excel export
	--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
	SELECT	1 AS TableIndex, convert(bit, 1) as ExportSetupTable, 'Portrait/Landscape' AS Orientation, 'n/a' AS SheetName, 'n/a' AS HiddenColumns
	UNION SELECT 0, 0, 'Landscape', 'Corrective Actions', 'CAStatusID,StatusClass,IsOutstanding,IsLoggedByMe,IsAssignedToMe,IsCompleted,IsFailed,IsSignedOff'
	ORDER BY TableIndex ASC

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_ResponseQuestion')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_ResponseQuestion] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets all question responses for response report
-- Version:		12
-- =============================================
-- MarkP: TFS bug 4233
-- Jeremyf: TFS 5058
-- JE TFS 5458/5459: added ListSamplesOnReport option col and SampleSummary col
-- JT TFS 4929: added ResponseQuestionID to output so that sub-report for images can be linked to it
-- JT TFS 6580 - Use new multi-sort function (for performance)
-- JT TFS 7010 - Show section headers when suppress blanks is true.
-- JT TFS 7920 - DataTypeID null or zero means header.
-- JE TFS 8717 - amended filter to show archived questions if they have a response against them
-- JT TFS 13-33004: 14/06/2016 - Treat empty strings as Blanks, rather than just NULL entries.
-- JT TFS 13-54521: 22/08/2016 - Include samples if supress blanks is enabled.
-- =============================================
ALTER PROCEDURE RPT_Response_ResponseQuestion
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0
AS

DECLARE @SupressBlanks bit
SET @SupressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0)

IF NULLIF(object_id('tempdb..#tmpAllAssesmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpAllAssesmentQuestions
SELECT question.AssessmentID, sort.AssessmentQuestionID, sort.SortIndex, sort.QuestionNumber
INTO #tmpAllAssesmentQuestions
FROM dbo.FNC_AssessmentQuestion_Sort_Multi(@UserID) sort -- This is the most expensive bit of code.
INNER JOIN QMS_AssessmentQuestion question ON sort.AssessmentQuestionID = question.AssessmentQuestionID 

IF NULLIF(object_id('tempdb..#tmpShownAssessmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpShownAssessmentQuestions
SELECT QMS_ResponseQuestion.ResponseID, assessment_questions.AssessmentQuestionID 
INTO #tmpShownAssessmentQuestions
FROM #tmpAllAssesmentQuestions assessment_questions
INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = assessment_questions.AssessmentQuestionID
INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
WHERE (
			(@SupressBlanks = 1 AND NULLIF(QMS_ResponseQuestion.Response_Text, '') IS NOT NULL)
	OR
			(@SupressBlanks = 0) 
)

IF (@SupressBlanks = 1)
BEGIN
-- Add headers for shown items if suppressing blanks.
	INSERT #tmpShownAssessmentQuestions (ResponseID, AssessmentQuestionID)
	SELECT DISTINCT shown.ResponseID, question_children.AssessmentQuestionID
	FROM (	SELECT	questions.AssessmentQuestionID, 
					(	SELECT '|' + convert(varchar(10), AssessmentQuestionID) 
						FROM #tmpAllAssesmentQuestions 
						WHERE QuestionNumber LIKE questions.QuestionNumber + '.%' 
						AND AssessmentID = questions.AssessmentID FOR XML PATH('')) + '|' Children
			FROM #tmpAllAssesmentQuestions questions) as question_children
	INNER JOIN #tmpShownAssessmentQuestions as shown ON question_children.Children like '%|' + convert(varchar(10), shown.AssessmentQuestionID) + '|%' 
	WHERE NOT EXISTS (SELECT * FROM #tmpShownAssessmentQuestions WHERE ResponseID = shown.ResponseID AND AssessmentQuestionID = question_children.AssessmentQuestionID)

-- Include any responses with samples in them.
	INSERT #tmpShownAssessmentQuestions (ResponseID, AssessmentQuestionID)
	SELECT QMS_ResponseQuestion.ResponseID, assessment_questions.AssessmentQuestionID 
	FROM #tmpAllAssesmentQuestions assessment_questions
	INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = assessment_questions.AssessmentQuestionID
	INNER JOIN QMS_ResponseQuestionSample ON QMS_ResponseQuestion.ResponseQuestionID = QMS_ResponseQuestionSample.ResponseQuestionID
	WHERE NOT EXISTS (	SELECT 1 FROM #tmpShownAssessmentQuestions 
						WHERE ResponseID = QMS_ResponseQuestion.ResponseID 
						AND AssessmentQuestionID = assessment_questions.AssessmentQuestionID);
END

SELECT     QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.QuestionNumber, QMS_QuestionPool.Question, APP_QuestionLevel.QuestionLevel, 
                      APP_QuestionLevel.ListIndex AS QuestionLevelSort, QMS_QuestionPool.Sys_Question, QMS_ResponseQuestion.Response_Text, 
                      QMS_ResponseQuestion.Response_Boolean, QMS_ResponseQuestion.Response_Date, QMS_ResponseQuestion.Response_Numeric, 
                      QMS_ResponseQuestion.Response_SourceID, ROUND(QMS_ResponseQuestion.Score, 1) AS Score, QMS_ResponseQuestion.Recommended_QAFlagID, 
                      QMS_ResponseQuestion.QuestionComments, CASE WHEN QMS_AssessmentQuestion.ResponseIsScore = 1 THEN ISNULL(QMS_ResponseQuestion.Score, 0) 
                      ELSE 0 END AS ResponseScore, @ShowCA AS ShowCA, CAST(CASE WHEN CorrectiveAction.ResponseQuestionID IS NULL THEN 0 ELSE 1 END AS bit) AS HasCA, 
                      CorrectiveAction.CorrectiveActionID, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
                      CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, @ShowGuidance AS ShowGuidance, 
                      CAST(CASE WHEN QMS_Guidance.GuidanceString IS NULL THEN CASE WHEN QMS_AssessmentQuestion.ShortGuidance IS NULL 
                      THEN 0 ELSE 1 END ELSE 1 END AS bit) AS HasGuidance, QMS_Guidance.GuidanceString, QMS_AssessmentQuestion.ShortGuidance, 
                      RedConstraints.Constraint_Score_Min AS LevelScoreMinRed, RedConstraints.Constraint_Score_Max AS LevelScoreMaxRed, 
                      RedConstraints.GuidanceString AS LevelGuidance, CAST(CASE WHEN RedConstraints.GuidanceString IS NULL THEN 0 ELSE 1 END AS bit) AS HasLevelGuidance, 
                      ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore, QMS_AssessmentQuestion.ScoreCalculationID, 
                      AmberConstraints.Constraint_Score_Min AS LevelScoreMinAmber, AmberConstraints.Constraint_Score_Max AS LevelScoreMaxAmber, 
                      QMS_AssessmentQuestion.HasSamples, QMS_AssessmentQuestion.SampleSummaryID, SampleSummary.MinSample, SampleSummary.MaxSample, 
                      SampleSummary.AvgSample, SampleSummary.NumSample, SampleSummary.SumSample, SampleSummary.SampleList, 
                      QMS_QuestionPool_Parent.Question AS ParentQuestion, APP_QAFlag.QAFlagBackColour, APP_QAFlag.QAFlagForeColour,
                      QMS_AssessmentQuestion.ListSamplesOnReport AS ShowSamples, APP_SampleSummary.SampleSummary,
		QMS_ResponseQuestion.ResponseQuestionID,
		IsSectionHeaderRow = convert(bit, CASE WHEN NULLIF(QMS_AssessmentQuestion.DataTypeID, 0) IS NULL THEN 1 ELSE 0 END)
FROM         (SELECT     QMS_CorrectiveAction.SourceObjectID AS ResponseQuestionID, QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CATitle, 
                                              QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 
            @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus, QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, 
                 QMS_CorrectiveAction.DateDeadline
         FROM          QMS_CorrectiveAction INNER JOIN
                                              APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID LEFT OUTER JOIN
                                              APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID LEFT OUTER JOIN
                                              QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
                       WHERE      (QMS_CorrectiveAction.CASourceID = 2) AND (QMS_CorrectiveAction.RecordStatus < 201)) AS CorrectiveAction RIGHT OUTER JOIN
                      dbo.FNC_ResponseQuestion_SampleSummary(@UserID) AS SampleSummary RIGHT OUTER JOIN
                      QMS_ResponseQuestion INNER JOIN
                      QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
                      TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID INNER JOIN
                      #tmpAllAssesmentQuestions AS AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                      APP_QAFlag ON QMS_ResponseQuestion.Recommended_QAFlagID = APP_QAFlag.QAFlagID ON 
                SampleSummary.ResponseQuestionID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
                      QMS_AssessmentQuestion AS QMS_AssessmentQuestion_Parent ON 
                      QMS_AssessmentQuestion.ParentQuestionID = QMS_AssessmentQuestion_Parent.AssessmentQuestionID LEFT OUTER JOIN
                          (SELECT     QMS_AssessmentConstraint_1.AssessmentID, APP_AssessmentConstraintType_1.QuestionLevelID, 
                                                   MIN(QMS_AssessmentConstraint_1.Constraint_Score_Min) AS Constraint_Score_Min, MAX(QMS_AssessmentConstraint_1.Constraint_Score_Max) 
                                                   AS Constraint_Score_Max
                            FROM          APP_AssessmentConstraintType AS APP_AssessmentConstraintType_1 INNER JOIN
                                                   QMS_AssessmentConstraint AS QMS_AssessmentConstraint_1 ON 
                                                   APP_AssessmentConstraintType_1.AssessmentConstraintTypeID = QMS_AssessmentConstraint_1.AssessmentConstraintTypeID
                            WHERE      (QMS_AssessmentConstraint_1.RecordStatus < 201) AND (QMS_AssessmentConstraint_1.QAFlagID = 2)
                            GROUP BY APP_AssessmentConstraintType_1.QuestionLevelID, QMS_AssessmentConstraint_1.AssessmentID) AS AmberConstraints ON 
                      QMS_AssessmentQuestion.AssessmentID = AmberConstraints.AssessmentID AND 
                      QMS_AssessmentQuestion.QuestionLevelID = AmberConstraints.QuestionLevelID LEFT OUTER JOIN
                      APP_QuestionLevel ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID LEFT OUTER JOIN
                          (SELECT     QMS_AssessmentConstraint.AssessmentID, APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, 
                                                   APP_QuestionLevel_1.ListIndex, MIN(QMS_AssessmentConstraint.Constraint_Score_Min) AS Constraint_Score_Min, 
                                                   MAX(QMS_AssessmentConstraint.Constraint_Score_Max) AS Constraint_Score_Max, QMS_Guidance_1.GuidanceString
  FROM          APP_QuestionLevel AS APP_QuestionLevel_1 INNER JOIN
                                                   APP_AssessmentConstraintType ON APP_QuestionLevel_1.QuestionLevelID = APP_AssessmentConstraintType.QuestionLevelID INNER JOIN
                                                   QMS_AssessmentConstraint ON 
                  APP_AssessmentConstraintType.AssessmentConstraintTypeID = QMS_AssessmentConstraint.AssessmentConstraintTypeID LEFT OUTER JOIN
                                                   QMS_Guidance AS QMS_Guidance_1 ON QMS_AssessmentConstraint.GuidanceID = QMS_Guidance_1.GuidanceID
                            WHERE      (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.QAFlagID = 3)
                            GROUP BY APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, APP_QuestionLevel_1.ListIndex, 
                                                   QMS_AssessmentConstraint.AssessmentID, QMS_Guidance_1.GuidanceString) AS RedConstraints ON 
                      QMS_AssessmentQuestion.QuestionLevelID = RedConstraints.QuestionLevelID AND 
                      QMS_AssessmentQuestion.AssessmentID = RedConstraints.AssessmentID LEFT OUTER JOIN
                      QMS_Guidance ON QMS_AssessmentQuestion.GuidanceID = QMS_Guidance.GuidanceID ON 
                      CorrectiveAction.ResponseQuestionID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
                      QMS_QuestionPool AS QMS_QuestionPool_Parent ON QMS_AssessmentQuestion_Parent.QuestionID = QMS_QuestionPool_Parent.QuestionID LEFT OUTER JOIN
                      APP_SampleSummary ON QMS_AssessmentQuestion.SampleSummaryID = APP_SampleSummary.SampleSummaryID
WHERE	(TEMP_Selected.UserID = @UserID) 
AND		(QMS_ResponseQuestion.RecordStatus < 201)
AND		((QMS_AssessmentQuestion.RecordStatus = 202 AND QMS_ResponseQuestion.Response_Text IS NOT NULL) --show archived questions if they have a Response against them
			OR
		 (QMS_AssessmentQuestion.RecordStatus < 201))
AND		(QMS_AssessmentQuestion.HideFromReports = 0)
AND		EXISTS (SELECT * FROM #tmpShownAssessmentQuestions WHERE ResponseID = QMS_ResponseQuestion.ResponseID AND AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID)
ORDER BY QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.SortIndex
GO




PRINT 'Database updated successfully!'
GO
