-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'QMS_DeploymentErrorLog')
	CREATE TABLE [dbo].[QMS_DeploymentErrorLog](
		[DeploymentErrorLogId] [int] IDENTITY(1,1) NOT NULL,
		[ScriptName] [nvarchar](255) NOT NULL,
		[UserName] [nvarchar](255) NOT NULL CONSTRAINT [DF_QMS_DeploymentErrorLog_UserName]  DEFAULT (N''),
		[DeploymentDate] [datetime] NOT NULL CONSTRAINT [DF_QMS_DeploymentErrorLog_DeploymentDate]  DEFAULT (getutcdate()),
		[ObjectName] [nvarchar](255) NOT NULL,
		[ErrorMessage] [nvarchar](4000) NULL,
		
		CONSTRAINT [PK_QMS_DeploymentErrorLog] PRIMARY KEY CLUSTERED 	([DeploymentErrorLogId] ASC)
	)


IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'QMS_DeploymentRecord')
	CREATE TABLE [dbo].[QMS_DeploymentRecord](
		[DeploymentRecordID] [int] IDENTITY(1,1) NOT NULL,
		[ScriptType] [int] NOT NULL,
		[ScriptName] [nvarchar](255) NOT NULL,
		[UserName] [nvarchar](255) NOT NULL CONSTRAINT [DF_QMS_DeploymentRecord_UserName]  DEFAULT (N''),
		[DeploymentDate] [datetime] NOT NULL CONSTRAINT [DF_QMS_DeploymentRecord_DeploymentDate]  DEFAULT (getutcdate()),
		[DeploymentErrorCount] [int] NOT NULL CONSTRAINT [DF_QMS_DeploymentRecord_DeploymentErrorCount]  DEFAULT ((0)),
		[RowVersion] [timestamp] NOT NULL,
		
		CONSTRAINT [PK_QMS_DeploymentRecord] PRIMARY KEY CLUSTERED (	[DeploymentRecordID] ASC)
	)

GO

PRINT 'Database updated successfully!'
GO
