-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


-- BEGIN DATA Rationale QMS_Assessment 48399
BEGIN TRY
IF NOT EXISTS (	SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_Assessment' AND c.name = 'RationaleForExistence')
BEGIN 
	ALTER TABLE QMS_Assessment 
		ADD RationaleForExistence nvarchar(500) NULL;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Rationale QMS_Assessment 48399', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Rationale QMS_Assessment 48399


-- BEGIN DATA Add_Column_APP_AssessmentType_IsWebChecksEnabled_49596
BEGIN TRY
-- Add_Column_APP_AssessmentType_HasBeenUsed_49596
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='APP_AssessmentType' and COLUMN_NAME='IsWebChecksEnabled')
BEGIN
	ALTER TABLE dbo.APP_AssessmentType
		ADD IsWebChecksEnabled bit NOT NULL DEFAULT 0;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Column_APP_AssessmentType_HasBeenUsed_49596', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add_Column_APP_AssessmentType_HasBeenUsed_49596


-- BEGIN DATA Update_APP_AssessmentType_HasBeenUsed_49596
BEGIN TRY
-- Update_APP_AssessmentType_HasBeenUsed_49596
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='APP_AssessmentType' and COLUMN_NAME='HasBeenUsed')
BEGIN
	ALTER TABLE dbo.APP_AssessmentType
		ADD HasBeenUsed bit NOT NULL DEFAULT 0;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Update_APP_AssessmentType_HasBeenUsed_49596', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Update_APP_AssessmentType_HasBeenUsed_49596


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Specification_ConstraintGuidance')
	EXEC('CREATE FUNCTION [dbo].[FNC_Specification_ConstraintGuidance]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/05/2010
-- Description:	Gets guidance images for assessment constraints
-- Version:		6
-- =============================================
-- JE TFS 6012 - added lookup of images from master spec to display for temp specs
-- JE TFS 6582 - updated so that if a question's guidance contains master and temp attachments, only show temp for that question
-- JE TFS 6582 - (comment by JT + incremented version number) Updated cursor so it returns same columns regardless of path.
-- JE TFS 6727 - altered TempFlag sub-query to use COUNT rather than IS NULL so multiple attachments to one question handled correctly
--					and ensured sub-query is only counting Temp Spec attachments.
-- JT TFS 13-47832: 27/06/2016 - Put cursor results in a table and get the results from the table, rather than swapping the cursor definition
-- =============================================
ALTER FUNCTION dbo.FNC_Specification_ConstraintGuidance 
(
	@AssessmentID int
)
RETURNS @Table_Guidance TABLE 
(
	AssessmentQuestionID int,
	IndexNo tinyint,
	GreenTemp bit,
	Green_AttachmentID int,
	AmberTemp bit,
	Amber_AttachmentID int,
	RedTemp bit,
	Red_AttachmentID int
)
AS
BEGIN

--uncomment for debugging
--declare @AssessmentID int
--set @AssessmentID = 59084 --58604
--declare @Table_Guidance TABLE 
--(
--	AssessmentQuestionID int,
--	IndexNo tinyint,
--	GreenTemp bit,
--	Green_AttachmentID int,
--	AmberTemp bit,
--	Amber_AttachmentID int,
--	RedTemp bit,
--	Red_AttachmentID int
--)
	
	DECLARE @AQ TABLE (
		AssessmentID int,
		AssessmentQuestionID int,
		Sys_AssessmentQuestionID int
	)
	INSERT @AQ (AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID)
	SELECT @AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID 
	FROM QMS_AssessmentQuestion
	WHERE AssessmentID = @AssessmentID
	AND RecordStatus < 201


	DECLARE @Guidance TABLE (
		AssessmentQuestionID int,
		QAFlagID int,
		GreenTempFlag int,
		GreenTitle int,
		AmberTempFlag int,
		AmberTitle int,
		RedTempFlag int,
		RedTitle int
	)

	--get master AssessmentID for @AssessmentID if @AssessmentID is a temp spec
	DECLARE @MasterAssessmentID as int

	SELECT	@MasterAssessmentID = MAX(QMS_Assessment_Master.AssessmentID)
	FROM	QMS_Assessment AS QMS_Assessment_Master 
	INNER JOIN	QMS_Assessment AS QMS_Assessment_Temp ON QMS_Assessment_Master.Sys_AssessmentID = QMS_Assessment_Temp.Sys_AssessmentID
	WHERE	(QMS_Assessment_Master.TempSpec = 0) AND (QMS_Assessment_Master.AssessmentStatusID = 3) AND
				(QMS_Assessment_Temp.AssessmentID = @AssessmentID) AND (QMS_Assessment_Temp.TempSpec = 1)

	DECLARE @MasterAQ TABLE (
		AssessmentID int,
		AssessmentQuestionID int,
		Sys_AssessmentQuestionID int
	)
	INSERT @MasterAQ (AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID)
	SELECT @MasterAssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID 
	FROM QMS_AssessmentQuestion
	WHERE AssessmentID = @MasterAssessmentID
	AND RecordStatus < 201


	DECLARE @fldAssessmentQuestionID int, @fldQAFlagID int, @fldGreenTempFlag bit, @fldGreenAttachmentID int, @fldAmberTempFlag bit,
				@fldAmberAttachmentID int, @fldRedTempFlag bit, @fldRedAttachmentID int

	IF @MasterAssessmentID IS NULL --don't need to look up Guidance for temp spec
		INSERT @Guidance (AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle)
		SELECT  QMS_AssessmentQuestionConstraint.AssessmentQuestionID, 
				QMS_AssessmentQuestionConstraint.QAFlagID, 
						  0 AS GreenTempFlag,
						  CASE WHEN QAFlagID = 1 THEN QMS_Attachment.AttachmentID ELSE NULL END AS GreenTitle, 
						  0 AS AmberTempFlag,
						  CASE WHEN QAFlagID = 2 THEN QMS_Attachment.AttachmentID ELSE NULL END AS AmberTitle, 
						  0 AS RedTempFlag,
						  CASE WHEN QAFlagID = 3 THEN QMS_Attachment.AttachmentID ELSE NULL END AS RedTitle
		FROM         QMS_Guidance AS Constraint_GuidanceAttachment 
		INNER JOIN	QMS_AssessmentQuestionConstraint ON Constraint_GuidanceAttachment.GuidanceID = QMS_AssessmentQuestionConstraint.GuidanceID 
		INNER JOIN	QMS_Attachment ON Constraint_GuidanceAttachment.GuidanceID = QMS_Attachment.SourceObjectID 
		INNER JOIN	@AQ as QMS_AssessmentQuestion ON QMS_AssessmentQuestionConstraint.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
		WHERE   (QMS_AssessmentQuestionConstraint.RecordStatus < 201) 
		AND		(QMS_Attachment.AttachmentSourceID = 3) 
		AND		(QMS_AssessmentQuestion.AssessmentID = @AssessmentID) 
		AND		(QMS_Attachment.RecordStatus < 201) 
		AND		(Constraint_GuidanceAttachment.RecordStatus < 201)
	
	ELSE --look up Guidance for temp spec from master
		INSERT @Guidance (AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle)
		SELECT Attachments.AssessmentQuestionID, Attachments.QAFlagID,
				CASE WHEN Attachments.QAFlagID = 1 THEN TempSpec_Attachment ELSE NULL END AS GreenTempFlag, --set flag to say if a Green Temp attachment is present or not
				CASE WHEN Attachments.QAFlagID = 1 THEN AttachmentID ELSE NULL END AS GreenTitle,
				CASE WHEN Attachments.QAFlagID = 2 THEN TempSpec_Attachment ELSE NULL END AS AmberTempFlag,
				CASE WHEN Attachments.QAFlagID = 2 THEN AttachmentID ELSE NULL END AS AmberTitle,
				CASE WHEN Attachments.QAFlagID = 3 THEN TempSpec_Attachment ELSE NULL END AS RedTempFlag,
				CASE WHEN Attachments.QAFlagID = 3 THEN AttachmentID ELSE NULL END AS RedTitle
		FROM (SELECT QMS_AssessmentQuestion_Master.Sys_AssessmentQuestionID AS AssessmentQuestionID, --use Sys_AssessmentQuestionID as this will be the same for master and temp assessments
						QMS_AssessmentQuestionConstraint_Master.QAFlagID, MasterAttachments.AttachmentID, 0 AS TempSpec_Attachment
				FROM	QMS_AssessmentQuestionConstraint AS QMS_AssessmentQuestionConstraint_Master
							INNER JOIN @MasterAQ AS QMS_AssessmentQuestion_Master
								ON QMS_AssessmentQuestionConstraint_Master.AssessmentQuestionID = QMS_AssessmentQuestion_Master.AssessmentQuestionID
							LEFT OUTER JOIN	QMS_Attachment AS MasterAttachments ON QMS_AssessmentQuestionConstraint_Master.GuidanceID = MasterAttachments.SourceObjectID
				WHERE	(QMS_AssessmentQuestionConstraint_Master.RecordStatus < 201)
							AND (MasterAttachments.AttachmentSourceID = 3)
							AND (QMS_AssessmentQuestion_Master.AssessmentID = @MasterAssessmentID)
							AND (MasterAttachments.RecordStatus < 201)
				UNION --two separate queries - one for master attachments, one for temp spec attachments
			  SELECT QMS_AssessmentQuestion_Temp.Sys_AssessmentQuestionID AS AssessmentQuestionID,
						QMS_AssessmentQuestionConstraint_Temp.QAFlagID,	TempAttachments.AttachmentID, 1 AS TempSpec_Attachment
				FROM	QMS_AssessmentQuestionConstraint AS QMS_AssessmentQuestionConstraint_Temp
							INNER JOIN @AQ AS QMS_AssessmentQuestion_Temp
								ON QMS_AssessmentQuestionConstraint_Temp.AssessmentQuestionID = QMS_AssessmentQuestion_Temp.AssessmentQuestionID
							LEFT OUTER JOIN	QMS_Attachment AS TempAttachments ON QMS_AssessmentQuestionConstraint_Temp.GuidanceID = TempAttachments.SourceObjectID
				WHERE	(QMS_AssessmentQuestionConstraint_Temp.RecordStatus < 201)
							AND (TempAttachments.AttachmentSourceID = 3)
							AND (QMS_AssessmentQuestion_Temp.AssessmentID = @AssessmentID)
							AND (TempAttachments.RecordStatus < 201)) AS Attachments
				ORDER BY GreenTempFlag DESC, AmberTempFlag DESC, RedTempFlag DESC


	DECLARE Guidance_cursor CURSOR FAST_FORWARD FOR 
	SELECT AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle FROM @Guidance;

	OPEN Guidance_cursor
	FETCH NEXT FROM Guidance_cursor INTO @fldAssessmentQuestionID, @fldQAFlagID, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag,
											@fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID
	WHILE @@FETCH_STATUS = 0
	BEGIN 
		IF EXISTS(SELECT AssessmentQuestionID FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID))
		BEGIN
			DECLARE @UpdateIndex tinyint, @MaxIndex tinyint
			SELECT @MaxIndex = ISNULL(MAX(IndexNo),0) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID)
			IF @fldQAFlagID = 1 --Green
			BEGIN
				IF @fldGreenTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Green_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldGreenTempFlag, @fldGreenAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET GreenTemp = @fldGreenTempFlag, Green_AttachmentID = @fldGreenAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp green attachment has already been inserted for this question, insert master attachments
				IF @fldGreenTempFlag = 0 AND (SELECT COUNT(Green_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND GreenTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Green_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldGreenTempFlag, @fldGreenAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET GreenTemp = @fldGreenTempFlag, Green_AttachmentID = @fldGreenAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END
			END
			IF @fldQAFlagID = 2 --Amber
			BEGIN
				IF @fldAmberTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Amber_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, AmberTemp, Amber_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldAmberTempFlag, @fldAmberAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET AmberTemp = @fldAmberTempFlag, Amber_AttachmentID = @fldAmberAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp amber attachment has already been inserted for this question, insert master attachments
				IF @fldAmberTempFlag = 0 AND (SELECT COUNT(Amber_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND AmberTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Amber_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, AmberTemp, Amber_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldAmberTempFlag, @fldAmberAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET AmberTemp = @fldAmberTempFlag, Amber_AttachmentID = @fldAmberAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END				
			END
			IF @fldQAFlagID = 3 --Red
			BEGIN
				IF @fldRedTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Red_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, RedTemp, Red_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldRedTempFlag, @fldRedAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET RedTemp = @fldRedTempFlag, Red_AttachmentID = @fldRedAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp red attachment has already been inserted for this question, insert master attachments
				IF @fldRedTempFlag = 0 AND (SELECT COUNT(Red_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND RedTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Red_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, RedTemp, Red_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldRedTempFlag, @fldRedAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET RedTemp = @fldRedTempFlag, Red_AttachmentID = @fldRedAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END	
			END
		END
		ELSE
			INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID, AmberTemp, Amber_AttachmentID, RedTemp, Red_AttachmentID)
			VALUES (@fldAssessmentQuestionID, 1, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag, @fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID)

		FETCH NEXT FROM Guidance_cursor INTO @fldAssessmentQuestionID, @fldQAFlagID, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag,
												@fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID
	END

	CLOSE Guidance_cursor
	DEALLOCATE Guidance_cursor

	RETURN
END
GO

-- BEGIN DATA Rationale QMS_Assessment 48399
BEGIN TRY
IF NOT EXISTS (	SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_Assessment' AND c.name = 'RationaleForExistence')
BEGIN 
	ALTER TABLE QMS_Assessment 
		ADD RationaleForExistence nvarchar(500) NULL;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Rationale QMS_Assessment 48399', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Rationale QMS_Assessment 48399

PRINT 'Database updated successfully!'
GO
