-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_Response_Quantity')
	EXEC ('CREATE PROCEDURE [dbo].[UP_Response_Quantity] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 26/08/2009
-- Description:	Updates assessment response quantities
-- Version:	2
-- =============================================
-- jf TFS 46249 - make sure the generic version is deployed in sprint80 as Coles have a customised version which needs to be overwritten 
-- =============================================
ALTER PROCEDURE [dbo].[UP_Response_Quantity] 
	@ResponseID int,
	@QuantityReceived int,
	@QuantityChecked int,
	@QuantityAccepted int,
	@QuantityRejected int,
	@QuantityReplaced int = NULL
AS

UPDATE    QMS_Response
SET              QuantityReceived = @QuantityReceived, QuantityChecked = @QuantityChecked, QuantityAccepted = @QuantityAccepted, 
                      QuantityRejected = @QuantityRejected, QuantityReplaced = @QuantityReplaced, Updated = GETUTCDATE()
WHERE     (ResponseID = @ResponseID)



GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		6
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - add itemstatus
-- PH TFS 13-46056 : v4 16/05/2016 - Added @DateRequiredAsText and @DepotDateAsText to work around unwanted XML UTC offset conversions.  As prescribed by Mark Powell.
-- PH TFS 13-46056 : v5 16/05/2016 - Reformatted code to make more understandable and inserted semi-colons to make forward compatible added dbo schema prefix.
-- PH TFS 13-46056 : v6 25/05/2016 - Fixed the Markleville and WaterFord Township (48327) bugs by specifying all nvarchar lengths on new parameters.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@DepotDateAsText nvarchar(50) = NULL,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@DateRequiredAsText nvarchar(50) = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@ItemStatus INT,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @DepotDateAsText IS NOT NULL
	SET @DepotDate = @DepotDateAsText;
ELSE
	SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate);

IF @DateRequiredAsText IS NOT NULL
	SET @DateRequired = @DateRequiredAsText;
ELSE
	SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired);

IF @Hide  IS NULL
	SET @Hide = 0;

IF NOT EXISTS(SELECT * FROM dbo.PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM dbo.PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO dbo.PM_ConsignmentItems
        (
			ConsignmentItemID,
			ConsignmentID,
			StockCodeID,
			Quantity,
			UnitStockCodeID,
			UnitQuantity,
			QuantityAccepted,
			DepotDate,
			UnitPrice,
			Comments,
			DateRequired,
			E_POItem,
			Hide,
			RecordStatus,
			GUID,
			VersionNo,
			ItemStatus
		)
		VALUES
		(
			@ConsignmentItemID,
			@ConsignmentID,
			@StockCodeID,
			@Quantity,
			@UnitStockCodeID,
			@UnitQuantity,
			@QuantityAccepted,
			@DepotDate,
			@UnitPrice,
			@Comments,
			@DateRequired,
			@E_POItem,
			@Hide,
			@RecordStatus,
			@GUID,
			@VersionNo,
			@ItemStatus
		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE	dbo.PM_ConsignmentItems
	SET
		StockCodeID = @StockCodeID,
		Quantity = @Quantity,
		UnitStockCodeID = @UnitStockCodeID,
		UnitQuantity = @UnitQuantity,
		QuantityAccepted = @QuantityAccepted,
		DepotDate = @DepotDate,
		UnitPrice = @UnitPrice,
		Comments = @Comments,
		DateRequired = @DateRequired,
		E_POItem = @E_POItem,
		Hide = @Hide,
		RecordStatus = @RecordStatus,
		VersionNo=@VersionNo,
		ItemStatus=@ItemStatus
	WHERE	ConsignmentItemID = @ConsignmentItemID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Consignment')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Consignment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		5
-- =============================================
-- jf TFS 18595 added text1 and text2 to the import
--jf tfs 22919 added text 3,4 and countrycode
-- PH TFS 13-46056 : v3 16/05/2016 - Added DateRequiredAsText and OrderDateAsText to work around unwanted XML UTC offset conversions.  As prescribed by Mark Powell.
-- PH TFS 13-46056 : v4 16/05/2016 - Reformatted code to make more understandable and inserted semi-colons to make forward compatible added dbo schema prefix.
-- PH TFS 13-46056 : v5 25/05/2016 - Fixed the Markleville and WaterFord Township (48327) bugs by specifying all nvarchar lengths on new parameters.
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_Consignment] 
	@ConsignmentID int,
	@SupplierID int,
	@OrderRef nvarchar(50),
	@OrderDate datetime,
	@OrderDateAsText nvarchar(50) = NULL,
	@DateRequired datetime,
	@DateRequiredText nvarchar(50) = NULL,
	@E_PO nvarchar(50),
	@LocationID int,
	@OrderStatus int,
	@WatchList nvarchar(1),
	@E_POType NVARCHAR(10) = NULL,
	@Comments NVARCHAR(1000) = NULL,
	@CustomerID INT = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Text1  nvarchar(100),
	@Text2 nvarchar(100),
	@Text3 nvarchar(100),
	@Text4 nvarchar(100),
	@CountryCode nvarchar(100),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS
IF @OrderDateAsText IS NOT NULL
	SET @OrderDate = @OrderDateAsText;
ELSE
	SET @OrderDate = dbo.FNC_ConvertServerDate(@OrderDate);

IF @DateRequiredText IS NOT NULL
	SET @DateRequired = @DateRequiredText;
ELSE
	SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired);

IF @Hide IS NULL
	SET @Hide=0

IF NOT EXISTS(SELECT * FROM dbo.PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT SupplierID FROM dbo.PM_Supplier WHERE (SupplierID = @SupplierID) OR @SupplierID IS NULL)
	BEGIN
		INSERT INTO dbo.PM_Consignment
		(
			ConsignmentID,
			SupplierID,
			OrderRef,
			OrderDate,
			DateRequired,
			E_PO,
			LocationID,
			OrderStatus,
			WatchList,
			E_POType,
			Comments,
			CustomerID,
			Hide,
			RecordStatus,
			GUID,
			Text1,
			Text2,
			Text3,
			Text4,
			CountryCode
		)
		VALUES
		(
			@ConsignmentID,
			@SupplierID,
			@OrderRef,
			@OrderDate,
			@DateRequired,
			@E_PO,
			@LocationID,
			@OrderStatus,
			@WatchList,
			@E_POType,
			@Comments,
			@CustomerID,
			@Hide,
			@RecordStatus,
			@GUID,
			@Text1,
			@Text2,
			@Text3,
			@Text4,
			@CountryCode
		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE	dbo.PM_Consignment
	SET
		SupplierID = @SupplierID,
		OrderRef = @OrderRef,
		OrderDate = @OrderDate,
		DateRequired = @DateRequired,
		E_PO = @E_PO,
		LocationID = @LocationID,
		OrderStatus = @OrderStatus,
		WatchList = @WatchList,
		E_POType = @E_POType,
		Comments = @Comments,
		CustomerID = @CustomerID,
		Hide = @Hide,
		RecordStatus = @RecordStatus,
		Text1 = @Text1,
		Text2 = @Text2,
		Text3 = @Text3,
		Text4 = @Text4,
		CountryCode = @CountryCode
	WHERE	ConsignmentID = @ConsignmentID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_ResponseAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_ResponseAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 18/11/2008
-- Description:	Saves QA action record
-- Version:		3
-- =============================================
-- JF TFS 6372 - add new notification columns
-- jf TFS 46249 - make sure the generic version is deployed in sprint80 as Coles have a customised version which needs to be overwritten 
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_ResponseAction] 
	@ResponseID int,
	@QAActionID int,
	@Comments nvarchar(1000),
	@Action_QAFlagID int,
	@QAActionReasonID int = NULL,
	@UserID int,
	@NotificationGroupID INT = NULL,
	@NotifySupplier BIT = NULL,
	@NotifyAssessor BIT = NULL
	
AS

SET NOCOUNT ON

IF @NotifySupplier IS NULL
	SET @NotifySupplier = 0
	
IF @NotifyAssessor IS NULL
	SET @NotifyAssessor = 0

IF ISNULL(@Action_QAFlagID,0)=0
	SET @Action_QAFlagID=NULL
ELSE
	UPDATE    QMS_Response
	SET              Override_QAFlagID = @Action_QAFlagID, Updated = GETUTCDATE()
	WHERE     (ResponseID = @ResponseID)
	
--Update response RecordStatus if already exported
UPDATE    QMS_Response
SET              RecordStatus = 20
WHERE     (ResponseID = @ResponseID) AND (RecordStatus = 30)

DECLARE @id TABLE (id int);

--Append action record
INSERT INTO QMS_ResponseAction
		(ResponseID, QAActionID, ActionDate, Comments, Action_QAFlagID, UserID, QAActionReasonID,NotificationGroupID,NotifySupplier,NotifyAssessor)
OUTPUT INSERTED.ResponseID INTO @id(id)
VALUES	(@ResponseID, @QAActionID, dbo.FNC_GetDate(), @Comments, @Action_QAFlagID, @UserID, @QAActionReasonID, @NotificationGroupID, @NotifySupplier, @NotifyAssessor)

--Get new ID
DECLARE @ResponseActionID int
SELECT     @ResponseActionID = MAX(id)
FROM         @id;


SET NOCOUNT OFF

SELECT @ResponseActionID
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Client')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Client] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 05/05/2016
-- Description	: Saves client info
-- Version		: 3
-- =============================================
-- PH TFS 13-46856 : Created
-- PH TFS 13-46988 : Added Application parameter
-- PH TFS 13-46988 : Application parameter changed to nvarchar
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Client]
	@ClientID int = NULL,
	@ClientGuid uniqueidentifier = NULL,
	@MachineName nvarchar(50) = NULL,
	@Inserted datetime = NULL,
	@LastSync datetime = NULL,
	@ClientType tinyint = NULL,
	@Enabled bit,
	@UserID int = NULL,
	@Application nvarchar(255) = NULL
AS

BEGIN
	SET NOCOUNT ON

	DECLARE @idTable TABLE
	(
		ClientID int NOT NULL
	);

	IF ISNULL(@ClientID, 0) = 0 --New record
		BEGIN
			INSERT INTO SYNC_Client
			(
				ClientGuid,
				MachineName,
				Inserted,
				LastSync,
				ClientType,
				Enabled,
				UserID,
				Application
			)
			OUTPUT INSERTED.ClientID INTO @idTable
			VALUES    
			(
				NEWID(),
				@MachineName,
				GETUTCDATE(),
				NULL,
				@ClientType,
				@Enabled,
				@UserID,
				@Application
			)
			--Get new ID
			SELECT  @ClientID = ClientID FROM @idTable;

		END
	ELSE --Update record
		UPDATE    SYNC_Client
		SET
			MachineName = @MachineName,
			LastSync = @LastSync,
			ClientType = @ClientType,
			Enabled = @Enabled,
			UserID = @UserID,
			Application = @Application
		WHERE	ClientID = @ClientID;

	SET NOCOUNT OFF;

	RETURN @ClientID;

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_DimTime_PeriodCombo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_DimTime_PeriodCombo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 14/02/2011
-- Description	: Gets list of reporting periods
-- Version		: 3
-- =============================================
-- PH TFS 13-47962 : v2 19/05/2016 - Add optional parameter to return period end dates
-- PH TFS 13-47962 : v2 19/05/2016 - Rename return columns
-- =============================================
ALTER PROCEDURE [dbo].[QRY_DimTime_PeriodCombo] 
(
	@AsEndDates bit = 0
)
AS
BEGIN
	IF(@AsEndDates = 0)
		SELECT
			MIN(PK_Date) AS Period_Date, -- Key
			CAST(Period_No AS nvarchar) + N' (' + CONVERT(nvarchar, Period_Year, 103) + N')' AS Period_Text -- DisplayText
		FROM         APP_DimTime
		WHERE     (Period_No IS NOT NULL) AND (Period_Year IS NOT NULL)
		GROUP BY CAST(Period_No AS nvarchar) + N' (' + CONVERT(nvarchar, Period_Year, 103) + N')'
		ORDER BY Period_Date;
	ELSE
		SELECT
			MAX(PK_Date) AS Period_Date, -- Key
			CAST(Period_No AS nvarchar) + N' (' + CONVERT(nvarchar, Period_Year, 103) + N')' AS Period_Text -- DisplayText
		FROM         APP_DimTime
		WHERE     (Period_No IS NOT NULL) AND (Period_Year IS NOT NULL)
		GROUP BY CAST(Period_No AS nvarchar) + N' (' + CONVERT(nvarchar, Period_Year, 103) + N')'
		ORDER BY Period_Date;
END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_ClearAllData')
	EXEC ('CREATE PROCEDURE [dbo].[SP_ClearAllData] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2008
-- Description:	Procedure to clear all data and reset ID's
-- Version:		3
-- =============================================
-- JT TFS 13-48401: 31/05/2016 - Clear out company data.
-- =============================================
ALTER PROCEDURE [dbo].[SP_ClearAllData] 
	@Password nvarchar(50)
AS

--***WARNING*** This procedure will clear all data

IF NOT @Password = N'muddy'
	RETURN 0

--Temp tables
PRINT 'Clear temp tables'
DELETE FROM TEMP_ResponseHeader
DELETE FROM TEMP_Selected
DELETE FROM TEMP_SelectedItem

--Unreferences tables

PRINT 'QMS_UserPermissions'
DELETE FROM QMS_UserPermissions
DBCC CHECKIDENT ('QMS_UserPermissions', RESEED, 1)

PRINT 'QMS_UserLog'
DELETE FROM QMS_UserLog
DBCC CHECKIDENT ('QMS_UserLog', RESEED, 1)

PRINT 'QMS_UserPassword'
DELETE FROM QMS_UserPassword
DBCC CHECKIDENT ('QMS_UserPassword', RESEED, 1)

PRINT 'QMS_UserFailedLogins'
DELETE FROM QMS_UserFailedLogins
DBCC CHECKIDENT ('QMS_UserFailedLogins', RESEED, 1)

PRINT 'QMS_Task'
DELETE FROM QMS_Task
DBCC CHECKIDENT ('QMS_Task', RESEED, 1)

PRINT 'QMS_RecordLock'
DELETE FROM QMS_RecordLock
DBCC CHECKIDENT ('QMS_RecordLock', RESEED, 1)

PRINT 'QMS_Notification'
DELETE FROM QMS_Notification
DBCC CHECKIDENT ('QMS_Notification', RESEED, 1)

PRINT 'QMS_ErrorLog'
DELETE FROM QMS_ErrorLog
DBCC CHECKIDENT ('QMS_ErrorLog', RESEED, 1)

PRINT 'QMS_Attachment'
DELETE FROM QMS_Attachment
DBCC CHECKIDENT ('QMS_Attachment', RESEED, 1)

PRINT 'QMS_Company'
DELETE FROM QMS_Company
DBCC CHECKIDENT ('QMS_Company', RESEED, 1)

PRINT 'QMS_CountryRegion'
DELETE FROM QMS_CountryRegion
DBCC CHECKIDENT ('QMS_CountryRegion', RESEED, 1)

PRINT 'QMS_CountryAlias'
DELETE FROM QMS_CountryAlias
--Set high reseed value because it is used with country lookup
DBCC CHECKIDENT ('QMS_CountryAlias', RESEED, 1000)

PRINT 'QMS_CustomReport'
DELETE FROM QMS_CustomReport
DBCC CHECKIDENT ('QMS_CustomReport', RESEED, 1)

PRINT 'QMS_CustomAlert'
DELETE FROM QMS_CustomAlert
DBCC CHECKIDENT ('QMS_CustomAlert', RESEED, 1)

--Responses

PRINT 'QMS_ResponseQuestionSample'
DELETE FROM QMS_ResponseQuestionSample
DBCC CHECKIDENT ('QMS_ResponseQuestionSample', RESEED, 1)

PRINT 'QMS_ResponseQuestion'
DELETE FROM QMS_ResponseQuestion
DBCC CHECKIDENT ('QMS_ResponseQuestion', RESEED, 1)

PRINT 'QMS_ResponseHeaderMulti'
DELETE FROM QMS_ResponseHeaderMulti
DBCC CHECKIDENT ('QMS_ResponseHeaderMulti', RESEED, 1)

PRINT 'QMS_ResponseHeader'
DELETE FROM QMS_ResponseHeader
DBCC CHECKIDENT ('QMS_ResponseHeader', RESEED, 1)

PRINT 'QMS_ResponseAction'
DELETE FROM QMS_ResponseAction
DBCC CHECKIDENT ('QMS_ResponseAction', RESEED, 1)

PRINT 'QMS_Response'
DELETE FROM QMS_Response
DBCC CHECKIDENT ('QMS_Response', RESEED, 1)

PRINT 'QMS_SupplierResponseQuestion'
DELETE FROM QMS_SupplierResponseQuestion

PRINT 'QMS_SupplierResponse'
DELETE FROM QMS_SupplierResponse

--Assessments

PRINT 'QMS_AssessmentTarget'
DELETE FROM QMS_AssessmentTarget
DBCC CHECKIDENT ('QMS_AssessmentTarget', RESEED, 1)

PRINT 'QMS_AssessmentSchedule'
DELETE FROM QMS_AssessmentSchedule
DBCC CHECKIDENT ('QMS_AssessmentSchedule', RESEED, 1)

PRINT 'QMS_AssessmentSampleConstraint'
DELETE FROM QMS_AssessmentSampleConstraint
DBCC CHECKIDENT ('QMS_AssessmentSampleConstraint', RESEED, 1)

PRINT 'QMS_AssessmentQuestionConstraint'
DELETE FROM QMS_AssessmentQuestionConstraint
DBCC CHECKIDENT ('QMS_AssessmentQuestionConstraint', RESEED, 1)

PRINT 'QMS_AssessmentQuestion'
DELETE FROM QMS_AssessmentQuestion
DBCC CHECKIDENT ('QMS_AssessmentQuestion', RESEED, 1)

PRINT 'QMS_AssessmentHeader'
DELETE FROM QMS_AssessmentHeader
DBCC CHECKIDENT ('QMS_AssessmentHeader', RESEED, 1)

PRINT 'QMS_AssessmentConstraint'
DELETE FROM QMS_AssessmentConstraint
DBCC CHECKIDENT ('QMS_AssessmentConstraint', RESEED, 1)

PRINT 'QMS_AssessmentSpecHeader'
DELETE FROM QMS_AssessmentSpecHeader
DBCC CHECKIDENT ('QMS_AssessmentSpecHeader', RESEED, 1)

PRINT 'QMS_Assessment'
DELETE FROM QMS_Assessment
DBCC CHECKIDENT ('QMS_Assessment', RESEED, 1)

--Corrective actions

PRINT 'QMS_AssessmentTypeCAType'
DELETE FROM QMS_AssessmentTypeCAType
DBCC CHECKIDENT ('QMS_AssessmentTypeCAType', RESEED, 1)

PRINT 'QMS_CorrectiveActionEscalation'
DELETE FROM QMS_CorrectiveActionEscalation
DBCC CHECKIDENT ('QMS_CorrectiveActionEscalation', RESEED, 1)

PRINT 'QMS_CorrectiveActionType'
DELETE FROM QMS_CorrectiveActionType
DBCC CHECKIDENT ('QMS_CorrectiveActionType', RESEED, 1)

PRINT 'QMS_CorrectiveAction'
DELETE FROM QMS_CorrectiveAction
DBCC CHECKIDENT ('QMS_CorrectiveAction', RESEED, 1)

--Lookup data

PRINT 'QMS_NotificationSetup'
DELETE FROM QMS_NotificationSetup
DBCC CHECKIDENT ('QMS_NotificationSetup', RESEED, 1)

PRINT 'QMS_NotificationGroupUser'
DELETE FROM QMS_NotificationGroupUser
DBCC CHECKIDENT ('QMS_NotificationGroupUser', RESEED, 1)

PRINT 'QMS_NotificationGroup'
DELETE FROM QMS_NotificationGroup
DBCC CHECKIDENT ('QMS_NotificationGroup', RESEED, 1)

PRINT 'QMS_User'
DELETE FROM QMS_User
WHERE     (UserID <> 1)
DBCC CHECKIDENT ('QMS_User', RESEED, 2)

PRINT 'QMS_CustomLookupItem'
DELETE FROM QMS_CustomLookupItem
DBCC CHECKIDENT ('QMS_CustomLookupItem', RESEED, 1)

PRINT 'QMS_CustomLookup'
DELETE FROM QMS_CustomLookup
DBCC CHECKIDENT ('QMS_CustomLookup', RESEED, 1)

PRINT 'QMS_QuestionPool'
DELETE FROM QMS_QuestionPool WHERE Sys_Question IS NULL
DECLARE @MaxQuestionID int
SELECT @MaxQuestionID=ISNULL(MAX(QuestionID),0)+1 FROM QMS_QuestionPool
DBCC CHECKIDENT ('QMS_QuestionPool', RESEED, @MaxQuestionID)
UPDATE QMS_QuestionPool SET Created = 1

PRINT 'QMS_Guidance'
DELETE FROM QMS_Guidance
DBCC CHECKIDENT ('QMS_Guidance', RESEED, 1)

PRINT 'QMS_Hotsheet'
DELETE FROM QMS_Hotsheet
DBCC CHECKIDENT ('QMS_Hotsheet', RESEED, 1)

PRINT 'QMS_SpecificationHeader'
DELETE FROM QMS_SpecificationHeader
DBCC CHECKIDENT ('QMS_SpecificationHeader', RESEED, 1)

PRINT 'QMS_CustomResource'
DELETE FROM QMS_CustomResource
DBCC CHECKIDENT ('QMS_CustomResource', RESEED, 1)
GO


PRINT 'Database updated successfully!'
GO
