-- =============================================
-- Author:		Jeremy Formby
-- Create date: 23/03/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'VW_ResponseHeader_SourceLookup')
	EXEC ('CREATE VIEW [dbo].[VW_ResponseHeader_SourceLookup] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 1/01/2000
-- Description:	Gets list of users to notify for each response
-- Version:		4
-- =============================================
-- JT TFS 4046: Added ConsignmentID to lookup.
-- MP TFS 5034: Made raw and intermediate stock codes pick up as stock code
-- MartinP TFS 13-44370: Added StockCodeID to return 
-- =============================================
ALTER VIEW [dbo].[VW_ResponseHeader_SourceLookup]
AS
SELECT  QMS_ResponseHeader.ResponseID, 
		QMS_AssessmentHeader.DataLookupID, 
		CASE WHEN DataLookupID = 1 THEN Header_Text ELSE NULL END AS Supplier, 
		CASE WHEN DataLookupID IN (2, 6, 8, 35, 43) THEN Header_Text ELSE NULL END AS StockCode, 
		CASE WHEN DataLookupID = 4 THEN Header_Text ELSE NULL END AS Location, 
		CASE WHEN DataLookupID = 5 THEN Header_Text ELSE NULL END AS Consignment, 
		CASE WHEN DataLookupID = 5 THEN Header_SourceID ELSE NULL END AS ConsignmentID, 
		CASE WHEN DataLookupID = 6 THEN Header_Text ELSE NULL END AS ConsignmentItem, 
		CASE WHEN DataLookupID = 7 THEN Header_Text ELSE NULL END AS Delivery, 
		CASE WHEN DataLookupID = 8 THEN Header_Text ELSE NULL END AS DeliveryItem, 
		CASE WHEN DataLookupID = 15 THEN Header_Text ELSE NULL END AS SupplierRef, 
		CASE WHEN DataLookupID = 16 THEN Header_Date ELSE NULL END AS ArrivalDate, 
		CASE WHEN DataLookupID = 17 THEN Header_Numeric ELSE NULL END AS QuantityReceived, 
		CASE WHEN DataLookupID = 18 THEN Header_Numeric ELSE NULL END AS QuantityChecked, 
		CASE WHEN DataLookupID = 3 THEN Header_Text ELSE NULL END AS Customer, 
		CASE WHEN DataLookupID = 24 THEN Header_Text ELSE NULL END AS AssessmentSubType, 
		CASE WHEN DataLookupID = 12 THEN Header_Date ELSE NULL END AS DepotDate, 
		CASE WHEN DataLookupID = 14 THEN Header_Text ELSE NULL END AS CountryOfOrigin, 
		CASE WHEN DataLookupID = 29 THEN Header_Text ELSE NULL END AS HarvestCrew,
		CASE WHEN DataLookupID IN (2, 6, 8, 35, 43) THEN Header_SourceID ELSE NULL END AS StockCodeID 
FROM         QMS_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (QMS_AssessmentHeader.DataLookupID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
                      (QMS_ResponseHeader.Header_Text IS NOT NULL) AND (QMS_ResponseHeader.RecordStatus < 201)


				
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_GetResponse')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_GetResponse] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 28/07/2008
-- Description	: Get selected response record
-- Version		: 2
-- =============================================
-- TFS 13-45118 : Buf fix - AssessmentTypeID saved against the response needed to be accessed.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_GetResponse] 
	@ResponseID int
AS

SELECT
	ResponseID,
	AssessmentID,
	StartDate,
	EndDate,
	Comments,
	Recommended_Score,
	Recommended_QAFlagID,
	Actual_Score,
	Actual_QAFlagID,
	QuantityReceived,
	QuantityChecked,
	QuantityAccepted,
	QuantityRejected,
	QuantityReplaced,
	ResponseStatus,
    AssessmentTypeID,
	NotificationSent,
	(
		SELECT TOP 1
			QAActionID
		FROM	QMS_ResponseAction
		WHERE
			ResponseID = @ResponseID
			AND RecordStatus < 201
		ORDER BY ResponseActionID
	) AS QAActionID
FROM	QMS_Response
WHERE	ResponseID = @ResponseID;
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'AQC_FNC_ResponseHeader')
	EXEC('CREATE FUNCTION [dbo].[AQC_FNC_ResponseHeader]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Stuart Stephenson
-- Create date: 11/04/2016
-- Description:	Show AQC Checks on previous checks screen
-- Version:		1
-- =============================================
-- SS TFS 13-33017: Created function
-- =============================================
ALTER FUNCTION AQC_FNC_ResponseHeader
(
)
RETURNS 
@Transpose_Question TABLE 
(
	ResponseID			int,	
	Supplier			nvarchar(255),
	StockCode			nvarchar(255),
	Location			nvarchar(255),
	Consignment			nvarchar(255),
	ConsignmentItem		nvarchar(255),
	Delivery			nvarchar(255),
	DeliveryItem		nvarchar(255),
	SupplierRef			nvarchar(255),
	ArrivalDate			datetime,
	QuantityReceived	int,
	QuantityChecked		int,
	Customer			nvarchar(255),
	AssessmentSubType	nvarchar(255),
	DepotDate		    datetime,
	CountryOfOrigin	    nvarchar(255),
	HarvestCrew		    nvarchar(255)
)
AS
BEGIN
	DECLARE @StockCodeDataLookupID INT 
	SELECT  @StockCodeDataLookupID = MIN(DataLookupID) FROM VW_ResponseHeader_SourceLookup WHERE StockCode IS NOT NULL 

	INSERT INTO @Transpose_Question 
	(
	ResponseID, 
	Supplier,
	StockCode,
	Location,
	Consignment,
	ConsignmentItem,
	Delivery,
	DeliveryItem,
	SupplierRef,
	ArrivalDate,
	QuantityReceived,
	QuantityChecked,
	Customer,
	AssessmentSubType,
	DepotDate,
	CountryOfOrigin,
	HarvestCrew
	)

	SELECT ResponseID, MAX(Supplier) AS Supplier, 
	   MAX(CASE WHEN DataLookupID = @StockCodeDataLookupID THEN StockCode ELSE NULL END ) AS StockCode,
	   MAX(Location) AS Location, MAX(Consignment) AS Consignment, 
	   MAX(ConsignmentItem) AS ConsignmentItem, MAX(Delivery) AS Delivery, MAX(DeliveryItem) AS DeliveryItem, MAX(SupplierRef) AS SupplierRef, 
	   MAX(ArrivalDate) AS ArrivalDate, MAX(QuantityReceived) AS QuantityReceived, MAX(QuantityChecked) AS QuantityChecked, 
	   MAX(Customer) AS Customer, MAX(AssessmentSubType) AS AssessmentSubType, MAX(DepotDate) AS DepotDate, MAX(CountryOfOrigin) AS CountryOfOrigin, 
	   MAX(HarvestCrew) AS HarvestCrew
	 FROM VW_ResponseHeader_SourceLookup as rh
	 GROUP BY rh.ResponseID
	RETURN 
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PreviousList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		25
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- MP TFS 13-12735: Added logic to check for AQC approval config setting
-- jf 13042 - AQC may not be multicheck so allow for it
-- PH TFS 13-15140:  Added 'IsWebChecks' column to determine whether the Response is authorised to be edited using WebChecks front end (permission derived from APP_Menu with ParentID = 233)
-- jf tfs 16880 -- removed inner joins to FNC_User_ResponseList and used TEMP_selected instead - UBE Check view performance for user with 2000+ stock code permissions
				-- took resource string calcs out of nexted select and put in main output query (QAFlagID, ResourceName,QAFlag)
-- PH TFS 13-34304:		Reformatted and refactored QRY_Response_PreviousList to make more sense, perform better and be forward compatible
-- PH TFS 13-34304:		Reformatted to close up gaps
-- SS TFS 13-33017: When AssessmentTypeID = 16, AQC_FNC_ResponseHeader is now used instead of FNC_ResponseHeader
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

    SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) as QAFlag,
                QMS_Response.Override_QAFlagID, 
				ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
				QAFlag_Override.QAFlag) as Override_QAFlag,
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag AS APP_QAFlag_1
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE   AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
					QMS_Response.EndDate, QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
					QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.AQC_FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments

						FROM	QMS_Attachment

						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201

						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
					
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag

						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
						)
						OR
						(
							@multiCheckDisplay = 2
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
						)
						OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag, 							  
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								QAFlag,ResourceName 
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END

GO



PRINT 'Database updated successfully!'
GO
