-- =============================================
-- Author:		Jeremy Formby
-- Create date: 23/03/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_AssessmentQuestionConstraint_CustomLookup')
	EXEC ('CREATE PROCEDURE [dbo].[APP_AssessmentQuestionConstraint_CustomLookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 13/03/2009
-- Description:	Fills default constraints for custom lookup question
-- Version:		2
-- =============================================
-- SS TFS 13-43528: - Formatted SP AND added AssessmentQuestionConstraint.RecordStatus < 201 to line 27 so that records with a status of 201 are not returned in result set
-- =============================================
ALTER PROCEDURE [dbo].[APP_AssessmentQuestionConstraint_CustomLookup] 
	@AssessmentQuestionID int
AS

INSERT INTO QMS_AssessmentQuestionConstraint
                      (AssessmentQuestionID, Constraint_SourceID, QAFlagID, Score)
SELECT     QMS_AssessmentQuestion.AssessmentQuestionID, QMS_CustomLookupItem.CustomLookupItemID, QMS_CustomLookupItem.QAFlagID, 
                      QMS_CustomLookupItem.Score
FROM         QMS_AssessmentQuestion 
INNER JOIN   QMS_CustomLookup ON QMS_AssessmentQuestion.CustomLookupID = QMS_CustomLookup.CustomLookupID 
INNER JOIN   QMS_CustomLookupItem ON QMS_CustomLookup.CustomLookupID = QMS_CustomLookupItem.CustomLookupID 
LEFT OUTER JOIN QMS_AssessmentQuestionConstraint AS AssessmentQuestionConstraint ON QMS_CustomLookupItem.CustomLookupItemID = AssessmentQuestionConstraint.Constraint_SourceID 
			AND	QMS_AssessmentQuestion.AssessmentQuestionID = AssessmentQuestionConstraint.AssessmentQuestionID
			AND AssessmentQuestionConstraint.RecordStatus < 201
WHERE       (QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) 
AND (QMS_CustomLookupItem.RecordStatus < 201) 
AND  (AssessmentQuestionConstraint.QuestionConstraintID IS NULL) 
AND (QMS_CustomLookupItem.QAFlagID IS NOT NULL)
ORDER BY QMS_CustomLookupItem.ListIndex


GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_AssessmentQuestion_Presort')
	EXEC ('CREATE PROCEDURE [dbo].[UP_AssessmentQuestion_Presort] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 18/10/2013
-- Description:	Populates overall SortIndex and complete (dotted) question number
-- Version:		3
-- =============================================
-- JT TFS 9797 - Handle NULL question numbers.
-- JT TFS 13-42266: 21/03/2016 - Load into temp table before calculating sortindex for performance reasons.
-- =============================================
ALTER PROCEDURE UP_AssessmentQuestion_Presort
	@AssessmentID int
AS
BEGIN
	DECLARE @tmpSortedQuestion TABLE (
		AssessmentQuestionID int, 
		AssessmentID int,
		ParentQuestionID int,
		QuestionNumber varchar(100), 
		QuestionLevel int,
		dotted nvarchar(100),
		dotted_padded nvarchar(100)		
	);
	INSERT @tmpSortedQuestion (AssessmentQuestionID, QuestionNumber, ParentQuestionID, dotted, dotted_padded, QuestionLevel, AssessmentID)
	SELECT	question.AssessmentQuestionID, 
			question.QuestionNo, 
			question.ParentQuestionID, 
			NULL as dotted,
			NULL as dotted_padded,
			NULL as depth,
			question.AssessmentID
	FROM QMS_AssessmentQuestion question
	WHERE RecordStatus < 201
	AND question.AssessmentID = @AssessmentID


	-- Set root level items
	UPDATE @tmpSortedQuestion
	SET dotted = convert(varchar(100), QuestionNumber),
		dotted_padded = convert(varchar(100), right('00000' + convert(varchar(10), QuestionNumber), 3)),
		QuestionLevel = 1
	WHERE ParentQuestionID IS NULL

	-- loop through each level of children, adding more info each time.
	DECLARE @recursion_safety_counter int = 0
	WHILE @@ROWCOUNT > 0 AND @recursion_safety_counter < 10
	BEGIN
		SET @recursion_safety_counter = @recursion_safety_counter + 1

		UPDATE child
		SET QuestionLevel = parent.QuestionLevel + 1,
			dotted = convert(varchar(100), parent.dotted + '.' + convert(varchar(10), child.QuestionNumber)),
			dotted_padded = convert(varchar(100), parent.dotted_padded + '.' + right('00000' + convert(varchar(10), child.QuestionNumber), 3))
		FROM @tmpSortedQuestion parent
		inner join @tmpSortedQuestion child ON parent.AssessmentQuestionID = child.ParentQuestionID
		WHERE parent.dotted IS NOT NULL
		AND child.dotted IS NULL
	END

	-- Get the 
	DECLARE @SortedQuestion TABLE (
		AssessmentQuestionID int, 
		QuestionNumber varchar(100), 
		SortIndex int -- This is the overall sortindex based on dotted_padded
	);
	INSERT @SortedQuestion (AssessmentQuestionID, QuestionNumber, SortIndex)
	SELECT	AssessmentQuestionID, 
			dotted as QuestionNumber,
			SortIndex = row_number() OVER(PARTITION BY AssessmentID ORDER BY dotted_padded)
	FROM @tmpSortedQuestion


	-- Update the QMS_AssessmentQuestion table with the pre-calculated values.
	UPDATE original
	SET OverallQuestionNo = tmp.QuestionNumber,
		OverallSortIndex = tmp.SortIndex,
		MachineName = HOST_NAME(), 
		Updated = GETUTCDATE()
	FROM QMS_AssessmentQuestion original
	INNER JOIN @SortedQuestion tmp ON original.AssessmentQuestionID = tmp.AssessmentQuestionID
	WHERE original.AssessmentID = @AssessmentID 
	AND (tmp.QuestionNumber <> ISNULL(original.OverallQuestionNo, '')
		OR tmp.SortIndex <> ISNULL(original.OverallSortIndex, -1))

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ShelfLifeAnalysis_Summary')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ShelfLifeAnalysis_Summary] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 25/08/2009
-- Description:	Get shelf life analysis summary date
-- JE TFS 1984 modified to filter by QuestionID
-- Version: 3
-- =============================================
-- jf tfs 14994 - performace improvements due to timeout on Greencell
-- JT TFS 13-43839: 22/03/2016 - Use @m_UserID in query (remove hard-coding)
-- =============================================
ALTER PROCEDURE [dbo].[RPT_ShelfLifeAnalysis_Summary] 
	@UserID int,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@StockCodeID int = NULL,
	@AssessmentSubTypeID int = NULL,
	@QuestionID int
AS

DECLARE @m_UserID int,
	@m_DateFrom datetime = NULL,
	@m_DateTo datetime = NULL,
	@m_StockCodeID int = NULL,
	@m_AssessmentSubTypeID int = NULL,
	@m_QuestionID int

declare @ShelfLifeAnalysis_Summary table( 
	DateFrom datetime,
	DateTo datetime,
	StockCode nvarchar(100),
	AssessmentSubType  nvarchar(100),
	NumChecks int,
	Question  nvarchar(100),
	DUDays int,
	AvgDepotDateWeight real,
	AvgDUDateWeight real,
	AvgWeightLoss real,
	AvgDUDateScore int,
	AvgDayOutOfSpec int
	
)

select @m_UserID=@UserID ,
	@m_DateFrom=@DateFrom ,
	@m_DateTo=@DateTo ,
	@m_StockCodeID=@StockCodeID ,
	@m_AssessmentSubTypeID=@AssessmentSubTypeID ,
	@m_QuestionID =@QuestionID

DECLARE @StockCode nvarchar(300), @AssessmentSubType nvarchar(50)
--Lookup stock code description
SELECT     @StockCode = DisplayText
FROM         PM_VW_StockCode
WHERE     (StockCodeID = @m_StockCodeID)
--Lookup assessment sub type
SELECT     @AssessmentSubType = AssessmentSubType
FROM         APP_AssessmentSubType
WHERE     (AssessmentSubTypeID = @m_AssessmentSubTypeID)

INSERT INTO @ShelfLifeAnalysis_Summary (DateFrom, DateTo, StockCode, AssessmentSubType) values (@m_DateFrom,@m_DateTo,@StockCode,@AssessmentSubType)

UPDATE @ShelfLifeAnalysis_Summary SET NumChecks = (SELECT count(SelectedID) FROM TEMP_Selected WHERE      (UserID = @m_UserID))

UPDATE @ShelfLifeAnalysis_Summary SET Question = (SELECT	Question FROM QMS_QuestionPool WHERE QuestionID = @m_QuestionID)

UPDATE @ShelfLifeAnalysis_Summary SET DUDays = 
(SELECT     MAX(QMS_AssessmentTarget_1.DUDays) AS MaxDUDays
                            FROM          QMS_AssessmentTarget AS QMS_AssessmentTarget_1 INNER JOIN
                                                   TEMP_Selected AS TEMP_Selected_1 INNER JOIN
                                                   dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCodeID_1 INNER JOIN
                                                   QMS_Response AS QMS_Response_1 ON FNC_ResponseHeader_StockCodeID_1.ResponseID = QMS_Response_1.ResponseID ON 
                                                   TEMP_Selected_1.SelectedID = QMS_Response_1.ResponseID ON 
                                                   QMS_AssessmentTarget_1.AssessmentID = QMS_Response_1.AssessmentID AND 
                                                   QMS_AssessmentTarget_1.SourceObjectID = FNC_ResponseHeader_StockCodeID_1.StockCodeID
                            WHERE      (TEMP_Selected_1.UserID = @m_UserID))

UPDATE @ShelfLifeAnalysis_Summary SET AvgDepotDateWeight = 
(SELECT     ROUND(AVG(QMS_ResponseQuestion.Response_Numeric),1) AS AvgWeight
                            FROM          TEMP_Selected AS TEMP_Selected_1 INNER JOIN
                                                   QMS_QuestionPool INNER JOIN
                                                   QMS_AssessmentQuestion ON QMS_QuestionPool.QuestionID = QMS_AssessmentQuestion.QuestionID INNER JOIN
                                                   QMS_ResponseQuestion ON QMS_AssessmentQuestion.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID ON 
                                                   TEMP_Selected_1.SelectedID = QMS_ResponseQuestion.ResponseID
                            WHERE      (TEMP_Selected_1.UserID = @m_UserID) AND (QMS_ResponseQuestion.Response_Numeric IS NOT NULL) AND 
                                                   (QMS_ResponseQuestion.SampleNo = 0) AND (QMS_QuestionPool.Sys_Question = N'ShelfLifeWeight'))


UPDATE @ShelfLifeAnalysis_Summary SET AvgDUDateWeight = 
(SELECT     ROUND(AVG(QMS_ResponseQuestion_3.Response_Numeric),1) AS AvgWeight
                            FROM          dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCodeID_1 INNER JOIN
                                                   QMS_Response ON FNC_ResponseHeader_StockCodeID_1.ResponseID = QMS_Response.ResponseID INNER JOIN
                                                   TEMP_Selected AS TEMP_Selected_1 INNER JOIN
                                                   QMS_QuestionPool AS QMS_QuestionPool_3 INNER JOIN
                                                   QMS_AssessmentQuestion AS QMS_AssessmentQuestion_3 ON 
                                                   QMS_QuestionPool_3.QuestionID = QMS_AssessmentQuestion_3.QuestionID INNER JOIN
                                                   QMS_ResponseQuestion AS QMS_ResponseQuestion_3 ON 
                                                   QMS_AssessmentQuestion_3.AssessmentQuestionID = QMS_ResponseQuestion_3.AssessmentQuestionID ON 
                                                   TEMP_Selected_1.SelectedID = QMS_ResponseQuestion_3.ResponseID ON 
                                                   QMS_Response.ResponseID = TEMP_Selected_1.SelectedID INNER JOIN
                                                   QMS_AssessmentTarget ON QMS_Response.AssessmentID = QMS_AssessmentTarget.AssessmentID AND 
                                                   FNC_ResponseHeader_StockCodeID_1.StockCodeID = QMS_AssessmentTarget.SourceObjectID AND 
                                                   QMS_ResponseQuestion_3.SampleNo = QMS_AssessmentTarget.DUDays
                            WHERE      (TEMP_Selected_1.UserID = @m_UserID) AND (QMS_ResponseQuestion_3.Response_Numeric IS NOT NULL) AND 
                                                   (QMS_QuestionPool_3.Sys_Question = N'ShelfLifeWeight'))


UPDATE @ShelfLifeAnalysis_Summary SET AvgWeightLoss = CAST(0 AS float)
UPDATE @ShelfLifeAnalysis_Summary SET AvgDUDateScore = 
(SELECT     ROUND(AVG(CAST(QMS_ResponseQuestion_2.Score AS float)),1) AS AvgScore
								FROM         dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCodeID_1 INNER JOIN
												  QMS_Response AS QMS_Response_2 ON FNC_ResponseHeader_StockCodeID_1.ResponseID = QMS_Response_2.ResponseID INNER JOIN
												  TEMP_Selected AS TEMP_Selected_1 INNER JOIN
												  QMS_QuestionPool AS QMS_QuestionPool_2 INNER JOIN
												  QMS_AssessmentQuestion AS QMS_AssessmentQuestion_2 ON QMS_QuestionPool_2.QuestionID = QMS_AssessmentQuestion_2.QuestionID INNER JOIN
												  QMS_ResponseQuestion AS QMS_ResponseQuestion_2 ON 
												  QMS_AssessmentQuestion_2.AssessmentQuestionID = QMS_ResponseQuestion_2.AssessmentQuestionID ON 
												  TEMP_Selected_1.SelectedID = QMS_ResponseQuestion_2.ResponseID ON QMS_Response_2.ResponseID = TEMP_Selected_1.SelectedID INNER JOIN
												  QMS_AssessmentTarget AS QMS_AssessmentTarget_2 ON QMS_Response_2.AssessmentID = QMS_AssessmentTarget_2.AssessmentID AND 
												  FNC_ResponseHeader_StockCodeID_1.StockCodeID = QMS_AssessmentTarget_2.SourceObjectID AND 
												  QMS_ResponseQuestion_2.SampleNo = QMS_AssessmentTarget_2.DUDays
								WHERE      (TEMP_Selected_1.UserID = @m_UserID) AND (QMS_QuestionPool_2.QuestionID = @m_QuestionID))

UPDATE @ShelfLifeAnalysis_Summary SET AvgDayOutOfSpec = (SELECT     ROUND(AVG(CAST(MinRedDay AS float)),1) AS AvgRedDay
                            FROM          (SELECT     QMS_ResponseQuestion_1.ResponseID, MIN(QMS_ResponseQuestion_1.SampleNo) AS MinRedDay
                                                    FROM          TEMP_Selected AS TEMP_Selected_1 INNER JOIN
                                             QMS_QuestionPool AS QMS_QuestionPool_1 INNER JOIN
                                                                           QMS_AssessmentQuestion AS QMS_AssessmentQuestion_1 ON 
                                                                           QMS_QuestionPool_1.QuestionID = QMS_AssessmentQuestion_1.QuestionID INNER JOIN
                                                                           QMS_ResponseQuestion AS QMS_ResponseQuestion_1 ON 
                                                                           QMS_AssessmentQuestion_1.AssessmentQuestionID = QMS_ResponseQuestion_1.AssessmentQuestionID ON 
                                                                           TEMP_Selected_1.SelectedID = QMS_ResponseQuestion_1.ResponseID
                                                    WHERE      (TEMP_Selected_1.UserID = @m_UserID) AND (QMS_QuestionPool_1.QuestionID = @m_QuestionID) AND 
                                                                           (QMS_ResponseQuestion_1.Recommended_QAFlagID = 3)
                                                    GROUP BY QMS_ResponseQuestion_1.ResponseID) AS Response_Red)

SELECT	DateFrom,
		DateTo,
		StockCode,
		AssessmentSubType,
		NumChecks,
		Question,
		DUDays,
		AvgDepotDateWeight,
		AvgDUDateWeight,
		AvgWeightLoss,
		AvgDUDateScore,
		AvgDayOutOfSpec 
FROM @ShelfLifeAnalysis_Summary
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Comparison_AQCResponseHeader')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Comparison_AQCResponseHeader] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/03/2009
-- Description:	Gets response header items for report
-- Version:		2
-- =============================================
-- JT TFS 13-43839: 22/03/2016 - Use @UserID in query (remove hard-coding)
-- =============================================
ALTER PROCEDURE RPT_Comparison_AQCResponseHeader 
	@UserID int
AS --DECLARE @UserID int SET @UserID = _1
SET ANSI_WARNINGS OFF -- Because we know we are getting rid of null aggregates.

SELECT     AssessmentHeaderID, HeaderText, 
			MAX(HeaderResponse_1) AS HeaderResponse_1, 
			MAX(HeaderResponse_2) AS HeaderResponse_2, 
            MAX(HeaderResponse_3) AS HeaderResponse_3, 
            MAX(HeaderResponse_4) AS HeaderResponse_4, 
            MAX(HeaderResponse_A) AS HeaderResponse_A
FROM	(--	DECLARE @UserID int SET @UserID = _1
			SELECT		generic_header.AssessmentHeaderID, 
						generic_header.ListIndex, 
						generic_header.HeaderText, 
						CASE WHEN TEMP_Selected.SelectedText = '1' THEN QMS_ResponseHeader.Header_Text END AS HeaderResponse_1, 
						CASE WHEN TEMP_Selected.SelectedText = '2' THEN QMS_ResponseHeader.Header_Text END AS HeaderResponse_2, 
						CASE WHEN TEMP_Selected.SelectedText = '3' THEN QMS_ResponseHeader.Header_Text END AS HeaderResponse_3, 
						CASE WHEN TEMP_Selected.SelectedText = '4' THEN QMS_ResponseHeader.Header_Text END AS HeaderResponse_4, 
						CASE WHEN TEMP_Selected.SelectedText = 'A' THEN QMS_ResponseHeader.Header_Text END AS HeaderResponse_A
			FROM			QMS_Response 
			INNER JOIN		QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID 
			INNER JOIN		QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID 
			INNER JOIN		TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
			INNER JOIN		VW_AssessmentHeaderLink ON QMS_ResponseHeader.AssessmentHeaderID IN (VW_AssessmentHeaderLink.AssessmentHeaderID, VW_AssessmentHeaderLink.AltAssessmentHeaderID)
			INNER JOIN		QMS_AssessmentHeader generic_header ON VW_AssessmentHeaderLink.AssessmentHeaderID = generic_header.AssessmentHeaderID 
			WHERE	VW_AssessmentHeaderLink.AssessmentTypeID = (	SELECT AssessmentTypeID FROM QMS_Response 
																	WHERE ResponseID = (SELECT SelectedID FROM TEMP_Selected 
																						WHERE UserID = @UserID AND SelectedText = 'A'))
			AND		VW_AssessmentHeaderLink.AltAssessmentTypeID = QMS_Response.AssessmentTypeID
			AND		(QMS_ResponseHeader.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.RecordStatus < 201) 
			AND		(TEMP_Selected.UserID = @UserID)) AS Comparison
GROUP BY AssessmentHeaderID, ListIndex, HeaderText
ORDER BY ListIndex
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_ShelfLife')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_ShelfLife] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 19/08/2009
-- Description:	Gets list of questions for shelf life test
-- Version:		3
-- =============================================
-- JE TFS 13-6548: added DisplayWarning column
-- PH TFS 13-43857: Bug fix.  Issue for Shelf Life check being saved with DataLookupDataTypeID column not being present.  Also reformatted, introduced aliases and included semicolon use.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_ShelfLife] 
	@AssessmentID int
AS

SELECT
	assessmentQuestion.AssessmentQuestionID,
	questionPool.Question,
	assessmentQuestion.DataTypeID,
	assessmentQuestion.DataLookupID,
	assessmentQuestion.CustomLookupID,
	assessmentQuestion.QuestionLevelID,
	assessmentQuestion.GuidanceID,
	assessmentQuestion.ShortGuidance,
	assessmentQuestion.HasSamples,
	assessmentQuestion.ResponseRequired,
	assessmentQuestion.ScoreCalculationID,
	assessmentQuestion.Hide,
	questionPool.Sys_Question,
	assessmentQuestion.ResponseFormula,
	assessmentQuestion.ScoreFormula,
	assessmentQuestion.UpdateOverallQAFlag,
	questionLevel.DisplayWarning,
	(
		SELECT	DataTypeID
		FROM	APP_DataLookup
		WHERE	DataLookupID = assessmentQuestion.DataLookupID
	) AS DataLookupDataTypeID
FROM	QMS_AssessmentQuestion AS assessmentQuestion
INNER JOIN QMS_QuestionPool AS questionPool
	ON assessmentQuestion.QuestionID = questionPool.QuestionID
INNER JOIN APP_QuestionLevel AS questionLevel
	ON assessmentQuestion.QuestionLevelID = questionLevel.QuestionLevelID
WHERE
	assessmentQuestion.AssessmentID = @AssessmentID
	AND assessmentQuestion.RecordStatus < 201
ORDER BY assessmentQuestion.QuestionNo;
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Assessment_AdminComboSys')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Assessment_AdminComboSys] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/10/2008
-- Description:	Gets list of all assessments for specified type grouped by Sys_AssessmentID
-- Version:		3
-- =============================================
-- JE TFS 13-2100: only run UP_Assessment_SystemIDs of NULLs exist in QMS_Assessment
-- MartinP TFS 13-43868  -Changed inital count to count AssessmentID rather than Sys_AssessmentID
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Assessment_AdminComboSys] 
	@AssessmentTypeID int
AS

SET NOCOUNT ON
	--check if update SP needs to be run
	IF (SELECT COUNT(AssessmentID) FROM QMS_Assessment WHERE(RecordStatus < 201) AND (Sys_AssessmentID IS NULL)) > 0
		EXEC UP_Assessment_SystemIDs
SET NOCOUNT OFF

SELECT     Assessment_LatestVersion.Sys_AssessmentID, QMS_Assessment.AssessmentName
FROM         QMS_Assessment INNER JOIN
                          (SELECT     Sys_AssessmentID, MAX(AssessmentID) AS MaxAssessmentID
                            FROM          QMS_Assessment AS QMS_Assessment_Latest
                            WHERE      (RecordStatus < 201)
                            GROUP BY Sys_AssessmentID) AS Assessment_LatestVersion ON 
                      QMS_Assessment.AssessmentID = Assessment_LatestVersion.MaxAssessmentID
WHERE     (QMS_Assessment.AssessmentTypeID = @AssessmentTypeID)
ORDER BY QMS_Assessment.AssessmentName

GO

IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'APP_DayOfWeek')
	BEGIN 

		CREATE TABLE [dbo].[APP_DayOfWeek](
			[DayOfWeekID] [int] IDENTITY(0,1) NOT NULL,
			[Day] [nvarchar](10) NOT NULL,
			CONSTRAINT [PK_APP_DayOfWeek] PRIMARY KEY CLUSTERED  (	[DayOfWeekID] ASC	)
		)
		
		-- Seed so that relationships work
		IF NOT EXISTS (SELECT * FROM [dbo].[APP_DayOfWeek])
		BEGIN
			SET IDENTITY_INSERT [dbo].[APP_DayOfWeek] ON;
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (0, 'Sunday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (1, 'Monday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (2, 'Tuesday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (3, 'Wednesday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (4, 'Thursday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (5, 'Friday');
			INSERT INTO [dbo].[APP_DayOfWeek] (DayOfWeekID, Day) VALUES (6, 'Saturday');
			SET IDENTITY_INSERT [dbo].[APP_DayOfWeek] OFF;
		END
	END
GO


IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'APP_FirstWeekOfYear')
BEGIN 

	CREATE TABLE [dbo].[APP_FirstWeekOfYear](
		[FirstWeekOfYearID] [int] IDENTITY(0,1) NOT NULL,
		[DisplayText] [nvarchar](50) NOT NULL,
		[Description] [nvarchar](255) NULL,
		
		CONSTRAINT [PK_APP_FirstWeekOfYear] PRIMARY KEY CLUSTERED (	[FirstWeekOfYearID] ASC	)
	)

END

-- Seed so that relationships work
IF NOT EXISTS (SELECT * FROM [dbo].[APP_FirstWeekOfYear])
BEGIN
	SET IDENTITY_INSERT [dbo].[APP_FirstWeekOfYear] ON;
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (0, '1st day of week', 'First week with 1st day of week (First full week)');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (1, '2nd day of week', 'First week with 2nd day of week');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (2, '3rd day of week', 'First week with 3rd day of week');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (3, '4th day of week', 'First week with 4th day of week (ISO-8601 when Monday as 1st day of week)');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (4, '5th day of week', 'First week with 5th day of week');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (5, '6th day of week', 'First week with 6th day of week');
	INSERT INTO [dbo].[APP_FirstWeekOfYear] (FirstWeekOfYearID, DisplayText, Description) VALUES (6, '7th day of week', 'First week with 7th day of week (First week has January 1st in it)');
	SET IDENTITY_INSERT [dbo].[APP_FirstWeekOfYear] OFF;
END
GO


IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'APP_WeekOfYearConfig')
		CREATE TABLE [dbo].[APP_WeekOfYearConfig](
			[WeekOfYearConfigID] [int] IDENTITY(1,1) NOT NULL,
			[FirstDayOfWeek] [int] NOT NULL,
			[FirstWeekOfYear] [int] NOT NULL,
			[DateFrom] [datetime] NULL,
			[DateTo] [datetime] NULL,
			[RecordStatus] [tinyint] NULL,
			[UserID] [int] NULL
		);


	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_APP_WeekOfYearConfig_APP_DayOfWeek')
	BEGIN
		ALTER TABLE [dbo].[APP_WeekOfYearConfig]  WITH CHECK ADD  CONSTRAINT [FK_APP_WeekOfYearConfig_APP_DayOfWeek] FOREIGN KEY([FirstDayOfWeek])
		REFERENCES [dbo].[APP_DayOfWeek] ([DayOfWeekID])

		ALTER TABLE [dbo].[APP_WeekOfYearConfig] CHECK CONSTRAINT [FK_APP_WeekOfYearConfig_APP_DayOfWeek]
	END

	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_APP_WeekOfYearConfig_APP_FirstWeekOfYear')
	BEGIN
		ALTER TABLE [dbo].[APP_WeekOfYearConfig]  WITH CHECK ADD  CONSTRAINT [FK_APP_WeekOfYearConfig_APP_FirstWeekOfYear] FOREIGN KEY([FirstWeekOfYear])
		REFERENCES [dbo].[APP_FirstWeekOfYear] ([FirstWeekOfYearID])

		ALTER TABLE [dbo].[APP_WeekOfYearConfig] CHECK CONSTRAINT [FK_APP_WeekOfYearConfig_APP_FirstWeekOfYear]
	END

GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_WeekOfYearConfig_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_WeekOfYearConfig_List] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 23/03/2016
-- Description	: Gets a list of all the undeleted records from APP_WeekOfYearConfig
-- Version		: 1
-- =============================================
-- PH TFS 13-43971 : Created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_WeekOfYearConfig_List] 
	@WeekOfYearConfigID int = NULL
AS

SELECT
	weekOfYear.WeekOfYearConfigID,
	weekOfYear.FirstDayOfWeek,
	weekOfYear.FirstWeekOfYear,
	weekOfYear.DateFrom,
	weekOfYear.DateTo,
	weekOfYear.RecordStatus,
	weekOfYear.UserID
FROM	APP_WeekOfYearConfig AS weekOfYear
WHERE
	weekOfYear.RecordStatus < 201
	AND
	(
		@WeekOfYearConfigID IS NULL
		OR weekOfYear.WeekOfYearConfigID = @WeekOfYearConfigID
	)
ORDER BY weekOfYear.WeekOfYearConfigID;
GO



PRINT 'Database updated successfully!'
GO
