-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'


PRINT 'Sorting indexes...'

PRINT 'Sorting Views...'


PRINT 'Sorting User Defined Functions...'


PRINT 'Sorting Stored Procedures...'

-- BEGIN [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]') AND type in (N'P', N'PC'))
BEGIN 
	     DROP PROCEDURE [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]
END  
GO
-- END [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Quantity_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev	
-- Create date: 16/12/15
-- Description:	Trigger for quantity ordered by consignment item and stock code
-- version: 2
-- tfs 13- 33338
-- jf 20/1/16 - just updated to re deploy
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] 
	-- Add the parameters for the stored procedure here
	@ConsignmentID int = NULL,
	@ConsignmentItemID int = NULL,
	@StockCodeID int = NULL
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
SELECT     Quantity
FROM         PM_VW_ConsignmentItems
WHERE     (StockCodeID = @StockCodeID) AND (ConsignmentID = @ConsignmentID) AND (ConsignmentItemID = @ConsignmentItemID)
END
GO



PRINT 'Sorting sync procedures...'

PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
