-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'

-- BEGIN DATA PM_Delivery add GRN
BEGIN TRY
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_Delivery' AND c.name = 'GRN' )
  alter table PM_Delivery add GRN nvarchar(50) null
else
	IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_Delivery' AND c.name = 'GRN' and max_length = 100  )
		alter table PM_delivery alter Column GRN nvarchar(50) null
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA PM_Delivery add GRN', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA PM_Delivery add GRN

PRINT 'Sorting indexes...'

PRINT 'Sorting Views...'



PRINT 'Sorting User Defined Functions...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader')
	BEGIN
		EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
	END
ELSE
	BEGIN
		DROP FUNCTION FNC_ResponseHeader
		EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
	END
GO



-- =============================================
-- Author:		Markp
-- Create date: 17/03/2009
-- Description:	Gets response header data for views
-- Version:		3
-- =============================================
-- tfs4354 - get the lowest DataLookupID for the stock code as there may be duplicates within an assessment (2,6 etc) 
-- JT TFS 13-19030: Move lookup of lowest DataLookupID into main query to prevent timeouts on rugby farms mobile.
-- JF tfs33017 - Investigate why no AQC Checks appearing on Previous Check screen - change to function type
-- =============================================
--drop function FNC_ResponseHeader
ALTER FUNCTION [dbo].[FNC_ResponseHeader] 
(	
)
--select * from dbo.fnc_ResponseHeader()
RETURNS
@Transpose_Question TABLE 
(
	ResponseID INT,	
	Supplier	 nvarchar(255),
	StockCode	 nvarchar(255),
	Location	 nvarchar(255),
	Consignment	 nvarchar(255),
	ConsignmentItem	 nvarchar(255),
	Delivery	 nvarchar(255),
	DeliveryItem	 nvarchar(255),
	SupplierRef	 nvarchar(255),
	ArrivalDate	 datetime,
	QuantityReceived	 INT,
	QuantityChecked	 int,
	Customer	 nvarchar(255),
	AssessmentSubType	 nvarchar(255),
	DepotDate	 datetime,
	CountryOfOrigin	 nvarchar(255),
	HarvestCrew nvarchar(255)
)

AS

BEGIN
  
	DECLARE @StockCodeDataLookupID INT 
	SELECT  @StockCodeDataLookupID = MIN(DataLookupID) FROM VW_ResponseHeader_SourceLookup WHERE StockCode IS NOT NULL 

	INSERT INTO @Transpose_Question (ResponseID,	Supplier,	StockCode,	Location,	Consignment,	ConsignmentItem,	Delivery,	DeliveryItem,	SupplierRef,	ArrivalDate,	QuantityReceived,	QuantityChecked,	Customer,	AssessmentSubType,	DepotDate,	CountryOfOrigin,	HarvestCrew)

	SELECT ResponseID, MAX(Supplier) AS Supplier, 
	   MAX(CASE WHEN DataLookupID = @StockCodeDataLookupID THEN StockCode ELSE NULL END ) AS StockCode,
	   MAX(Location) AS Location, MAX(Consignment) AS Consignment, 
	   MAX(ConsignmentItem) AS ConsignmentItem, MAX(Delivery) AS Delivery, MAX(DeliveryItem) AS DeliveryItem, MAX(SupplierRef) AS SupplierRef, 
	   MAX(ArrivalDate) AS ArrivalDate, MAX(QuantityReceived) AS QuantityReceived, MAX(QuantityChecked) AS QuantityChecked, 
	   MAX(Customer) AS Customer, MAX(AssessmentSubType) AS AssessmentSubType, MAX(DepotDate) AS DepotDate, MAX(CountryOfOrigin) AS CountryOfOrigin, 
	   MAX(HarvestCrew) AS HarvestCrew
	 FROM VW_ResponseHeader_SourceLookup as rh
	 GROUP BY rh.ResponseID

RETURN
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_StockCodeList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_StockCodeList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/12/2009
-- Description:	Returns list of stockcodes that user can access (for admin)
-- Version:		6
-- =============================================
-- JE updated 10/01/2012 - added filtering by Business Group
-- TFS 3655: j.toolan: 27/6/2012: Stop multiple StockcodeIDs from returning.
-- TFS 5028: remove primary supplier filter for supplier users
-- JT TFS 15423: Either have stockcode permissions OR supplier stockcode pack permissions. The two do not complement each other.
-- PH TFS 35132: Refactoring code and comments to make logic clearer
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_StockCodeList] 
(
	@UserID int
)
RETURNS 
@StockCode TABLE 
(
	StockCodeID int
)
AS
BEGIN
	--Check for permissions in three exclusive permission levels in order of precedence: Business Group, Sub Group, Stockcode, Supplier
	--Check for enabled Business Group permissions
	DECLARE	@Table_BusinessGroup TABLE
		(
			StockCodeBusinessGroup nvarchar(100)
		)
	INSERT INTO @Table_BusinessGroup
		(
			StockCodeBusinessGroup
		)
	SELECT	PermissionTitle
	FROM	QMS_UserPermissions
	WHERE	PermissionType = 106
			AND PermissionAllow = 1
			AND UserID = @UserID;

	IF (SELECT COUNT(StockCodeBusinessGroup) FROM @Table_BusinessGroup) > 0 --If business group restricted
		INSERT INTO @StockCode (StockCodeID)
		SELECT		StockCodeID
		FROM        PM_VW_StockCode
		WHERE		BusinessGroup IN (SELECT StockCodeBusinessGroup FROM @Table_BusinessGroup); -- <-- then select by business group relationships only. (return values finalised)

	ELSE
	BEGIN		
		--Check for enabled Sub Group permissions
		DECLARE	@Table_SubGroup TABLE
			(
				StockCodeSubGroup nvarchar(100)
			)
		INSERT INTO @Table_SubGroup
			(
				StockCodeSubGroup
			)
		SELECT	PermissionTitle
		FROM	QMS_UserPermissions
		WHERE	PermissionType = 105
				AND PermissionAllow = 1
				AND UserID = @UserID;
		
		IF	(SELECT COUNT(StockCodeSubGroup) FROM @Table_SubGroup)>0  -- If Sub-group restricted
			INSERT INTO @StockCode (StockCodeID)
			SELECT	StockCodeID
			FROM	PM_VW_StockCode
			WHERE	StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @Table_SubGroup); -- < -- then select by sub group relationships only. (return values finalised)
		
		ELSE
		BEGIN
			--Check for enabled Stockcode permissions
			DECLARE @Table_StockCode TABLE
				(
					StockCodeID int
				)
			INSERT INTO @Table_StockCode
				(
					StockCodeID
				)
			SELECT	CAST(PermissionTitle AS int) AS StockCodeID
			FROM	QMS_UserPermissions
			WHERE	PermissionType = 104
					AND PermissionAllow = 1
					AND UserID = @UserID;

			IF (SELECT COUNT(StockCodeID) FROM @Table_StockCode)>0 --If Stockcode restricted
				INSERT INTO @StockCode (StockCodeID)
				SELECT	StockCodeID
				FROM	@Table_StockCode
				GROUP BY	StockCodeID; -- < -- then select by stockcode relationships only. (return values finalised)

			ELSE
			BEGIN
				--Check for enabled Supplier permissions
				DECLARE	@Table_Supplier TABLE
					(
						SupplierID int
					)
				INSERT INTO @Table_Supplier
					(
						SupplierID
					)
				SELECT	CAST(PermissionTitle AS int) AS SupplierID
				FROM	QMS_UserPermissions
				WHERE	PermissionType = 101
						AND PermissionAllow = 1
						AND UserID = @UserID;

				IF (SELECT COUNT(SupplierID) FROM @Table_Supplier)>0 --If Stockcode restricted
					INSERT INTO @StockCode (StockCodeID)
					SELECT DISTINCT	PM_VW_StockCodePack.StockCodeID
					FROM	@Table_Supplier AS Supplier
					INNER JOIN	PM_VW_StockCodePack
						ON Supplier.SupplierID = PM_VW_StockCodePack.SupplierID; -- < -- then select by stockcode relationships only. (return values finalised)			

				ELSE
					INSERT INTO @StockCode (StockCodeID)
					SELECT	StockCodeID
					FROM	PM_VW_StockCode; -- < -- then select all stockcodes. (return values finalised)
			END
		END
	END
	RETURN 
END
GO

PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_GetPOList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_GetPOList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 24/11/2015
-- Description:	Gets list of consignments used in a check since a specified date.
-- version: 	1
-- =============================================
-- JT TFS 13-35120: Get list of completed POs.
-- =============================================
ALTER PROCEDURE QRY_Response_GetPOList 
	@UserID int,
	@StartDate datetime,
	@EndDate datetime
AS
BEGIN
	SELECT	responseheader.Header_SourceID as ConsignmentID,
			responseheader.Header_Text as PO
	FROM QMS_Response as response
	INNER JOIN QMS_ResponseHeader as responseheader ON response.ResponseID = responseheader.ResponseID
	INNER JOIN QMS_AssessmentHeader as assessmentheader ON responseheader.AssessmentHeaderID = assessmentheader.AssessmentHeaderID
														AND assessmentheader.DataTypeID = 9
														AND assessmentheader.DataLookupID = 5
	WHERE response.EndDate BETWEEN @StartDate AND @EndDate
	AND response.ResponseStatus = 1
	GROUP BY responseheader.Header_SourceID, responseheader.Header_Text
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PreviousList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		24
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- MP TFS 13-12735: Added logic to check for AQC approval config setting
-- jf 13042 - AQC may not be multicheck so allow for it
-- PH TFS 13-15140:  Added 'IsWebChecks' column to determine whether the Response is authorised to be edited using WebChecks front end (permission derived from APP_Menu with ParentID = 233)
-- jf tfs 16880 -- removed inner joins to FNC_User_ResponseList and used TEMP_selected instead - UBE Check view performance for user with 2000+ stock code permissions
				-- took resource string calcs out of nexted select and put in main output query (QAFlagID, ResourceName,QAFlag)
-- PH TFS 13-34304:		Reformatted and refactored QRY_Response_PreviousList to make more sense, perform better and be forward compatible
-- PH TFS 13-34304:		Reformatted to close up gaps
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

    SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) as QAFlag,
                QMS_Response.Override_QAFlagID, 
				ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
				QAFlag_Override.QAFlag) as Override_QAFlag,
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag AS APP_QAFlag_1
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE   AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
					QMS_Response.EndDate, QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
					QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments

						FROM	QMS_Attachment

						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201

						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
					
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag

						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
						)
						OR
						(
							@multiCheckDisplay = 2
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
						)
						OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag, 							  
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								QAFlag,ResourceName 
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_Action')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_Action] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/04/2009
-- Description:	QC Check report actions sub
-- Version:		6
-- =============================================
-- MP TFS 4357 - Removed UTC conversion as now converts on upload
-- MP TFS 6017 - added sort order
-- JE TFS 13-3927: updated for use with Multi Check QC Actions sub report (this only ever reports on Parent checks)
-- SS TFS 36059: Added FNC_ResourceStringUser so custom QAACtion names are included within reports 
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_Action]
	@UserID int
AS

SELECT     QMS_ResponseAction.ResponseID, QMS_ResponseAction.ActionDate, 
			ISNULL([dbo].[FNC_ResourceString_User](APP_QAAction.ResourceName,@UserID ), APP_QAAction.QAAction) AS QAAction,
			QMS_User.FullName, QMS_ResponseAction.Comments, 
                      QMS_ResponseAction.Action_QAFlagID, QAFlag.QAFlag, QAFlag.QAFlagBackColour, QAFlag.QAFlagForeColour
FROM         QMS_ResponseAction INNER JOIN
                      QMS_User ON QMS_ResponseAction.UserID = QMS_User.UserID INNER JOIN
                      APP_QAAction ON QMS_ResponseAction.QAActionID = APP_QAAction.QAActionID INNER JOIN
                      TEMP_Selected ON QMS_ResponseAction.ResponseID = TEMP_Selected.SelectedID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag, QAFlagBackColour, QAFlagForeColour
                            FROM          APP_QAFlag) AS QAFlag ON QMS_ResponseAction.Action_QAFlagID = QAFlag.QAFlagID
WHERE     (QMS_ResponseAction.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID)
				--TEMP_Selected.SelectedValue will always be NULL for non-Multi Check report and for Parent checks in Multi Check report
				AND (TEMP_Selected.SelectedValue IS NULL)
ORDER BY QMS_ResponseAction.ResponseID, QMS_ResponseAction.ActionDate, APP_QAAction.QAAction

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Attachment')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Attachment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/09/2008
-- Description:	Saves attachment
-- Version:		5
-- =============================================
-- SF TFS 7843 - updated for Entity Framework
-- JT TFS 13-3861 - add ability to add temp attachments to an object. If they are left for 24 hours as temporary, then they will get removed.
                  -- and update SourceObjectId from zero to good value.
-- MartinP TFS 13 - 36259 - Changed the Update on QMS_Attachment to improve performance 
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Attachment]
	@AttachmentID int = NULL,
	@AttachmentSourceID int,
	@SourceObjectID int,
	@AttachmentTitle nvarchar(255),
	@AttachmentFileName nvarchar(100),
	@Attachment image,
	@AttachmentURL nvarchar(255),
	@UserID int,
	@IsTemp bit = 0
AS

SET NOCOUNT ON;

-- remove (and empty out) old temp attachments
UPDATE QMS_Attachment 
SET RecordStatus = 201, Attachment = NULL, Updated = GETUTCDATE(), Deleted = GETUTCDATE()
WHERE AttachmentID IN (
	SELECT AttachmentID FROM (
		SELECT AttachmentID, DATALENGTH(Attachment) AS AttachmentLength
		FROM QMS_Attachment
		WHERE RecordStatus = 100						-- Only remove TEMP attachments
		AND Inserted < dateadd(hour, -24, getdate())	-- older than a day.
	) AS AttachmentTable
	WHERE AttachmentLength IS NOT NULL
)

IF ISNULL(@AttachmentID,0)=0 --New record
BEGIN
	DECLARE @new TABLE (AttachmentID int);

	INSERT INTO QMS_Attachment	(AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, UserID, RecordStatus)
	OUTPUT INSERTED.AttachmentID INTO @new
	VALUES     (@AttachmentSourceID, @SourceObjectID, @AttachmentTitle, @AttachmentFileName, @Attachment, @AttachmentURL, @UserID, CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END);

	--Get new ID
	SELECT @AttachmentID = AttachmentID FROM @new;
END
ELSE --Update record
BEGIN
	UPDATE    QMS_Attachment
	SET         AttachmentTitle = @AttachmentTitle, 
				AttachmentFileName = @AttachmentFileName, 
				Attachment = @Attachment, 
				AttachmentURL = @AttachmentURL,
				RecordStatus = CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END,
				SourceObjectID = CASE WHEN SourceObjectID = 0 THEN @SourceObjectID ELSE SourceObjectID END, -- Only change from zero to good value, not backwards.
				UserID = @UserID, MachineName = HOST_NAME(), Updated = GETUTCDATE()
	WHERE     (AttachmentID = @AttachmentID);
END


SET NOCOUNT OFF;

SELECT @AttachmentID as AttachmentID;

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Delivery')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Delivery] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		3
-- =============================================
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 35719 - add GRN
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_Delivery] 
	@DeliveryID int,
	@LocationID int,
	@SupplierID int,
	@LorryNo int,
	@Haulier nvarchar(50),
	@LorryReg nvarchar(20),
	@Driver nvarchar(50),
	@DispatchDate datetime,
	@ArrivalDate datetime,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@GRN nvarchar(50) = null,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DispatchDate = dbo.FNC_ConvertServerDate(@DispatchDate)
SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)

IF NOT EXISTS(SELECT * FROM PM_Delivery WHERE (DeliveryID = @DeliveryID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_Delivery
                      (DeliveryID, LocationID, SupplierID, LorryNo, Haulier, LorryReg, Driver, DispatchDate, ArrivalDate, RecordStatus, GUID, GRN)
		VALUES     (@DeliveryID,@LocationID,@SupplierID,@LorryNo,@Haulier,@LorryReg,@Driver,@DispatchDate,@ArrivalDate,@RecordStatus,@GUID,@GRN)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Delivery
	SET              SupplierID = @SupplierID, LorryNo = @LorryNo, Haulier = @Haulier, LorryReg = @LorryReg, Driver = @Driver, DispatchDate = @DispatchDate, 
                      ArrivalDate = @ArrivalDate, RecordStatus = @RecordStatus, GRN=@GRN
	WHERE     (DeliveryID = @DeliveryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


-- BEGIN [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]') AND type in (N'P', N'PC'))
BEGIN 
	     DROP PROCEDURE [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]
END  
GO
-- END [dbo].[PM_QRY_ConsignmentItemQuantity_Lookup]



PRINT 'Sorting sync procedures...'

PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
