-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'


--this is to update mobile database as they are different from office
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_ConsignmentItems' AND c.name = 'ItemStatus' )

	alter table PM_Consignmentitems add
		ItemStatus INT
GO

--this is to update mobile database as they are different from office
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_GoodsIntake' AND c.name = 'StoreID' )

	alter table PM_GoodsIntake add
		StoreID INT
GO


PRINT 'Sorting indexes...'

PRINT 'Sorting Views...'


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_GoodsIntake')
	EXEC ('CREATE VIEW [dbo].[PM_VW_GoodsIntake] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Unknown
-- Create date: 29/06/2010
-- Description:	Gets header informaton for PM_GoodsIntake
-- Version:		8
-- =============================================
-- JT TFS 4286: 9-Aug-2012: Added PalletID
-- JF: Added ArrivalTemp and Certified
-- MP TFS 2798: Added Updated column
-- jf TFS 19129 - added PalletStockCodeID
-- jf TFS 29162 - added storeID
-- =============================================
ALTER VIEW [dbo].[PM_VW_GoodsIntake]
AS
SELECT        GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, UserGroupID, ItemCount, UnitQuantity, PalletNo, HarvestDate, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Barcode, Comments, E_Text1, 
                         E_Text2, UnitStockCodeID, OriginalBarcode, E_Numeric1, E_DateTime1, PalletID, ArrivalTemp, Certified, Updated, NetWeight, PalletStockCodeID, RowVersion, Created, RecordStatus, E_Numeric3, E_Numeric2, 
                         GUID,StoreID
FROM            dbo.PM_GoodsIntake
WHERE        (RecordStatus < 201)

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_ConsignmentItems')
	EXEC ('CREATE VIEW [dbo].[PM_VW_ConsignmentItems] AS SELECT 1 as ''stub version, to be replaced''')
GO
--===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_ConsignmentItems
-- Version:		4
-- ===================================================
-- JF: Added DateRequired column
-- JF: Added E_POItem column
-- jf tfs 19430 - added GUID, RowVersion, Hide, RecordStatus, VersionNo, Created, Updated for sync purposes
-- jf tfs 29101 - added itemstatus
-- ===================================================
ALTER VIEW [dbo].[PM_VW_ConsignmentItems]
AS
SELECT        ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, QuantityAccepted, UnitPrice, UnitQuantity, UnitStockCodeID, DepotDate, Comments, DateRequired, E_POItem,  Hide, RecordStatus, 
                         VersionNo,   ItemStatus
FROM            dbo.PM_ConsignmentItems
WHERE        (Hide = 0) AND (RecordStatus < 201)

GO



PRINT 'Sorting User Defined Functions...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_GreatestDateTime')
	EXEC('CREATE FUNCTION [dbo].[FNC_GreatestDateTime]() RETURNS bit AS BEGIN RETURN 0 END')
GO
--=============================================
-- Author:		MBS\phil.harding
-- Create date: 26 OCT 2015
-- Version:		1
-- Description: Returns the greatest datetime of the two provided.  For comparing RowVersions.
--=============================================
-- PH TFS 13-28779: included for iOS functionality
--=============================================
ALTER FUNCTION [dbo].[FNC_GreatestDateTime]
(
	@DateTimeA datetime,
	@DateTimeB datetime
)
RETURNS DateTime

AS
BEGIN

	DECLARE @greatestDateTime datetime =
		CASE WHEN (@DateTimeA > @DateTimeB)
			THEN @DateTimeA
			ELSE @DateTimeB
			END;

	RETURN @greatestDateTime;
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_SupplierSitePermissions_Any')
	EXEC('CREATE FUNCTION [dbo].[FNC_SupplierSitePermissions_Any]() RETURNS bit AS BEGIN RETURN 0 END')
GO
--=============================================
-- Author:		MBS\phil.harding
-- Create date: 26 OCT 2015
-- Version:		1
-- Description: Indicates whether the specified user has any active Supplier permissions
--=============================================
-- PH TFS 13-28779: First iteration (Helps hide/show "Edit Check" icon)
--=============================================
ALTER FUNCTION [dbo].[FNC_SupplierSitePermissions_Any] ( @UserID int )
RETURNS bit

AS
BEGIN
	DECLARE @_userID int = @UserID;
	DECLARE @any bit = 0;

	SET @any = CASE WHEN (
		(
			SELECT COUNT(*) FROM QMS_UserPermissions AS userPermissions
	
			INNER JOIN PM_VW_Location AS location
				ON userPermissions.PermissionTitle = location.LocationID
	
			WHERE (userPermissions.PermissionType = 103)
				AND (userPermissions.UserID = @_userId)
				AND (location.LocationType = 3)
				AND (userPermissions.PermissionAllow = 1)

		) = 0) THEN 0 ELSE 1 END;

	RETURN @any;
END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_SupplierPermissions_Any')
	EXEC('CREATE FUNCTION [dbo].[FNC_SupplierPermissions_Any]() RETURNS bit AS BEGIN RETURN 0 END')
GO
--=============================================
-- Author:		MBS\phil.aarding
-- Create date: 26 OCT 2015
-- Version:		1
-- Description: Indicates whether the specified user has any active Supplier permissions
--=============================================
-- PH TFS 13-28779: included for iOS functionality
--=============================================
ALTER FUNCTION [dbo].[FNC_SupplierPermissions_Any] ( @UserID int )
RETURNS bit

AS
BEGIN
	DECLARE @_userID int = @UserID;
	DECLARE @any bit = 0;

	SET @any = CASE WHEN (
		(
			SELECT COUNT(*) FROM QMS_UserPermissions AS userPermissions
	
			INNER JOIN PM_VW_Supplier AS supplier
				ON userPermissions.PermissionTitle = supplier.SupplierID

			WHERE (userPermissions.PermissionType = 101)
				AND (userPermissions.UserID = @_userID)
				AND (userPermissions.PermissionAllow = 1)
		) = 0)

		THEN 0 ELSE 1 END;

	RETURN @any;
END
GO



PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		3
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - add itemstatus
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@ItemStatus INT,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate)
SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired)

IF @Hide  IS NULL
	SET @Hide = 0

IF NOT EXISTS(SELECT * FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO PM_ConsignmentItems
                      (ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, UnitStockCodeID, UnitQuantity, QuantityAccepted, DepotDate, UnitPrice, Comments, DateRequired, 
                      E_POItem, Hide, RecordStatus, GUID,VersionNo,ItemStatus)
		VALUES     (@ConsignmentItemID,@ConsignmentID,@StockCodeID,@Quantity,@UnitStockCodeID,@UnitQuantity,@QuantityAccepted,@DepotDate,@UnitPrice,@Comments,@DateRequired,@E_POItem,@Hide,@RecordStatus,@GUID,@VersionNo,@ItemStatus)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_ConsignmentItems
	SET              StockCodeID = @StockCodeID, Quantity = @Quantity, UnitStockCodeID = @UnitStockCodeID, UnitQuantity = @UnitQuantity, QuantityAccepted = @QuantityAccepted, 
                      DepotDate = @DepotDate, UnitPrice = @UnitPrice, Comments = @Comments, DateRequired = @DateRequired, E_POItem = @E_POItem, Hide = @Hide, 
                      RecordStatus = @RecordStatus, VersionNo=@VersionNo,ItemStatus=@ItemStatus
	WHERE     (ConsignmentItemID = @ConsignmentItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ComboSource_Supplier')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ComboSource_Supplier] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		:	MBS\phil.harding
-- Create date	:	14th Sep 15
-- Description	:	Gets/Syncs a list of Supplier combo items
-- Version		:	2
-- =============================================
-- PH TFS 13-25807 :	First iteration (experimental)
-- PH TFS 13-29332 :	include demo of FirstSync property
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ComboSource_Supplier]
	@UserID int = 0,
	@TimeStamp bigint = 0,
	@PageSize int = 0,
	@DataLookupID int = NULL,
	@FirstSync bit = 0
AS

-- Declare locals (avoid parameter sniffing)
DECLARE @_userId int = @UserID;
DECLARE @_timeStamp int = @TimeStamp;
DECLARE @_pageSize int = @PageSize;

-- Declare locals (operational)
DECLARE @permittedSuppliers table (SupplierID int);
DECLARE @allSuppliersPermitted bit;


-- Get permitted suppliers
INSERT INTO @permittedSuppliers SELECT SupplierID FROM dbo.FNC_User_SupplierList(@_userId);
-- If no permissions set, then all suppliers permitted
SET @allSuppliersPermitted = CAST(CASE WHEN ((SELECT COUNT(*) FROM @permittedSuppliers) = 0) THEN 1 ELSE 0 END AS BIT)

-- Calculate actual page size
IF (@_pageSize = 0)
BEGIN
	SET @_pageSize = (SELECT COUNT(*) FROM @permittedSuppliers);
END

-- Has no supplier permissions set
IF (@allSuppliersPermitted = 1)
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupID AS DataLookupID,
				supplier.SupplierID AS ComboKey,
				supplier.SupplierName AS ComboValue,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted

		FROM PM_VW_Supplier AS supplier

		WHERE ((@_timeStamp = 0 OR @FirstSync = 1) AND (supplier.RecordStatus < 201))
				OR (@_timeStamp > 0 AND @FirstSync = 0) -- ((@_timeStamp = 1) AND (supplier.RowVersion > @_timeStamp))
		
		ORDER BY supplier.SupplierID; -- ORDER BY RowVersion

	END

-- Has supplier permissions set
ELSE
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupID AS DataLookupID,
				supplier.SupplierID AS ComboKey,
				supplier.SupplierName AS ComboValue,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(CASE WHEN (supplier.RecordStatus > 200) THEN 1 ELSE 0 END AS bit) AS IsNowDeleted

		FROM PM_VW_Supplier AS supplier

		INNER JOIN	@permittedSuppliers
				ON [@permittedSuppliers].SupplierID = supplier.SupplierID

		WHERE ((@_timeStamp = 0 OR @FirstSync = 1) AND (supplier.RecordStatus < 201))
				OR (@_timeStamp > 0 AND @FirstSync = 0) -- ((@_timeStamp > 0) AND (supplier.RowVersion > @_timeStamp))
				
		ORDER BY supplier.SupplierID;  -- ORDER BY RowVersion

	END


GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 09/07/2008
-- Description:	Gets list of questions for specified assessment
-- Version:		11
-- =============================================
-- j.toolan 10 Apr 2012: [TFS: 3087] Added IsLocked flag which restricts users from editing the question in assesssment question admin screen.
--jf 26/10/12 - added hide from reports option
-- JE TFS 5456: added List Samples On Report col
-- JE TFS 5067: added Lookup_DataLookupDataTypeID col in order to access a lookup's data type
-- JT TFS 6621		- Added code to specify AssessmentQuestionID
-- JT TFS 6960		- Added code to include lookup for LookupAssessmentQuestionID (just list of questions in this assessment)
-- JE TFS 7951		- added MultiSampleSummary col
-- JT TFS 7785		- Added GuidanceRequired column.
-- PH TFS 13-18551	- Added IsQuestionGroup column, so that DataType controls can be hidden if group heading
-- PH TFS 13-30547	- Added InstrumentID
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_AdminList] 
	@AssessmentID int,
	@AssessmentQuestionID int = NULL
AS

SET NOCOUNT ON
	IF @AssessmentQuestionID IS NOT NULL AND NULLIF(@AssessmentID, 0) IS NULL
		SELECT @AssessmentID = AssessmentID 
		FROM QMS_AssessmentQuestion 
		WHERE AssessmentQuestionID = @AssessmentQuestionID 


	IF NULLIF(object_id('tempdb..#tmpLookupQuestion'), 0) IS NOT NULL DROP TABLE #tmpLookupQuestion
	SELECT sorted.AssessmentQuestionID, convert(nvarchar(30), sorted.QuestionNumber) + N' ' + QMS_QuestionPool.Question 'Question'
	INTO #tmpLookupQuestion
	FROM dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) sorted
	INNER JOIN QMS_AssessmentQuestion ON QMS_AssessmentQuestion.AssessmentQuestionID = sorted.AssessmentQuestionID 
	INNER JOIN QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID 


SET NOCOUNT OFF

SELECT	QMS_AssessmentQuestion.AssessmentQuestionID,
		QMS_AssessmentQuestion.AssessmentID,
		FNC_AssessmentQuestion_Sort.QuestionNumber AS SortNumber, 
        QMS_AssessmentQuestion.QuestionNo,
		QMS_AssessmentQuestion.QuestionID,
		QMS_QuestionPool.Question AS Lookup_QuestionID, 
        QMS_AssessmentQuestion.ParentQuestionID,
		AssessmentQuestion_Parent.QuestionText AS Lookup_ParentQuestionID,
		QMS_AssessmentQuestion.DataTypeID,
        (SELECT     DataType
			FROM          APP_DataType
			WHERE      (DataTypeID = QMS_AssessmentQuestion.DataTypeID)) AS Lookup_DataTypeID,
		QMS_AssessmentQuestion.DataLookupID,
        (SELECT     DataLookup
			FROM          APP_DataLookup
			WHERE      (DataLookupID = QMS_AssessmentQuestion.DataLookupID)) AS Lookup_DataLookupID,
		QMS_AssessmentQuestion.CustomLookupID,
        (SELECT		DataTypeID --TFS 5067
			FROM		APP_DataLookup
			WHERE	(DataLookupID = QMS_AssessmentQuestion.DataLookupID)) AS Lookup_DataLookupDataTypeID,
        (SELECT     LookupName
			FROM          QMS_CustomLookup
			WHERE      (CustomLookupID = QMS_AssessmentQuestion.CustomLookupID)) AS Lookup_CustomLookupID,
		QMS_AssessmentQuestion.QuestionLevelID,
        (SELECT     QuestionLevel
			FROM          APP_QuestionLevel
			WHERE      (QuestionLevelID = QMS_AssessmentQuestion.QuestionLevelID)) AS Lookup_QuestionLevelID,
		QMS_AssessmentQuestion.GuidanceID, 
		QMS_Guidance.GuidanceDesc AS Lookup_GuidanceID,
		QMS_AssessmentQuestion.ShortGuidance,
		QMS_AssessmentQuestion.ResponseFormula, 
		QMS_AssessmentQuestion.ScoreCalculationID,
        (SELECT		ScoreCalculation
			FROM	APP_QuestionScoreCalculation
			WHERE	(ScoreCalculationID = QMS_AssessmentQuestion.ScoreCalculationID)) AS Lookup_ScoreCalculationID,
		QMS_AssessmentQuestion.ScoreFormula, 
		QMS_AssessmentQuestion.HasSamples, QMS_AssessmentQuestion.SampleSummaryID,
        (SELECT		SampleSummary
			FROM	APP_SampleSummary
			WHERE	(SampleSummaryID = QMS_AssessmentQuestion.SampleSummaryID)) AS Lookup_SampleSummaryID,
		QMS_AssessmentQuestion.Sample_DataTypeID,
		QMS_AssessmentQuestion.Multi_SampleSummaryID,
		(SELECT		SampleSummary
			FROM	APP_SampleSummary
			WHERE	(SampleSummaryID = QMS_AssessmentQuestion.Multi_SampleSummaryID)) AS Lookup_Multi_SampleSummaryID,
        (SELECT		DataType
			FROM	APP_DataType AS APP_DataType_1
			WHERE	(DataTypeID = QMS_AssessmentQuestion.Sample_DataTypeID)) AS Lookup_Sample_DataTypeID,
		QMS_AssessmentQuestion.MinSampleCount, 
		QMS_AssessmentQuestion.LookupAssessmentQuestionID, 
		(SELECT		Question
			FROM	#tmpLookupQuestion
			WHERE	AssessmentQuestionID = QMS_AssessmentQuestion.LookupAssessmentQuestionID) as Lookup_LookupAssessmentQuestionID,
		QMS_AssessmentQuestion.LookupSampleSet, 
		QMS_AssessmentQuestion.InstrumentID,
        (SELECT		InstrumentName
			FROM	APP_Instrument
			WHERE	(InstrumentID = QMS_AssessmentQuestion.InstrumentID)) AS Lookup_InstrumentID,
		QMS_AssessmentQuestion.Acceptable_Numeric_Min, 
		QMS_AssessmentQuestion.Acceptable_Numeric_Max,
		QMS_AssessmentQuestion.BackfillResponse,
		QMS_AssessmentQuestion.UpdateOverallQAFlag, 
		QMS_AssessmentQuestion.ResponseRequired,
		QMS_AssessmentQuestion.ChartQuestion,
		QMS_AssessmentQuestion.Hide,
		QMS_QuestionPool.Sys_Question,
		QMS_QuestionPool.Hide AS [Lookup_IsLocked],
		QMS_AssessmentQuestion.HideFromReports,
		QMS_AssessmentQuestion.ListSamplesOnReport,
		QMS_AssessmentQuestion.GuidanceRequired,
		QMS_QuestionPool.IsQuestionGroup,
		QMS_AssessmentQuestion.InstrumentID 
FROM         QMS_AssessmentQuestion INNER JOIN
                      dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) AS FNC_AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = FNC_AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                      QMS_Guidance ON QMS_AssessmentQuestion.GuidanceID = QMS_Guidance.GuidanceID LEFT OUTER JOIN
                          (SELECT     TOP (100) PERCENT QMS_AssessmentQuestion_Parent.AssessmentQuestionID, CAST(AssessmentQuestion_Sort_Parent.QuestionNumber AS nvarchar) 
                                                   + N' ' + QMS_QuestionPool_Parent.Question AS QuestionText
                            FROM          QMS_AssessmentQuestion AS QMS_AssessmentQuestion_Parent INNER JOIN
                                                   QMS_QuestionPool AS QMS_QuestionPool_Parent ON 
                                                   QMS_AssessmentQuestion_Parent.QuestionID = QMS_QuestionPool_Parent.QuestionID INNER JOIN
                                                   dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) AS AssessmentQuestion_Sort_Parent ON 
                                                   QMS_AssessmentQuestion_Parent.AssessmentQuestionID = AssessmentQuestion_Sort_Parent.AssessmentQuestionID
                            WHERE      (QMS_AssessmentQuestion_Parent.AssessmentID = @AssessmentID) AND (QMS_AssessmentQuestion_Parent.RecordStatus < 201)
                            ORDER BY AssessmentQuestion_Sort_Parent.QuestionNumber, QMS_QuestionPool_Parent.Question) AS AssessmentQuestion_Parent ON 
                      QMS_AssessmentQuestion.ParentQuestionID = AssessmentQuestion_Parent.AssessmentQuestionID
WHERE     (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) 
AND		(@AssessmentQuestionID IS NULL OR QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID)
AND		(QMS_AssessmentQuestion.RecordStatus < 201) 
AND (QMS_QuestionPool.RecordStatus < 201)
ORDER BY FNC_AssessmentQuestion_Sort.SortIndex1, FNC_AssessmentQuestion_Sort.SortIndex2, FNC_AssessmentQuestion_Sort.SortIndex3, 
                      FNC_AssessmentQuestion_Sort.SortIndex4

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_StockBatchItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jf
-- Create date: 11/2/15
-- Description:	Imort StockBatchItems
-- Version:		2
-- =============================================
-- jf 11/2/15 - added @TotalQuantity
-- jf tfs 20519- - check if PM_StockBatch exists before inserting to avoid foreign key errors
-- =============================================
ALTER PROCEDURE dbo.SYNC_Import_PM_StockBatchItems 
	@StockItemID int, 
	@StockBatchID INt, 
	@StockCodeID int, 
	@SupplierID int, 
	@UseByDate datetime, 
	@RecordStatus tinyint, 
	@Source tinyint, 
	@Updated datetime,  
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@TotalQuantity decimal(18,2),

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT StockItemID FROM PM_StockBatchItems WHERE (StockItemID = @StockItemID))
BEGIN --Append record
	IF @RecordStatus < 201 and EXISTS(SELECT StockBatchID FROM PM_StockBatch WHERE (StockBatchID  = @StockBatchID))
	BEGIN
		INSERT INTO PM_StockBatchItems
						(StockBatchID, StockCodeID, SupplierID, UseByDate, RecordStatus, Source, Updated, GUID, TotalQuantity )
                      --(StockBatchID, BatchType, LocationID, Barcode, BatchRef, QAStatus, DateAdded, DateClosed, ExpiryDate, Closed, RecordStatus, GUID)
		VALUES     (@StockBatchID,@StockCodeID,@SupplierID,@UseByDate,@RecordStatus,@Source,@Updated,@GUID,@TotalQuantity)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatchItems
	SET              StockBatchID=@StockBatchID, StockCodeID=@StockCodeID, SupplierID=@SupplierID, UseByDate=@UseByDate, RecordStatus=@RecordStatus, Source=@Source, Updated=@Updated, TotalQuantity=@TotalQuantity
	WHERE     (StockItemID = @StockItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknows
-- Create date: 18/12/2008
-- Description:	imports data
-- Version:		4
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - added storeid 
-- =============================================

ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@StoreID int = null,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateArrived = dbo.FNC_ConvertServerDate(@DateArrived)
SET @HarvestDate = dbo.FNC_ConvertServerDate(@HarvestDate)
SET @E_DateTime1 = dbo.FNC_ConvertServerDate(@E_DateTime1)

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID, StoreID)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID, @StoreID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID,StoreID=@StoreID
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created


GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Delivery')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Delivery] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		2
-- =============================================
--jf TFS 23605 - make sure no date conversions happen
-- =============================================
ALTER PROCEDURE dbo.SYNC_Import_PM_Delivery 
	@DeliveryID int,
	@LocationID int,
	@SupplierID int,
	@LorryNo int,
	@Haulier nvarchar(50),
	@LorryReg nvarchar(20),
	@Driver nvarchar(50),
	@DispatchDate datetime,
	@ArrivalDate datetime,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DispatchDate = dbo.FNC_ConvertServerDate(@DispatchDate)
SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)

IF NOT EXISTS(SELECT * FROM PM_Delivery WHERE (DeliveryID = @DeliveryID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_Delivery
                      (DeliveryID, LocationID, SupplierID, LorryNo, Haulier, LorryReg, Driver, DispatchDate, ArrivalDate, RecordStatus, GUID)
		VALUES     (@DeliveryID,@LocationID,@SupplierID,@LorryNo,@Haulier,@LorryReg,@Driver,@DispatchDate,@ArrivalDate,@RecordStatus,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Delivery
	SET              SupplierID = @SupplierID, LorryNo = @LorryNo, Haulier = @Haulier, LorryReg = @LorryReg, Driver = @Driver, DispatchDate = @DispatchDate, 
                      ArrivalDate = @ArrivalDate, RecordStatus = @RecordStatus
	WHERE     (DeliveryID = @DeliveryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknows
-- Create date: 18/12/2008
-- Description:	imports data
-- Version:		2
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
-- jf tfs 29101 - added storeid
-- =============================================

ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@StoreID int = null,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID, StoreID)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID,@StoreID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID, StoreID = @StoreID
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created


GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Instrument_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Instrument_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 20/05/2011
-- Description	: Gets Instrument list for combo
-- Version		: 2
-- =============================================
-- PH TFS 13-30520 : Added optional DataTypeID for filtering instruments by DataTypeID returned
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Instrument_Combo] 
	@DataTypeID int = NULL
AS

SELECT     InstrumentID, InstrumentName

FROM         APP_Instrument

WHERE     (Hide = 0)
	AND
	(
		(@DataTypeID IS NULL)
		OR
		(@DataTypeID IS NOT NULL AND @DataTypeID = DataTypeID)
	)

ORDER BY InstrumentName
GO

-- BEGIN [dbo].[TEMP_UserData]
IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TEMP_UserData]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[TEMP_UserData](
		[UserID] [int] NULL,
		[ID1] [int] NULL,
		[ID2] [int] NULL,
		[String1] [nvarchar](255) COLLATE Latin1_General_CI_AS NULL,
		[String2] [nvarchar](255) COLLATE Latin1_General_CI_AS NULL
	) ON [PRIMARY]
END
GO
-- END [dbo].[TEMP_UserData]


PRINT 'Sorting sync procedures...'

PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
