-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'

PRINT 'Sorting indexes...'


BEGIN 

	IF EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[QMS_ResponseHeader]') and name='IX_QMS_ResponseHeader_Covered')
		DROP INDEX QMS_ResponseHeader.IX_QMS_ResponseHeader_Covered

	IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[QMS_ResponseHeader]') and name='IX_QMS_ResponseHeader_Covered')
	BEGIN 
	CREATE NONCLUSTERED INDEX [IX_QMS_ResponseHeader_Covered] ON [dbo].[QMS_ResponseHeader]
	(
		[Header_Text] ASC,
		[RecordStatus] ASC
	)
	INCLUDE ( 
		[ResponseID],
		[AssessmentHeaderID],
		[Header_Date],
		[Header_Numeric]) 
	DBCC DBREINDEX ('QMS_ResponseHeader')

	
	END
END 
GO




PRINT 'Sorting Views...'

PRINT 'Sorting User Defined Functions...'

PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ComboSource_Supplier')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ComboSource_Supplier] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		:	MBS\phil.harding
-- Create date	:	14th Sep 15
-- Description	:	Gets/Syncs a list of Supplier combo items
-- Version		:	1
-- =============================================
-- PH TFS 13-25807 :	First iteration (experimental)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ComboSource_Supplier]
	@UserID int = 0,
	@TimeStamp bigint = 0,
	@PageSize int = 0,
	@DataLookupID int = NULL
AS

-- Declare locals (avoid parameter sniffing)
DECLARE @_userId int = @UserID;
DECLARE @_timeStamp int = @TimeStamp;
DECLARE @_pageSize int = @PageSize;

-- Declare locals (operational)
DECLARE @permittedSuppliers table (SupplierID int);
DECLARE @allSuppliersPermitted bit;


-- Get permitted suppliers
INSERT INTO @permittedSuppliers SELECT SupplierID FROM dbo.FNC_User_SupplierList(@_userId);
-- If no permissions set, then all suppliers permitted
SET @allSuppliersPermitted = CAST(CASE WHEN ((SELECT COUNT(*) FROM @permittedSuppliers) = 0) THEN 1 ELSE 0 END AS BIT)

-- Calculate actual page size
IF (@_pageSize = 0)
BEGIN
	SET @_pageSize = (SELECT COUNT(*) FROM @permittedSuppliers);
END

-- Has no supplier permissions set
IF (@allSuppliersPermitted = 1)
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupID AS DataLookupID,
				supplier.SupplierID AS ComboKey,
				supplier.SupplierName AS ComboValue,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted

		FROM PM_VW_Supplier AS supplier

		WHERE ((@_timeStamp = 0) AND (supplier.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp = 1) AND (supplier.RowVersion > @_timeStamp))
		
		ORDER BY supplier.SupplierID; -- ORDER BY RowVersion

	END

-- Has supplier permissions set
ELSE
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupID AS DataLookupID,
				supplier.SupplierID AS ComboKey,
				supplier.SupplierName AS ComboValue,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(CASE WHEN (supplier.RecordStatus > 200) THEN 1 ELSE 0 END AS bit) AS IsNowDeleted

		FROM PM_VW_Supplier AS supplier

		INNER JOIN	@permittedSuppliers
				ON [@permittedSuppliers].SupplierID = supplier.SupplierID

		WHERE ((@_timeStamp = 0) AND (supplier.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp > 0) AND (supplier.RowVersion > @_timeStamp))
				
		ORDER BY supplier.SupplierID;  -- ORDER BY RowVersion

	END


GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_ArchiveData')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_ArchiveData] AS SELECT ''stub version, to be replaced''')
GO
-- ===========================================================================================
-- Author		: MBS\Mark.Powell
-- Create date	: 25/06/2010
-- Description	: Archives old data to reduce size of Mobile database
-- Version		: 6
-- ===========================================================================================
-- jf tfs 14982 - Update SYNC_ArchiveData to include PM archiving based on DateRequired
-- jf tfs 15149 - return if archive days=0
-- jf tfs 15149 - use <= for date comparrisons as if there are more than 1000 consignments with same date it doesn't work
-- PH TFS 13-27729 : Include use of new config option, MobilePurchaseOrderArchiveDays, to define which PM data is archived/erased
--jf 28649 bug with FNC_GetConfigOption
-- ===========================================================================================
ALTER PROCEDURE [dbo].[SYNC_ArchiveData] 
--exec SYNC_ArchiveData

AS

DECLARE @mobileArchiveDays int = ISNULL(dbo.FNC_GetOptionValue(20),0);
DECLARE @mobilePurchaseOrderArchiveDays int = ISNULL(NULLIF(dbo.FNC_GetOptionValue(131), ''), 0);

IF @mobilePurchaseOrderArchiveDays = 0
	SET @mobilePurchaseOrderArchiveDays = @mobileArchiveDays;

IF @mobileArchiveDays = 0
	RETURN 0;
	
DECLARE @DateFrom datetime = DATEADD(day,-@mobileArchiveDays,GETDATE())
SELECT @DateFrom

DECLARE @purchaseOrderDateFrom datetime = DATEADD(day,-@mobilePurchaseOrderArchiveDays,GETDATE())

DECLARE @LastSent bigint

PRINT 'Delete QMS_ResponseQuestionSample...'

SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_ResponseQuestionSample')

DELETE FROM QMS_ResponseQuestionSample
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom)

PRINT 'Delete QMS_ResponseQuestion...'

SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_ResponseQuestion')

DELETE FROM QMS_ResponseQuestion
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom) AND (NOT (ResponseQuestionID IN
                          (SELECT     ResponseQuestionID
                            FROM          QMS_ResponseQuestionSample)))
                            
PRINT 'Delete QMS_ResponseHeader...'

SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_ResponseHeader')

DELETE FROM QMS_ResponseHeader
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom)

PRINT 'Delete QMS_Response...'

SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_Response')

DELETE FROM QMS_Response
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom) AND (NOT (ResponseID IN
                          (SELECT     ResponseID
                            FROM          QMS_ResponseQuestion)))

-- Attachment                        
PRINT 'Delete QMS_Attachment...'
SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_Attachment')
DELETE FROM QMS_Attachment
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom) AND (AttachmentSourceID = 1)
DELETE FROM QMS_Attachment
WHERE     (RecordStatus > 200)

--Release space on attachment table
DECLARE @DBName nvarchar(255)
SET @DBName = DB_NAME()
DBCC CLEANTABLE(@DBName,'QMS_Attachment')

-- Corrective Action
PRINT 'Delete QMS_CorrectiveAction...'
SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_CorrectiveAction')
DELETE FROM QMS_CorrectiveAction
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom)

-- Notifications                     
PRINT 'Delete QMS_Notification...'
SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_Notification')
DELETE FROM QMS_Notification
WHERE     (Created < @LastSent)

-- ErrorLog
PRINT 'Delete QMS_ErrorLog...'
DELETE FROM QMS_ErrorLog
WHERE     (Occured < @DateFrom)



-- limit the amount of records deleted by getting the oldest 1000 consignment records - will take a few itterations to catch up
DECLARE @MinDateRequired DATETIME
SELECT @MinDateRequired = max(DateRequired) FROM  (SELECT TOP 1000 DateRequired FROM PM_Consignment WHERE DateRequired <= @purchaseOrderDateFrom ORDER BY DateRequired ASC) tmp

-- StockBatchItem
PRINT 'Delete PM_StockBatchItems...'
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_StockBatchItems]') AND type in (N'U'))
	DELETE FROM PM_StockBatchItems  
	WHERE StockBatchID IN 
		(SELECT StockBatchID FROM PM_StockBatchSource INNER JOIN PM_GoodsIntake ON PM_GoodsIntake.GoodsIntakeID = PM_StockBatchSource.GoodsIntakeID 
			INNER JOIN PM_ConsignmentItems ON PM_ConsignmentItems.ConsignmentID = PM_GoodsIntake.ConsignmentItemID  
			INNER JOIN PM_Consignment ON PM_ConsignmentItems.ConsignmentID  =PM_Consignment.ConsignmentID  WHERE PM_Consignment.DateRequired <= @MinDateRequired
		)

-- StockBatch
PRINT 'Delete PM_StockBatch...'
DELETE FROM PM_StockBatch 
WHERE StockBatchID IN 
		(SELECT StockBatchID FROM PM_StockBatchSource INNER JOIN PM_GoodsIntake ON PM_GoodsIntake.GoodsIntakeID = PM_StockBatchSource.GoodsIntakeID 
			INNER JOIN PM_ConsignmentItems ON PM_ConsignmentItems.ConsignmentID = PM_GoodsIntake.ConsignmentItemID  
			INNER JOIN PM_Consignment ON PM_ConsignmentItems.ConsignmentID  =PM_Consignment.ConsignmentID  WHERE PM_Consignment.DateRequired <= @MinDateRequired
		)

-- StockBatchSource
PRINT 'Delete PM_StockBatchSource...'
DELETE FROM PM_StockBatchSource
WHERE GoodsintakeID in	
		(SELECT GoodsIntakeID  FROM PM_GoodsIntake 
			INNER JOIN PM_ConsignmentItems ON PM_ConsignmentItems.ConsignmentID = PM_GoodsIntake.ConsignmentItemID  
			INNER JOIN PM_Consignment ON PM_ConsignmentItems.ConsignmentID  =PM_Consignment.ConsignmentID  WHERE PM_Consignment.DateRequired <= @MinDateRequired
		)

-- GoodsIntake
PRINT 'Delete PM_GoodsIntake...'
DELETE FROM PM_GoodsIntake 
WHERE ConsignmentItemID in 
		(SELECT ConsignmentItemID FROM PM_ConsignmentItems 
			INNER JOIN PM_Consignment ON PM_ConsignmentItems.ConsignmentID  =PM_Consignment.ConsignmentID  WHERE PM_Consignment.DateRequired <= @MinDateRequired
		)

-- ConsignmentItems
PRINT 'Delete PM_ConsignmentItems...'
DELETE FROM PM_ConsignmentItems 
WHERE ConsignmentID  IN 
		(SELECT ConsignmentID FROM PM_Consignment WHERE DateRequired <= @MinDateRequired)

-- Consignment
PRINT 'Delete PM_Consignment...'
DELETE FROM PM_Consignment WHERE DateRequired <= @MinDateRequired

SELECT     @LastSent = ISNULL(LastSent,0)
FROM         SYNC_ClientAnchor
WHERE     (TableName = N'QMS_Response')

DELETE FROM QMS_Response
WHERE     (Created < @LastSent) AND (Inserted < @DateFrom) AND (NOT (ResponseID IN
                          (SELECT     ResponseID
                            FROM          QMS_ResponseQuestion)))
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionPool_AllowSampleCombo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionPool_AllowSampleCombo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/04/2011
-- Description:	Gets all questions included in specified assessment
-- Version:		3
-- =============================================
-- Jonathan Toolan - 9 Sep 2011: Added link to only display questions that have a response.
-- TH TFS 13-1017: Moved filtered QMS_Response table data to table variable to join on.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_QuestionPool_AllowSampleCombo] 
	@AssessmentTypeID int,
	@AssessmentID int
AS

DECLARE @Question TABLE (QuestionID int)
INSERT INTO @Question
SELECT QMS_AssessmentQuestion.QuestionID FROM QMS_AssessmentQuestion  INNER JOIN
                      QMS_Assessment ON QMS_AssessmentQuestion.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
					  QMS_Response ON QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID
WHERE     ((QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_Assessment.RecordStatus < 201) AND 
					  (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID > 0) AND 
                      (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) AND (QMS_Response.AssessmentTypeID = @AssessmentTypeID)) OR
                      ((QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_Assessment.RecordStatus < 201) AND 
					  (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID = 0) AND 
                      (QMS_Response.AssessmentTypeID = @AssessmentTypeID))

SELECT DISTINCT QMS_QuestionPool.QuestionID, QMS_QuestionPool.Question
FROM         QMS_QuestionPool
WHERE QuestionID IN (SELECT QuestionID FROM @Question)
AND RecordStatus < 201
ORDER BY Question
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_DataLookupTriggers_Supplier_CaseEndBarcode')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_DataLookupTriggers_Supplier_CaseEndBarcode] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		:	MBS\phil.harding
-- Create date	:	14th Sep 15
-- Description	:	Gets/Syncs a list of Supplier combo triggers
-- Version		:	1
-- =============================================
-- PH TFS 13-25807 :	First iteration (experimental)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_DataLookupTriggers_Supplier_CaseEndBarcode]
	@UserID int = 0,
	@TimeStamp bigint = 0,
	@PageSize int = 0,
	@DataLookupTriggerID int = NULL
AS

-- Declare locals (avoid parameter sniffing)
DECLARE @_userId int = @UserID;
DECLARE @_timeStamp int = @TimeStamp;
DECLARE @_pageSize int = @PageSize;

-- Declare locals (operational)
DECLARE @permittedSuppliers table (SupplierID int);
DECLARE @allSuppliersPermitted bit;
DECLARE @permittedStockCodes table (StockCodeID int);
DECLARE @allStockCodesPermitted bit;

-- Get permitted suppliers
INSERT INTO @permittedSuppliers SELECT SupplierID FROM dbo.FNC_User_SupplierList(@_userId);
-- If no permissions set, then all suppliers permitted
SET @allSuppliersPermitted = CAST(CASE WHEN ((SELECT COUNT(*) FROM @permittedSuppliers) = 0) THEN 1 ELSE 0 END AS BIT)

-- Get permitted stockcodes
INSERT INTO @permittedStockCodes SELECT StockCodeID FROM dbo.FNC_User_StockcodeList(@_userId);
-- If no permissions set, then all suppliers permitted
SET @allStockCodesPermitted = CAST(CASE WHEN ((SELECT COUNT(*) FROM @permittedSuppliers) = 0) THEN 1 ELSE 0 END AS BIT)

-- Calculate actual page size
IF (@_pageSize = 0)
BEGIN
	SET @_pageSize = (SELECT COUNT(*) FROM @permittedSuppliers);
END

-- Has supplier no permissions
IF (@allSuppliersPermitted = 1)
BEGIN
	-- Has supplier no permissions
	IF (@allSuppliersPermitted = 1)
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupTriggerID AS DataLookupTriggerID,
				stockCodePack.StockCodePackID AS TriggerKey,
				stockCodePack.CaseEndBarcode AS TriggerValue,
				supplier.SupplierID AS SelectionKey,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted

		FROM PM_VW_StockCodePack AS stockCodePack
		
		INNER JOIN PM_VW_Supplier AS supplier
			ON supplier.SupplierID = stockCodePack.SupplierID

		WHERE (@_timeStamp = 0) -- ((@_timeStamp = 0) AND (stockCodePack.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp = 1) AND (stockCodePack.RowVersion > @_timeStamp))
		
		ORDER BY supplier.SupplierID; -- ORDER BY RowVersion

	END

	-- Has supplier permissions
	ELSE
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupTriggerID AS DataLookupTriggerID,
				stockCodePack.StockCodePackID AS TriggerKey,
				stockCodePack.CaseEndBarcode AS TriggerValue,
				supplier.SupplierID AS SelectionKey,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted --  CAST(CASE WHEN (stockCodePack.RecordStatus > 200) THEN 1 ELSE 0 END AS bit) AS IsNowDeleted

		FROM PM_VW_StockCodePack AS stockCodePack
		
		INNER JOIN PM_VW_Supplier AS supplier
			ON supplier.SupplierID = stockCodePack.SupplierID

		INNER JOIN	@permittedSuppliers
				ON [@permittedSuppliers].SupplierID = supplier.SupplierID

		WHERE (@_timeStamp = 0) -- ((@_timeStamp = 0) AND (stockCodePack.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp > 0) AND (stockCodePack.RowVersion > @_timeStamp))
				
		ORDER BY supplier.SupplierID;  -- ORDER BY RowVersion

	END
END
-- Has stockcode permissions
BEGIN
	-- Has supplier no permissions
	IF (@allSuppliersPermitted = 1)
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupTriggerID AS DataLookupTriggerID,
				stockCodePack.StockCodePackID AS TriggerKey,
				stockCodePack.CaseEndBarcode AS TriggerValue,
				supplier.SupplierID AS SelectionKey,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted

		FROM PM_VW_StockCodePack AS stockCodePack

		INNER JOIN	@permittedStockCodes
				ON [@permittedStockCodes].StockCodeID = stockCodePack.StockCodeID
		
		INNER JOIN PM_VW_Supplier AS supplier
			ON supplier.SupplierID = stockCodePack.SupplierID

		WHERE (@_timeStamp = 0) -- ((@_timeStamp = 0) AND (stockCodePack.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp = 1) AND (stockCodePack.RowVersion > @_timeStamp))
		
		ORDER BY supplier.SupplierID; -- ORDER BY RowVersion

	END

	-- Has supplier permissions
	ELSE
	BEGIN
		SELECT	TOP (@_pageSize)
				@DataLookupTriggerID AS DataLookupTriggerID,
				stockCodePack.StockCodePackID AS TriggerKey,
				stockCodePack.CaseEndBarcode AS TriggerValue,
				supplier.SupplierID AS SelectionKey,
				CAST(0 AS bigint) AS RowVersion, -- Convert(bigint, [RowVersion]) as RowVersion
				CAST(0 AS bit) AS IsNowDeleted --  CAST(CASE WHEN (stockCodePack.RecordStatus > 200) THEN 1 ELSE 0 END AS bit) AS IsNowDeleted

		FROM PM_VW_StockCodePack AS stockCodePack
		
		INNER JOIN PM_VW_Supplier AS supplier
			ON supplier.SupplierID = stockCodePack.SupplierID

		INNER JOIN	@permittedStockCodes
				ON [@permittedStockCodes].StockCodeID = stockCodePack.StockCodeID

		INNER JOIN	@permittedSuppliers
				ON [@permittedSuppliers].SupplierID = supplier.SupplierID

		WHERE (@_timeStamp = 0) -- ((@_timeStamp = 0) AND (stockCodePack.RecordStatus < 201))
				OR (@_timeStamp > 0) -- ((@_timeStamp > 0) AND (stockCodePack.RowVersion > @_timeStamp))
				
		ORDER BY supplier.SupplierID;  -- ORDER BY RowVersion

	END
END

GO

-- BEGIN [dbo].[QRY_YesNoOption_Combo]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_YesNoOption_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_YesNoOption_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =================================================================================
-- Created By   :   MBS\Phil.Harding
-- Created Date :   23rd Sep 2015
-- Description  :   Yes/No Option combo for Yes/No questions that required a bit response (very clever stuff)
-- Version		:	2
-- =================================================================================
-- PH TFS 13-27708 : Required for PO Sample Complete response report filter for AGT/Chingfords
-- PH TFS 13-27708 : Corrected naming
-- =================================================================================
alter PROCEDURE [dbo].[QRY_YesNoOption_Combo]

AS
BEGIN

	SELECT 1 AS OptionID, 'Yes' AS OptionText
	UNION
	SELECT 0 AS OptionID, 'No' AS OptionText

END


GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_YesNoOption_Combo]') AND type in (N'P', N'PC'))
	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Failed to create [dbo].[QRY_YesNoOption_Combo]', ERROR_MESSAGE()
	FROM #tmpScriptName
GO
-- END [dbo].[QRY_YesNoOption_Combo]


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_SampleReport')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_SampleReport] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 01/04/2011
-- Description:	Fills available datatable for Sample Report
-- Version:		4
-- =============================================
-- j.toolan 30 Mar 2012 - Added location.
-- JT TFS 4707: Added AssessmentType filtering on to SP.
-- TH TFS 1017: Move join to FNC_ResponseHeader() outside the main query.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_SampleReport]
	@UserID int, 
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID int = NULL
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @ATypeNames nvarchar(max)
	SELECT @ATypeNames = dbo.FNC_AssessmentNamesFromIDs(@AssessmentTypeID, @UserID)

	SET NOCOUNT OFF

	SELECT @DateFrom AS DateFrom,
			@DateTo AS DateTo, 
			@ATypeNames AS AssessmentType,
			innerQ.Question,
			innerQ.CheckNo,
			innerQ.CheckDate,
			ResponseHeader.Supplier,
			ResponseHeader.StockCode,
			innerQ.SampleNo,
			innerQ.Sample_Numeric,
			ResponseHeader.Location
	FROM dbo.FNC_ResponseHeader() AS ResponseHeader
	INNER JOIN
	(
		SELECT  QMS_QuestionPool.Question, QMS_Response.ResponseID AS CheckNo, QMS_Response.EndDate AS CheckDate, 
								dbo.FNC_NumberToAlpha(QMS_ResponseQuestionSample.SampleNo) AS SampleNo, 
								QMS_ResponseQuestionSample.Sample_Numeric
		FROM         QMS_ResponseQuestionSample INNER JOIN
								QMS_ResponseQuestion ON QMS_ResponseQuestionSample.ResponseQuestionID = QMS_ResponseQuestion.ResponseQuestionID INNER JOIN
								QMS_AssessmentQuestion INNER JOIN
								QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
								QMS_Response INNER JOIN
								TEMP_ResponseHeader ON QMS_Response.ResponseID = TEMP_ResponseHeader.AssessmentHeaderID ON 
								QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID ON 
								QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID AND 
								QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
								TEMP_Selected ON QMS_QuestionPool.QuestionID = TEMP_Selected.SelectedID
		WHERE     (TEMP_ResponseHeader.UserID = @UserID) AND (TEMP_Selected.UserID = @UserID)
	) AS innerQ
	ON ResponseHeader.ResponseID = innerQ.CheckNo
	ORDER BY innerQ.Question, innerQ.CheckDate, innerQ.SampleNo
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ProductProfile_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ProductProfile_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 04/04/2011
-- Description:	Fills TEMP_Selected with ResponseID for data to show on product profile report
-- Version:		9
-- =============================================
-- JE TFS 3061 - moved SelectedText population to separate UPDATE statement
-- JT TFS 3806 - Reinstated filtering based on ProductId and ProductText
-- JE TFS 4317 - amended filter reinstatement for reporting on PT
-- JE TFS 4668 - updated to filter by list of AssessmentTypeIDs and to handle two tier filtering
-- JT TFS 8117 - added offline reporting
-- JT TFS 13-1076 - Offline only uses SupplierResponse table (and ignores QMS_Response entries)
-- JT TFS 13-3246: Filtering matches on ID for stockcode if present.
-- JT TFS 13-28909: Remove NULL SelectedValue when filtering by Stockcode.
-- =============================================
ALTER PROCEDURE RPT_ProductProfile_FillSelected 
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@ReportOn tinyint,
    @ProductID int,
    @ProductText nvarchar(255),
    @FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
    @AssessmentTypeID_LIST nvarchar(100),
    @Offline bit = 0
AS
BEGIN
	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	-- Always assume that the filtering has been done (offline and online check live happily side by side in here)
	INSERT INTO TEMP_Selected (SelectedID, UserID)
	SELECT ResponseID, UserID FROM TEMP_ResponseFilter
	WHERE UserID = @UserID
	

	IF @Offline = 1
	BEGIN
		UPDATE TEMP_Selected
		SET		SelectedText = GroupBy.GroupByText, 
				SelectedValue = GroupBy.GroupByID
		FROM TEMP_Selected
		INNER JOIN dbo.FNC_ReportGrouping_Response_Offline(@UserID, @ReportOn) 
					AS GroupBy ON TEMP_Selected.SelectedID = GroupBy.ResponseID
		WHERE UserID = @UserID 
		

	END ELSE BEGIN -- @Offline = 0
		-- will only work on non-custom filters, but that's ok because we restrict what @ReportOn can be.
		--TFS 3060 - update table with grouping titles
		UPDATE TEMP_Selected
		SET SelectedText = GroupBy.GroupByText,
			SelectedValue = GroupBy.GroupByID 
		FROM TEMP_Selected
		INNER JOIN dbo.FNC_ReportGrouping_Response(@UserID, @ReportOn) 
				AS GroupBy ON TEMP_Selected.SelectedID = GroupBy.ResponseID
		WHERE UserID = @UserID 
					
	END

	IF @ReportOn = 2 AND @ProductID > 0 -- Reporting by stockcode always supplies ProductID.
	BEGIN
		DELETE TEMP_Selected
		WHERE UserID = @UserID
		AND (SelectedValue <> @ProductID OR SelectedValue IS NULL)
			
	END ELSE BEGIN
		-- TFS 3806 - reinstate filters
		DELETE TEMP_Selected 
		WHERE	UserID = @UserID 
		AND		((@ReportOn <> 16 AND ISNULL(SelectedText, '') <> @ProductText)
				  OR --for PT reporting, SelectedText will contain a list of PTs, so need to use LIKE
				 (@ReportOn = 16 AND ISNULL(SelectedText, '') NOT LIKE '%' + @ProductText + '%'))
	END
END
GO




PRINT 'Sorting sync procedures...'

PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
