-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'

PRINT 'Sorting indexes...'


BEGIN 

	IF EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[QMS_QuestionPool]') and name='IX_QMS_QuestionPool_Question')
		DROP INDEX QMS_QuestionPool.IX_QMS_QuestionPool_Question

	IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[QMS_QuestionPool]') and name='IX_QMS_QuestionPool_Question')
	BEGIN 
		CREATE UNIQUE NONCLUSTERED INDEX [IX_QMS_QuestionPool_Question] ON [dbo].[QMS_QuestionPool]
		(
			[Question] ASC,
			[QuestionID] ASC
		)
		DBCC DBREINDEX ('QMS_QuestionPool')
	
	END
END 
GO

PRINT 'Sorting Views...'

PRINT 'Sorting User Defined Functions...'

PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QAS_QRY_Assessment_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QAS_QRY_Assessment_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/02/2013
-- Description:	Gets data for generic QAS dashboard view
-- Version:		15
-- =============================================
-- JT TFS 5985: Added IsTempSpec and IsPrimarySupplier
-- JT TFS 8534: Added HasLinkedSites
-- JT TFS 8578: Added generic filtering if applied.
-- JT TFS 9015: Shelved assessments are always hidden from the QAS Dashboard (AssessmentStatusID of 2).
-- JT TFS 13-1729: Added StockCodeSubGroup to output display (because of filter, we are no longer able to set it from front end).
-- JT TFS 13-1729: Added Individual AssessmentID selection to update single items.
-- JT TFS 13-2453: Added SignOff_Comments
-- JT TFS 13-2914: Added SourceAssessmentID.
-- JT TFS 13-2944: Link to temp-spec-supplier now ignores deleted entries.
-- JT TFS 13-10124: Include PrimaryUserGroupID from QMS_SupplierPermission table in output.
-- JT TFS 13-10128: Send for Sign Off allowed if user is PrimarySupplier
-- JT TFS 13-11547: QAS Owner for UserGroup needs to be displayed.
-- JT TFS 13-26550: Remove parameter sniffing.
-- JT TFS 13-26550: Refactoring for consistent speed.
-- =============================================
ALTER PROCEDURE dbo.QAS_QRY_Assessment_AdminList
	@UserID int,
	@StockCodeSubGroup nvarchar(100) = NULL,
	@IsFilterApplied bit = 0,
	@AssessmentID int = NULL
AS

SET NOCOUNT ON

-- avoid parameter sniffing
DECLARE @pUserID int,
		@pStockCodeSubGroup nvarchar(100),
		@pAssessmentID int,
		@pIsFilterApplied bit
SELECT	@pUserID = @UserID,
		@pStockCodeSubGroup = @StockCodeSubGroup,
		@pAssessmentID = @AssessmentID,
		@pIsFilterApplied = @IsFilterApplied

DECLARE @TEMP_Selected TABLE (SelectedID int, UserID int)

DELETE TEMP_Selected WHERE UserID = @pUserID
IF @pAssessmentID IS NOT NULL BEGIN
	INSERT @TEMP_Selected (SelectedID, UserID)
	SELECT SourceObjectID, @pUserID FROM QMS_AssessmentTarget WHERE AssessmentID = @pAssessmentID

	SET @pIsFilterApplied = 1

END	ELSE IF @pIsFilterApplied = 1 BEGIN
	INSERT @TEMP_Selected (SelectedID, UserID)
	SELECT StockCodeID, @pUserID FROM TEMP_StockCodeFilter WHERE UserID = @pUserID

END ELSE BEGIN
	INSERT @TEMP_Selected (SelectedID, UserID)
	SELECT StockCodeID, @pUserID FROM PM_VW_StockCode WHERE StockCodeSubGroup = @pStockCodeSubGroup
END

DECLARE @tmpResult TABLE (
	[StockCodeID] [int] NOT NULL,
	[Description] [nvarchar](255) NOT NULL,
	[StockCode] [nvarchar](50) NULL,
	[TempSpecSupplier] [nvarchar](1000) NULL,
	[PrimarySupplier] [nvarchar](1000) NULL,
	[AssessmentID] [int] NOT NULL,
	[AssessmentName] [nvarchar](100) NULL,
	[Version] [nvarchar](20) NULL,
	[CheckedOutUserID] [int] NULL,
	[CheckedOutBy] [nvarchar](255) NULL,
	[AssessmentStatus] [nvarchar](50) NULL,
	[Active] [bit] NOT NULL,
	[IsTempSpec] [bit] NULL,
	[IsPrimarySupplier] [bit] NULL,
	[HasLinkedSites] [bit] NULL,
	[StockCodeSubGroup] [nvarchar](100) NULL,
	[SignOff_Comments] [nvarchar](255) NULL,
	[PreviousAssessmentID] [int] NULL,
	[SourceAssessmentID] [int] NULL,
	[PriorAssessmentDisplayText] [nvarchar](150) NULL,
	[PrimaryUserGroupID] [int] NULL,
	[PrimaryUserGroup] [nvarchar](255) NULL,
	[PrimarySupplierID] [int] NULL,
	[AssessmentGUID] [uniqueidentifier] NOT NULL
)

--IF NULLIF(object_id('tempdb..@tmpResult'), 0) IS NOT NULL DROP TABLE @tmpResult
INSERT @tmpResult
SELECT  dbo.PM_VW_StockCode.StockCodeID, 
		dbo.PM_VW_StockCode.Description,
		dbo.PM_VW_StockCode.StockCode,
		TempSpecSupplier = convert(nvarchar(1000), NULL), -- do not show in final results.
		PrimarySupplier = convert(nvarchar(1000), NULL), --CASE WHEN TempSpec_Supplier.SupplierID IS NULL THEN PrimarySupplier.SupplierName ELSE TempSpec_Supplier.SupplierName + N'*' END AS , 
		dbo.QMS_Assessment.AssessmentID,
		dbo.QMS_Assessment.AssessmentName, 
		dbo.QMS_Assessment.Version, 
		CheckedOutUserID = convert(int, NULL),--CurrentCheckOut.UserID AS CheckedOutUserID,
		CheckedOutBy = convert(nvarchar(255), NULL), --CurrentCheckOut.FullName AS CheckedOutBy, 
		dbo.APP_AssessmentStatus.AssessmentStatus, 
		dbo.APP_AssessmentStatus.Active,
		IsTempSpec = convert(bit, 0), --convert(bit, CASE WHEN TempSpec_Supplier.AssessmentID IS NULL THEN 0 ELSE 1 END) AS IsTempSpec,
		IsPrimarySupplier = convert(bit, 0),
		HasLinkedSites = convert(bit, 0), /* convert(bit, CASE WHEN EXISTS (	SELECT 1 FROM PM_VW_StockCodeLocation
															INNER JOIN PM_VW_Location ON PM_VW_StockCodeLocation.LocationID = PM_VW_Location.LocationID
															WHERE PM_VW_StockCodeLocation.StockCodeID = PM_VW_StockCode.StockCodeID) THEN 1 ELSE 0 END), */
		dbo.PM_VW_StockCode.StockCodeSubGroup,
		dbo.QMS_Assessment.SignOff_Comments,
		dbo.QMS_Assessment.PreviousAssessmentID,
		dbo.QMS_Assessment.SourceAssessmentID,
		PriorAssessmentDisplayText = convert(nvarchar(150), NULL),
		PrimaryUserGroupID = convert(int, null), --PrimarySupplier.UserGroupID AS PrimaryUserGroupID,
		PrimaryUserGroup = convert(nvarchar(255), null), --(SELECT TOP 1 FullName FROM QMS_User WHERE UserID = PrimarySupplier.UserGroupID) as PrimaryUserGroup

		PrimarySupplierID = convert(int, NULL), -- Do not show in final results.
		dbo.QMS_Assessment.GUID AS AssessmentGUID -- Do not show in final results.
FROM         dbo.QMS_AssessmentTarget 
INNER JOIN	dbo.QMS_Assessment ON dbo.QMS_AssessmentTarget.AssessmentID = dbo.QMS_Assessment.AssessmentID 
INNER JOIN	dbo.APP_AssessmentStatus ON dbo.QMS_Assessment.AssessmentStatusID = dbo.APP_AssessmentStatus.AssessmentStatusID 
INNER JOIN	dbo.FNC_User_StockCodeList(@pUserID) AS User_StockCodeList 
INNER JOIN	dbo.PM_VW_StockCode ON User_StockCodeList.StockCodeID = dbo.PM_VW_StockCode.StockCodeID 
	ON dbo.QMS_AssessmentTarget.SourceObjectID = dbo.PM_VW_StockCode.StockCodeID
INNER JOIN @TEMP_Selected AS TEMP_Selected ON TEMP_Selected.SelectedID = dbo.PM_VW_StockCode.StockCodeID AND TEMP_Selected.UserID = @pUserID
INNER JOIN	dbo.QAS_AssessmentType ON dbo.QMS_Assessment.AssessmentTypeID = dbo.QAS_AssessmentType.AssessmentTypeID 

WHERE	(dbo.PM_VW_StockCode.StockCodeSubGroup = @pStockCodeSubGroup OR @pIsFilterApplied = 1)
AND		(dbo.PM_VW_StockCode.Hide = 0)
AND		(dbo.APP_AssessmentStatus.AssessmentVisible = 1)
AND		(dbo.QMS_Assessment.AssessmentTargetTypeID = 1)
AND		(dbo.QMS_Assessment.RecordStatus < 201)
AND		(dbo.QMS_AssessmentTarget.RecordStatus < 201)
AND		(dbo.QAS_AssessmentType.Hide = 0)
AND		(dbo.QMS_Assessment.AssessmentStatusID <> 2) -- Hide shelved assessments
AND		(@pAssessmentID IS NULL OR dbo.QMS_Assessment.AssessmentID = @pAssessmentID)



UPDATE result
SET IsTempSpec = 1,
	TempSpecSupplier = assessmentspecheader.Spec_Text + N'*'
FROM @tmpResult result
INNER JOIN	dbo.QMS_AssessmentSpecHeader as assessmentspecheader ON assessmentspecheader.AssessmentID = result.AssessmentID 
INNER JOIN  dbo.QMS_SpecificationHeader AS specheader ON specheader.SpecificationHeaderID = assessmentspecheader.SpecificationHeaderID
WHERE      (specheader.Sys_SpecHeader = N'TempSpec_Supplier')
AND specheader.RecordStatus < 201
AND assessmentspecheader.RecordStatus < 201




UPDATE result
SET PrimaryUserGroupID = PrimarySupplier.UserGroupID,
	PrimarySupplierID = PrimarySupplier.SupplierID
FROM @tmpResult result
INNER JOIN 
	(	SELECT     dbo.QMS_SupplierPermissions.PermissionSourceID AS StockCodeID, 
					dbo.QMS_SupplierPermissions.SupplierID, 
					dbo.QMS_SupplierPermissions.UserGroupID
		FROM          dbo.QMS_SupplierPermissions 
		WHERE   (dbo.QMS_SupplierPermissions.PermissionType = 1) 
		AND		(dbo.QMS_SupplierPermissions.PermissionAllow = 1)) AS PrimarySupplier 
	ON	result.StockCodeID = PrimarySupplier.StockCodeID 

UPDATE result
SET PrimaryUserGroup = [user].FullName
FROM @tmpResult result
INNER JOIN QMS_User as [user] ON result.PrimaryUserGroupID = [user].UserID

UPDATE result
SET PrimarySupplier = PrimarySupplier.SupplierName
FROM @tmpResult result
INNER JOIN dbo.PM_VW_Supplier AS PrimarySupplier ON PrimarySupplier.SupplierID = result.PrimarySupplierID



UPDATE result
SET 	CheckedOutUserID = CurrentCheckOut.UserID,
		CheckedOutBy = CurrentCheckOut.FullName
FROM @tmpResult result
INNER JOIN 
	(
		SELECT     dbo.VW_RecordLock_Current.RowGUID, dbo.VW_RecordLock_Current.UserID, dbo.QMS_User.FullName
		FROM          dbo.VW_RecordLock_Current 
		INNER JOIN	dbo.QMS_User ON dbo.VW_RecordLock_Current.UserID = dbo.QMS_User.UserID
		WHERE      (dbo.VW_RecordLock_Current.ObjectName = N'QMS_Assessment')
	) AS CurrentCheckOut 
	ON	result.AssessmentGUID = CurrentCheckOut.RowGUID


UPDATE result
SET PriorAssessmentDisplayText = assessment.AssessmentName  + ' v' + assessment.[Version]
FROM @tmpResult result
INNER JOIN dbo.QMS_Assessment as assessment ON assessment.AssessmentID = isnull(result.SourceAssessmentID, result.PreviousAssessmentID)


UPDATE result
SET HasLinkedSites = 1
FROM @tmpResult as result
INNER JOIN PM_VW_StockCodeLocation ON PM_VW_StockCodeLocation.StockCodeID = result.StockCodeID
INNER JOIN PM_VW_Location ON PM_VW_StockCodeLocation.LocationID = PM_VW_Location.LocationID
														

SET NOCOUNT OFF


SELECT StockCodeID, [Description], StockCode,
		PrimarySupplier, 
		AssessmentID, AssessmentName, [Version], 
		CheckedOutUserID, CheckedOutBy, 
		AssessmentStatus, Active,
		IsTempSpec, IsPrimarySupplier,
		HasLinkedSites, 
		StockCodeSubGroup, SignOff_Comments,
		PreviousAssessmentID, SourceAssessmentID, PriorAssessmentDisplayText,
		PrimaryUserGroupID, PrimaryUserGroup
FROM @tmpResult as result
ORDER BY [Description]

GO


-- BEGIN [dbo].[QMS_AssessmentHeader]

IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_AssessmentHeader' AND c.name = 'MustMatchParent' )
BEGIN TRY

	ALTER TABLE [dbo].[QMS_AssessmentHeader]
		ADD [MustMatchParent] [bit] NOT NULL DEFAULT ((0))

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Alter MustMatchParent in QMS_AssessmentHeader table', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO

-- END [dbo].[QMS_AssessmentHeader]

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentHeader_VariableList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentHeader_VariableList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 03/04/2013
-- Description:	Gets variable header info for specified type (used for Multi checks)
-- Version:		2
-- =============================================
-- JE TFS 6292 - added AllowCopy column
-- TS TFS 26601 - added MustMatchParent column
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentHeader_VariableList]
	@AssessmentTypeID int
AS
BEGIN
	SELECT	'QMS_AssessmentHeader' AS DataSource, QMS_AssessmentHeader.AssessmentHeaderID AS AssessmentSourceID,
				CAST(QMS_AssessmentHeader.ListIndex AS nvarchar(20)) AS SortNumber, QMS_AssessmentHeader.HeaderText AS AttributeText,
				QMS_AssessmentHeader.DataTypeID, QMS_AssessmentHeader.DataLookupID, APP_DataLookup.SourceObjectColumn,
				QMS_AssessmentHeader.CustomLookupID, QMS_AssessmentHeader.ResponseRequired, APP_DataLookup.DataTypeID AS Lookup_DataTypeID,
				QMS_AssessmentHeader.ClearForNewCheck, APP_DataLookup.IsCombo, QMS_AssessmentHeader.AllowEdit, QMS_AssessmentHeader.AllowCopy, QMS_AssessmentHeader.MustMatchParent
	FROM	QMS_AssessmentHeader LEFT OUTER JOIN
				APP_DataLookup ON QMS_AssessmentHeader.DataLookupID = APP_DataLookup.DataLookupID
	WHERE	(QMS_AssessmentHeader.AssessmentTypeID = @AssessmentTypeID) AND (QMS_AssessmentHeader.RecordStatus < 201) AND 
				(QMS_AssessmentHeader.Hide = 0) AND (QMS_AssessmentHeader.AssessmentID IS NULL) AND (VariableItem = 1)
	ORDER BY QMS_AssessmentHeader.ListIndex, QMS_AssessmentHeader.HeaderText
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionPool_AllowSampleCombo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionPool_AllowSampleCombo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/04/2011
-- Description:	Gets all questions included in specified assessment
-- Version:		3
-- =============================================
-- Jonathan Toolan - 9 Sep 2011: Added link to only display questions that have a response.
-- TH TFS 13-1017: Moved filtered QMS_Response table data to table variable to join on.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_QuestionPool_AllowSampleCombo] 
	@AssessmentTypeID int,
	@AssessmentID int
AS

DECLARE @QMS_Response TABLE
(
	AssessmentID INT,
	AssessmentTypeID INT,
	RecordStatus INT
)

-- Make sure we join onto filtered data to reduce execution time. This table can be HUGE!
INSERT INTO @QMS_Response
SELECT AssessmentID, AssessmentTypeID, RecordStatus
FROM QMS_Response
WHERE RecordStatus < 201 AND AssessmentTypeID = @AssessmentTypeID

SELECT DISTINCT QMS_QuestionPool.QuestionID, QMS_QuestionPool.Question
FROM         QMS_QuestionPool INNER JOIN
                      QMS_AssessmentQuestion ON QMS_QuestionPool.QuestionID = QMS_AssessmentQuestion.QuestionID INNER JOIN
                      QMS_Assessment ON QMS_AssessmentQuestion.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      @QMS_Response AS QMS_Response ON QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID
WHERE     (QMS_QuestionPool.RecordStatus < 201) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_Assessment.RecordStatus < 201) AND 
                      --(QMS_Response.RecordStatus < 201) AND (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID > 0) AND 
					  (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID > 0) AND 
                      (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) AND (QMS_Response.AssessmentTypeID = @AssessmentTypeID) OR
                      (QMS_QuestionPool.RecordStatus < 201) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_Assessment.RecordStatus < 201) AND 
                      --(QMS_Response.RecordStatus < 201) AND (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID = 0) AND 
					  (QMS_AssessmentQuestion.HasSamples = 1) AND (@AssessmentID = 0) AND 
                      (QMS_Response.AssessmentTypeID = @AssessmentTypeID)
ORDER BY QMS_QuestionPool.Question
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_AssessmentHeader')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_AssessmentHeader] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: Unknown
-- Description:	Imports an assessment header from web service data into mobile.
-- Version:		2
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_AssessmentHeader] 
	@AssessmentHeaderID int,
	@AssessmentTypeID int,
	@AssessmentID int,
	@HeaderText nvarchar(50),
	@DataTypeID int,
	@DataLookupID int,
	@CustomLookupID int,
	@ListIndex int,	
	@ResponseRequired bit,
	@Hide bit,
	@ClearForNewCheck bit,
	@HideFromReports bit,
	@AllowMultiSelect bit,
	@AllowEdit bit,
	@MatchRepeatCheck bit = 0,
	@AllowCopy bit = 0,
	@VariableItem BIT = NULL,
	@MustMatchParent bit = 0,
	@UserID int,
	@MachineName nvarchar(255),
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @VariableItem IS NULL
	SET @VariableItem = 0

IF NOT EXISTS(SELECT AssessmentHeaderID FROM QMS_AssessmentHeader WHERE (AssessmentHeaderID = @AssessmentHeaderID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		SET IDENTITY_INSERT QMS_AssessmentHeader ON
		INSERT INTO QMS_AssessmentHeader (
				AssessmentHeaderID, AssessmentTypeID, AssessmentID, HeaderText, DataTypeID, DataLookupID, CustomLookupID, ListIndex, ResponseRequired, Hide, 
                ClearForNewCheck, HideFromReports, AllowMultiSelect, AllowEdit, MatchRepeatCheck, AllowCopy, VariableItem, 
				MustMatchParent,
				UserID, MachineName, RecordStatus, Inserted, 
                Updated, Deleted, GUID)
		VALUES     (	@AssessmentHeaderID,@AssessmentTypeID,@AssessmentID,@HeaderText,@DataTypeID,@DataLookupID,@CustomLookupID,@ListIndex,@ResponseRequired,@Hide,
						@ClearForNewCheck,@HideFromReports,@AllowMultiSelect,@AllowEdit,@MatchRepeatCheck,@AllowCopy,@VariableItem,
						@MustMatchParent,
						@UserID,@MachineName,@RecordStatus,@Inserted,@Updated,@Deleted,@GUID)
		SET @InsertCount = @@rowcount
		SET IDENTITY_INSERT QMS_AssessmentHeader OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_AssessmentHeader
	SET              AssessmentTypeID = @AssessmentTypeID, AssessmentID = @AssessmentID, HeaderText = @HeaderText, DataTypeID = @DataTypeID, 
                      DataLookupID = @DataLookupID, CustomLookupID = @CustomLookupID, ListIndex = @ListIndex, ResponseRequired = @ResponseRequired, Hide = @Hide, 
                      ClearForNewCheck = @ClearForNewCheck, HideFromReports = @HideFromReports, AllowMultiSelect = @AllowMultiSelect, AllowEdit = @AllowEdit, 
                      MatchRepeatCheck = @MatchRepeatCheck, AllowCopy = @AllowCopy, VariableItem = @VariableItem, MustMatchParent = @MustMatchParent,
					  UserID = @UserID, MachineName = @MachineName, 
                      RecordStatus = @RecordStatus, Inserted = @Inserted, Updated = @Updated, Deleted = @Deleted
	WHERE     (AssessmentHeaderID = @AssessmentHeaderID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


PRINT 'Sorting sync procedures...'

PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
