-- =============================================
-- Author:		Jeremy Formby
-- Create date: 27/05/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'


PRINT 'Sorting indexes...'


PRINT 'Sorting Views...'


PRINT 'Sorting User Defined Functions...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_UserGetPasswordExpiry')
	EXEC('CREATE FUNCTION [dbo].[FNC_UserGetPasswordExpiry]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- ========================================================
-- Author:		Jonathan Toolan
-- Create date: 22/05/2013
-- Description:	Returns user's current password expiry date
-- Version:		2
-- ========================================================
-- JT TFS 6630 - Created
-- JT TFS 13-20389: Sometimes an entry is uploaded by mobile which is an older one, but which 
--                  has a larger PasswordID. Get the latest ExpiryDate in the system for the user instead.
-- ========================================================
ALTER FUNCTION dbo.FNC_UserGetPasswordExpiry(@UserID int) 
RETURNS datetime
AS
BEGIN
	RETURN ISNULL(
		CASE WHEN ISNULL(dbo.FNC_GetOptionValue(46), 0) = 0 THEN NULL
			 ELSE (	
					SELECT max(ExpiryDate) 
					FROM QMS_UserPassword
					WHERE UserID = @UserID
			 ) END
			, dateadd(day, 1, getdate()))
END
GO


PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_User_Unlock')
	EXEC ('CREATE PROCEDURE [dbo].[SP_User_Unlock] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 18/09/2013
-- Description:	Procedure to reinstate a user account
-- Version:		2
-- =============================================
ALTER PROCEDURE [dbo].[SP_User_Unlock]
	@Username NVARCHAR(255),
	@FullName NVARCHAR(255)
AS
BEGIN
	DECLARE @UserID INT

	SELECT @UserID = MAX(UserID) FROM dbo.QMS_User WHERE UserName = @Username

	IF @UserID IS NULL
	BEGIN
		SELECT 'Username not found!' AS [Result]
		RETURN -1
	END

	DECLARE @Password NVARCHAR(255)

	SELECT @Password = MAX(Password) FROM dbo.QMS_UserPassword
	WHERE UserID = @UserID AND ExpiryDate > GETDATE()

	IF @UserID = 1 AND @Password IS NULL
	BEGIN
		SET @Password = N'E1A2F3931A22B9A3235E880DF6FD0137'
		PRINT 'Using default muddy password'
	END

	UPDATE  dbo.QMS_User
	SET     FullName = @FullName ,
			LeftCompany = 0 ,
			RecordStatus = 20 ,
			Updated = GETDATE() ,
			Password = @Password
	WHERE   UserID = @UserID

	IF @@ROWCOUNT<=0
	BEGIN
		SELECT 'Failed to unlock user!' AS [Result]
		RETURN -1
	END
	ELSE
	BEGIN
		IF @Password IS NULL
			SELECT 'User successfully unlocked! You will need to reissue a password' AS [Result]
		ELSE
			SELECT 'User successfully unlocked!' AS [Result]
		RETURN 0
	END
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveActionUser')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveActionUser] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 06/01/2015
-- Description:	Saves CA user data to QMS_CorrectiveActionUser
-- Version:		6
-- =============================================
-- JE TFS 13-12635: created
-- JE TFS 13-13404: amended INSERT for unassigned users into QMS_CorrectiveActionUser
-- JT TFS 13-14013: Simplified code, and remove corrective actions that you no longer have permission to see.
-- JT TFS 13-21031: Do not call delete code or update code if there are no CA users when starting the SP.
-- JT TFS 13-21873: Bug in insert would not insert items if the user had other corrective actions visible.
-- =============================================
ALTER PROCEDURE SAVE_CorrectiveActionUser
	@CorrectiveActionID int
AS
BEGIN
	SET NOCOUNT ON

	IF nullif(object_id('tempdb..#tmpCorrectiveActionUser'), 0) IS NOT NULL DROP TABLE #tmpCorrectiveActionUser
	CREATE TABLE #tmpCorrectiveActionUser (
		UserID int,
		Assigned bit
	)

	-- We want #tmpCorrectiveActionUser to contain exactly what QMS_CorrectiveAction should eventually contain.
	INSERT INTO #tmpCorrectiveActionUser(UserID, Assigned)
	SELECT UserID, 1
	FROM dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()
	WHERE CorrectiveActionID = @CorrectiveActionID 

	INSERT INTO #tmpCorrectiveActionUser (UserID, Assigned)
	SELECT UserID, 0
	FROM dbo.FNC_GENERATE_CorrectiveAction_UserList(@CorrectiveActionID) as userlist
	WHERE UserID NOT IN (SELECT UserID FROM #tmpCorrectiveActionUser)
	
	DECLARE @IsExistingCAUsers bit 
	SELECT @IsExistingCAUsers = CASE WHEN EXISTS (	SELECT 'Y' FROM QMS_CorrectiveActionUser 
													WHERE CorrectiveActionID = @CorrectiveActionID) THEN 1 ELSE 0 END

	IF @IsExistingCAUsers = 1
	BEGIN
		-- DELETE REMOVED ONES
		DELETE QMS_CorrectiveActionUser
		FROM QMS_CorrectiveActionUser
		LEFT OUTER JOIN #tmpCorrectiveActionUser CAUser ON CAUser.UserID = QMS_CorrectiveActionUser.UserID
		WHERE QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID
		AND CAUser.UserID IS NULL -- delete ones which aren't in temp table.

		-- UPDATE EXISTING
		UPDATE QMS_CorrectiveActionUser
		SET Assigned = CAUser.Assigned,
			Updated = GETUTCDATE()
		FROM QMS_CorrectiveActionUser
		INNER JOIN #tmpCorrectiveActionUser as CAUser ON CAUser.UserID = QMS_CorrectiveActionUser.UserID
														AND QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID 
		WHERE QMS_CorrectiveActionUser.Assigned <> CAUser.Assigned
	END

	-- INSERT MISSING
	INSERT QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
	SELECT @CorrectiveActionID, CAUser.UserID, CAUser.Assigned 
	FROM #tmpCorrectiveActionUser AS CAUser
	LEFT OUTER JOIN QMS_CorrectiveActionUser ON CAUser.UserID = QMS_CorrectiveActionUser.UserID
											AND QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID 
	WHERE QMS_CorrectiveActionUser.CorrectiveActionID IS NULL -- insert ones which aren't in the main table.

	DROP TABLE #tmpCorrectiveActionUser

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		14
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- PH TFS 13-21031: 10/06/2015 - Got rid of code smell that may have been causing bug.  New CorrectiveActionID obtained OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int,
	@CATitle nvarchar(50),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		DECLARE @caIdTable TABLE (CorrectiveActionID int)

		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
				OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         @caIdTable
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Comparison_AQCSummary_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Comparison_AQCSummary_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- ===============================================================
-- Author:		Jon Edwards
-- Create date: 24/11/2011
-- Description:	Fills temp table for AQC Summary Comparison Report
-- Version:		4
-- =======================================================
-- MP TFS 6530: Procedure now allows for no AQC location and filters on ArrivalDate
-- MP TFS 7274: Added distinct to initial insert statement
-- jf TFS 6334 - select arrival checks based on DUDate or Arrival (not just DU date)
-- ===============================================================
ALTER PROCEDURE [dbo].[RPT_Comparison_AQCSummary_FillSelected]
	@UserID int,
	@AssessmentID int,
	@DateFrom datetime,
	@DateTo datetime
AS
BEGIN

--clear temp selected
DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

--insert AQC checks for supplier/locations in TEMP_ResponseHeader
INSERT INTO		TEMP_Selected (SelectedID, UserID)
SELECT			DISTINCT QMS_SupplierResponse.ResponseID, UserID
FROM			TEMP_ResponseHeader INNER JOIN
                      QMS_SupplierResponse ON (TEMP_ResponseHeader.Header_SourceID = QMS_SupplierResponse.LocationID OR TEMP_ResponseHeader.Header_SourceID = -1) AND 
                      TEMP_ResponseHeader.AssessmentTargetTypeID = QMS_SupplierResponse.SupplierID
WHERE			(TEMP_ResponseHeader.UserID = @UserID) AND (QMS_SupplierResponse.RecordStatus < 201) AND
					((QMS_SupplierResponse.DUDate BETWEEN @DateFrom AND @DateTo) OR (QMS_SupplierResponse.ArrivalDate BETWEEN @DateFrom AND @DateTo))
					 AND (QMS_SupplierResponse.AssessmentTypeID = 16) AND
					(QMS_SupplierResponse.AssessmentID = @AssessmentID)

--insert Arrival checks for selected Assessment
INSERT INTO		TEMP_Selected (SelectedID, UserID)
SELECT			ResponseID, @UserID
FROM			QMS_SupplierResponse
WHERE			(RecordStatus < 201) AND (AssessmentTypeID = 2) AND
				(DUDate BETWEEN @DateFrom AND @DateTo OR QMS_SupplierResponse.ArrivalDate BETWEEN @DateFrom AND @DateTo)  
				AND (AssessmentID = @AssessmentID)

END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_Validate')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_Validate] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 26/06/2008
-- Description:	Procedure to validate user credentials
-- Version:		4
-- =============================================
-- j.toolan 8/3/2012 Added code to allow password to be sent using md5 or sha2
-- j.toolan 11/1/2013 Code to always allow RC4 (for sync server) authentication.
-- JT TFS 6792: Added code to make sure that locked accounts cannot log in.
-- S Irving: Removed ', *' from the SELECT list
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_Validate] 
	@Username nvarchar(255), 
	@Password nvarchar(255),
	@PIN nvarchar(10) = NULL
AS

-- RC4  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = 'E1A2F3931A22B9A3235E880DF6FD0137', @PIN nvarchar(10) = NULL
-- MD5  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = '1c952787aef6aed213e3e7764556dd', @PIN nvarchar(10) = NULL
-- SHA2 -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = 'pyj5ztrNCr0/VoXgKWpln2DpQZSoBoLNCZM+yq/srj8=', @PIN nvarchar(10) = NULL
-- PIN  -- declare @Username nvarchar(255) = 'muddy', @Password nvarchar(255) = NULL, @PIN nvarchar(10) = '1234'

-- AQC user: -- declare @Username nvarchar(255) = 'wealmoor.AQC', @Password nvarchar(255) = '4F5DD615F790EDC53514816DB90CB6D83400D082', @PIN nvarchar(10) = NULL

SET NOCOUNT ON

DECLARE @EncryptionMode int
SELECT @EncryptionMode = CONVERT(int, APP_Config.OptionValue)
FROM APP_Config 
WHERE OptionID = 61 --PasswordEncryption
AND ISNUMERIC(APP_Config.OptionValue) = 1
IF (@EncryptionMode IS NULL)
	SET @EncryptionMode = 0

SET NOCOUNT OFF

SELECT     QMS_User.UserID, QMS_User.FullName, ISNULL(UserGroup.UserLevel, QMS_User.UserLevel) AS UserLevel, APP_CountryLocales.CountryLocaleID, 
                      APP_CountryLocales.StringCode
FROM         QMS_User LEFT OUTER JOIN
                      APP_CountryLocales ON QMS_User.LocaleID = APP_CountryLocales.CountryLocaleID LEFT OUTER JOIN
                          (SELECT     UserID, FullName, UserLevel
                            FROM          QMS_User AS QMS_User_Group
                            WHERE      (IsUserGroup = 1) AND (RecordStatus < 201) AND (LeftCompany = 0)) AS UserGroup ON QMS_User.ParentUserID = UserGroup.UserID
WHERE   (QMS_User.UserName = @Username) 
AND (QMS_User.RecordStatus < 201) 
AND (QMS_User.IsUserGroup = 0) 
AND (QMS_User.Password IS NOT NULL) -- Stop locked accounts getting in.
AND (
		(QMS_User.PIN = @PIN AND @PIN IS NOT NULL)
/* Only config encryption method allowed (but exact match (RC4) allowed for sync) */	
	OR	(QMS_User.Password = @Password) 
	OR  (QMS_User.Password_MD5 = @Password AND @EncryptionMode = 1)
	OR  (QMS_User.Password_SHA2 = @Password AND @EncryptionMode = 2) --*/
)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_TEMP_ResponseHeader_RepeatCheckReponse')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 09/06/2011
-- Description:	Lookup previous assessments with matching header responses for repeat checks
-- Version: 7
-- =============================================
-- JE TFS 4162 - added checking of QMS_ResponseHeader.Header_Date too so date fields can be matched for repeat checks
-- JE TFS 5105 CAS-15187-CW55FM - added extra clause in date matching sub query as this was picking up values other than just dates
-- MP TFS 5246 - query failed when more than 1 header date field existed in list to match
-- JF TFS 2279 - Make change to repeat check process so that it can copy across assessment types - this will match on assessment header text rather than ID
-- JE TFS 13-10513: check config value to see if incomplete checks can be used to fill repeat check responses
-- MP TFS 13-21544: populated header data in table variable before comparing to resolve issues with dates
-- =============================================
ALTER PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse] 
					
	@UserID int, 
	@AssessmentID int
AS

SET NOCOUNT ON

--get option value for EnableRepeatCheckProcess
DECLARE @RepeatForIncompleteChecks int
SELECT @RepeatForIncompleteChecks = dbo.FNC_GetOptionValue(52)

DECLARE @ResponseCount int

--get number of header responses that need to match for a repeat check to be performed
SELECT     @ResponseCount = COUNT(*)
FROM         TEMP_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (TEMP_ResponseHeader.UserID = @UserID) AND (QMS_AssessmentHeader.MatchRepeatCheck = 1)

DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

IF @ResponseCount > 0
BEGIN

	DECLARE @Header TABLE (AssessmentHeaderID int, Header_Text nvarchar(255),Header_Date smalldatetime)
	INSERT INTO @Header (AssessmentHeaderID,Header_Text,Header_Date)
	SELECT     AssessmentHeaderID, Header_Text, CASE WHEN ISDATE(TEMP_ResponseHeader.Header_Text) = 1 AND 
												  TEMP_ResponseHeader.Header_Text LIKE '%[ /-\]%' THEN DATEADD(dd, 0, DATEDIFF(dd, 0, 
												  CAST(TEMP_ResponseHeader.Header_Text AS smalldatetime))) ELSE CAST(NULL AS smalldatetime) END AS Header_Date
						   FROM          TEMP_ResponseHeader
						   WHERE      (UserID = @UserID)
							   
	INSERT INTO TEMP_Selected (SelectedID, SelectedValue, UserID)
	SELECT     QMS_ResponseHeader.ResponseID, COUNT(QMS_ResponseHeader.ResponseHeaderID) AS HeaderCount, @UserID AS UserID
	FROM  @Header AS TEMP_Header 
	INNER JOIN  QMS_ResponseHeader ON TEMP_Header.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID AND 
	(TEMP_Header.Header_Text = QMS_ResponseHeader.Header_Text OR  TEMP_Header.Header_Date = DATEADD(dd, 0, DATEDIFF(dd, 0, CAST(QMS_ResponseHeader.Header_Date AS smalldatetime)))) 
	INNER JOIN  QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID 
	INNER JOIN  QMS_AssessmentHeader ON TEMP_Header.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE     
		(QMS_Response.AssessmentID = @AssessmentID) AND 
		(QMS_Response.RecordStatus < 201) AND 
		(QMS_ResponseHeader.RecordStatus < 201) AND 
		((@RepeatForIncompleteChecks = 1 AND QMS_Response.ResponseStatus = 1) OR (@RepeatForIncompleteChecks = 2)) AND
		(QMS_AssessmentHeader.MatchRepeatCheck = 1)
	GROUP BY QMS_ResponseHeader.ResponseID
	HAVING      (COUNT(QMS_ResponseHeader.ResponseHeaderID) = @ResponseCount)
	ORDER BY QMS_ResponseHeader.ResponseID DESC
	
	
	--if cant find a match, check in other assessment types but will have to join on HeaderText rather than AssessmentHeaderID
	IF NOT EXISTS (SELECT SelectedID FROM TEMP_Selected WHERE UserID = @UserID)
		   
		INSERT INTO TEMP_Selected (SelectedID, SelectedValue, UserID)
		SELECT     QMS_ResponseHeader.ResponseID, COUNT(QMS_ResponseHeader.ResponseHeaderID) AS HeaderCount, @UserID AS UserID
		FROM    @Header AS TEMP_Header 
		INNER JOIN  QMS_AssessmentHeader as QMS_AssessmentHeader_DEST ON TEMP_Header.AssessmentHeaderID = QMS_AssessmentHeader_DEST.AssessmentHeaderID
		INNER JOIN QMS_AssessmentHeader as QMS_AssessmentHeader_SRC ON QMS_AssessmentHeader_SRC.HeaderText = QMS_AssessmentHeader_DEST.HeaderText 
		INNER JOIN  QMS_ResponseHeader ON QMS_AssessmentHeader_SRC.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID AND 
		(TEMP_Header.Header_Text = QMS_ResponseHeader.Header_Text OR  TEMP_Header.Header_Date = DATEADD(dd, 0, DATEDIFF(dd, 0, CAST(QMS_ResponseHeader.Header_Date AS smalldatetime)))) 
		INNER JOIN  QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID 

		WHERE     
			(QMS_Response.AssessmentID = @AssessmentID) AND 
			(QMS_Response.RecordStatus < 201) AND 
			(QMS_ResponseHeader.RecordStatus < 201) AND 
			((@RepeatForIncompleteChecks = 1 AND QMS_Response.ResponseStatus = 1) OR (@RepeatForIncompleteChecks = 2)) AND
			--(QMS_AssessmentHeader.MatchRepeatCheck = 1)
			(QMS_AssessmentHeader_DEST.MatchRepeatCheck = 1) AND
			
			(QMS_AssessmentHeader_DEST.AssessmentHeaderID  = QMS_AssessmentHeader_SRC.AssessmentHeaderID  OR
			exists --check the assessment links
				(
				SELECT AssessmentTypeMultiID 
				FROM 	QMS_Assessment INNER JOIN QMS_AssessmentTypeMulti ON QMS_AssessmentTypeMulti.AssessmentID=QMS_Assessment.AssessmentID 
				WHERE QMS_Assessment.AssessmentID = @AssessmentID and 
				QMS_AssessmentTypeMulti.RecordStatus <201 and 
				QMS_Assessment.AssessmentTypeID = QMS_AssessmentHeader_DEST.AssessmentTypeID and 
				QMS_AssessmentTypeMulti.AssessmentTypeID = QMS_AssessmentHeader_SRC.AssessmentTypeID
				)
			)		
			
		GROUP BY QMS_ResponseHeader.ResponseID
		HAVING      (COUNT(QMS_ResponseHeader.ResponseHeaderID) = @ResponseCount)
		ORDER BY QMS_ResponseHeader.ResponseID DESC
		

END
SET NOCOUNT OFF

SELECT     SelectedID AS ResponseID
FROM         TEMP_Selected
WHERE     (UserID = @UserID)

GO



PRINT 'Sorting sync procedures...'


PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
