-- =============================================
-- Author:		Jon Edwards
-- Create date: 07/01/2015
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 55v2
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

PRINT 'Inserting tables...'

/****** Object:  Table [dbo].[QMS_CorrectiveActionUser]    Script Date: 16/01/2015 11:34:36 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QMS_CorrectiveActionUser]') AND type in (N'U'))
DROP TABLE [dbo].[QMS_CorrectiveActionUser]
GO
/****** Object:  Table [dbo].[QMS_CorrectiveActionUser]    Script Date: 16/01/2015 11:34:36 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QMS_CorrectiveActionUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[QMS_CorrectiveActionUser](
	[CorrectiveActionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Assigned] [bit] NOT NULL CONSTRAINT [DF_QMS_CorrectiveActionUser_Assigned]  DEFAULT ((0)),
	[Updated] [datetime] NULL
) ON [PRIMARY]
END
GO

PRINT 'Updating tables...'

IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'QMS_SupplierResponse' AND c.name = 'Barcode' )
BEGIN TRY
	alter table QMS_SupplierResponse add
		Barcode nvarchar(max)

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Alter Barcode in QMS_SupplierResponse table'
	FROM #tmpScriptName
	
END CATCH
GO

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

PRINT 'Updating User Defined Functions...'

/****** Object:  UserDefinedFunction [dbo].[FNC_User_CorrectiveActionList]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_User_CorrectiveActionList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_Selected]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_ResponseHeader_Selected]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_UserList]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_UserList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_CorrectiveAction_UserList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_AssignUsers]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_AssignUsers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_CorrectiveAction_AssignUsers]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_StockCodeID]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_User_CorrectiveActionList]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_GENERATE_User_CorrectiveActionList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_CorrectiveAction_UserList]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_CorrectiveAction_UserList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_GENERATE_CorrectiveAction_UserList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveActionUser_CAList]    Script Date: 16/01/2015 11:23:37 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveActionUser_CAList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_CorrectiveActionUser_CAList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveActionUser_CAList]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveActionUser_CAList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- ===================================================
-- Author:		Jon Edwards
-- Create date:	12/01/2015
-- Description:	Returns a list of Corrective Actions a user can access
-- Version:		1
-- ===================================================
-- JE TFS 13-12640: created
-- ===================================================
CREATE FUNCTION [dbo].[FNC_CorrectiveActionUser_CAList]
(
	@UserID int
)
RETURNS @CorrectiveActions TABLE
(
	CorrectiveActionID int
)
AS
BEGIN

	INSERT INTO @CorrectiveActions (CorrectiveActionID)
	SELECT	CorrectiveActionID
	FROM	QMS_CorrectiveActionUser
	WHERE	(UserID = @UserID)

	RETURN

END
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_CorrectiveAction_UserList]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_CorrectiveAction_UserList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 06/01/2015
-- Description:	Returns list of users with visibility of a Corrective Action
-- Version: 1
-- =============================================
-- JE TFS 13-9973: created
-- =============================================
CREATE FUNCTION [dbo].[FNC_GENERATE_CorrectiveAction_UserList]
(
	@CorrectiveActionID int
)
RETURNS
@Users TABLE
(
	UserID int
)
AS
BEGIN

	--get CA''s LocationID
	DECLARE @LocationID int
	SELECT @LocationID = LocationID FROM QMS_CorrectiveAction WHERE CorrectiveActionID = @CorrectiveActionID

	--get CA''s SupplierID
	DECLARE @SupplierID int
	SELECT @SupplierID = AssignSupplierID FROM QMS_CorrectiveAction WHERE CorrectiveActionID = @CorrectiveActionID

	--get StockCodeID for CA linked at check level
	DECLARE @StockCodeID int
	SELECT	@StockCodeID = QMS_ResponseHeader.Header_SourceID
	FROM	QMS_ResponseHeader
			INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			INNER JOIN QMS_CorrectiveAction ON QMS_ResponseHeader.ResponseID = QMS_CorrectiveAction.SourceObjectID
	WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
			AND (QMS_CorrectiveAction.CASourceID = 1)
			AND (QMS_AssessmentHeader.DataTypeID = 9)
			AND (QMS_AssessmentHeader.DataLookupID = 2)

	--get StockCodeID for CA linked at question level if CA not linked at check level
	IF @StockCodeID IS NULL
		SELECT	@StockCodeID = QMS_ResponseHeader.Header_SourceID
		FROM	QMS_ResponseQuestion
				INNER JOIN QMS_ResponseHeader ON QMS_ResponseQuestion.ResponseID = QMS_ResponseHeader.ResponseID
				INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID		
				INNER JOIN QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID
		WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
				AND (QMS_CorrectiveAction.CASourceID = 2)
				AND (QMS_AssessmentHeader.DataTypeID = 9)
				AND (QMS_AssessmentHeader.DataLookupID = 2)

	--get BusinessGroup and StockCodeSubGroup for CA''s StockCodeID (if CA has one)
	IF @StockCodeID IS NOT NULL
	BEGIN
		DECLARE @BusinessGroup AS nvarchar(50)
		SELECT @BusinessGroup = BusinessGroup FROM PM_VW_StockCode WHERE StockCodeID = @StockCodeID

		DECLARE @StockCodeSubGroup AS nvarchar(50)
		SELECT @StockCodeSubGroup = StockCodeSubGroup FROM PM_VW_StockCode WHERE StockCodeID = @StockCodeID
	END

	--get users with permissions to the LocationID
	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			INNER JOIN QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
	WHERE	(PermissionType = 103) AND (PermissionAllow = 1) AND (PermissionTitle = @LocationID)

	--get users with permissions to the SupplierID
	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			INNER JOIN QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
	WHERE	(PermissionType = 101) AND (PermissionAllow = 1) AND (PermissionTitle = @SupplierID)
			AND NOT EXISTS (SELECT UserID FROM @Users WHERE UserID = QMS_User.UserID)

	--get users with permissions to the StockCodeID (need to check three levels of hierarchy: Business Group, Sub Group and Stock Code)
	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			INNER JOIN QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
	WHERE	((PermissionType = 106) AND (PermissionAllow = 1) AND (PermissionTitle = @BusinessGroup))
			AND NOT EXISTS (SELECT UserID FROM @Users WHERE UserID = QMS_User.UserID)

	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			INNER JOIN QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
	WHERE	((PermissionType = 105) AND (PermissionAllow = 1) AND (PermissionTitle = @StockCodeSubGroup))
			AND NOT EXISTS (SELECT UserID FROM @Users WHERE UserID = QMS_User.UserID)

	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			INNER JOIN QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
	WHERE	((PermissionType = 104) AND (PermissionAllow = 1) AND (PermissionTitle = @StockCodeID))
			AND NOT EXISTS (SELECT UserID FROM @Users WHERE UserID = QMS_User.UserID)

	--table of all users with Location permissions
	DECLARE @LocationPermissions TABLE (UserID int, LocationID int)
	INSERT INTO @LocationPermissions
	SELECT DISTINCT	UserID, PermissionTitle
	FROM	QMS_UserPermissions
	WHERE	(PermissionType = 103) AND (PermissionAllow = 1)

	--get admin users or users with no specific Location permissions as they still have visibility of it
	INSERT INTO @Users
	SELECT	QMS_User.UserID
	FROM	QMS_User
			LEFT OUTER JOIN @LocationPermissions AS LocationPermissions ON QMS_User.UserID = LocationPermissions.UserID
	WHERE	(QMS_User.UserLevel = 1) --admin can see all CAs
			OR
			((QMS_User.UserLevel <> 1) AND (LocationPermissions.UserID IS NULL)) --show CAs to non-admin users if they have NO location permissions
			OR
			((QMS_User.UserLevel <> 1) AND (LocationPermissions.LocationID <> ISNULL(@LocationID, 0))) --show CAs to non-admin users if they have Location permissons but the CA has NO LocationID
			AND NOT EXISTS (SELECT UserID FROM @Users WHERE UserID = QMS_User.UserID)

	RETURN

END
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_User_CorrectiveActionList]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 27/01/2012
-- Description:	Returns list of Corrective Actions
-- Version: 1
-- =============================================
-- JE TFS 13-9973: created
-- =============================================
CREATE FUNCTION [dbo].[FNC_GENERATE_User_CorrectiveActionList]
(
	@UserID int,
	@IsActive bit
)
RETURNS
@CorrectiveActions TABLE
(
	CorrectiveActionID int
)
AS
BEGIN

	--Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserLevel = 1 --Admin can see hidden/void checks
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 180
	
	DECLARE @Table_Location TABLE (LocationID int)
	
	--updated in TFS 2757 - only make CAs available to Suppliers if CA is associated with permitted supplier
	IF @UserLevel = 9
	BEGIN
	
		--Get table of available locations
		INSERT INTO @Table_Location (LocationID)
		SELECT     CAST(PermissionTitle AS int) AS LocationID
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 103) AND (PermissionAllow = 1) AND (UserID = @UserID)
		
		--Get table of permitted Suppliers for user
		DECLARE @Table_Supplier TABLE (SupplierID int)
		INSERT INTO @Table_Supplier (SupplierID)
		SELECT		PermissionTitle AS SupplierID
		FROM		QMS_UserPermissions
		WHERE		(PermissionType = 101) AND (PermissionAllow = 1) AND (UserID = @UserID)		
	
		--If just Supplier permissions
		IF (SELECT COUNT (LocationID) FROM @Table_Location)=0 AND (SELECT COUNT (SupplierID) FROM @Table_Supplier)>0
		--Check CA status
		BEGIN
			--get CAs which are assigned to Supplier(s) user has permission on
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	QMS_CorrectiveAction.CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)))
		END
		
		--If Supplier AND Location permissions
		IF (SELECT COUNT (LocationID) FROM @Table_Location)>0 AND (SELECT COUNT (SupplierID) FROM @Table_Supplier)>0
		BEGIN
			--Table of ResponseIDs linked to locations
			DECLARE @Table_ResponseLocationSupplier TABLE (ResponseID int, ResponseStatus int, LocationID int)
			INSERT INTO @Table_ResponseLocationSupplier (ResponseID, ResponseStatus, LocationID)
			SELECT	QMS_Response.ResponseID, QMS_Response.ResponseStatus, User_Location.LocationID
			FROM	QMS_Response INNER JOIN
						  (SELECT	ResponseHeader_Location.ResponseID, ResponseHeader_Location.Header_SourceID AS LocationID
							FROM		QMS_ResponseHeader AS ResponseHeader_Location INNER JOIN
											QMS_AssessmentHeader AS AssessmentHeader_Location ON 
											ResponseHeader_Location.AssessmentHeaderID = AssessmentHeader_Location.AssessmentHeaderID INNER JOIN
											@Table_Location AS Location ON ResponseHeader_Location.Header_SourceID = Location.LocationID
							WHERE	(AssessmentHeader_Location.DataTypeID = 9) AND (AssessmentHeader_Location.DataLookupID = 4 OR 
											AssessmentHeader_Location.DataLookupID = 53)) AS User_Location ON 
					QMS_Response.ResponseID = User_Location.ResponseID
			WHERE     (QMS_Response.RecordStatus < @RecordStatus)

			--get CAs linked to Suppliers and Locations user has permissions on - where CA linked to question
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID LEFT OUTER JOIN
						QMS_ResponseQuestion ON QMS_CorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
						@Table_ResponseLocationSupplier AS ResponseLocationSupplier ON QMS_ResponseQuestion.ResponseID = ResponseLocationSupplier.ResponseID
			WHERE	((@IsActive = 1 AND CAStatusID IN (1,2,3,6) AND CASourceID = 2) --Check for CAs that are New, In Progress, Failed or Rejected
					OR
					(@IsActive = 0 AND CAStatusID NOT IN (1,2,3,6))  AND CASourceID = 2)
					--suppliers with supplier permissions will always have location permissions for that supplier too, so check responses have a location supplier has permission for
					AND ResponseLocationSupplier.LocationID IS NOT NULL
					
			--get CAs linked to Suppliers and Locations user has permissions on - where CA linked to check
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID LEFT OUTER JOIN
						@Table_ResponseLocationSupplier AS ResponseLocationSupplier ON QMS_CorrectiveAction.SourceObjectID = ResponseLocationSupplier.ResponseID
			WHERE	((@IsActive = 1 AND CAStatusID IN (1,2,3,6) AND CASourceID = 1) --Check for CAs that are New, In Progress, Failed or Rejected
					OR
					(@IsActive = 0 AND CAStatusID NOT IN (1,2,3,6))  AND CASourceID = 1)
					--suppliers with supplier permissions will always have location permissions for that supplier too, so check responses have a location supplier has permission for
					AND ResponseLocationSupplier.LocationID IS NOT NULL
		END
	END
	
--User Level is not 9 (Supplier), check Stock Code hierarchy permissions if they are assigned and that user''s Location permissions
	IF @UserLevel <> 9
	BEGIN
		--Get table of available Locations user has permissions for
		INSERT INTO @Table_Location (LocationID)
		SELECT	CAST(PermissionTitle AS int) AS LocationID
		FROM	QMS_UserPermissions
		WHERE	(PermissionType = 103) AND (PermissionAllow = 1) AND (UserID = @UserID)

		--get table of CAs that are linked to above Locations
		DECLARE @Table_LocationCorrectiveAction TABLE (CorrectiveActionID int, SourceObjectID int, CAStatusID int, CASourceID int)
		INSERT INTO @Table_LocationCorrectiveAction (CorrectiveActionID, SourceObjectID, CAStatusID, CASourceID)
		SELECT	CorrectiveActionID, SourceObjectID, CAStatusID, CASourceID
		FROM	QMS_CorrectiveAction
		WHERE	((@UserLevel <> 1) AND (LocationID IN (SELECT LocationID FROM @Table_Location))) --restrict non-admin users visiblity of CAs to those assigned to their Location(s) only
					OR
				(@UserLevel = 1) --Admin can access all CAs
					OR
				((@UserLevel <> 1) AND (SELECT COUNT(LocationID) FROM @Table_Location) = 0) --show all CAs if user has NO Location permissions
						OR
				((QMS_CorrectiveAction.LocationID IS NULL) OR (QMS_CorrectiveAction.LocationID = 0)) --also include all CAs that aren''t assigned to a Location
	
		--get Stock Code permissions for user
		DECLARE @Table_UserStockCodes TABLE (ResponseID int, StockCodeID int)
		INSERT INTO @Table_UserStockCodes (ResponseID, StockCodeID)
		SELECT	ResponseHeader_StockCode.ResponseID, ResponseHeader_StockCode.Header_SourceID AS StockCodeID
		FROM	QMS_ResponseHeader AS ResponseHeader_StockCode INNER JOIN
					QMS_AssessmentHeader AS AssessmentHeader_StockCode ON ResponseHeader_StockCode.AssessmentHeaderID = AssessmentHeader_StockCode.AssessmentHeaderID INNER JOIN
					dbo.FNC_User_StockCodeList(@UserID) AS StockCodes ON ResponseHeader_StockCode.Header_SourceID = StockCodes.StockCodeID
		WHERE	(AssessmentHeader_StockCode.DataTypeID = 9) AND (AssessmentHeader_StockCode.DataLookupID = 2)
		
		DECLARE @ca_staging TABLE (CorrectiveActionID int)
		IF  (SELECT COUNT (UserPermissionID) FROM QMS_UserPermissions WHERE (UserID = @UserID) AND (PermissionAllow = 1) AND (PermissionType IN (104,105,106))) > 0 --user has Stock Code permissions, so check these
		BEGIN
			--get Question Level CAs linked to StockCodes user has permission to
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						QMS_ResponseQuestion ON LocationCorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID INNER JOIN
						@Table_UserStockCodes AS User_StockCodes ON	QMS_ResponseQuestion.ResponseID = User_StockCodes.ResponseID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 2))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 2))
		
			--get CAs linked at check level
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						@Table_UserStockCodes AS User_StockCodes ON	LocationCorrectiveAction.SourceObjectID = User_StockCodes.ResponseID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 1))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 1))
			
			--get Ad-Hoc CAs (not linked to a Response)
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction
			WHERE	(((@IsActive = 1) AND (CASourceID = 4) AND (CAStatusID IN (1,2,3,6)))
					OR
					((@IsActive = 0) AND (CASourceID = 4) AND (CAStatusID NOT IN (1,2,3,6))))
		END
		ELSE
		BEGIN
			--get Question Level CAs
			INSERT INTO @ca_staging(CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						QMS_ResponseQuestion ON LocationCorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 2))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 2))
					
			--get CAs linked at check level and Ad-Hoc CAs (not linked to a Response)
			INSERT INTO @ca_staging(CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID IN (1,4)))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID IN (1,4)))
		END

		INSERT INTO @CorrectiveActions(CorrectiveActionID)
		SELECT CorrectiveActionID FROM @ca_staging 
		GROUP BY CorrectiveActionID

	END
	RETURN
END
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_StockCodeID]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets stock code id for responses
-- Version:		4
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- =============================================
CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID] 
(
)
RETURNS 
@ResponseHeader TABLE 
(
	ResponseID int,
	StockCodeID int
)
AS
BEGIN
	--Add header where stock code selected
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, QMS_ResponseHeader.Header_SourceID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_ResponseHeader.Header_SourceID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) 
                      AND (QMS_AssessmentHeader.DataLookupID IN (2, 35)) AND (QMS_AssessmentHeader.RecordStatus < 201)

	--Add consignment item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_ConsignmentItems ON QMS_ResponseHeader.Header_SourceID = PM_VW_ConsignmentItems.ConsignmentItemID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 6) AND
				(QMS_AssessmentHeader.RecordStatus < 201) AND NOT (QMS_Response.ResponseID IN (SELECT ResponseID FROM @ResponseHeader))
	
	--Add delivery item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_GoodsIntake ON QMS_ResponseHeader.Header_SourceID = PM_VW_GoodsIntake.GoodsIntakeID INNER JOIN
                      PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 8) AND
				(QMS_AssessmentHeader.RecordStatus < 201) AND NOT (QMS_Response.ResponseID IN (SELECT ResponseID FROM @ResponseHeader))

	RETURN 
END


' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_AssignUsers]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_AssignUsers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Markp
-- Create date: 19/06/2009
-- Description:	Gets all users assigned to each corrective action
-- Version:		3
-- =============================================
-- JE TFS 275 added third SELECT to get assigned Supplier users
-- JE TFS 13-?: rework to make use of QMS_CorrectiveActionUser table
-- =============================================
CREATE FUNCTION [dbo].[FNC_CorrectiveAction_AssignUsers]
()
RETURNS TABLE 
AS
RETURN 
(
	SELECT	CorrectiveActionID, UserID
	FROM	QMS_CorrectiveActionUser
	WHERE	(Assigned = 1)
)
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_UserList]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_UserList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 06/01/2015
-- Description:	Returns list of users with visibility of a Corrective Action
-- Version: 2
-- =============================================
-- JE TFS 13-12635: created
-- JE TFS 13-?: rework to make use of QMS_CorrectiveActionUser table
-- =============================================
CREATE FUNCTION [dbo].[FNC_CorrectiveAction_UserList]
(
	@CorrectiveActionID int
)
RETURNS TABLE
AS
RETURN
(
	SELECT	UserID
	FROM	QMS_CorrectiveActionUser
	WHERE	(CorrectiveActionID = @CorrectiveActionID)
)
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Markp
-- Create date: 19/06/2009
-- Description:	Gets all users assigned to each corrective action
-- Version: 1
-- =============================================
-- JE TFS 13-9973: created
-- =============================================
CREATE FUNCTION [dbo].[FNC_GENERATE_CorrectiveAction_AssignUsers]
()
RETURNS TABLE 
AS
RETURN 
(
	SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_NotificationGroupUser.UserID
	FROM         QMS_CorrectiveAction INNER JOIN
						  QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID INNER JOIN
						  QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID
	WHERE     (QMS_NotificationGroup.RecordStatus < 201) AND (QMS_NotificationGroupUser.RecordStatus < 201)
	UNION
	SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_User.UserID
	FROM         QMS_CorrectiveAction INNER JOIN
                      QMS_User ON QMS_CorrectiveAction.AssignUserID = QMS_User.UserID
	WHERE     (QMS_User.RecordStatus < 201)
	UNION
	SELECT     QMS_CorrectiveAction.CorrectiveActionID, QMS_User.UserID
	FROM         QMS_CorrectiveAction INNER JOIN
					  QMS_UserPermissions ON QMS_CorrectiveAction.AssignSupplierID = QMS_UserPermissions.PermissionTitle INNER JOIN
                      QMS_User ON QMS_UserPermissions.UserID = QMS_User.UserID
	WHERE     (QMS_UserPermissions.PermissionType = 101) AND(QMS_UserPermissions.PermissionAllow = 1) AND (QMS_User.UserLevel = 9) AND (QMS_User.RecordStatus < 201)
)

' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_Selected]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Unknown
-- Create date: 01/01/2010
-- Description:	Gets summary of response header data for reporting
-- Version:		3
-- =============================================
-- JMF TFS 1005 - not showing stockcode
-- MP TFS 12467 - Added Location column and NOLOCK hint
-- =============================================
CREATE FUNCTION [dbo].[FNC_ResponseHeader_Selected]
(
	@UserID int
)
RETURNS TABLE
AS
RETURN
(
	SELECT        ResponseID, MAX(Supplier) AS Supplier, MAX(StockCode) AS StockCode, MAX(Location) AS Location
	FROM            (SELECT        QMS_ResponseHeader.ResponseID, CASE WHEN DataLookupID = 1 THEN Header_Text ELSE NULL END AS Supplier, CASE WHEN DataLookupID IN (2, 6, 8, 35, 43) THEN Header_Text ELSE NULL 
														END AS StockCode, CASE WHEN DataLookupID = 4 THEN Header_Text ELSE NULL END AS Location
							  FROM            QMS_ResponseHeader WITH (NOLOCK) INNER JOIN
														QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
														TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
							  WHERE        (QMS_AssessmentHeader.DataLookupID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_ResponseHeader.Header_Text IS NOT NULL) AND 
														(QMS_ResponseHeader.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID)) AS ResponseHeader
	GROUP BY ResponseID
)


' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_User_CorrectiveActionList]    Script Date: 16/01/2015 11:23:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 27/01/2012
-- Description:	Returns list of Corrective Actions
-- Version: 19
-- =============================================
-- TFS 2757 added Supplier permission filtering
-- TFS 3003 Locations now picking up DataLookupID 53 (suppier site) too
-- TFS 3321 Added Business Group and Stock Code Sub Group permission checking
-- TFS 3509 Corrected filtering so able to handle Supplier AND Location permissions
-- TFS 4094 Supplier AND Location filtering changed to not show ad-hoc CAs.
-- JE TFS 4279 Simplified and added Stock Code permission checking
-- JE TFS 5485 Ad Hoc CAs (not linked to any location or stock code) now returned too
-- JE TFS 5690 Added Ad Hoc CA selection to Supplier selects
-- JE TFS 5642 Ad-Hoc CAs assigned directly to users are now displayed
-- JE TFS 5857 Removed redundant code and corrected Ad-Hoc CA visibility
-- JE TFS 6004 Added check that Responses always have a Location that Supplier has permission on
-- MP TFS 5873 Added code to handle CAs links to checks (not questons)
-- JE TFS 6185 Updated for non-Supplier users with check whether to apply Stock Code permissions or not
-- JE TFS 7839 Updated to filter available CAs by a (non-supplier) user''s location permissons
-- JE TFS 7982 Updated to include CAs where no location is assigned
-- JE TFS 8045 Updated to include CAs where LocationID = 0 (i.e. no Location assigned)
-- JE TFS 7586 Include Failed (CAStatusID 3) and Rejected (6) CAs where IsActive = True
-- JT TFS 13-3845 AVoid use of union when joining on stockcode to improve performance
-- JE TFS 13-?: rework to make use of QMS_CorrectiveActionUser table
-- =============================================
CREATE FUNCTION [dbo].[FNC_User_CorrectiveActionList]
(
	@UserID int,
	@IsActive bit
)
RETURNS TABLE
AS
RETURN
(
	SELECT	QMS_CorrectiveActionUser.CorrectiveActionID
	FROM	QMS_CorrectiveActionUser
			INNER JOIN QMS_CorrectiveAction ON QMS_CorrectiveActionUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
	WHERE	QMS_CorrectiveActionUser.UserID = @UserID
			AND	(((@IsActive = 1) AND (QMS_CorrectiveAction.CAStatusID IN (1,2,3,6)))
					OR
				 ((@IsActive = 0) AND (QMS_CorrectiveAction.CAStatusID NOT IN (1,2,3,6))))
)
' 
END

GO

/****** Object:  UserDefinedFunction [dbo].[FNC_Response_StockCodeID]    Script Date: 21/01/2015 13:55:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_Response_StockCodeID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_Response_StockCodeID]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_Response_IsApproved]    Script Date: 21/01/2015 13:55:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_Response_IsApproved]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_Response_IsApproved]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_Response_IsApproved]    Script Date: 21/01/2015 13:55:06 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_Response_IsApproved]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 27/11/2014
-- Description:	Determines whether an AQC child check response has been approved
-- Version:		1
-- =============================================
-- JE TFS 13-9699: created
-- JE TFS 13-11903: added provision for QAActionID = 16
-- =============================================
CREATE FUNCTION [dbo].[FNC_Response_IsApproved](@ResponseID int)
	RETURNS tinyint
AS
BEGIN
	RETURN (SELECT TOP 1 CASE WHEN QAActionID IN (15,16) THEN 1 ELSE 0 END
			FROM	QMS_ResponseAction
			WHERE	(QMS_ResponseAction.ResponseID = @ResponseID))
END
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_Response_StockCodeID]    Script Date: 21/01/2015 13:55:06 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_Response_StockCodeID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		MartinP
-- Create date: 20/01/2015
-- Description:	Gets stock code id for response
-- Version:		1
-- =============================================
-- MartinP TFS 13-13907 Made into single use function for use with CROSS APPLY
-- =============================================
CREATE FUNCTION [dbo].[FNC_Response_StockCodeID] 
(
	@ResponseID int
)
RETURNS 
@ResponseHeader TABLE 
(
	ResponseID int,
	StockCodeID int
)
AS
BEGIN
	--Add header where stock code selected
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, QMS_ResponseHeader.Header_SourceID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_ResponseHeader.Header_SourceID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) 
                      AND (QMS_AssessmentHeader.DataLookupID IN (2, 35)) AND (QMS_AssessmentHeader.RecordStatus < 201)
					  AND QMS_Response.ResponseID = @ResponseID

	--Add consignment item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_ConsignmentItems ON QMS_ResponseHeader.Header_SourceID = PM_VW_ConsignmentItems.ConsignmentItemID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 6) AND
				(QMS_AssessmentHeader.RecordStatus < 201) AND NOT (QMS_Response.ResponseID IN (SELECT ResponseID FROM @ResponseHeader))
						  AND QMS_Response.ResponseID = @ResponseID

	--Add delivery item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_Response INNER JOIN
                      QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_GoodsIntake ON QMS_ResponseHeader.Header_SourceID = PM_VW_GoodsIntake.GoodsIntakeID INNER JOIN
                      PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID
	WHERE     (QMS_Response.RecordStatus < 201) AND (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 8) AND
				(QMS_AssessmentHeader.RecordStatus < 201) AND NOT (QMS_Response.ResponseID IN (SELECT ResponseID FROM @ResponseHeader))
									  AND QMS_Response.ResponseID = @ResponseID
	RETURN 
END
' 
END

GO


PRINT 'Updating Stored Procedures...'
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UP_NotificationGroupUser_Delete]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UP_NotificationGroupUser_Delete]
GO



/****** Object:  StoredProcedure [dbo].[SAVE_UserPermissions]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_UserPermissions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_UserPermissions]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroupUser]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroupUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_NotificationGroupUser]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroup]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_NotificationGroup]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveAction]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveAction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_CorrectiveAction]
GO
/****** Object:  StoredProcedure [dbo].[RPT_CorrectiveActionDetail]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_CorrectiveActionDetail]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_CorrectiveActionDetail]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Response_PreviousList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CustomLookupItem_NamedList]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CustomLookupItem_NamedList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_List]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_List]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_CorrectiveAction_List]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_Select]    Script Date: 16/01/2015 11:29:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_Select]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Assessment_Select]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_Select]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_Select]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Assessment_Select] AS' 
END
GO
-- =============================================      
-- Author:  Jonathan Toolan      
-- Create date: 14/02/2013     
-- Description: Gets an assessment  
-- Version:  5
-- =============================================      
-- JT TFS 5986 - Created  
-- JT TFS 8592 - Added AssessmentStatus
-- JT TFS 13-1729 - Added TempSpec
-- JT TFS 13-10128 - Added PrimaryUserGroupID
-- JT TFS 13-12578 - Exclude UserGroupIDs which are not allowed.
-- =============================================      
ALTER PROCEDURE [dbo].[QRY_Assessment_Select]
	@UserID int = NULL,  
	@AssessmentID int = NULL      
AS      
BEGIN
	SELECT		AssessmentID, AssessmentTypeID, AssessmentName, [Version],
				StockCodeID = (SELECT TOP 1 StockCodeID FROM dbo.FNC_Assessment_StockCodeID() WHERE AssessmentID = QMS_Assessment.AssessmentID),
				AssessmentStatusID,
				AssessmentStatus = (SELECT TOP 1 AssessmentStatus FROM APP_AssessmentStatus WHERE AssessmentStatusID = QMS_Assessment.AssessmentStatusID),
				TempSpec,
				PrimaryUserGroupID = (	SELECT TOP 1 UserGroupID FROM QMS_SupplierPermissions
										WHERE PermissionAllow = 1
										AND PermissionSourceID = (SELECT TOP 1 StockCodeID 
																	FROM dbo.FNC_Assessment_StockCodeID() 
																	WHERE AssessmentID = QMS_Assessment.AssessmentID))
	FROM         QMS_Assessment
	WHERE     (AssessmentID = @AssessmentID)
END

GO
/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_List]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_List]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_List] AS' 
END
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	20/5/2014
-- Description:	Lists all corrective actions for corrective action manager screen.
-- Version:		4
-- ===================================================
-- JT TFS 13-3845: Created
-- JT TFS 13-7000: Order by DateOccurred DESC, so that any truncations chop off old CAs first.
-- JT TFS 13-8870: Add source column.
-- JE TFS 13-12640: use new function to get corrective actions from QMS_CorrectiveActionUser
-- ===================================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_List]
	@UserID int = 1,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@IsFilterApplied bit = 0
AS
BEGIN
	/* NOTE: Supplier and location filters work differently. All other filters are response filters. */

	-- NOTE: DateDeadline is the first sort order for completed.
	--       DateFailed is the first sort order for failed.
	--       DateCompleted is the first sort order for signed off.

	BEGIN -- setup temp tables 
		SET NOCOUNT ON 
		
		IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
		CREATE TABLE #tmpUserCAs (
			CorrectiveActionID int
		)
		
		IF @IsFilterApplied = 1
		BEGIN
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT CorrectiveActionID FROM TEMP_CorrectiveActionFilter
			WHERE UserID = @UserID
		
		END ELSE BEGIN
		
			--temp table containing all CAs (i.e. all statuses) user has permission to see
			INSERT INTO	#tmpUserCAs (CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	dbo.FNC_CorrectiveActionUser_CAList(@UserID)
			
		END

		--populate temp table with CA refs and their Reviewers' names
		IF nullif(object_id('tempdb..#tmpCAReviewers'), 0) IS NOT NULL DROP TABLE #tmpCAReviewers
		CREATE TABLE #tmpCAReviewers (
			CorrectiveActionID int,
			Reviewers nvarchar(500)
		)
		INSERT INTO #tmpCAReviewers
		SELECT	CorrectiveActionID, dbo.FNC_CorrectiveAction_ReviewList(QMS_CorrectiveAction.CorrectiveActionID) AS Reviewers
		FROM	QMS_CorrectiveAction
		
		SET NOCOUNT OFF
	END 

	SELECT 
			QMS_CorrectiveAction.CorrectiveActionID,
			dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) AS CARef,
			CAResponseList.ResponseID,
			QMS_CorrectiveAction.CATitle,
			QMS_CorrectiveAction.CASubTitle,
			QMS_CorrectiveAction.CAReason,
			QMS_CorrectiveAction.CARequired,
			QMS_CorrectiveAction.ActionTaken,
			QMS_CorrectiveAction.Comments,
			ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS [Status],
			CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (1,2) THEN 'new'
			     WHEN APP_CorrectiveActionStatus.CAStatusID IN (4,5) THEN 'completed'
																	 ELSE 'failed' END AS [StatusClass],
			APP_PriorityLevel.PriorityLevel,
			QMS_CorrectiveAction.DateOccurred,
			QMS_CorrectiveAction.DateLogged,
			QMS_CorrectiveAction.DateDeadline,
			QMS_CorrectiveActionType.CorrectiveActionType,
			QMS_CorrectiveActionEscalation.ListIndex AS [EscalationLevel],
			PM_VW_Location.LocationName AS Location,
			ISNULL(QMS_NotificationGroup.NotificationGroup, ISNULL(QMS_User_Assign.FullName, Supplier_Assign.SupplierName)) AS [AssignedTo],
			QMS_User_Logged.FullName AS [LoggedBy],
			QMS_CorrectiveAction.DateFailed,
			QMS_CorrectiveAction.DateCompleted,
			QMS_User_Completed.FullName AS [CompletedBy],
			CAReviewers.Reviewers AS [ReviewedBy],
			QMS_User_SignedOff.FullName AS [SignedOffBy],
			QMS_CorrectiveAction.DateSignedOff,
			QMS_CorrectiveAction.CAStatusID,

			CASE WHEN QMS_CorrectiveAction.CASourceID = 4 THEN N'Ad-Hoc'
					 WHEN QMS_CorrectiveAction.CASourceID = 3 THEN N'CA: ' + dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.SourceObjectID)
					 WHEN QMS_CorrectiveAction.CASourceID = 2 THEN 'Question'
					 WHEN QMS_CorrectiveAction.CASourceID = 1 THEN 'Check'
			END AS [Source],

			IsOutstanding = CASE WHEN APP_CorrectiveActionStatus.CAStatusID < 3 THEN 1 ELSE 0 END,
			IsLoggedByMe = CASE WHEN QMS_CorrectiveAction.Logged_UserID = @UserID THEN 1 ELSE 0 END,
			IsAssignedToMe = CASE WHEN EXISTS (	SELECT * FROM dbo.FNC_CorrectiveAction_AssignUsers() AssignUser 
												WHERE AssignUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
												AND AssignUser.UserID = @UserID) THEN 1 ELSE 0 END,
			IsCompleted = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 4 THEN 1 ELSE 0 END,
			IsFailed = CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (3,6,7) THEN 1 ELSE 0 END,
			IsSignedOff = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 5 THEN 1 ELSE 0 END
		
	FROM QMS_CorrectiveAction
	INNER JOIN #tmpUserCAs AS UserCAList ON QMS_CorrectiveAction.CorrectiveActionID = UserCAList.CorrectiveActionID
	INNER JOIN #tmpCAReviewers AS CAReviewers ON UserCAList.CorrectiveActionID = CAReviewers.CorrectiveActionID
	INNER JOIN dbo.FNC_CorrectiveAction_Response() AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
	INNER JOIN APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	INNER JOIN QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID
	LEFT OUTER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
	LEFT OUTER JOIN QMS_CorrectiveActionType ON QMS_CorrectiveActionType.CorrectiveActionTypeID = QMS_CorrectiveAction.CorrectiveActionTypeID 
	LEFT OUTER JOIN QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID
	LEFT OUTER JOIN QMS_User AS QMS_User_SignedOff ON QMS_CorrectiveAction.SignOff_UserID = QMS_User_SignedOff.UserID
	LEFT OUTER JOIN APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
	LEFT OUTER JOIN PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
	LEFT OUTER JOIN PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID 
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR DateOccurred > @DateFrom)-- OR DateDeadline > @DateFrom OR DateCompleted > @DateFrom OR DateFailed > @DateFrom)
	AND (@DateTo IS NULL OR DateOccurred <= @DateTo)-- OR DateDeadline <= @DateTo OR DateCompleted <= @DateTo OR DateFailed <= @DateTo)
	ORDER BY	QMS_CorrectiveAction.DateOccurred DESC,
				QMS_CorrectiveAction.CorrectiveActionID DESC

	--get list of columns that need to be hidden in Excel export
	--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
	SELECT	1 AS TableIndex, convert(bit, 1) as ExportSetupTable, 'Portrait/Landscape' AS Orientation, 'n/a' AS SheetName, 'n/a' AS HiddenColumns
	UNION SELECT 0, 0, 'Landscape', 'Corrective Actions', 'CAStatusID,StatusClass,IsOutstanding,IsLoggedByMe,IsAssignedToMe,IsCompleted,IsFailed,IsSignedOff'
	ORDER BY TableIndex ASC

END

GO
/****** Object:  StoredProcedure [dbo].[QRY_CustomLookupItem_NamedList]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CustomLookupItem_NamedList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList] AS' 
END
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 14/08/2013
-- Description:	Gets list of lookup items for selected list by system name
-- Version:		2
-- =============================================
-- JT TFS 7337 - Lookup custom lookups by name
-- PH TFS 13-4850 - Join in flag colours to get data to front end. 
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList] 
	@SysLookupName nvarchar(50)
AS

SELECT     item.CustomLookupItemID, item.LookupText, item.QAFlagID, flag.QAFlagForeColour, flag.QAFlagBackColour 
FROM         QMS_CustomLookupItem item
INNER JOIN QMS_CustomLookup customlookup ON customlookup.CustomLookupID = item.CustomLookupID 
LEFT OUTER JOIN APP_QAFlag as flag ON flag.QAFlagID = item.QAFlagID
WHERE     (customlookup.Sys_Lookup  = @SysLookupName) AND (item.RecordStatus < 201) AND (item.Hide = 0)
ORDER BY item.ListIndex, item.LookupText

GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		20
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- MP TFS 13-12735: Added logic to check for AQC approval config setting
-- jf 13042 - AQC may not be multicheck so allow for it
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport
AS 
    BEGIN
        SET NOCOUNT ON
    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
        DECLARE @AssessmentFormat INT
        SELECT  @AssessmentFormat = AssessmentFormat
        FROM    APP_AssessmentType
        WHERE   AssessmentTypeID = @AssessmentTypeID


		DECLARE @multiCheckDisplay INT;
        SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
										THEN  1    --show parent checks only for previouschecks screen
										WHEN @AssessmentFormat = 6 THEN 1
										ELSE 2
									END
									
		DECLARE @AQCApproval bit
		SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0)

        IF ( @AssessmentTypeID_LIST IS NULL ) 
            SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID)

--Clear temp table
        DELETE  FROM TEMP_Selected
        WHERE   ( UserID = @UserID )

--Fill temp table
        IF @IsFilterApplied = 0 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     QMS_Response.ResponseID, @UserID AS UserID
				FROM         QMS_Response INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID INNER JOIN
                      dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString ON QMS_Response.AssessmentTypeID = SplitString.Token

            END
        ELSE 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     ResponseID, @UserID AS UserID
				FROM         TEMP_ResponseFilter
				WHERE     (UserID = @UserID)

            END

        SET NOCOUNT OFF

        IF @AssessmentTypeID_LIST = '2' --Arrival check
            BEGIN
                SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Supplier, ResponseHeader.StockCode, 
                      ResponseHeader.Location, QMS_Response.StartDate, QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, 
                      QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, 
                      CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
				FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag AS APP_QAFlag_1) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
				WHERE     
				
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding IS NULL) 
					OR                      
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding = 1) AND 
                    (QMS_Response.ResponseStatus = 0) 
                    OR
                    (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
                    (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
                    (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
                    (@ShowOutstanding = 0) AND 
                    (QMS_Response.ResponseStatus <> 0)
                    
				ORDER BY QMS_Response.EndDate DESC
            END
        ELSE 
            IF @AssessmentTypeID_LIST IN ( '3', '4', '5' ) --Online/Label/Dispatch
                BEGIN
                    SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
                      ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, QMS_Response.EndDate, 
                      QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
                      QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
                      QMS_User.FullName
					FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
					WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
                      (QMS_Response.ResponseStatus = 0) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
                      (QMS_Response.ResponseStatus <> 0)
					ORDER BY QMS_Response.EndDate DESC
                END
            ELSE 
                IF @AssessmentTypeID_LIST = '6' --Shelf life
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
            ELSE 
                IF @AssessmentTypeID_LIST = '16' --Active Quality Chain
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
							  ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)) OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0)
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)) OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0)
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 1)
								AND (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)) OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0)
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 0)
								AND (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
                ELSE 
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Location, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, 
							  QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
							  = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID
						WHERE     (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
        SELECT  1 AS TableIndex ,
                CONVERT(BIT, 1) AS ExportSetupTable ,
                'Portrait/Landscape' AS Orientation ,
                'n/a' AS SheetName ,
                'n/a' AS HiddenColumns ,
                'n/a' AS FixedColumns ,
                'n/a' AS StaticColumns ,
                'n/a' AS CyclicColumns
        UNION
        SELECT  0 ,
                0 ,
                'Portrait' ,
                'View Checks' ,
                NULL ,
                NULL ,
                'Location,FullName' ,
                'REMAINING_COLUMNS'
        ORDER BY TableIndex ASC

    END

GO
/****** Object:  StoredProcedure [dbo].[RPT_CorrectiveActionDetail]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_CorrectiveActionDetail]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_CorrectiveActionDetail] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 23/06/2009
-- Description:	Gets data for Corrective Action Detail Report
-- Version: 9
-- =============================================
-- JE TFS 2745 - updated to look up CAStatus resources
-- JE TFS 2769 - added filtering by AssignSupplierID
-- JE TFS 6004 - now uses FNC_User_CorrectiveActionList for user CA filtering
-- MP TFS 6004 - now uses FNC_User_CorrectiveActionList for report by supplier & group
-- MP TFS 6749 - fix to ensure that closed CAs are also picked up
-- JT TFS 7586 - Stop non-outstanding only query filtered by user from returning all corrective actions.
-- JT TFS 7586 - Supplier users shows AssignSupplierID links.
-- JT TFS 7586 - Use FilterID user specified in supplier link for FilterBy User.
-- JE TFS 13-12643: replaced use of FNC_User_CorrectiveActionList with QMS_CorrectiveActionUser
-- =============================================
ALTER PROCEDURE [dbo].[RPT_CorrectiveActionDetail]
	@UserID int,
	@DateFrom datetime, 
	@DateTo datetime,
	@FilterBy tinyint, --1=user, 2=group
	@FilterID int,
	@OutstandingOnly bit
AS

SET NOCOUNT ON
--Fill temp table with selected CAs
DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

DECLARE @User_CA TABLE (CorrectiveActionID INT)

INSERT INTO @User_CA ( CorrectiveActionID )
SELECT	QMS_CorrectiveActionUser.CorrectiveActionID
FROM	QMS_CorrectiveActionUser
		INNER JOIN QMS_CorrectiveAction ON QMS_CorrectiveActionUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
WHERE	(QMS_CorrectiveActionUser.UserID = CASE WHEN @FilterBy = 1 THEN @FilterID ELSE @UserID END)
		AND (QMS_CorrectiveAction.CAStatusID IN (1,2,3,6))

IF @OutstandingOnly = 0 --Add closed CAs too
	INSERT INTO @User_CA ( CorrectiveActionID )
	SELECT	QMS_CorrectiveActionUser.CorrectiveActionID
	FROM	QMS_CorrectiveActionUser
			INNER JOIN QMS_CorrectiveAction ON QMS_CorrectiveActionUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
	WHERE	(QMS_CorrectiveActionUser.UserID = CASE WHEN @FilterBy = 1 THEN @FilterID ELSE @UserID END)
			AND (QMS_CorrectiveAction.CAStatusID NOT IN (1,2,3,6))

IF @FilterBy=1 --User
BEGIN
--1. if CA assigned to that user
--2. If CA assigned to a group that the user is in
--3. If CA assigned to a supplier that the user has permissions to see and they have a supplier user level (this should be handled in "permissions to see - FNC_User_CorrectiveActionList")

	DECLARE @IsSupplierUser bit
	SELECT @IsSupplierUser = CASE WHEN [dbo].[FNC_GetUserOrderLevel](@FilterID) = 9 THEN 1 ELSE 0 END

	INSERT INTO TEMP_Selected
                      (UserID, SelectedID)
	SELECT     @UserID AS UserID, QMS_CorrectiveAction.CorrectiveActionID
	FROM        QMS_CorrectiveAction 
	INNER JOIN	@User_CA AS UserCAs ON QMS_CorrectiveAction.CorrectiveActionID = UserCAs.CorrectiveActionID
	WHERE   (QMS_CorrectiveAction.DateLogged BETWEEN @DateFrom AND @DateTo) 
	AND		(QMS_CorrectiveAction.RecordStatus < 201) 
	
	AND (	QMS_CorrectiveAction.AssignUserID = @FilterID
		OR 
			QMS_CorrectiveAction.NotificationGroupID IN (SELECT NotificationGroupID FROM QMS_NotificationGroupUser where UserID = @FilterID)
		OR 
			(@IsSupplierUser = 1 AND QMS_CorrectiveAction.AssignSupplierID IN (SELECT SupplierID FROM VW_PermissionLink WHERE SupplierID IS NOT NULL AND UserID = @FilterID))
	)
	AND (	(@OutstandingOnly = 0)
			OR
			((@OutstandingOnly = 1) AND (QMS_CorrectiveAction.CAStatusID < 4))
	)
END
	
IF @FilterBy=2 --Group
	INSERT INTO TEMP_Selected
                      (UserID, SelectedID)
	SELECT     @UserID AS UserID, QMS_CorrectiveAction.CorrectiveActionID
	FROM         QMS_CorrectiveAction INNER JOIN
						  @User_CA AS UserCAs ON QMS_CorrectiveAction.CorrectiveActionID = UserCAs.CorrectiveActionID
	WHERE   (DateLogged BETWEEN @DateFrom AND @DateTo) 
	AND		(RecordStatus < 201)  
	AND		(NotificationGroupID = @FilterID)
	AND	(	(@OutstandingOnly = 0) 
			OR
			((@OutstandingOnly = 1) AND (CAStatusID < 4))
	)

IF @FilterBy=3 --Supplier
	INSERT INTO TEMP_Selected
						(UserID, SelectedID)
	SELECT		@UserID AS UserID, QMS_CorrectiveAction.CorrectiveActionID
	FROM		QMS_CorrectiveAction INNER JOIN
						  @User_CA AS UserCAs ON QMS_CorrectiveAction.CorrectiveActionID = UserCAs.CorrectiveActionID
	WHERE	(DateLogged BETWEEN @DateFrom AND @DateTo) 
	AND		(RecordStatus < 201) 
	AND		(AssignSupplierID = @FilterID) 
	AND	(	(@OutstandingOnly = 0) 
			OR
            ((@OutstandingOnly = 1) AND (CAStatusID < 4))
    )

SET NOCOUNT OFF

SELECT     @DateFrom AS DateFrom, @DateTo AS DateTo, QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CATitle, 
                  QMS_CorrectiveAction.CASubTitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired,
					  ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus, 
                      APP_PriorityLevel.PriorityLevel, QMS_CorrectiveAction.DateLogged, QMS_CorrectiveAction.DateDeadline, 
                      QMS_CorrectiveActionType.CorrectiveActionType, QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
                      ISNULL(QMS_NotificationGroup.NotificationGroup, QMS_User_Assign.FullName) AS AssignTo, QMS_User_Logged.FullName AS LoggedBy, 
                      QMS_CorrectiveAction.ActionTaken, QMS_CorrectiveAction.Comments, QMS_CorrectiveAction.DateCompleted, 
                      QMS_User_Completed.FullName AS CompletedBy, APP_PriorityLevel.ListIndex AS PriorityOrder, QMS_CorrectiveAction.DateSignedOff, 
                      QMS_User.FullName AS SignedOffBy, QMS_CorrectiveAction.DateFailed
FROM         QMS_CorrectiveAction INNER JOIN
                      APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID INNER JOIN
                      TEMP_Selected ON QMS_CorrectiveAction.CorrectiveActionID = TEMP_Selected.SelectedID LEFT OUTER JOIN
                      QMS_User ON QMS_CorrectiveAction.SignOff_UserID = QMS_User.UserID LEFT OUTER JOIN
                      QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID LEFT OUTER JOIN
                      QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID LEFT OUTER JOIN
                      QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID LEFT OUTER JOIN
                      QMS_CorrectiveActionEscalation ON 
                      QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID LEFT OUTER JOIN
                      QMS_CorrectiveActionType ON QMS_CorrectiveAction.CorrectiveActionTypeID = QMS_CorrectiveActionType.CorrectiveActionTypeID LEFT OUTER JOIN
                      QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID LEFT OUTER JOIN
                      APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
WHERE     (TEMP_Selected.UserID = @UserID)
ORDER BY QMS_CorrectiveAction.DateLogged, PriorityOrder

GO
/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveAction]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveAction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		10
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int,
	@CASourceID int,
	@SourceObjectID int,
	@CATitle nvarchar(50),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         QMS_CorrectiveAction
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
	EXEC SAVE_CorrectiveActionUser @CorrectiveActionID

	SELECT @CorrectiveActionID
END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroup]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroup]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_NotificationGroup] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Adds and edits notification groups
-- Version:		2
-- =============================================
-- JT TFS 12834: Take (and ignore) @Sys_Group parameter.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_NotificationGroup] 
	@NotificationGroupID int,
	@NotificationGroup nvarchar(50),
	@Enabled bit,
	@Sys_Group nvarchar(100) = NULL
AS
BEGIN
	SET NOCOUNT ON

	IF ISNULL(@NotificationGroupID,0)=0 --New record
	BEGIN
		INSERT INTO QMS_NotificationGroup
						  (NotificationGroup, Enabled)
		VALUES     (@NotificationGroup,@Enabled)
		--Get new ID
		SELECT     @NotificationGroupID = MAX(NotificationGroupID)
		FROM         QMS_NotificationGroup
	END
	ELSE --Update record
	BEGIN
			DECLARE @Original_Sys_Group nvarchar(50) 
			SELECT @Original_Sys_Group = Sys_Group FROM QMS_NotificationGroup WHERE (NotificationGroupID = @NotificationGroupID)
			IF @Original_Sys_Group IS NULL --Disable edit of system groups
				UPDATE    QMS_NotificationGroup
				SET              NotificationGroup = @NotificationGroup, Enabled = @Enabled, Updated = GETUTCDATE()
				WHERE     (NotificationGroupID = @NotificationGroupID)
	END

	SET NOCOUNT OFF

	SELECT @NotificationGroupID
END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroupUser]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroupUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_NotificationGroupUser] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Adds and edits notification users
-- Version:		2
-- =============================================
-- JE TFS 13-12639: update QMS_CorrectiveActionUser when group's users have been changed
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_NotificationGroupUser]
	@NotificationGroupUserID int,	
	@NotificationGroupID int,
	@UserID int
AS

SET NOCOUNT ON

IF ISNULL(@NotificationGroupUserID,0)=0 --New record
BEGIN
	INSERT INTO QMS_NotificationGroupUser
                      (NotificationGroupID, UserID)
	VALUES     (@NotificationGroupID,@UserID)
	--Get new ID
	SELECT     @NotificationGroupUserID = MAX(NotificationGroupUserID)
	FROM         QMS_NotificationGroupUser
END
ELSE --Update record
BEGIN	
	UPDATE    QMS_NotificationGroupUser
	SET              UserID = @UserID, Updated = GETUTCDATE()
	WHERE     (NotificationGroupUserID = @NotificationGroupUserID)
END

--JE TFS 13-12639: update CA assignments based on updates to notification groups
--clear out records for user from QMS_CorrectiveActionUser
DELETE FROM QMS_CorrectiveActionUser
WHERE UserID = @UserID AND Assigned = 1

--insert records for assignd users (results of function will have been updated by above insert/update actions)
INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
SELECT	CorrectiveActionID, UserID, 1
FROM	dbo.FNC_CorrectiveAction_AssignUsers()
WHERE	(UserID = @UserID)

SET NOCOUNT OFF

SELECT @NotificationGroupUserID

GO
/****** Object:  StoredProcedure [dbo].[SAVE_UserPermissions]    Script Date: 16/01/2015 11:29:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_UserPermissions]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_UserPermissions] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Saves or deletes user permissions
-- Version:		6
-- =============================================
-- JT TFS 13-1791: Lookup UserPermissionID if not specified, and convert AppID to PermissionType.
-- JT TFS 13-4134: Added permissions for add/edit/delete for menu items added for mobile (AppID = 2).
-- JT TFS 13-4012: Added code to remove favourites of children as well as current user.
-- JE TFS 13-12638: update QMS_CorrectiveActionUser when permissions have been changed
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_UserPermissions]
	@UserID int,
	@UserPermissionID int,
	@PermissionType int,
	@PermissionTitle nvarchar(255),
	@PermissionAllow bit,
	@ChangedBy int = NULL -- UserID of user who is changing this entry.
AS
BEGIN
	SET NOCOUNT ON
	IF @ChangedBy IS NULL SET @ChangedBy = @UserID

	-- If PermissionType is an AppID, then change it to be a PermissionType
	IF @PermissionType IN (0,1,2,3)
	BEGIN
		SELECT @PermissionType = 
			CASE	WHEN EXISTS (	SELECT * FROM APP_Menu 
									WHERE MenuID = convert(int, @PermissionTitle)
									AND ParentID IS NULL) 
					THEN 0 ELSE 1 END
		
		-- Remove any other permissions which link to this userpermission (favourites, homepage, reportfavourites)
		IF @PermissionAllow = 0
		BEGIN
			UPDATE QMS_UserPermissions
			SET PermissionAllow = 0,
				Updated = getutcdate(),
				Deleted = getutcdate(),
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (4, 20, 21)
			AND PermissionTitle = @PermissionTitle
			AND (	UserID = @UserID 
					OR 
					UserID IN (	SELECT UserID FROM QMS_User children
								WHERE ParentUserID = @UserID)
			)
			AND PermissionAllow <> 0 -- only update if it would change from 1 to 0.
		END
		
		-- Do a menu item check for mobile permissions (only on leaf items)
		IF EXISTS (SELECT * FROM APP_Menu 
					WHERE MenuID = convert(int, @PermissionTitle)
					AND AppID = 2)
		AND NOT EXISTS (SELECT * FROM APP_Menu
						WHERE ParentID = convert(int, @PermissionTitle)
						AND AppID = 2)
		BEGIN
			-- Ensure that three child permissions exist: add/edit/delete
			UPDATE QMS_UserPermissions
			SET PermissionAllow = @PermissionAllow,
				Updated = getutcdate(),
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (11,12, 13)
			AND PermissionTitle = @PermissionTitle
			AND UserID = @UserID
			AND PermissionAllow <> @PermissionAllow
			
			INSERT QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
			SELECT @UserID, PermissionType, @PermissionTitle, @PermissionAllow, @ChangedBy 
			FROM (SELECT 11 PermissionType UNION SELECT 12 UNION SELECT 13) as t
			WHERE NOT EXISTS (
				SELECT * FROM QMS_UserPermissions
				WHERE PermissionType = t.PermissionType
				AND PermissionTitle = @PermissionTitle
				AND UserID = @UserID
			)
		END
	END

	-- Modify this actual permission.
	IF @UserPermissionID = 0
	BEGIN
		-- Treat zero and one permissiontypes as identical.
		DECLARE @SearchType int
		SELECT @SearchType = CASE WHEN @PermissionType IN (0,1) THEN 0 ELSE @PermissionType END

		SELECT @UserPermissionID = UserPermissionID
		FROM QMS_UserPermissions
		WHERE UserID = @UserID 
		AND CASE WHEN PermissionType IN (0,1) THEN 0 ELSE PermissionType END = @SearchType 
		AND PermissionTitle = @PermissionTitle;
	END

	IF ISNULL(@UserPermissionID,0)=0 --New permission
	BEGIN
		DECLARE @UserPermissions TABLE( UserPermissionID int);

		INSERT INTO QMS_UserPermissions
					(UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
		OUTPUT INSERTED.UserPermissionID 
			INTO @UserPermissions 
		VALUES     (@UserID,@PermissionType,@PermissionTitle,@PermissionAllow, @ChangedBy)
		
		--Get new UserPermissionID
		SELECT     @UserPermissionID = MAX(UserPermissionID)
		FROM         @UserPermissions
	END
	ELSE
	BEGIN
		UPDATE  QMS_UserPermissions
		SET     PermissionType = @PermissionType, 
				PermissionTitle = @PermissionTitle, 
				PermissionAllow = @PermissionAllow, 
				Updated = GETUTCDATE(),
				-- only change deleted if allow is set to false.
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
		WHERE     (UserPermissionID = @UserPermissionID)
	END

	--TFS 13-12638: update QMS_CorrectiveActionUser to reflect changes to user permissions
	--clear table of all CAs for the user whose permissions are being updated
	DELETE FROM QMS_CorrectiveActionUser
	WHERE UserID = @UserID

	--insert active CAs for UserID
	INSERT INTO QMS_CorrectiveActionUser(CorrectiveActionID, UserID)
	SELECT	CorrectiveActionID, @UserID
	FROM	dbo.FNC_GENERATE_User_CorrectiveActionList(@UserID, 1)

	--insert inactive CAs for UserID
	INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID)
	SELECT	CorrectiveActionID, @UserID
	FROM	dbo.FNC_GENERATE_User_CorrectiveActionList(@UserID, 0)

	SET NOCOUNT OFF

	SELECT @UserPermissionID
END

GO


PRINT 'Updating sync procedures...'

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_PM_Consignment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SYNC_Import_PM_Consignment]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_PM_Consignment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'create PROCEDURE [dbo].[SYNC_Import_PM_Consignment] 
	@ConsignmentID int,
	@SupplierID int,
	@OrderRef nvarchar(50),
	@OrderDate datetime,
	@DateRequired datetime,
	@E_PO nvarchar(50),
	@LocationID int,
	@OrderStatus int,
	@WatchList nvarchar(1),
	@E_POType NVARCHAR(10) = NULL,
	@Comments NVARCHAR(1000) = NULL,
	@CustomerID INT = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @OrderDate = dbo.FNC_ConvertServerDate(@OrderDate)
SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired)

IF @Hide IS NULL
	SET @Hide=0

IF NOT EXISTS(SELECT * FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT SupplierID FROM PM_Supplier WHERE (SupplierID = @SupplierID) OR @SupplierID IS NULL)
	BEGIN
		INSERT INTO PM_Consignment
                      (ConsignmentID, SupplierID, OrderRef, OrderDate, DateRequired, E_PO, LocationID, OrderStatus, WatchList, E_POType, Comments, CustomerID, Hide, RecordStatus, 
                      GUID)
		VALUES     (@ConsignmentID,@SupplierID,@OrderRef,@OrderDate,@DateRequired,@E_PO,@LocationID,@OrderStatus,@WatchList,@E_POType,@Comments,@CustomerID,@Hide,@RecordStatus,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Consignment
	SET              SupplierID = @SupplierID, OrderRef = @OrderRef, OrderDate = @OrderDate, DateRequired = @DateRequired, E_PO = @E_PO, LocationID = @LocationID, 
                      OrderStatus = @OrderStatus, WatchList = @WatchList, E_POType = @E_POType, Comments = @Comments, CustomerID = @CustomerID, Hide = @Hide, 
                      RecordStatus = @RecordStatus
	WHERE     (ConsignmentID = @ConsignmentID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
' 
END
GO

/****** Object:  StoredProcedure [dbo].[SYNC_Import_SupplierResponse]    Script Date: 16/01/2015 11:31:02 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_SupplierResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SYNC_Import_SupplierResponse]
GO
/****** Object:  StoredProcedure [dbo].[SYNC_Import_SupplierResponse]    Script Date: 16/01/2015 11:31:02 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_SupplierResponse]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SYNC_Import_SupplierResponse] AS' 
END
GO
alter PROCEDURE [dbo].[SYNC_Import_SupplierResponse] 
	@ResponseID int,
	@SupplierID int,
	@StockCodeID int,
	@LocationID int,
	@EndDate datetime,
	@ArrivalDate datetime,
	@QuantityReceived int,
	@QuantityChecked int,
	@QuantityAccepted int,
	@QuantityRejected int,
	@QAFlagID int,
	@RedResponses nvarchar(1000),
	@Comments nvarchar(2000),
	@AssessmentTypeID int = NULL,
	@AssessmentID int = NULL,
	@ConsignmentID int = NULL,
	@DUDate datetime = NULL,
	@RecordStatus tinyint,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Barcode nvarchar(max),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @EndDate = dbo.FNC_ConvertServerDate(@EndDate)
SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)
SET @DUDate = dbo.FNC_ConvertServerDate(@DUDate)

IF NOT EXISTS(SELECT * FROM QMS_SupplierResponse WHERE (ResponseID = @ResponseID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		--SET IDENTITY_INSERT QMS_SupplierResponse ON
		INSERT INTO QMS_SupplierResponse
                      (ResponseID, SupplierID, StockCodeID, LocationID, EndDate, ArrivalDate, QuantityReceived, QuantityChecked, QuantityAccepted, QuantityRejected, QAFlagID, 
                      RedResponses, Comments, AssessmentTypeID, AssessmentID, DUDate, ConsignmentID, RecordStatus, Updated, GUID, Barcode)
		VALUES     (@ResponseID,@SupplierID,@StockCodeID,@LocationID,@EndDate,@ArrivalDate,@QuantityReceived,@QuantityChecked,@QuantityAccepted,@QuantityRejected,@QAFlagID,@RedResponses,@Comments,@AssessmentTypeID,@AssessmentID,@DUDate,@ConsignmentID,@RecordStatus,@Updated,@GUID,@Barcode)
		SET @InsertCount = @@rowcount
		--SET IDENTITY_INSERT QMS_SupplierResponse OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_SupplierResponse
	SET              SupplierID = @SupplierID, StockCodeID = @StockCodeID, LocationID = @LocationID, EndDate = @EndDate, ArrivalDate = @ArrivalDate, 
                      QuantityReceived = @QuantityReceived, QuantityChecked = @QuantityChecked, QuantityAccepted = @QuantityAccepted, QuantityRejected = @QuantityRejected, 
                      QAFlagID = @QAFlagID, RedResponses = @RedResponses, Comments = @Comments, AssessmentTypeID = @AssessmentTypeID, 
                      AssessmentID = @AssessmentID, DUDate = @DUDate, ConsignmentID = @ConsignmentID, RecordStatus = @RecordStatus, Updated = @Updated, Barcode = @Barcode
	WHERE     (ResponseID = @ResponseID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created


GO

/****** Object:  StoredProcedure [dbo].[UP_NotificationGroupUser_Delete]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UP_NotificationGroupUser_Delete]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UP_NotificationGroupUser_Delete]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_UserPermissions]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_UserPermissions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_UserPermissions]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroupUser]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroupUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_NotificationGroupUser]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveActionUser]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveActionUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_CorrectiveActionUser]
GO
/****** Object:  StoredProcedure [dbo].[RPT_ResponseSummary_FillSelected]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_ResponseSummary_FillSelected]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected]
GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseQuestion_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseQuestion_AQCMultiList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_ResponseQuestion_AQCMultiList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseHeader_AQCNewParentCheck]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseHeader_AQCNewParentCheck]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_ResponseHeader_AQCNewParentCheck]
GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseHeader_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseHeader_AQCMultiList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_ResponseHeader_AQCMultiList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_AQCMultiList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Response_AQCMultiList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_AQCMulti_Validate]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_AQCMulti_Validate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Response_AQCMulti_Validate]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CustomLookupItem_NamedList]    Script Date: 21/01/2015 13:47:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CustomLookupItem_NamedList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CustomLookupItem_NamedList]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CustomLookupItem_NamedList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList] AS' 
END
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 14/08/2013
-- Description:	Gets list of lookup items for selected list by system name
-- Version:		3
-- =============================================
-- JT TFS 7337 - Lookup custom lookups by name
-- PH TFS 13-13428 - Join in flag sainbury's name to get data to front end. 
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CustomLookupItem_NamedList] 
	@SysLookupName nvarchar(50)
AS

SELECT     item.CustomLookupItemID, item.LookupText, item.QAFlagID, flag.QAFlagForeColour, flag.QAFlagBackColour, ISNULL(dbo.FNC_ResourceString_User(ResourceName, null), flag.QAFlag) AS QAFlag
FROM         QMS_CustomLookupItem item
INNER JOIN QMS_CustomLookup customlookup ON customlookup.CustomLookupID = item.CustomLookupID 
LEFT OUTER JOIN APP_QAFlag as flag ON flag.QAFlagID = item.QAFlagID

WHERE     (customlookup.Sys_Lookup  = @SysLookupName) AND (item.RecordStatus < 201) AND (item.Hide = 0)
ORDER BY item.ListIndex, item.LookupText

GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_AQCMulti_Validate]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_AQCMulti_Validate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Response_AQCMulti_Validate] AS' 
END
GO

-- =============================================
-- Author:		Jon Edwards
-- Create date: 26/11/2014
-- Description:	Gets AssessmentID and StockCodeID for selected AQC Multi Checks that are being approved
-- Version:		1
-- =============================================
-- JE TFS 13-9699: created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_AQCMulti_Validate]
	@ResponseIDs nvarchar(255) --AQC child check ResponseIDs
AS
BEGIN

	--need to get parent check ResponseIDs as the StockCodeID is stored against these
	DECLARE @ParentChecks AS TABLE (ResponseID int)
	INSERT INTO @ParentChecks
	SELECT DISTINCT	Parent.ResponseID
	FROM	QMS_Response AS Child INNER JOIN
				QMS_Response AS Parent ON Child.ParentResponseGUID = Parent.GUID
	WHERE	(Child.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
										 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
										 WHERE	(ISNUMERIC(Token) = 1 )))
	AND     (Child.RecordStatus < 180) -- Hide voided and cancelled checks.

	--get AssessmentID and StockCodeID for each parent check
	SELECT DISTINCT  QMS_Response.AssessmentID,
			MAX(CASE WHEN DataLookupID = 2 THEN QMS_ResponseHeader.Header_SourceID ELSE NULL END) AS StockCodeID
	FROM	QMS_Response INNER JOIN
				@ParentChecks AS ParentChecks ON QMS_Response.ResponseID = ParentChecks.ResponseID INNER JOIN
				QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
				QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	GROUP BY QMS_Response.ResponseID, QMS_Response.AssessmentID

END

GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_AQCMultiList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Response_AQCMultiList] AS' 
END
GO

-- =============================================
-- Author:		Jon Edwards
-- Create date: 12/11/2014
-- Description:	Returns data from all AQC child check ResponseIDs passed in
-- Version:		1
-- =============================================
-- JE TFS 13-9698: created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_AQCMultiList] 
	@ResponseIDs nvarchar(255)
AS
BEGIN

	--get data for all child responses in ResponseIDs comma separated string
	SELECT	ResponseID, Actual_Score, Actual_QAFlagID, RecordStatus, Comments
	FROM	QMS_Response
	WHERE	(QMS_Response.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
										 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
										 WHERE	(ISNUMERIC(Token) = 1 )))
	AND     (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.

END

GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseHeader_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseHeader_AQCMultiList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_ResponseHeader_AQCMultiList] AS' 
END
GO

-- =============================================
-- Author:		Jon Edwards
-- Create date: 12/11/2014
-- Description:	Returns header data from all AQC child check ResponseIDs passed in
-- Version:		1
-- =============================================
-- JE TFS 13-9698: created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ResponseHeader_AQCMultiList] 
	@ResponseIDs nvarchar(255)
AS
BEGIN

	--get data for all child responses in ResponseIDs comma separated string
	DECLARE	@ChildCheckCount AS int
	SELECT	@ChildCheckCount = COUNT(ResponseID)
	FROM	QMS_Response
	WHERE	(QMS_Response.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
										 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
										 WHERE	(ISNUMERIC(Token) = 1 )))
	AND     (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.

	--get header info
	SELECT	QMS_ResponseHeader.ResponseID, QMS_ResponseHeader.ResponseHeaderID, QMS_ResponseHeader.AssessmentHeaderID,
				QMS_ResponseHeader.Header_Text, QMS_ResponseHeader.Header_Boolean, QMS_ResponseHeader.Header_Date,
				QMS_ResponseHeader.Header_Numeric, QMS_ResponseHeader.Header_SourceID, @ChildCheckCount AS  ChildCheckCount
	FROM	QMS_ResponseHeader
			INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
	WHERE   (QMS_ResponseHeader.RecordStatus < 201) 
			AND	(QMS_Response.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
											 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
											 WHERE	(ISNUMERIC(Token) = 1 )))
			AND (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.
	ORDER BY QMS_ResponseHeader.ResponseID
	
END

GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseHeader_AQCNewParentCheck]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseHeader_AQCNewParentCheck]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_ResponseHeader_AQCNewParentCheck] AS' 
END
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 02/12/2014
-- Description:	Gets all non-variable header items and responses for a newly created AQC parent check
-- Version: 2
-- =============================================
-- JE TFS 13-11987: created
-- JE TFS 13-12108: ensure IDs are being saved for header items
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ResponseHeader_AQCNewParentCheck]
	@ParentResponseID int
AS
BEGIN

	SELECT	QMS_AssessmentHeader.AssessmentHeaderID, QMS_AssessmentHeader.HeaderText,
				0 AS ResponseHeaderID, --always set this to 0 to force a new save as we'll never be updating ResponseHeader records for new AQC parents
				QMS_AssessmentHeader.DataTypeID, APP_DataLookup.DataTypeID AS Lookup_DataTypeID,
				CASE WHEN QMS_AssessmentHeader.DataTypeID = 2 THEN CONVERT(nvarchar(5), QMS_ResponseHeader.Header_Boolean)
					 WHEN QMS_AssessmentHeader.DataTypeID IN (3,4,5) THEN CONVERT(nvarchar(50), QMS_ResponseHeader.Header_Date, 121)
					 WHEN QMS_AssessmentHeader.DataTypeID IN (7,8) THEN CONVERT(nvarchar(50), QMS_ResponseHeader.Header_Numeric)
					 WHEN QMS_AssessmentHeader.DataTypeID IN (9,10) THEN
							(CASE WHEN QMS_AssessmentHeader.AllowMultiSelect = 1 THEN CONVERT(nvarchar(1), -1)
								ELSE
								(CASE WHEN APP_DataLookup.DataTypeID = 2 THEN CONVERT(nvarchar(5), QMS_ResponseHeader.Header_Boolean)
									  WHEN APP_DataLookup.DataTypeID IN (3,4,5) THEN CONVERT(nvarchar(50), QMS_ResponseHeader.Header_Date, 121)
									  WHEN APP_DataLookup.DataTypeID IN (7,8) THEN CONVERT(nvarchar(50), QMS_ResponseHeader.Header_Numeric)
								 ELSE CONVERT(nvarchar(5), QMS_ResponseHeader.Header_SourceID) END)
							 END)
					 ELSE QMS_ResponseHeader.Header_Text END AS Response,
				QMS_ResponseHeader.Header_Text AS ResponseText, QMS_AssessmentHeader.AllowMultiSelect, QMS_AssessmentHeader.CustomLookupID,
				QMS_AssessmentHeader.VariableItem
	FROM	QMS_ResponseHeader INNER JOIN
				QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID LEFT OUTER JOIN
				APP_DataLookup ON QMS_AssessmentHeader.DataLookupID = APP_DataLookup.DataLookupID
	WHERE	(QMS_ResponseHeader.ResponseID = @ParentResponseID)
			AND	(QMS_ResponseHeader.RecordStatus < 201)
			AND (QMS_AssessmentHeader.VariableItem = 0)

END

GO
/****** Object:  StoredProcedure [dbo].[QRY_ResponseQuestion_AQCMultiList]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_ResponseQuestion_AQCMultiList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_ResponseQuestion_AQCMultiList] AS' 
END
GO

-- =============================================
-- Author:		Jon Edwards
-- Create date: 12/11/2014
-- Description:	Returns question data from all AQC child check ResponseIDs passed in
-- Version:		1
-- =============================================
-- JE TFS 13-9698: created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_ResponseQuestion_AQCMultiList] 
	@ResponseIDs nvarchar(255)
AS
BEGIN

	--get data for all child responses in ResponseIDs comma separated string
	DECLARE	@ChildCheckCount AS int
	SELECT	@ChildCheckCount = COUNT(ResponseID)
	FROM	QMS_Response
	WHERE	(QMS_Response.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
										 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
										 WHERE	(ISNUMERIC(Token) = 1 )))
	AND     (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.
	
	SELECT	QMS_ResponseQuestion.ResponseID, QMS_ResponseQuestion.ResponseQuestionID, QMS_ResponseQuestion.AssessmentQuestionID,
				QMS_ResponseQuestion.Response_Text, QMS_ResponseQuestion.Response_Boolean, QMS_ResponseQuestion.Response_Date,
				QMS_ResponseQuestion.Response_Numeric, QMS_ResponseQuestion.Response_SourceID, QMS_ResponseQuestion.Score,
				QMS_ResponseQuestion.Recommended_QAFlagID, QMS_ResponseQuestion.QuestionComments, QMS_ResponseQuestion.SampleNo,
				@ChildCheckCount AS  ChildCheckCount
	FROM	QMS_ResponseQuestion INNER JOIN
				QMS_Response ON QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID
	WHERE	(QMS_Response.ResponseID IN (SELECT CONVERT(INT, Token) AS AssessmentTypeID
										 FROM	dbo.FNC_SplitString(@ResponseIDs, ',') AS SplitString
										 WHERE	(ISNUMERIC(Token) = 1 )))
	AND		(QMS_ResponseQuestion.RecordStatus < 201)
	AND     (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.
	ORDER BY QMS_ResponseQuestion.ResponseID

END

GO
/****** Object:  StoredProcedure [dbo].[RPT_ResponseSummary_FillSelected]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_ResponseSummary_FillSelected]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 14/10/08
-- Description:	Fills TEMP_Selected with AssessmentID for checks to show on QC Summary report
-- Version:		8
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- MarkP: 04-May-2012 Added @AlertPeriod parameter
-- JE TFS 4853: changed filtering to new method
-- JT TFS 6689: Added DataWarehouse code.
-- MP TFS 8278: Removed tables APP_QAFlag and QMS_Assessment from statements as not required
-- JE TFS 13-3050: replaced CROSS JOIN with LEFT JOIN in main query as this didn't work correctly when @AssessmentTypeID_LIST = NULL
-- JT TFS 13-12688: Log ResponseIDs to DEBUG tables to determine source of issues with daily reports.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] 
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(100) = NULL,
	@AssessmentID int = NULL,
	@AlertPeriod tinyint = NULL,
	@UserID int,
	@FilterApplied bit = 0 -- If set, query checks TEMP_ResponseFilter
AS
BEGIN
	SET NOCOUNT ON

	--test params
	--declare @AssessmentTypeID_LIST nvarchar(100) = NULL,  @DateFrom datetime = '9 Jun 2014 02:00:00',  @DateTo datetime = '10 Jun 2014 23:59:59', 
	--		@AlertPeriod tinyint = 2,  @UserID int = 311, @FilterApplied bit = 0, @AssessmentID int = 1124

	DECLARE @UseDataWarehouse bit
	SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)

	--get config value for Override QAFlag
	DECLARE @OverrideFlag bit
	SET @OverrideFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	DECLARE @Table_Response TABLE (ResponseID int)
	IF ISNULL(@AlertPeriod,0) IN (2,5,6,7) --Hourly, Daily, Weekday, Weekend alerts - filter by uploaded time
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     User_ResponseList.ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, DATEADD(day, - 1, @DateFrom), @DateTo) AS User_ResponseList INNER JOIN
						  QMS_Response ON User_ResponseList.ResponseID = QMS_Response.ResponseID
		WHERE     (User_ResponseList.ResponseStatus = 1) AND (QMS_Response.Uploaded IS NULL) AND (QMS_Response.EndDate BETWEEN @DateFrom AND @DateTo) OR
						  (User_ResponseList.ResponseStatus = 1) AND (QMS_Response.Uploaded BETWEEN @DateFrom AND @DateTo)
	END
	ELSE
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo)
		WHERE     (ResponseStatus = 1)
	END

	SET NOCOUNT OFF

	IF (@UseDataWarehouse = 1)
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT RPT_Warehouse_Response.ResponseID, @UserID AS UserID
		FROM         RPT_Warehouse_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON RPT_Warehouse_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON RPT_Warehouse_Response.QAFlagID = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR RPT_Warehouse_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (RPT_Warehouse_Response.AssessmentID = @AssessmentID)
		)
	END
	ELSE
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT QMS_Response.ResponseID, @UserID AS UserID
		FROM         QMS_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON QMS_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON  --check config value to join on Actual or Override QAFlagID
						  (CASE WHEN @OverrideFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END) = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR QMS_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (dbo.QMS_Response.AssessmentID = @AssessmentID)
		)
	END

	SET NOCOUNT ON
	-- CAS-35175-S8P0X3
	IF NULLIF(object_id('DEBUG_TEMP_Selected'), 0) IS NOT NULL
	BEGIN
		INSERT DEBUG_TEMP_Selected (UniqueID, RunTime, UserID, SelectedID, SelectedText, SelectedValue, SelectedText2)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, SelectedID, SelectedText, SelectedValue, SelectedText2
		FROM TEMP_Selected 
		WHERE UserID = @UserID
	END
	IF NULLIF(object_id('DEBUG_TEMP_ResponseFilter'), 0) IS NOT NULL
	BEGIN
		INSERT DEBUG_TEMP_ResponseFilter (UniqueID, RunTime, UserID, ResponseID)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, ResponseID
		FROM TEMP_ResponseFilter 
		WHERE UserID = @UserID
	END
	IF NULLIF(object_id('DEBUG_TEMP_ResponseGroupBy'), 0) IS NOT NULL 
	BEGIN
		INSERT DEBUG_TEMP_ResponseGroupBy (UniqueID, RunTime, UserID, ResponseID, GroupByHeader, GroupByText)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, ResponseID, GroupByHeader, GroupByText
		FROM TEMP_ResponseGroupBy 
		WHERE UserID = @UserID
	END
	SET NOCOUNT OFF

END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveActionUser]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveActionUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_CorrectiveActionUser] AS' 
END
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 06/01/2015
-- Description:	Saves CA user data to QMS_CorrectiveActionUser
-- Version:		2
-- =============================================
-- JE TFS 13-12635: created
-- JE TFS 13-13404: amended INSERT for unassigned users into QMS_CorrectiveActionUser
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveActionUser]
	@CorrectiveActionID int
AS
BEGIN
	SET NOCOUNT ON

	--get GUID for the CA we're saving data for
	DECLARE @CorrectiveActionGUID uniqueidentifier
	SELECT @CorrectiveActionGUID = GUID FROM QMS_CorrectiveAction WHERE CorrectiveActionID = @CorrectiveActionID

	--get CA user assignment data into a temp table (should contain data for specifically assigned users, users assigned as part of a notification group and users with permissions to assigned suppliers)
	IF nullif(object_id('tempdb..#tmpCorrectiveActionUserAssignment'), 0) IS NOT NULL DROP TABLE #tmpCorrectiveActionUserAssignment
	CREATE TABLE #tmpCorrectiveActionUserAssignment (
		CorrectiveActionID int,
		UserID int
	)
	INSERT INTO #tmpCorrectiveActionUserAssignment (CorrectiveActionID, UserID)
	SELECT CorrectiveActionID, UserID
	FROM dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()

	--insert data for CAs that are assigned to users/groups/suppliers
	IF (SELECT COUNT(CorrectiveActionID) FROM QMS_CorrectiveActionUser WHERE CorrectiveActionID = @CorrectiveActionID) = 0
		--insert data for users that have been assigned the CA (individually, as part of a group, or as a supplier) from temp table directly as no data exists already
		INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
		SELECT	CorrectiveActionID, UserID, 1
		FROM	#tmpCorrectiveActionUserAssignment
		WHERE	(CorrectiveActionID = @CorrectiveActionID)
	ELSE
		--data for this CA already exists, so insert new and update where appropriate
		BEGIN
			INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
			SELECT	AssignedUsers.CorrectiveActionID, AssignedUsers.UserID, 1
			FROM	#tmpCorrectiveActionUserAssignment AS AssignedUsers
					LEFT OUTER JOIN QMS_CorrectiveActionUser ON AssignedUsers.UserID = QMS_CorrectiveActionUser.UserID
			WHERE	(QMS_CorrectiveActionUser.CorrectiveActionID IS NULL) AND (QMS_CorrectiveActionUser.UserID IS NULL)
					AND (AssignedUsers.CorrectiveActionID = @CorrectiveActionID)
			
			--update Assigned value to 0 for users that were already in QMS_CorrectiveActionUser but no longer in temp table (i.e. CA is no longer directly assigned to them but they still have visibility of it)
			UPDATE	QMS_CorrectiveActionUser
			SET		Assigned = 0, Updated = GETUTCDATE()
			FROM	QMS_CorrectiveActionUser INNER JOIN (
						SELECT	QMS_CorrectiveActionUser.CorrectiveActionID, QMS_CorrectiveActionUser.UserID
						FROM	QMS_CorrectiveActionUser
								LEFT OUTER JOIN #tmpCorrectiveActionUserAssignment AS AssignedUsers ON QMS_CorrectiveActionUser.CorrectiveActionID = AssignedUsers.CorrectiveActionID
						WHERE	((AssignedUsers.UserID) IS NULL OR (AssignedUsers.UserID <> QMS_CorrectiveActionUser.UserID))
								AND (QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID)
								AND (QMS_CorrectiveActionUser.Assigned = 1)
						) AS UpdatedRecords
							ON QMS_CorrectiveActionUser.CorrectiveActionID = UpdatedRecords.CorrectiveActionID
								AND QMS_CorrectiveActionUser.UserID = UpdatedRecords.UserID
			WHERE (QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID)

			--update Assigned value to 1 for users that were already in QMS_CorrectiveActionUser and are now also in temp table (i.e. CA is now directly assigned to them)
			UPDATE	QMS_CorrectiveActionUser
			SET		Assigned = 1, Updated = GETUTCDATE()
			FROM	QMS_CorrectiveActionUser INNER JOIN (
						SELECT	QMS_CorrectiveActionUser.CorrectiveActionID, QMS_CorrectiveActionUser.UserID
						FROM	QMS_CorrectiveActionUser
								INNER JOIN #tmpCorrectiveActionUserAssignment AS AssignedUsers ON QMS_CorrectiveActionUser.UserID = AssignedUsers.UserID
												AND QMS_CorrectiveActionUser.CorrectiveActionID = AssignedUsers.CorrectiveActionID
						WHERE	(QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID)
								AND (QMS_CorrectiveActionUser.Assigned = 0)
						) AS UpdatedRecords
							ON QMS_CorrectiveActionUser.CorrectiveActionID = UpdatedRecords.CorrectiveActionID
								AND QMS_CorrectiveActionUser.UserID = UpdatedRecords.UserID
			WHERE (QMS_CorrectiveActionUser.CorrectiveActionID = @CorrectiveActionID)
		END

	--insert data for users that have visibility of the CA (not assigned as this would already be in the table)
	INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID)
	SELECT DISTINCT @CorrectiveActionID, AllCorrectiveActionUsers.UserID
	FROM	dbo.FNC_GENERATE_CorrectiveAction_UserList(@CorrectiveActionID) AS AllCorrectiveActionUsers
	WHERE	(AllCorrectiveActionUsers.UserID NOT IN (SELECT UserID FROM QMS_CorrectiveActionUser WHERE CorrectiveActionID = @CorrectiveActionID))

	SET NOCOUNT OFF
END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_NotificationGroupUser]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_NotificationGroupUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_NotificationGroupUser] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Adds and edits notification users
-- Version:		2
-- =============================================
-- JE TFS 13-12639: update QMS_CorrectiveActionUser when group's users have been changed
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_NotificationGroupUser]
	@NotificationGroupUserID int,	
	@NotificationGroupID int,
	@UserID int
AS

SET NOCOUNT ON

IF ISNULL(@NotificationGroupUserID,0)=0 --New record
BEGIN
	INSERT INTO QMS_NotificationGroupUser
                      (NotificationGroupID, UserID)
	VALUES     (@NotificationGroupID,@UserID)
	--Get new ID
	SELECT     @NotificationGroupUserID = MAX(NotificationGroupUserID)
	FROM         QMS_NotificationGroupUser
END
ELSE --Update record
BEGIN	
	UPDATE    QMS_NotificationGroupUser
	SET              UserID = @UserID, Updated = GETUTCDATE()
	WHERE     (NotificationGroupUserID = @NotificationGroupUserID)
END

--JE TFS 13-12639: update CA assignments based on updates to notification groups
--clear out records for user from QMS_CorrectiveActionUser
DELETE FROM QMS_CorrectiveActionUser
WHERE UserID = @UserID AND Assigned = 1

--insert records for assigned users (results of function will have been updated by above insert/update actions)
INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
SELECT	CorrectiveActionID, UserID, 1
FROM	dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()
WHERE	(UserID = @UserID)

SET NOCOUNT OFF

SELECT @NotificationGroupUserID

GO
/****** Object:  StoredProcedure [dbo].[SAVE_UserPermissions]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_UserPermissions]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_UserPermissions] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Saves or deletes user permissions
-- Version:		7
-- =============================================
-- JT TFS 13-1791: Lookup UserPermissionID if not specified, and convert AppID to PermissionType.
-- JT TFS 13-4134: Added permissions for add/edit/delete for menu items added for mobile (AppID = 2).
-- JT TFS 13-4012: Added code to remove favourites of children as well as current user.
-- JE TFS 13-12638: update QMS_CorrectiveActionUser when permissions have been changed
-- JE TFS 13-13177: update Assigned column in QMS_CorrectiveActionUser
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_UserPermissions]
	@UserID int,
	@UserPermissionID int,
	@PermissionType int,
	@PermissionTitle nvarchar(255),
	@PermissionAllow bit,
	@ChangedBy int = NULL -- UserID of user who is changing this entry.
AS
BEGIN
	SET NOCOUNT ON
	IF @ChangedBy IS NULL SET @ChangedBy = @UserID

	-- If PermissionType is an AppID, then change it to be a PermissionType
	IF @PermissionType IN (0,1,2,3)
	BEGIN
		SELECT @PermissionType = 
			CASE	WHEN EXISTS (	SELECT * FROM APP_Menu 
									WHERE MenuID = convert(int, @PermissionTitle)
									AND ParentID IS NULL) 
					THEN 0 ELSE 1 END
		
		-- Remove any other permissions which link to this userpermission (favourites, homepage, reportfavourites)
		IF @PermissionAllow = 0
		BEGIN
			UPDATE QMS_UserPermissions
			SET PermissionAllow = 0,
				Updated = getutcdate(),
				Deleted = getutcdate(),
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (4, 20, 21)
			AND PermissionTitle = @PermissionTitle
			AND (	UserID = @UserID 
					OR 
					UserID IN (	SELECT UserID FROM QMS_User children
								WHERE ParentUserID = @UserID)
			)
			AND PermissionAllow <> 0 -- only update if it would change from 1 to 0.
		END
		
		-- Do a menu item check for mobile permissions (only on leaf items)
		IF EXISTS (SELECT * FROM APP_Menu 
					WHERE MenuID = convert(int, @PermissionTitle)
					AND AppID = 2)
		AND NOT EXISTS (SELECT * FROM APP_Menu
						WHERE ParentID = convert(int, @PermissionTitle)
						AND AppID = 2)
		BEGIN
			-- Ensure that three child permissions exist: add/edit/delete
			UPDATE QMS_UserPermissions
			SET PermissionAllow = @PermissionAllow,
				Updated = getutcdate(),
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (11,12, 13)
			AND PermissionTitle = @PermissionTitle
			AND UserID = @UserID
			AND PermissionAllow <> @PermissionAllow
			
			INSERT QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
			SELECT @UserID, PermissionType, @PermissionTitle, @PermissionAllow, @ChangedBy 
			FROM (SELECT 11 PermissionType UNION SELECT 12 UNION SELECT 13) as t
			WHERE NOT EXISTS (
				SELECT * FROM QMS_UserPermissions
				WHERE PermissionType = t.PermissionType
				AND PermissionTitle = @PermissionTitle
				AND UserID = @UserID
			)
		END
	END

	-- Modify this actual permission.
	IF @UserPermissionID = 0
	BEGIN
		-- Treat zero and one permissiontypes as identical.
		DECLARE @SearchType int
		SELECT @SearchType = CASE WHEN @PermissionType IN (0,1) THEN 0 ELSE @PermissionType END

		SELECT @UserPermissionID = UserPermissionID
		FROM QMS_UserPermissions
		WHERE UserID = @UserID 
		AND CASE WHEN PermissionType IN (0,1) THEN 0 ELSE PermissionType END = @SearchType 
		AND PermissionTitle = @PermissionTitle;
	END

	IF ISNULL(@UserPermissionID,0)=0 --New permission
	BEGIN
		DECLARE @UserPermissions TABLE( UserPermissionID int);

		INSERT INTO QMS_UserPermissions
					(UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
		OUTPUT INSERTED.UserPermissionID 
			INTO @UserPermissions 
		VALUES     (@UserID,@PermissionType,@PermissionTitle,@PermissionAllow, @ChangedBy)
		
		--Get new UserPermissionID
		SELECT     @UserPermissionID = MAX(UserPermissionID)
		FROM         @UserPermissions
	END
	ELSE
	BEGIN
		UPDATE  QMS_UserPermissions
		SET     PermissionType = @PermissionType, 
				PermissionTitle = @PermissionTitle, 
				PermissionAllow = @PermissionAllow, 
				Updated = GETUTCDATE(),
				-- only change deleted if allow is set to false.
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
		WHERE     (UserPermissionID = @UserPermissionID)
	END

	--TFS 13-12638: update QMS_CorrectiveActionUser to reflect changes to user permissions
	--clear table of all CAs for the user whose permissions are being updated
	DELETE FROM QMS_CorrectiveActionUser
	WHERE UserID = @UserID

	--insert active CAs for UserID
	INSERT INTO QMS_CorrectiveActionUser(CorrectiveActionID, UserID)
	SELECT	CorrectiveActionID, @UserID
	FROM	dbo.FNC_GENERATE_User_CorrectiveActionList(@UserID, 1)

	--insert inactive CAs for UserID
	INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID)
	SELECT	CorrectiveActionID, @UserID
	FROM	dbo.FNC_GENERATE_User_CorrectiveActionList(@UserID, 0)

	--insert records for assignd users (results of function will have been updated by above insert/update actions)
	INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
	SELECT	CorrectiveActionID, UserID, 1
	FROM	dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()
	WHERE	(UserID = @UserID)

	SET NOCOUNT OFF

	SELECT @UserPermissionID
END

GO
/****** Object:  StoredProcedure [dbo].[UP_NotificationGroupUser_Delete]    Script Date: 21/01/2015 13:47:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UP_NotificationGroupUser_Delete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[UP_NotificationGroupUser_Delete] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Deletes notification user
-- Version:		2
-- =============================================
-- JE TFS 13-13183: update QMS_CorrectiveActionUser when a user is removed from a Notification Group
-- =============================================
ALTER PROCEDURE [dbo].[UP_NotificationGroupUser_Delete]
	@NotificationGroupUserID int
AS

	UPDATE	QMS_NotificationGroupUser
	SET		RecordStatus = 201, Deleted = GETUTCDATE()
	WHERE	(NotificationGroupUserID = @NotificationGroupUserID)

	--get NotificationGroupID and UserID for group membership we're removing
	DECLARE @NotificationGroupID int, @UserID int
	SELECT	@NotificationGroupID = NotificationGroupID, @UserID = UserID
	FROM	QMS_NotificationGroupUser
	WHERE	NotificationGroupUserID = @NotificationGroupUserID

	--clear out records for user from QMS_CorrectiveActionUser
	DELETE FROM QMS_CorrectiveActionUser
	WHERE UserID = @UserID AND Assigned = 1

	--insert records for assignd users (results of function will have been updated by above insert/update actions)
	INSERT INTO QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
	SELECT	CorrectiveActionID, UserID, 1
	FROM	dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()
	WHERE	(UserID = @UserID)


GO



--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
