-- =============================================
-- Author:		Jon Edwards
-- Create date: 24/12/2014
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 54
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

--PRINT 'Inserting tables...'

--PRINT 'Updating tables...'

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

--PRINT 'Updating User Defined Functions...'

PRINT 'Updating Stored Procedures...'

/****** Object:  StoredProcedure [dbo].[SAVE_User]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_User]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_User]
GO
/****** Object:  StoredProcedure [dbo].[RPT_ResponseSummary]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_ResponseSummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_ResponseSummary]
GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_ResponseHeader]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_ResponseHeader]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_Response_ResponseHeader]
GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_MultiCheckHeader]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_MultiCheckHeader]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_Response_MultiCheckHeader]
GO
/****** Object:  StoredProcedure [dbo].[QRY_User_ListOfAdmins]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_ListOfAdmins]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_User_ListOfAdmins]
GO
/****** Object:  StoredProcedure [dbo].[QRY_User_AdminList]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_AdminList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_User_AdminList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Response_PreviousList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_NotificationGroup_AdminList]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_NotificationGroup_AdminList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_NotificationGroup_AdminList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_AlertExpiry]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_AlertExpiry]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Assessment_AlertExpiry]
GO
/****** Object:  StoredProcedure [dbo].[PM_QRY_StockCode_Combo]    Script Date: 24/12/2014 08:42:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_StockCode_Combo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PM_QRY_StockCode_Combo]
GO
/****** Object:  StoredProcedure [dbo].[PM_QRY_StockCode_Combo]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_StockCode_Combo]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[PM_QRY_StockCode_Combo] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets a stock code list
-- Version:		7
-- =============================================
-- JE updated to filter list by Customer
-- JT TFS 3657 - updated to only return one query result.
-- MP TFS 3869 - updated to ensure customer filter only used when trigger enabled
-- JE TFS 4178 - added AssessmentTypeID param so we know when to filter out hidden Stock Codes
-- JT TFS 5902 - 13-Feb-2012 - Added searchText
-- JE TFS 13-11942: exclude stock type of Seed/Variety when accessed from Mobile
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_Combo]
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@CustomerID int = NULL,
	@AssessmentTypeID int = NULL,
	@SearchText nvarchar(100) = NULL
AS

IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
BEGIN
	DECLARE @FilterStockCodeID int
	IF @CaseEndBarcode IS NOT NULL
		SET @FilterStockCodeID = dbo.FNC_CaseEndToStockCode(@CaseEndBarcode)
	ELSE
		SET @FilterStockCodeID = NULL

	SELECT     StockCodeID, DisplayText
	FROM         PM_VW_StockCode
	WHERE   ((StockCodeID = @FilterStockCodeID) AND (@FilterStockCodeID IS NOT NULL) 	OR		(@FilterStockCodeID IS NULL) AND (Hide = 0))
	AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
	AND (PM_VW_StockCode.StockTypeID <> 4)
	ORDER BY DisplayText
END
ELSE
BEGIN
	DECLARE @EnableCustomerFilter bit
	IF @CustomerID IS NOT NULL
		SELECT     @EnableCustomerFilter = Enabled
		FROM         APP_DataLookupTrigger
		WHERE     (DataLookupID_Update = 2) AND (DataLookupID_Trigger = 3)
	ELSE
		SET @EnableCustomerFilter = 0
		
	IF @UserID IS NULL AND @EnableCustomerFilter = 1 --combo not being accessed from an assessment, so show all stock codes
		SELECT		StockCodeID, DisplayText
		FROM         PM_VW_StockCode
		WHERE		CustomerID = @CustomerID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE (Hide = 0)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		AND (PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText

	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID) AND (Hide = 0)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		AND (PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText
	
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText	
		
	ELSE
		SELECT     StockCodeID, DisplayText
		FROM         PM_VW_StockCode
		WHERE (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
END

GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_AlertExpiry]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_AlertExpiry]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Assessment_AlertExpiry] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 23/10/2008
-- Description:	Gets list of assessments expired and about to expire
-- Version:		3
-- =============================================
-- 4578 - populate new @AssessmentStatusID parameter in FNC_AssessmentSpecHeader_VersionChanges and FNC_AssessmentQuestion_VersionChanges
-- 13-11249: Change join on versionchanges function to be an outer apply to avoid entire db hit.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Assessment_AlertExpiry]
	
AS

DECLARE @ExpiryDate datetime
SET @ExpiryDate = DATEADD(day, 3, GETDATE())

--Get notification groups
SELECT DISTINCT QMS_NotificationGroup.NotificationGroupID, QMS_NotificationGroup.NotificationGroup
FROM         QMS_Assessment INNER JOIN
                      QMS_NotificationGroup ON QMS_Assessment.Expired_NotificationGroupID = QMS_NotificationGroup.NotificationGroupID INNER JOIN
                      APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID
WHERE     (QMS_NotificationGroup.Enabled = 1) AND (QMS_NotificationGroup.RecordStatus < 201) AND (APP_AssessmentStatus.Active = 1) AND 
                      (QMS_Assessment.RecordStatus < 201) AND (QMS_Assessment.ValidTo < @ExpiryDate)
ORDER BY QMS_NotificationGroup.NotificationGroup

--Get assessments to notify by group
SELECT     QMS_NotificationGroup.NotificationGroupID, APP_AssessmentType.AssessmentType, QMS_Assessment.AssessmentName, 
                      QMS_Assessment.Version, QMS_Assessment.ValidTo, QMS_Assessment.AutoExpire
FROM         QMS_Assessment INNER JOIN
                      QMS_NotificationGroup ON QMS_Assessment.Expired_NotificationGroupID = QMS_NotificationGroup.NotificationGroupID INNER JOIN
                      APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID INNER JOIN
                      APP_AssessmentType ON QMS_Assessment.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID
WHERE     (QMS_NotificationGroup.Enabled = 1) AND (QMS_NotificationGroup.RecordStatus < 201) AND (APP_AssessmentStatus.Active = 1) AND 
                      (QMS_Assessment.RecordStatus < 201) AND (QMS_Assessment.ValidTo < @ExpiryDate)

--Get assessments to notify with no group
SELECT     QMS_Assessment.AssessmentName, QMS_Assessment.Version, QMS_Assessment.ValidTo, QMS_Assessment.AutoExpire, QMS_User.FullName, QMS_User.EMail, 
                      AssessmentSpecHeader_VersionChanges.HeaderText, AssessmentQuestion_VersionChanges.QuestionText
FROM         (SELECT DISTINCT RowGUID, UserID
                       FROM          QMS_RecordLock
                       WHERE      (ObjectName = N'QMS_Assessment') AND (RecordStatus < 201)) AS Assessment_CheckOut INNER JOIN
                      QMS_Assessment ON Assessment_CheckOut.RowGUID = QMS_Assessment.GUID AND Assessment_CheckOut.UserID <> ISNULL(QMS_Assessment.SignOff_UserID, 
                      0) INNER JOIN
                      QMS_User ON Assessment_CheckOut.UserID = QMS_User.UserID INNER JOIN
                      APP_AssessmentStatus ON QMS_Assessment.AssessmentStatusID = APP_AssessmentStatus.AssessmentStatusID 
OUTER APPLY dbo.FNC_AssessmentQuestion_VersionChangesByID(QMS_Assessment.AssessmentID) AS AssessmentQuestion_VersionChanges
OUTER APPLY dbo.FNC_AssessmentSpecHeader_VersionChangesByID(QMS_Assessment.AssessmentID) AS AssessmentSpecHeader_VersionChanges
WHERE     (QMS_User.LeftCompany = 0) AND (APP_AssessmentStatus.Active = 1) AND (QMS_User.EMail IS NOT NULL) AND (QMS_Assessment.ValidTo < @ExpiryDate) AND 
                      (QMS_Assessment.Expired_NotificationGroupID IS NULL) AND (QMS_User.RecordStatus < 201) AND (QMS_Assessment.RecordStatus < 201)

GO
/****** Object:  StoredProcedure [dbo].[QRY_NotificationGroup_AdminList]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_NotificationGroup_AdminList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_NotificationGroup_AdminList] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Gets list of notification groups for admin
-- Version:		2
-- =============================================
-- JT TFS 11261: User cannot delete system groups.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_NotificationGroup_AdminList] 
AS
BEGIN
	SELECT     NotificationGroupID, NotificationGroup, Enabled, Sys_Group
	FROM         QMS_NotificationGroup
	WHERE     (RecordStatus < 201)
	ORDER BY NotificationGroup
END

GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		18
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport
AS 
    BEGIN
        SET NOCOUNT ON
    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
        DECLARE @AssessmentFormat INT
        SELECT  @AssessmentFormat = AssessmentFormat
        FROM    APP_AssessmentType
        WHERE   AssessmentTypeID = @AssessmentTypeID


		DECLARE @multiCheckDisplay INT;
        SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
										THEN  1    --show parent checks only for previouschecks screen
										WHEN @AssessmentFormat = 6 THEN 1
										ELSE 2
									END

        IF ( @AssessmentTypeID_LIST IS NULL ) 
            SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID)

--Clear temp table
        DELETE  FROM TEMP_Selected
        WHERE   ( UserID = @UserID )

--Fill temp table
        IF @IsFilterApplied = 0 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     QMS_Response.ResponseID, @UserID AS UserID
				FROM         QMS_Response INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID INNER JOIN
                      dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString ON QMS_Response.AssessmentTypeID = SplitString.Token

            END
        ELSE 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     ResponseID, @UserID AS UserID
				FROM         TEMP_ResponseFilter
				WHERE     (UserID = @UserID)

            END

        SET NOCOUNT OFF

        IF @AssessmentTypeID_LIST = '2' --Arrival check
            BEGIN
                SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Supplier, ResponseHeader.StockCode, 
                      ResponseHeader.Location, QMS_Response.StartDate, QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, 
                      QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, 
                      CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
				FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag AS APP_QAFlag_1) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
				WHERE     
				
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding IS NULL) 
					OR                      
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding = 1) AND 
                    (QMS_Response.ResponseStatus = 0) 
                    OR
                    (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
                    (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
                    (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
                    (@ShowOutstanding = 0) AND 
                    (QMS_Response.ResponseStatus <> 0)
                    
				ORDER BY QMS_Response.EndDate DESC
            END
        ELSE 
            IF @AssessmentTypeID_LIST IN ( '3', '4', '5' ) --Online/Label/Dispatch
                BEGIN
                    SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
                      ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, QMS_Response.EndDate, 
                      QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
                      QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
                      QMS_User.FullName
					FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
					WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
                      (QMS_Response.ResponseStatus = 0) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
                      (QMS_Response.ResponseStatus <> 0)
					ORDER BY QMS_Response.EndDate DESC
                END
            ELSE 
                IF @AssessmentTypeID_LIST = '6' --Shelf life
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
            ELSE 
                IF @AssessmentTypeID_LIST = '16' --Active Quality Chain
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName, ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) AS IsApproved,
							  ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 1)
								AND (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND ((@multiCheckDisplay = 1 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1) OR (@multiCheckDisplay = 2 AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 0)
								AND (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
                ELSE 
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Location, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, 
							  QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
							  = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID
						WHERE     (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
        SELECT  1 AS TableIndex ,
                CONVERT(BIT, 1) AS ExportSetupTable ,
                'Portrait/Landscape' AS Orientation ,
                'n/a' AS SheetName ,
                'n/a' AS HiddenColumns ,
                'n/a' AS FixedColumns ,
                'n/a' AS StaticColumns ,
                'n/a' AS CyclicColumns
        UNION
        SELECT  0 ,
                0 ,
                'Portrait' ,
                'View Checks' ,
                NULL ,
                NULL ,
                'Location,FullName' ,
                'REMAINING_COLUMNS'
        ORDER BY TableIndex ASC

    END

GO
/****** Object:  StoredProcedure [dbo].[QRY_User_AdminList]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_AdminList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_User_AdminList] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/06/2008
-- Description:	Gets list of users for admin
-- Version:		6
-- =============================================
-- JE TFS 2677 added new UserLevel logic
-- MP 18/09/12 change to selection of avalable user level as not sure why QMS_User was included here
-- JT TFS 6623 added IsUserLockedOut column (based on logic in clsUserAdmin.IsUserLockedOut, and added SearchUserID
-- JT TFS 7115 Added begin/end and NOCOUNT options to see if they fixed slowdown.
-- JT TFS 8022 - Return GUID so that it can be passed to LogiXML
-- JT TFS 13-11810 - Include CustomerID in output.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_AdminList] 
	@UserID int,
	@Company nvarchar(255) = NULL,
	@SearchUserID int = NULL
AS
BEGIN

	SET NOCOUNT ON 
	-- temp table to hold user levels
	DECLARE @AvailableUserLevels TABLE
	(
		UserLevelID int,
		UserLevel nvarchar(50),
		LevelOrder int
	)
	-- user level of selected User
	DECLARE @LevelOrder int
	-- match UserID to get LevelOrder
	SET @LevelOrder = (SELECT LevelOrder FROM APP_UserLevel INNER JOIN
							QMS_User ON APP_UserLevel.UserLevelID = QMS_User.UserLevel
						WHERE UserID = @UserID)

	IF @LevelOrder = 1
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder >= @LevelOrder)
	ELSE
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder > @LevelOrder)

	SET NOCOUNT OFF

	SELECT DISTINCT
		QMS_User.UserID, 
		QMS_User.FullName, 
		QMS_User.UserName, 
		QMS_User.Password, 
		QMS_User.Position, 
		QMS_User.Company, 
		QMS_User.EMail, 
		QMS_User.Mobile, 
		QMS_User.PIN, 
		QMS_User.LeftCompany, 
		QMS_User.UserLevel, 
		AvailableUserLevels.UserLevel AS Lookup_UserLevel, 
		QMS_User.LocaleID, 
		QMS_User.IsUserGroup, 
		QMS_User.ParentUserID, 
		Lookup_UserGroup.FullName AS Lookup_ParentUserID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN SupplierID 
					ELSE NULL END AS int) AS SupplierID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     SupplierName
																					FROM          PM_VW_Supplier
																					WHERE      (SupplierID = SupplierPermissions.SupplierID)), '(deleted supplier)')
					ELSE NULL END AS nvarchar) AS Lookup_SupplierID, 

		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN CustomerID 
					ELSE NULL END AS int) AS CustomerID, 
		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     CustomerName
																					FROM          PM_VW_Customer_Admin
																					WHERE      (CustomerID = CustomerPermissions.CustomerID)), '(deleted customer)') 
					ELSE NULL END AS nvarchar) AS Lookup_CustomerID, 
		CAST(OfficePermissions.NumPermissions AS nvarchar(100)) AS OfficeAccess, 
		CAST(MobilePermissions.NumPermissions AS nvarchar(100)) AS MobileAccess, 
		CAST(WebPermissions.NumPermissions AS nvarchar(100)) AS WebAccess, 
		CAST(SupplierPermissions.NumPermissions AS nvarchar(100)) AS SupplierAccess, 
		CAST(CustomerPermissions.NumPermissions AS nvarchar(100)) AS CustomerAccess, 
		CAST(LocationPermissions.NumPermissions AS nvarchar(100)) AS LocationAccess, 
		CAST(StockCodePermissions.NumPermissions AS nvarchar(100)) AS StockCodeAccess,
		CAST(CASE WHEN QMS_User.[Password] IS NULL THEN 1 ELSE 0 END as bit) Lookup_IsUserLockedOut,
		GUID AS Lookup_GUID
	FROM         QMS_User INNER JOIN
						   @AvailableUserLevels AS AvailableUserLevels ON QMS_User.UserLevel = AvailableUserLevels.UserLevelID LEFT OUTER JOIN
							  (SELECT     UserID, FullName
								FROM          QMS_User AS User_Group
								WHERE      (RecordStatus < 201) AND (IsUserGroup = 1)) AS Lookup_UserGroup ON QMS_User.ParentUserID = Lookup_UserGroup.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS StockCode_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 104)
								GROUP BY UserID) AS StockCodePermissions ON QMS_User.UserID = StockCodePermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Location_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 103)
								GROUP BY UserID) AS LocationPermissions ON QMS_User.UserID = LocationPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS SupplierID
								FROM          QMS_UserPermissions AS Supplier_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 101)
								GROUP BY UserID) AS SupplierPermissions ON QMS_User.UserID = SupplierPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS CustomerID
								FROM          QMS_UserPermissions AS Customer_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 102)
								GROUP BY UserID) AS CustomerPermissions ON QMS_User.UserID = CustomerPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Web_Permissions.UserID, COUNT(Web_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Web_Permissions INNER JOIN
													   APP_Menu AS Web_Menu ON CAST(Web_Permissions.PermissionTitle AS int) = Web_Menu.MenuID
								WHERE      (Web_Permissions.PermissionAllow = 1) AND (Web_Permissions.PermissionType = 0) AND (Web_Menu.AppID = 3)
								GROUP BY Web_Permissions.UserID) AS WebPermissions ON QMS_User.UserID = WebPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Mobile_Permissions.UserID, COUNT(Mobile_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Mobile_Permissions INNER JOIN
													   APP_Menu AS Mobile_Menu ON CAST(Mobile_Permissions.PermissionTitle AS int) = Mobile_Menu.MenuID
								WHERE      (Mobile_Permissions.PermissionAllow = 1) AND (Mobile_Permissions.PermissionType = 0) AND (Mobile_Menu.AppID = 2)
								GROUP BY Mobile_Permissions.UserID) AS MobilePermissions ON QMS_User.UserID = MobilePermissions.UserID LEFT OUTER JOIN
							  (SELECT     Office_Permissions.UserID, COUNT(Office_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Office_Permissions INNER JOIN
													   APP_Menu AS Office_Menu ON CAST(Office_Permissions.PermissionTitle AS int) = Office_Menu.MenuID
								WHERE      (Office_Permissions.PermissionAllow = 1) AND (Office_Permissions.PermissionType = 0) AND (Office_Menu.AppID = 1)
								GROUP BY Office_Permissions.UserID) AS OfficePermissions ON QMS_User.UserID = OfficePermissions.UserID
	WHERE     (QMS_User.RecordStatus < 201) 
	AND (QMS_User.Company = @Company OR @Company IS NULL)
	AND (QMS_User.UserID = @SearchUserID OR @SearchUserID IS NULL)
	ORDER BY QMS_User.IsUserGroup, QMS_User.FullName
END

GO
/****** Object:  StoredProcedure [dbo].[QRY_User_ListOfAdmins]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_ListOfAdmins]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_User_ListOfAdmins] AS' 
END
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 17/05/2011
-- Description:	Returns all admin users
-- Version:		3
-- =============================================
-- JT TFS 13-11261: Modified list to only include administrators who are in the system group "AdminAlerts".
-- JT TFS 13-11715: Do not include deleted NotificationGroupUsers.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_ListOfAdmins]
AS
BEGIN
	SELECT FullName, EMail
	FROM QMS_User
	WHERE UserID IN (	SELECT UserID FROM QMS_NotificationGroupUser 
						WHERE NotificationGroupID IN (	SELECT NotificationGroupID 
														FROM QMS_NotificationGroup 
														WHERE Sys_Group = 'AdminAlerts')
						AND RecordStatus < 201)

	AND LeftCompany = 0 
	AND RecordStatus < 201 
	AND EMail IS NOT NULL
END

GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_MultiCheckHeader]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_MultiCheckHeader]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_Response_MultiCheckHeader] AS' 
END
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 13/01/2014
-- Description:	Gets parent and child check header data for Multi Check responses
-- Version:		4
-- =============================================
-- JE TFS 8904: added UserID filter in TEMP_Selected population
-- JE TFS 13-499: added NoOfHeadersToHide column
-- JE TFS 13-11438: added checking of SuppressBlanks option
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_MultiCheckHeader]
	@UserID int
AS
BEGIN

--declare @UserID int
--select @UserID = 1

	DECLARE @SuppressBlanks bit
	SET @SuppressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0)

	--parent check ID(s) will already be in TEMP_Selected, but we need to add all their associated child check IDs too
	INSERT INTO TEMP_Selected (UserID, SelectedID, SelectedValue)
	SELECT	@UserID, ChildCheck.ResponseID AS ChildCheckID, ParentCheck.ResponseID AS ParentCheckID
	FROM	TEMP_Selected INNER JOIN
				QMS_Response AS ParentCheck ON TEMP_Selected.SelectedID = ParentCheck.ResponseID INNER JOIN
				QMS_Response AS ChildCheck ON ParentCheck.GUID = ChildCheck.ParentResponseGUID
	WHERE	(ChildCheck.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID)

	--get header data for parent and child checks
	SELECT	QMS_ResponseHeader.ResponseID, QMS_AssessmentHeader.HeaderText, QMS_ResponseHeader.Header_Text, QMS_ResponseHeader.Header_Boolean, 
				QMS_ResponseHeader.Header_Date, QMS_ResponseHeader.Header_Numeric, QMS_AssessmentHeader.HideFromReports, TEMP_Selected.SelectedValue,
				QMS_AssessmentHeader.VariableItem, NumberOfChildChecks.NoOfChildChecks,
				--headers are in blocks of 5, the below calculates how many we need to hide
				CASE WHEN (ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) < NumberOfChildChecks.NoOfChildChecks
							THEN (((ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) + 5) - NumberOfChildChecks.NoOfChildChecks)
					 ELSE ((ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) - NumberOfChildChecks.NoOfChildChecks) END AS NoOfHeadersToHide
	FROM	QMS_AssessmentHeader INNER JOIN
				QMS_ResponseHeader ON QMS_AssessmentHeader.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID INNER JOIN
				QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID INNER JOIN
                TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID LEFT OUTER JOIN
                (SELECT SelectedValue AS ParentCheckID, COUNT(SelectedID) As NoOfChildChecks
					FROM TEMP_Selected
					WHERE (UserID = @UserID) AND (SelectedValue IS NOT NULL)
					GROUP BY SelectedValue) AS NumberOfChildChecks ON TEMP_Selected.SelectedValue = NumberOfChildChecks.ParentCheckID
	WHERE	(QMS_ResponseHeader.RecordStatus < 201) AND (QMS_AssessmentHeader.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID) AND 
		        (QMS_AssessmentHeader.HideFromReports = 0)
			AND ((@SuppressBlanks = 1 AND QMS_ResponseHeader.Header_Text IS NOT NULL AND QMS_ResponseHeader.Header_Text <> '')
				OR
				(@SuppressBlanks = 0))
	ORDER BY QMS_ResponseHeader.ResponseID, QMS_AssessmentHeader.ListIndex

END

GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_ResponseHeader]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_ResponseHeader]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_Response_ResponseHeader] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets response header items for report
-- Version:		2
-- =============================================
-- JE TFS 13-11438: added checking of SuppressBlanks option
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_ResponseHeader]
	@UserID int
AS
BEGIN
	DECLARE @SuppressBlanks bit
	SET @SuppressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0)

	SELECT     QMS_ResponseHeader.ResponseID, QMS_AssessmentHeader.HeaderText, QMS_ResponseHeader.Header_Text, QMS_ResponseHeader.Header_Boolean, 
						  QMS_ResponseHeader.Header_Date, QMS_ResponseHeader.Header_Numeric, QMS_AssessmentHeader.HideFromReports
	FROM         QMS_AssessmentHeader INNER JOIN
						  QMS_ResponseHeader ON QMS_AssessmentHeader.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID INNER JOIN
						  TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
	WHERE     (QMS_ResponseHeader.RecordStatus < 201) AND (QMS_AssessmentHeader.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID) AND 
						  (QMS_AssessmentHeader.HideFromReports = 0)
			AND ((@SuppressBlanks = 1 AND QMS_ResponseHeader.Header_Text IS NOT NULL AND QMS_ResponseHeader.Header_Text <> '')
					OR
				 (@SuppressBlanks = 0))

	ORDER BY QMS_ResponseHeader.ResponseID, QMS_AssessmentHeader.ListIndex
END

GO
/****** Object:  StoredProcedure [dbo].[RPT_ResponseSummary]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_ResponseSummary]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_ResponseSummary] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 14/10/08
-- Description:	Gets data for QC summary report
-- Version:		5
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- JE TFS 4853: added QA Flag override config check and QA Flag cell colouring
-- JT TFS 6689: Added DataWarehouse code.
-- JE TFS 13-11439: added HideQAScore col
-- =============================================
ALTER PROCEDURE [dbo].[RPT_ResponseSummary]
	@DateFrom datetime,
	@DateTo datetime,
	@UserID int
AS

DECLARE @UseDataWarehouse bit
SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)

--get config value for Override QAFlag
DECLARE @OverrideFlag bit
SET @OverrideFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

if NULLIF(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
SELECT	QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
INTO #tmpQAFlag
FROM	APP_QAFlag

IF @UseDataWarehouse = 1 
BEGIN
	SELECT     @DateFrom AS DateFrom, @DateTo AS DateTo, APP_AssessmentType.AssessmentType, QMS_Assessment.AssessmentName, response.ResponseID, 
						  response.StartDate, response.EndDate, response.Score as Actual_Score, QAFlag.QAFlagID, QAFlag.QAFlag, QMS_User.FullName, 
						  response.HeaderText AS SourceText, response.Comments, 
						  response.GreenResponses, response.GreenComments, 
						  response.AmberResponses, response.AmberComments, 
						  response.RedResponses, response.RedComments, 
						  response.QuantityReceived, response.QuantityChecked, response.QuantityAccepted, 
						  response.QuantityRejected, Temperature.Response_Temperature AS Temperature_Response, Temperature.QAFlagID AS Temperature_QAFlagID,
						  APP_QAFlag.QAFlagBackColour, APP_QAFlag.QAFlagForeColour,
						  ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore
	FROM        RPT_Warehouse_Response response
	INNER JOIN	APP_QAFlag ON response.QAFlagID = APP_QAFlag.QAFlagID 
	INNER JOIN	QMS_Assessment ON response.AssessmentID = QMS_Assessment.AssessmentID 
	INNER JOIN	APP_AssessmentType ON response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID 
	INNER JOIN	TEMP_Selected ON response.ResponseID = TEMP_Selected.SelectedID 
	LEFT OUTER JOIN	(	SELECT     InnerResponse.ResponseID, MAX(QMS_ResponseQuestion.Response_Numeric) AS Response_Temperature, 
													   MAX(QMS_ResponseQuestion.Recommended_QAFlagID) AS QAFlagID
						FROM		QMS_QuestionPool 
						INNER JOIN	QMS_AssessmentQuestion ON QMS_QuestionPool.QuestionID = QMS_AssessmentQuestion.QuestionID 
						INNER JOIN	QMS_ResponseQuestion ON QMS_AssessmentQuestion.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID 
						INNER JOIN	RPT_Warehouse_Response AS InnerResponse ON QMS_ResponseQuestion.ResponseID = InnerResponse.ResponseID 
						INNER JOIN	TEMP_Selected AS Selected ON InnerResponse.ResponseID = Selected.SelectedID
						WHERE      (QMS_QuestionPool.Question LIKE '%temp%') AND (Selected.UserID = @UserID)
						GROUP BY InnerResponse.ResponseID) AS Temperature ON response.ResponseID = Temperature.ResponseID 
	LEFT OUTER JOIN	QMS_User ON response.UserID = QMS_User.UserID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag ON APP_QAFlag.QAFlagID = QAFlag.QAFlagID
	WHERE     (TEMP_Selected.UserID = @UserID)
	ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, response.EndDate
END
ELSE
BEGIN
	SELECT     @DateFrom AS DateFrom, @DateTo AS DateTo, APP_AssessmentType.AssessmentType, QMS_Assessment.AssessmentName, QMS_Response.ResponseID, 
						  QMS_Response.StartDate, QMS_Response.EndDate, QMS_Response.Actual_Score, QAFlag.QAFlagID, QAFlag.QAFlag, QMS_User.FullName, 
						  AssessmentHeader.DisplayText AS SourceText, QMS_Response.Comments, FNC_ResponseQuestion.GreenResponses, FNC_ResponseQuestion.GreenComments, 
						  FNC_ResponseQuestion.AmberResponses, FNC_ResponseQuestion.AmberComments, FNC_ResponseQuestion.RedResponses, 
						  FNC_ResponseQuestion.RedComments, QMS_Response.QuantityReceived, QMS_Response.QuantityChecked, QMS_Response.QuantityAccepted, 
						  QMS_Response.QuantityRejected, Temperature.Response_Temperature AS Temperature_Response, Temperature.QAFlagID AS Temperature_QAFlagID,
						  APP_QAFlag.QAFlagBackColour, APP_QAFlag.QAFlagForeColour,
						  ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore
	FROM         QMS_Response INNER JOIN
						  APP_QAFlag ON
						  --check config value to join on Actual or Override QAFlagID
						  (CASE WHEN @OverrideFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END)
								 = APP_QAFlag.QAFlagID INNER JOIN
						  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
						  APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID INNER JOIN
						  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID LEFT OUTER JOIN
						  dbo.FNC_ResponseQuestion_Selected(@UserID, 0) AS FNC_ResponseQuestion ON 
						  QMS_Response.ResponseID = FNC_ResponseQuestion.ResponseID LEFT OUTER JOIN
							  (SELECT     Response.ResponseID, MAX(QMS_ResponseQuestion.Response_Numeric) AS Response_Temperature, 
													   MAX(QMS_ResponseQuestion.Recommended_QAFlagID) AS QAFlagID
								FROM          QMS_QuestionPool INNER JOIN
													   QMS_AssessmentQuestion ON QMS_QuestionPool.QuestionID = QMS_AssessmentQuestion.QuestionID INNER JOIN
													   QMS_ResponseQuestion ON QMS_AssessmentQuestion.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID INNER JOIN
													   QMS_Response AS Response ON QMS_ResponseQuestion.ResponseID = Response.ResponseID INNER JOIN
													   TEMP_Selected AS Selected ON Response.ResponseID = Selected.SelectedID
								WHERE      (QMS_QuestionPool.Question LIKE '%temp%') AND (Selected.UserID = @UserID)
								GROUP BY Response.ResponseID) AS Temperature ON QMS_Response.ResponseID = Temperature.ResponseID LEFT OUTER JOIN
						  dbo.FNC_AssessmentHeader_Selected(@UserID) AS AssessmentHeader ON QMS_Response.ResponseID = AssessmentHeader.ResponseID LEFT OUTER JOIN
						  QMS_User ON QMS_Response.UserID = QMS_User.UserID 
						  LEFT OUTER JOIN #tmpQAFlag AS QAFlag ON APP_QAFlag.QAFlagID = QAFlag.QAFlagID
	WHERE     (TEMP_Selected.UserID = @UserID)
	ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, QMS_Response.EndDate
END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_User]    Script Date: 24/12/2014 08:42:34 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_User]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_User] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 30/06/2008
-- Description:	Adds and edits user details
-- Version:		8
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@Password_MD5 nvarchar(255) = NULL,
	@Password_SHA2 nvarchar(255) = NULL
AS

SET NOCOUNT ON

IF ISNULL(@UserID,0)=0 --New user
BEGIN
	IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
	BEGIN
		INSERT INTO QMS_User(FullName,	UserName,	Position,	EMail,	Mobile,		PIN,	LeftCompany,	UserLevel,	LocaleID,	IsUserGroup,	ParentUserID,	Company)
		VALUES				(@FullName,	@UserName,	@Position,	@EMail,	@Mobile,	@PIN,	@LeftCompany,	@UserLevel,	@LocaleID,	@IsUserGroup,	@ParentUserID,	@Company)
		--Get new UserID
		SELECT @UserID = SCOPE_IDENTITY()
		
		EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2

		-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

		DECLARE @NotificationGroupID int
		SELECT @NotificationGroupID = NotificationGroupID
		FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

		INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
		SELECT @NotificationGroupID, UserID, 2
		FROM QMS_User 
		WHERE dbo.FNC_GetUserLevel(UserID) = 1 
		AND RecordStatus < 201
		AND UserID = @UserID
		AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
						WHERE NotificationGroupID = @NotificationGroupID 
						AND UserID = QMS_User.UserID
						AND RecordStatus < 201)

		-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

	END
END
ELSE --Update user
BEGIN
-- Don't change the username to an existing other username. It violates the single username principle of logging in.
	IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
	BEGIN
		SET @UserID = 0 -- This should cause the save procedure to fail.
	END
	ELSE
	BEGIN -- Username is still unique on all undeleted records.
		--JE - update passwords table (TFS 973)
		IF @Password IS NOT NULL
		BEGIN
			EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2
		END

		UPDATE    QMS_User
		SET			FullName = @FullName, UserName = @UserName, Position = @Position, EMail = @EMail, Mobile = @Mobile, PIN = @PIN, 
					LeftCompany = @LeftCompany, UserLevel = @UserLevel, LocaleID = @LocaleID, IsUserGroup = @IsUserGroup, ParentUserID = @ParentUserID, 
					Company = @Company, Updated = GETUTCDATE()
		WHERE     (UserID = @UserID)
	END
END

DECLARE @PermissionID int = NULL
IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
BEGIN --Setup linked supplier
	SELECT     @PermissionID = MAX(UserPermissionID)
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
	IF ISNULL(@PermissionID,0)=0 --Add permission
	BEGIN
		INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
		VALUES     (@UserID, 101,@SupplierID, 1)
	END
	ELSE
	BEGIN
		UPDATE	QMS_UserPermissions
		SET		PermissionAllow = 1, Updated = GETUTCDATE()
		WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
	END
	
	--Remove any existing permissions
	UPDATE  QMS_UserPermissions
	SET		PermissionAllow = 0, Updated = GETUTCDATE()
	WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
END


-- Setup CustomerID Link
SET @PermissionID = NULL -- in case it has a previous value
IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
BEGIN --Setup linked customer
	SELECT     @PermissionID = MAX(UserPermissionID)
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
	IF ISNULL(@PermissionID,0)=0 --Add permission
	BEGIN
		INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
		VALUES     (@UserID, 102,@CustomerID, 1)
	END
	ELSE
	BEGIN
		UPDATE	QMS_UserPermissions
		SET		PermissionAllow = 1, Updated = GETUTCDATE()
		WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
	END
	
	--Remove any existing permissions
	UPDATE  QMS_UserPermissions
	SET		PermissionAllow = 0, Updated = GETUTCDATE()
	WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
END


SET NOCOUNT OFF

SELECT @UserID

GO

--PRINT 'Updating sync procedures...'

--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
