-- =============================================
-- Author:		Jon Edwards
-- Create date: 10/11/2014
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 52
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

--PRINT 'Inserting tables...'

--PRINT 'Updating tables...'

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

PRINT 'Updating User Defined Functions...'
/****** Object:  UserDefinedFunction [dbo].[FNC_AssessmentQuestion_VersionChanges_Selected]    Script Date: 10/11/2014 11:11:07 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_AssessmentQuestion_VersionChanges_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_AssessmentQuestion_VersionChanges_Selected]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_AssessmentQuestion_VersionChanges_Selected]    Script Date: 10/11/2014 11:11:07 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_AssessmentQuestion_VersionChanges_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Markp
-- Create date: 12/10/2012
-- Description:	Gets question changes by assessment
-- Version:		2
-- =============================================
-- JE TFS 13-10507: updated to use FOR XML PATH rather than cursor
-- =============================================
CREATE FUNCTION [dbo].[FNC_AssessmentQuestion_VersionChanges_Selected] 
(
	@UserID INT
)
RETURNS 
@Questions TABLE 
(
	AssessmentID int,
	QuestionText nvarchar(1000)
)
AS

BEGIN
	DECLARE @group_data TABLE (AssessmentID int, Question nvarchar(255))
	INSERT @group_data (AssessmentID, Question)
	SELECT DISTINCT Assessment.AssessmentID, QMS_QuestionPool.Question
	FROM         QMS_AssessmentQuestion INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                      QMS_AssessmentQuestionConstraint ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = QMS_AssessmentQuestionConstraint.AssessmentQuestionID INNER JOIN
                          (SELECT     QMS_Assessment.AssessmentID, QMS_Assessment.Inserted
                            FROM          QMS_Assessment INNER JOIN
                                                   TEMP_Selected ON QMS_Assessment.AssessmentID = TEMP_Selected.SelectedID
                            WHERE      (QMS_Assessment.RecordStatus < 201) AND (QMS_Assessment.PreviousAssessmentID IS NOT NULL) AND (TEMP_Selected.UserID = @UserID)) 
                      AS Assessment ON QMS_AssessmentQuestion.AssessmentID = Assessment.AssessmentID
	WHERE     (QMS_AssessmentQuestion.Inserted > DATEADD(second, 30, Assessment.Inserted)) AND (QMS_AssessmentQuestion.RecordStatus < 201) OR
                      (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_AssessmentQuestion.Updated > DATEADD(second, 30, Assessment.Inserted)) OR
                      (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201) AND 
                      (QMS_AssessmentQuestionConstraint.Inserted > DATEADD(second, 30, Assessment.Inserted)) OR
                      (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201) AND 
                      (QMS_AssessmentQuestionConstraint.Updated > DATEADD(second, 30, Assessment.Inserted))
	ORDER BY Assessment.AssessmentID
	
	INSERT INTO @Questions (AssessmentID, QuestionText)
	SELECT	AssessmentID, 
		substring(
			(	SELECT '', '' + Question
				FROM @group_data
				WHERE AssessmentID = m.AssessmentID
				FOR XML PATH(''''), type
			).value(''.'', ''nvarchar(max)''), 
			3, 
			1000) -- (max is 2147483647 - we are truncating deliberately)
					
		AS Question
	FROM @group_data m
	GROUP BY AssessmentID

	RETURN 

END
' 
END

GO

PRINT 'Updating Stored Procedures...'

/****** Object:  StoredProcedure [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse]    Script Date: 10/11/2014 11:17:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_List]    Script Date: 10/11/2014 11:17:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_List]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_CorrectiveAction_List]
GO
/****** Object:  StoredProcedure [dbo].[QRY_AssessmentQuestion_GetGuidance]    Script Date: 10/11/2014 11:17:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_AssessmentQuestion_GetGuidance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance]
GO
/****** Object:  StoredProcedure [dbo].[QRY_AssessmentQuestion_GetGuidance]    Script Date: 10/11/2014 11:17:41 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_AssessmentQuestion_GetGuidance]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/03/2010
-- version 2
-- Description:	Gets the guidance detail for the selected assessment question
-- TFS 10889 - Mobile guidance should be reordered in Guidance popup
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] 
	@AssessmentQuestionID int
AS

--Constraint guidance
SELECT     ISNULL(QMS_CustomLookupItem.LookupText, APP_QAFlag.QAFlag) AS Title, CAST(NULL AS image) AS AttachmentImage, Constraint_Guidance.Attachment, 
                      Constraint_Guidance.AttachmentFileName, Constraint_Guidance.AttachmentTitle, QMS_AssessmentQuestionConstraint.ShortGuidance, 
                      Constraint_Guidance.GuidanceDesc, Constraint_Guidance.GuidanceString, Constraint_Guidance.GuidanceURL, QMS_AssessmentQuestionConstraint.QAFlagID
FROM         APP_QAFlag RIGHT OUTER JOIN
                      QMS_AssessmentQuestionConstraint ON APP_QAFlag.QAFlagID = QMS_AssessmentQuestionConstraint.QAFlagID LEFT OUTER JOIN
                          (SELECT     QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL, 
                                                   ISNULL(Attachments.AttachmentTitle, Linked_Attachments.AttachmentTitle) AS AttachmentTitle, ISNULL(Attachments.Attachment, 
                                                   Linked_Attachments.Attachment) AS Attachment, ISNULL(Attachments.AttachmentFileName, Linked_Attachments.AttachmentFileName) 
                                                   AS AttachmentFileName
                            FROM          QMS_Guidance LEFT OUTER JOIN
                                                       (SELECT     LastAttachment.Sys_GuidanceID, Attachment_Linked.AttachmentTitle, Attachment_Linked.Attachment, 
                                                                                Attachment_Linked.AttachmentFileName
                                                         FROM          (SELECT     QMS_Guidance.Sys_GuidanceID, MAX(Attachment_Linked.Created) AS MaxCreated
                                                                                 FROM          QMS_Attachment AS Attachment_Linked INNER JOIN
                                                                                                        QMS_Guidance ON Attachment_Linked.SourceObjectID = QMS_Guidance.GuidanceID
                                                                                 WHERE      (Attachment_Linked.AttachmentSourceID = 3) AND (Attachment_Linked.RecordStatus < 201) AND 
                                                                                                        (QMS_Guidance.RecordStatus < 201)
                                                                                 GROUP BY QMS_Guidance.Sys_GuidanceID) AS LastAttachment INNER JOIN
                                                                                QMS_Attachment AS Attachment_Linked ON LastAttachment.MaxCreated = Attachment_Linked.Created INNER JOIN
                                                                                QMS_Guidance AS Guidance ON LastAttachment.Sys_GuidanceID = Guidance.Sys_GuidanceID AND 
                                                                                Attachment_Linked.SourceObjectID = Guidance.GuidanceID
                                                         WHERE      (Attachment_Linked.AttachmentSourceID = 3) AND (Attachment_Linked.RecordStatus < 201)) AS Linked_Attachments ON 
                                                   QMS_Guidance.Sys_GuidanceID = Linked_Attachments.Sys_GuidanceID LEFT OUTER JOIN
                                                       (SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName
                                                         FROM          QMS_Attachment
                                                         WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)) AS Attachments ON QMS_Guidance.GuidanceID = Attachments.GuidanceID
                            WHERE      (QMS_Guidance.RecordStatus < 201) AND (QMS_Guidance.Hide = 0)) AS Constraint_Guidance ON 
                      QMS_AssessmentQuestionConstraint.GuidanceID = Constraint_Guidance.GuidanceID LEFT OUTER JOIN
                      QMS_CustomLookupItem ON QMS_AssessmentQuestionConstraint.Constraint_SourceID = QMS_CustomLookupItem.CustomLookupItemID
WHERE     (ISNULL(LEN(QMS_AssessmentQuestionConstraint.ShortGuidance), 0) > 0) AND 
                      (QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID) AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201) OR
                      (QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID) AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201) AND 
                      (Constraint_Guidance.GuidanceID IS NOT NULL)
ORDER BY QMS_AssessmentQuestionConstraint.QAFlagID


--Question guidance
SELECT     QMS_QuestionPool.Question AS Title, CAST(NULL AS image) AS AttachmentImage, Question_Guidance.Attachment, Question_Guidance.AttachmentFileName, Question_Guidance.AttachmentTitle, 
                      QMS_AssessmentQuestion.ShortGuidance, Question_Guidance.GuidanceDesc, Question_Guidance.GuidanceString, Question_Guidance.GuidanceURL, 
                      CAST(NULL AS int) AS QAFlagID
FROM         QMS_AssessmentQuestion INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                          (SELECT     QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL, 
                                                   Attachments.AttachmentTitle, Attachments.Attachment, Attachments.AttachmentFileName
                            FROM          QMS_Guidance LEFT OUTER JOIN
                                                       (SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName
                                                         FROM          QMS_Attachment
                                                         WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)) AS Attachments ON 
                                                   QMS_Guidance.GuidanceID = Attachments.GuidanceID
                            WHERE      (QMS_Guidance.RecordStatus < 201) AND (QMS_Guidance.Hide = 0)) AS Question_Guidance ON 
                      QMS_AssessmentQuestion.GuidanceID = Question_Guidance.GuidanceID
WHERE     (QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) AND (ISNULL(LEN(QMS_AssessmentQuestion.ShortGuidance), 0) 
                      > 0) OR
                      (QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) AND (Question_Guidance.GuidanceID IS NOT NULL)




GO
/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_List]    Script Date: 10/11/2014 11:17:41 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_List]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_List] AS' 
END
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	20/5/2014
-- Description:	Lists all corrective actions for corrective action manager screen.
-- Version:		3
-- ===================================================
-- JT TFS 13-3845: Created
-- JT TFS 13-7000: Order by DateOccurred DESC, so that any truncations chop off old CAs first.
-- JT TFS 13-8870: Add source column.
-- ===================================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_List]
	@UserID int = 1,
	@DateFrom datetime = NULL,
	@DateTo datetime = NULL,
	@IsFilterApplied bit = 0
AS
BEGIN
	/* NOTE: Supplier and location filters work differently. All other filters are response filters. */

	-- NOTE: DateDeadline is the first sort order for completed.
	--       DateFailed is the first sort order for failed.
	--       DateCompleted is the first sort order for signed off.

	BEGIN -- setup temp tables 
		SET NOCOUNT ON 
		
		IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
		CREATE TABLE #tmpUserCAs (
			CorrectiveActionID int,
			IsActive bit NULL
		)
		
		IF @IsFilterApplied = 1
		BEGIN
			INSERT INTO	#tmpUserCAs (CorrectiveActionID, IsActive)
			SELECT CorrectiveActionID, NULL FROM TEMP_CorrectiveActionFilter
			WHERE UserID = @UserID
		
		END ELSE BEGIN
		
			--temp table containing all CAs (i.e. all statuses) user has permission to see
			INSERT INTO	#tmpUserCAs (CorrectiveActionID, IsActive)
			SELECT	CorrectiveActionID, convert(bit, 1) as IsActive
			FROM	dbo.FNC_User_CorrectiveActionList(@UserID, 1)

			INSERT INTO	#tmpUserCAs (CorrectiveActionID, IsActive)
			SELECT	CorrectiveActionID, 0
			FROM	dbo.FNC_User_CorrectiveActionList(@UserID, 0)
			
		END

		--populate temp table with CA refs and their Reviewers' names
		IF nullif(object_id('tempdb..#tmpCAReviewers'), 0) IS NOT NULL DROP TABLE #tmpCAReviewers
		CREATE TABLE #tmpCAReviewers (
			CorrectiveActionID int,
			Reviewers nvarchar(500)
		)
		INSERT INTO #tmpCAReviewers
		SELECT	CorrectiveActionID, dbo.FNC_CorrectiveAction_ReviewList(QMS_CorrectiveAction.CorrectiveActionID) AS Reviewers
		FROM	QMS_CorrectiveAction
		
		SET NOCOUNT OFF
	END 

	SELECT 
			QMS_CorrectiveAction.CorrectiveActionID,
			dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) AS CARef,
			CAResponseList.ResponseID,
			QMS_CorrectiveAction.CATitle,
			QMS_CorrectiveAction.CASubTitle,
			QMS_CorrectiveAction.CAReason,
			QMS_CorrectiveAction.CARequired,
			QMS_CorrectiveAction.ActionTaken,
			QMS_CorrectiveAction.Comments,
			ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS [Status],
			CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (1,2) THEN 'new'
			     WHEN APP_CorrectiveActionStatus.CAStatusID IN (4,5) THEN 'completed'
																	 ELSE 'failed' END AS [StatusClass],
			APP_PriorityLevel.PriorityLevel,
			QMS_CorrectiveAction.DateOccurred,
			QMS_CorrectiveAction.DateLogged,
			QMS_CorrectiveAction.DateDeadline,
			QMS_CorrectiveActionType.CorrectiveActionType,
			QMS_CorrectiveActionEscalation.ListIndex AS [EscalationLevel],
			PM_VW_Location.LocationName AS Location,
			ISNULL(QMS_NotificationGroup.NotificationGroup, ISNULL(QMS_User_Assign.FullName, Supplier_Assign.SupplierName)) AS [AssignedTo],
			QMS_User_Logged.FullName AS [LoggedBy],
			QMS_CorrectiveAction.DateFailed,
			QMS_CorrectiveAction.DateCompleted,
			QMS_User_Completed.FullName AS [CompletedBy],
			CAReviewers.Reviewers AS [ReviewedBy],
			QMS_User_SignedOff.FullName AS [SignedOffBy],
			QMS_CorrectiveAction.DateSignedOff,
			QMS_CorrectiveAction.CAStatusID,

			CASE WHEN QMS_CorrectiveAction.CASourceID = 4 THEN N'Ad-Hoc'
					 WHEN QMS_CorrectiveAction.CASourceID = 3 THEN N'CA: ' + dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.SourceObjectID)
					 WHEN QMS_CorrectiveAction.CASourceID = 2 THEN 'Question'
					 WHEN QMS_CorrectiveAction.CASourceID = 1 THEN 'Check'
			END AS [Source],

			IsOutstanding = CASE WHEN APP_CorrectiveActionStatus.CAStatusID < 3 THEN 1 ELSE 0 END,
			IsLoggedByMe = CASE WHEN QMS_CorrectiveAction.Logged_UserID = @UserID THEN 1 ELSE 0 END,
			IsAssignedToMe = CASE WHEN EXISTS (	SELECT * FROM dbo.FNC_CorrectiveAction_AssignUsers() AssignUser 
												WHERE AssignUser.CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID
												AND AssignUser.UserID = @UserID) THEN 1 ELSE 0 END,
			IsCompleted = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 4 THEN 1 ELSE 0 END,
			IsFailed = CASE WHEN APP_CorrectiveActionStatus.CAStatusID IN (3,6,7) THEN 1 ELSE 0 END,
			IsSignedOff = CASE WHEN APP_CorrectiveActionStatus.CAStatusID = 5 THEN 1 ELSE 0 END
		
	FROM QMS_CorrectiveAction
	INNER JOIN #tmpUserCAs AS UserCAList ON QMS_CorrectiveAction.CorrectiveActionID = UserCAList.CorrectiveActionID
	INNER JOIN #tmpCAReviewers AS CAReviewers ON UserCAList.CorrectiveActionID = CAReviewers.CorrectiveActionID
	INNER JOIN dbo.FNC_CorrectiveAction_Response() AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
	INNER JOIN APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	INNER JOIN QMS_User AS QMS_User_Logged ON QMS_CorrectiveAction.Logged_UserID = QMS_User_Logged.UserID
	LEFT OUTER JOIN QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
	LEFT OUTER JOIN QMS_CorrectiveActionType ON QMS_CorrectiveActionType.CorrectiveActionTypeID = QMS_CorrectiveAction.CorrectiveActionTypeID 
	LEFT OUTER JOIN QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Assign ON QMS_CorrectiveAction.AssignUserID = QMS_User_Assign.UserID 
	LEFT OUTER JOIN QMS_User AS QMS_User_Completed ON QMS_CorrectiveAction.Completed_UserID = QMS_User_Completed.UserID
	LEFT OUTER JOIN QMS_User AS QMS_User_SignedOff ON QMS_CorrectiveAction.SignOff_UserID = QMS_User_SignedOff.UserID
	LEFT OUTER JOIN APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID 
	LEFT OUTER JOIN PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
	LEFT OUTER JOIN PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID 
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR DateOccurred > @DateFrom)-- OR DateDeadline > @DateFrom OR DateCompleted > @DateFrom OR DateFailed > @DateFrom)
	AND (@DateTo IS NULL OR DateOccurred <= @DateTo)-- OR DateDeadline <= @DateTo OR DateCompleted <= @DateTo OR DateFailed <= @DateTo)
	ORDER BY	QMS_CorrectiveAction.DateOccurred DESC,
				QMS_CorrectiveAction.CorrectiveActionID DESC

	--get list of columns that need to be hidden in Excel export
	--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
	SELECT	1 AS TableIndex, convert(bit, 1) as ExportSetupTable, 'Portrait/Landscape' AS Orientation, 'n/a' AS SheetName, 'n/a' AS HiddenColumns
	UNION SELECT 0, 0, 'Landscape', 'Corrective Actions', 'CAStatusID,StatusClass,IsOutstanding,IsLoggedByMe,IsAssignedToMe,IsCompleted,IsFailed,IsSignedOff'
	ORDER BY TableIndex ASC

END

GO
/****** Object:  StoredProcedure [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse]    Script Date: 10/11/2014 11:17:41 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse] AS' 
END
GO

-- =============================================
-- Author:		Markp
-- Create date: 09/06/2011
-- Description:	Lookup previous assessments with matching header responses for repeat checks
-- Version: 6
-- =============================================
-- JE TFS 4162 - added checking of QMS_ResponseHeader.Header_Date too so date fields can be matched for repeat checks
-- JE TFS 5105 CAS-15187-CW55FM - added extra clause in date matching sub query as this was picking up values other than just dates
-- MP TFS 5246 - query failed when more than 1 header date field existed in list to match
-- JF TFS 2279 - Make change to repeat check process so that it can copy across assessment types - this will match on assessment header text rather than ID
-- JE TFS 13-10513: check config value to see if incomplete checks can be used to fill repeat check responses
-- =============================================
ALTER PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_RepeatCheckReponse] 
	@UserID int, 
	@AssessmentID int 
AS

SET NOCOUNT ON

--get option value for EnableRepeatCheckProcess
DECLARE @RepeatForIncompleteChecks int
SELECT @RepeatForIncompleteChecks = dbo.FNC_GetOptionValue(52)

DECLARE @ResponseCount int

--get number of header responses that need to match for a repeat check to be performed
SELECT     @ResponseCount = COUNT(*)
FROM         TEMP_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (TEMP_ResponseHeader.UserID = @UserID) AND (QMS_AssessmentHeader.MatchRepeatCheck = 1)

DELETE FROM TEMP_Selected
WHERE     (UserID = @UserID)

IF @ResponseCount > 0
BEGIN
	INSERT INTO TEMP_Selected (SelectedID, SelectedValue, UserID)
	SELECT     QMS_ResponseHeader.ResponseID, COUNT(QMS_ResponseHeader.ResponseHeaderID) AS HeaderCount, @UserID AS UserID
	FROM         
		(SELECT     AssessmentHeaderID, Header_Text, CASE WHEN ISDATE(TEMP_ResponseHeader.Header_Text) = 1 AND 
						TEMP_ResponseHeader.Header_Text LIKE '%[ /-\]%' THEN DATEADD(dd, 0, DATEDIFF(dd, 0, 
						CAST(TEMP_ResponseHeader.Header_Text AS smalldatetime))) ELSE CAST(NULL AS smalldatetime) END AS Header_Date
		 FROM          TEMP_ResponseHeader
		 WHERE      (UserID = @UserID)
		) AS TEMP_Header 
	INNER JOIN  QMS_ResponseHeader ON TEMP_Header.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID AND 
	(TEMP_Header.Header_Text = QMS_ResponseHeader.Header_Text OR  TEMP_Header.Header_Date = DATEADD(dd, 0, DATEDIFF(dd, 0, CAST(QMS_ResponseHeader.Header_Date AS smalldatetime)))) 
	INNER JOIN  QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID 
	INNER JOIN  QMS_AssessmentHeader ON TEMP_Header.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE     
		(QMS_Response.AssessmentID = @AssessmentID) AND 
		(QMS_Response.RecordStatus < 201) AND 
		(QMS_ResponseHeader.RecordStatus < 201) AND 
		((@RepeatForIncompleteChecks = 1 AND QMS_Response.ResponseStatus = 1) OR (@RepeatForIncompleteChecks = 2)) AND
		(QMS_AssessmentHeader.MatchRepeatCheck = 1)
	GROUP BY QMS_ResponseHeader.ResponseID
	HAVING      (COUNT(QMS_ResponseHeader.ResponseHeaderID) = @ResponseCount)
	ORDER BY QMS_ResponseHeader.ResponseID DESC
	
	
	--if cant find a match, check in other assessment types but will have to join on HeaderText rather than AssessmentHeaderID
	IF NOT EXISTS (SELECT SelectedID FROM TEMP_Selected WHERE UserID = @UserID)
	
		INSERT INTO TEMP_Selected (SelectedID, SelectedValue, UserID)
		SELECT     QMS_ResponseHeader.ResponseID, COUNT(QMS_ResponseHeader.ResponseHeaderID) AS HeaderCount, @UserID AS UserID
		FROM         
			(SELECT     AssessmentHeaderID, Header_Text, CASE WHEN ISDATE(TEMP_ResponseHeader.Header_Text) = 1 AND 
													  TEMP_ResponseHeader.Header_Text LIKE '%[ /-\]%' THEN DATEADD(dd, 0, DATEDIFF(dd, 0, 
													  CAST(TEMP_ResponseHeader.Header_Text AS smalldatetime))) ELSE CAST(NULL AS smalldatetime) END AS Header_Date
							   FROM          TEMP_ResponseHeader
							   WHERE      (UserID = @UserID)
			) AS TEMP_Header 
		INNER JOIN  QMS_AssessmentHeader as QMS_AssessmentHeader_DEST ON TEMP_Header.AssessmentHeaderID = QMS_AssessmentHeader_DEST.AssessmentHeaderID
		INNER JOIN QMS_AssessmentHeader as QMS_AssessmentHeader_SRC ON QMS_AssessmentHeader_SRC.HeaderText = QMS_AssessmentHeader_DEST.HeaderText 
		INNER JOIN  QMS_ResponseHeader ON QMS_AssessmentHeader_SRC.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID AND 
		(TEMP_Header.Header_Text = QMS_ResponseHeader.Header_Text OR  TEMP_Header.Header_Date = DATEADD(dd, 0, DATEDIFF(dd, 0, CAST(QMS_ResponseHeader.Header_Date AS smalldatetime)))) 
		INNER JOIN  QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID 

		WHERE     
			(QMS_Response.AssessmentID = @AssessmentID) AND 
			(QMS_Response.RecordStatus < 201) AND 
			(QMS_ResponseHeader.RecordStatus < 201) AND 
			((@RepeatForIncompleteChecks = 1 AND QMS_Response.ResponseStatus = 1) OR (@RepeatForIncompleteChecks = 2)) AND
			--(QMS_AssessmentHeader.MatchRepeatCheck = 1)
			(QMS_AssessmentHeader_DEST.MatchRepeatCheck = 1) AND
			
			(QMS_AssessmentHeader_DEST.AssessmentHeaderID  = QMS_AssessmentHeader_SRC.AssessmentHeaderID  OR
			exists --check the assessment links
				(
				SELECT AssessmentTypeMultiID 
				FROM 	QMS_Assessment INNER JOIN QMS_AssessmentTypeMulti ON QMS_AssessmentTypeMulti.AssessmentID=QMS_Assessment.AssessmentID 
				WHERE QMS_Assessment.AssessmentID = @AssessmentID and 
				QMS_AssessmentTypeMulti.RecordStatus <201 and 
				QMS_Assessment.AssessmentTypeID = QMS_AssessmentHeader_DEST.AssessmentTypeID and 
				QMS_AssessmentTypeMulti.AssessmentTypeID = QMS_AssessmentHeader_SRC.AssessmentTypeID
				)
			)		
			
		GROUP BY QMS_ResponseHeader.ResponseID
		HAVING      (COUNT(QMS_ResponseHeader.ResponseHeaderID) = @ResponseCount)
		ORDER BY QMS_ResponseHeader.ResponseID DESC
		

END
SET NOCOUNT OFF

SELECT     SelectedID AS ResponseID
FROM         TEMP_Selected
WHERE     (UserID = @UserID)


GO

--PRINT 'Updating sync procedures...'

--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
