-- =============================================
-- Author:		Jon Edwards
-- Create date: 25/09/2014
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 50
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

--PRINT 'Inserting tables...'

--PRINT 'Updating tables...'

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

PRINT 'Updating User Defined Functions...'

/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_Response]    Script Date: 30/09/2014 11:49:52 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_Response]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_CorrectiveAction_Response]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_User_CorrectiveActionList]    Script Date: 30/09/2014 11:49:52 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_User_CorrectiveActionList]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_User_CorrectiveActionList]    Script Date: 30/09/2014 11:49:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_User_CorrectiveActionList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 27/01/2012
-- Description:	Returns list of Corrective Actions
-- Version: 19
-- =============================================
-- TFS 2757 added Supplier permission filtering
-- TFS 3003 Locations now picking up DataLookupID 53 (suppier site) too
-- TFS 3321 Added Business Group and Stock Code Sub Group permission checking
-- TFS 3509 Corrected filtering so able to handle Supplier AND Location permissions
-- TFS 4094 Supplier AND Location filtering changed to not show ad-hoc CAs.
-- JE TFS 4279 Simplified and added Stock Code permission checking
-- JE TFS 5485 Ad Hoc CAs (not linked to any location or stock code) now returned too
-- JE TFS 5690 Added Ad Hoc CA selection to Supplier selects
-- JE TFS 5642 Ad-Hoc CAs assigned directly to users are now displayed
-- JE TFS 5857 Removed redundant code and corrected Ad-Hoc CA visibility
-- JE TFS 6004 Added check that Responses always have a Location that Supplier has permission on
-- MP TFS 5873 Added code to handle CAs links to checks (not questons)
-- JE TFS 6185 Updated for non-Supplier users with check whether to apply Stock Code permissions or not
-- JE TFS 7839 Updated to filter available CAs by a (non-supplier) user''s location permissons
-- JE TFS 7982 Updated to include CAs where no location is assigned
-- JE TFS 8045 Updated to include CAs where LocationID = 0 (i.e. no Location assigned)
-- JE TFS 7586 Include Failed (CAStatusID 3) and Rejected (6) CAs where IsActive = True
-- JT TFS 13-3845 Avoid use of union when joining on stockcode to improve performance
-- JE TFS 13-7950: include CAs where CASourceID = 3 (i.e. raised from another CA)
-- =============================================
CREATE FUNCTION [dbo].[FNC_User_CorrectiveActionList]
(
	@UserID int,
	@IsActive bit
)
RETURNS
@CorrectiveActions TABLE
(
	CorrectiveActionID int
)
AS
BEGIN

	--Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserLevel = 1 --Admin can see hidden/void checks
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 180
	
	DECLARE @Table_Location TABLE (LocationID int)
	
	--updated in TFS 2757 - only make CAs available to Suppliers if CA is associated with permitted supplier
	IF @UserLevel = 9
	BEGIN
	
		--Get table of available locations
		INSERT INTO @Table_Location (LocationID)
		SELECT     CAST(PermissionTitle AS int) AS LocationID
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 103) AND (PermissionAllow = 1) AND (UserID = @UserID)
		
		--Get table of permitted Suppliers for user
		DECLARE @Table_Supplier TABLE (SupplierID int)
		INSERT INTO @Table_Supplier (SupplierID)
		SELECT		PermissionTitle AS SupplierID
		FROM		QMS_UserPermissions
		WHERE		(PermissionType = 101) AND (PermissionAllow = 1) AND (UserID = @UserID)		
	
		--If just Supplier permissions
		IF (SELECT COUNT (LocationID) FROM @Table_Location)=0 AND (SELECT COUNT (SupplierID) FROM @Table_Supplier)>0
		--Check CA status
		BEGIN
			--get CAs which are assigned to Supplier(s) user has permission on
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	QMS_CorrectiveAction.CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)))
		END
		
		--If Supplier AND Location permissions
		IF (SELECT COUNT (LocationID) FROM @Table_Location)>0 AND (SELECT COUNT (SupplierID) FROM @Table_Supplier)>0
		BEGIN
			--Table of ResponseIDs linked to locations
			DECLARE @Table_ResponseLocationSupplier TABLE (ResponseID int, ResponseStatus int, LocationID int)
			INSERT INTO @Table_ResponseLocationSupplier (ResponseID, ResponseStatus, LocationID)
			SELECT	QMS_Response.ResponseID, QMS_Response.ResponseStatus, User_Location.LocationID
			FROM	QMS_Response INNER JOIN
						  (SELECT	ResponseHeader_Location.ResponseID, ResponseHeader_Location.Header_SourceID AS LocationID
							FROM		QMS_ResponseHeader AS ResponseHeader_Location INNER JOIN
											QMS_AssessmentHeader AS AssessmentHeader_Location ON 
											ResponseHeader_Location.AssessmentHeaderID = AssessmentHeader_Location.AssessmentHeaderID INNER JOIN
											@Table_Location AS Location ON ResponseHeader_Location.Header_SourceID = Location.LocationID
							WHERE	(AssessmentHeader_Location.DataTypeID = 9) AND (AssessmentHeader_Location.DataLookupID = 4 OR 
											AssessmentHeader_Location.DataLookupID = 53)) AS User_Location ON 
					QMS_Response.ResponseID = User_Location.ResponseID
			WHERE     (QMS_Response.RecordStatus < @RecordStatus)

			--get CAs linked to Suppliers and Locations user has permissions on - where CA linked to question
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID LEFT OUTER JOIN
						QMS_ResponseQuestion ON QMS_CorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
						@Table_ResponseLocationSupplier AS ResponseLocationSupplier ON QMS_ResponseQuestion.ResponseID = ResponseLocationSupplier.ResponseID
			WHERE	((@IsActive = 1 AND CAStatusID IN (1,2,3,6) AND CASourceID = 2) --Check for CAs that are New, In Progress, Failed or Rejected
					OR
					(@IsActive = 0 AND CAStatusID NOT IN (1,2,3,6))  AND CASourceID = 2)
					--suppliers with supplier permissions will always have location permissions for that supplier too, so check responses have a location supplier has permission for
					AND ResponseLocationSupplier.LocationID IS NOT NULL
					
			--get CAs linked to Suppliers and Locations user has permissions on - where CA linked to check
			INSERT INTO @CorrectiveActions(CorrectiveActionID)
			SELECT	CorrectiveActionID
			FROM	QMS_CorrectiveAction INNER JOIN
						@Table_Supplier AS Supplier ON QMS_CorrectiveAction.AssignSupplierID = Supplier.SupplierID LEFT OUTER JOIN
						@Table_ResponseLocationSupplier AS ResponseLocationSupplier ON QMS_CorrectiveAction.SourceObjectID = ResponseLocationSupplier.ResponseID
			WHERE	((@IsActive = 1 AND CAStatusID IN (1,2,3,6) AND CASourceID = 1) --Check for CAs that are New, In Progress, Failed or Rejected
					OR
					(@IsActive = 0 AND CAStatusID NOT IN (1,2,3,6))  AND CASourceID = 1)
					--suppliers with supplier permissions will always have location permissions for that supplier too, so check responses have a location supplier has permission for
					AND ResponseLocationSupplier.LocationID IS NOT NULL
		END
	END
	
--User Level is not 9 (Supplier), check Stock Code hierarchy permissions if they are assigned and that user''s Location permissions
	IF @UserLevel <> 9
	BEGIN
		--Get table of available Locations user has permissions for
		INSERT INTO @Table_Location (LocationID)
		SELECT	CAST(PermissionTitle AS int) AS LocationID
		FROM	QMS_UserPermissions
		WHERE	(PermissionType = 103) AND (PermissionAllow = 1) AND (UserID = @UserID)

		--get table of CAs that are linked to above Locations
		DECLARE @Table_LocationCorrectiveAction TABLE (CorrectiveActionID int, SourceObjectID int, CAStatusID int, CASourceID int)
		INSERT INTO @Table_LocationCorrectiveAction (CorrectiveActionID, SourceObjectID, CAStatusID, CASourceID)
		SELECT	CorrectiveActionID, SourceObjectID, CAStatusID, CASourceID
		FROM	QMS_CorrectiveAction
		WHERE	((@UserLevel <> 1) AND (LocationID IN (SELECT LocationID FROM @Table_Location))) --restrict non-admin users visiblity of CAs to those assigned to their Location(s) only
					OR
				(@UserLevel = 1) --Admin can access all CAs
					OR
				((@UserLevel <> 1) AND (SELECT COUNT(LocationID) FROM @Table_Location) = 0) --show all CAs if user has NO Location permissions
						OR
				((QMS_CorrectiveAction.LocationID IS NULL) OR (QMS_CorrectiveAction.LocationID = 0)) --also include all CAs that aren''t assigned to a Location
	
		--get Stock Code permissions for user
		DECLARE @Table_UserStockCodes TABLE (ResponseID int, StockCodeID int)
		INSERT INTO @Table_UserStockCodes (ResponseID, StockCodeID)
		SELECT	ResponseHeader_StockCode.ResponseID, ResponseHeader_StockCode.Header_SourceID AS StockCodeID
		FROM	QMS_ResponseHeader AS ResponseHeader_StockCode INNER JOIN
					QMS_AssessmentHeader AS AssessmentHeader_StockCode ON ResponseHeader_StockCode.AssessmentHeaderID = AssessmentHeader_StockCode.AssessmentHeaderID INNER JOIN
					dbo.FNC_User_StockCodeList(@UserID) AS StockCodes ON ResponseHeader_StockCode.Header_SourceID = StockCodes.StockCodeID
		WHERE	(AssessmentHeader_StockCode.DataTypeID = 9) AND (AssessmentHeader_StockCode.DataLookupID = 2)
		
		DECLARE @ca_staging TABLE (CorrectiveActionID int)
		IF  (SELECT COUNT (UserPermissionID) FROM QMS_UserPermissions WHERE (UserID = @UserID) AND (PermissionAllow = 1) AND (PermissionType IN (104,105,106))) > 0 --user has Stock Code permissions, so check these
		BEGIN
			--get Question Level CAs linked to StockCodes user has permission to
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						QMS_ResponseQuestion ON LocationCorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID INNER JOIN
						@Table_UserStockCodes AS User_StockCodes ON	QMS_ResponseQuestion.ResponseID = User_StockCodes.ResponseID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 2))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 2))
		
			--get CAs linked at check level
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						@Table_UserStockCodes AS User_StockCodes ON	LocationCorrectiveAction.SourceObjectID = User_StockCodes.ResponseID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 1))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 1))
			
			--get Ad-Hoc CAs (not linked to a Response)
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction
			WHERE	(((@IsActive = 1) AND (CASourceID = 4) AND (CAStatusID IN (1,2,3,6)))
					OR
					((@IsActive = 0) AND (CASourceID = 4) AND (CAStatusID NOT IN (1,2,3,6))))

			--get CAs linked to another CA that user has permission to view
			INSERT @ca_staging (CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction
			WHERE	(SourceObjectID IN (SELECT SourceObjectID FROM @Table_LocationCorrectiveAction))
					AND
					((((@IsActive = 1) AND (CASourceID = 3) AND (CAStatusID IN (1,2,3,6)))
					OR
					((@IsActive = 0) AND (CASourceID = 3) AND (CAStatusID NOT IN (1,2,3,6)))))

		END
		ELSE
		BEGIN
			--get Question Level CAs
			INSERT INTO @ca_staging(CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction INNER JOIN
						QMS_ResponseQuestion ON LocationCorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID = 2))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID = 2))
					
			--get CAs linked at check level, Ad-Hoc CAs (not linked to a Response) and CAs linked to another CA
			INSERT INTO @ca_staging(CorrectiveActionID)
			SELECT	LocationCorrectiveAction.CorrectiveActionID
			FROM	@Table_LocationCorrectiveAction AS LocationCorrectiveAction
			WHERE	((@IsActive = 1) AND (CAStatusID IN (1,2,3,6)) AND (CASourceID IN (1,4,3)))
					OR
					((@IsActive = 0) AND (CAStatusID NOT IN (1,2,3,6)) AND (CASourceID IN (1,4,3)))

		END

		INSERT INTO @CorrectiveActions(CorrectiveActionID)
		SELECT CorrectiveActionID FROM @ca_staging 
		GROUP BY CorrectiveActionID

	END
	RETURN
END
' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_CorrectiveAction_Response]    Script Date: 30/09/2014 11:49:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_CorrectiveAction_Response]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Jon Edwards
-- Create date: 15/02/2012
-- Description:	Returns a list of all CA''s and their associated responses
-- Version:		2
-- =============================================
-- JE TFS 13-7950: added SELECT for CAs logged from an Ad Hoc CA
-- =============================================
CREATE FUNCTION [dbo].[FNC_CorrectiveAction_Response]
(	
)
RETURNS TABLE 
AS
RETURN 
(
	--Ad-Hoc CA''s (no ResponseID)
	SELECT	CorrectiveActionID, SourceObjectID As ResponseID
	FROM	QMS_CorrectiveAction
	WHERE	CASourceID = 4
	UNION
	--CA''s directly from a Response
	SELECT	CorrectiveActionID, SourceObjectID AS ResponseID
	FROM	QMS_CorrectiveAction
	WHERE	CASourceID = 1 
	UNION
	--CA''s logged from a ResponseQuestion
	SELECT	CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction INNER JOIN
				QMS_ResponseQuestion ON QMS_CorrectiveAction.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	CASourceID = 2
	UNION
	--CA''s logged from another CA
	SELECT	CA_1.CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction CA_1 INNER JOIN
				QMS_CorrectiveAction CA_2 ON CA_1.SourceObjectID = CA_2.CorrectiveActionID INNER JOIN
				QMS_ResponseQuestion ON CA_2.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	CA_1.CASourceID = 3
	UNION
	--CAs logged from another Ad Hoc CA
	SELECT	CA_1.CorrectiveActionID, ResponseID
	FROM	QMS_CorrectiveAction  CA_1 INNER JOIN
				QMS_CorrectiveAction CA_2 ON CA_1.SourceObjectID = CA_2.CorrectiveActionID LEFT OUTER JOIN
				QMS_ResponseQuestion ON CA_2.SourceObjectID = QMS_ResponseQuestion.ResponseQuestionID
	WHERE	(CA_1.CASourceID) = 3 AND (QMS_ResponseQuestion.ResponseQuestionID IS NULL)
)
' 
END

GO


PRINT 'Updating Stored Procedures...'

/****** Object:  StoredProcedure [dbo].[QRY_User_Combo]    Script Date: 25/09/2014 15:49:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_Combo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_User_Combo]
GO
/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_Alert]    Script Date: 25/09/2014 15:49:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_Alert]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_CorrectiveAction_Alert]
GO
/****** Object:  StoredProcedure [dbo].[PM_SAVE_StockCode_DefaultCount]    Script Date: 25/09/2014 15:49:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_SAVE_StockCode_DefaultCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PM_SAVE_StockCode_DefaultCount]
GO
/****** Object:  StoredProcedure [dbo].[APP_Temp_ReportFilter_CorrectiveAction]    Script Date: 25/09/2014 15:49:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APP_Temp_ReportFilter_CorrectiveAction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[APP_Temp_ReportFilter_CorrectiveAction]
GO
/****** Object:  StoredProcedure [dbo].[APP_Attachment_AssessmentCopy]    Script Date: 25/09/2014 15:49:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APP_Attachment_AssessmentCopy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[APP_Attachment_AssessmentCopy]
GO
/****** Object:  StoredProcedure [dbo].[APP_Attachment_AssessmentCopy]    Script Date: 25/09/2014 15:49:09 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APP_Attachment_AssessmentCopy]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[APP_Attachment_AssessmentCopy] AS' 
END
GO

-- =============================================
-- Author:		Markp
-- Create date: 09/06/2010
-- Description:	Copy the attachments from one assessment to another
-- Version:		3
-- =============================================
-- JT TFS 8211: Renamed from QAS_APP_Attachment_AssessmentCopy (and don't duplicate attachments if called twice)
-- JT TFS 8290: Copy Attachments using Sys_AssSpecHeaderID
-- =============================================
ALTER PROCEDURE [dbo].[APP_Attachment_AssessmentCopy] 
	@SourceAssessmentID int, 
	@NewAssessmentID int,
	@UserID int
AS

--Copy spec header attachments
INSERT INTO QMS_Attachment
                      (Attachment, AttachmentURL, UserID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName)
SELECT		QMS_Attachment_Original.Attachment, 
			QMS_Attachment_Original.AttachmentURL, 
			@UserID AS UserID, 
			QMS_Attachment_Original.AttachmentSourceID, 
            QMS_AssessmentSpecHeader_New.AssessmentSpecHeaderID, 
            QMS_Attachment_Original.AttachmentTitle, 
            QMS_Attachment_Original.AttachmentFileName
FROM         QMS_AssessmentSpecHeader AS QMS_AssessmentSpecHeader_Original 
INNER JOIN	QMS_Attachment AS QMS_Attachment_Original ON QMS_AssessmentSpecHeader_Original.AssessmentSpecHeaderID = QMS_Attachment_Original.SourceObjectID 
INNER JOIN	QMS_AssessmentSpecHeader AS QMS_AssessmentSpecHeader_New ON QMS_AssessmentSpecHeader_Original.Sys_AssSpecHeaderID = QMS_AssessmentSpecHeader_New.Sys_AssSpecHeaderID
WHERE   (QMS_Attachment_Original.RecordStatus < 201) 
AND		(QMS_Attachment_Original.AttachmentSourceID = 4) 
AND		(QMS_AssessmentSpecHeader_New.AssessmentID = @NewAssessmentID) 
AND		(QMS_AssessmentSpecHeader_Original.AssessmentID = @SourceAssessmentID)
-- Don't duplicate exact match attachments.
AND NOT EXISTS (SELECT AttachmentID FROM QMS_Attachment 
				WHERE convert(varbinary(max), Attachment) = convert(varbinary(max), QMS_Attachment_Original.Attachment)
				AND ISNULL(AttachmentURL, '') = ISNULL(QMS_Attachment_Original.AttachmentURL, '')
				AND AttachmentSourceID = QMS_Attachment_Original.AttachmentSourceID
				AND SourceObjectID = QMS_AssessmentSpecHeader_New.AssessmentSpecHeaderID
				AND ISNULL(AttachmentTitle, '') = ISNULL(QMS_Attachment_Original.AttachmentTitle, '')
				AND ISNULL(AttachmentFileName, '') = ISNULL(QMS_Attachment_Original.AttachmentFileName, ''))

--Copy assessment question constraint guidance attachments
INSERT INTO QMS_Attachment (Attachment, AttachmentURL, UserID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName)
SELECT		QMS_Attachment_Original.Attachment, 
			QMS_Attachment_Original.AttachmentURL, 
			@UserID AS UserID, 
			QMS_Attachment_Original.AttachmentSourceID, 
            AssessmentGuidance_New.GuidanceID, 
            QMS_Attachment_Original.AttachmentTitle, 
            QMS_Attachment_Original.AttachmentFileName
FROM         (	SELECT DISTINCT AssessmentQuestion_New.AssessmentID, Guidance_New.GuidanceID, Guidance_New.Sys_GuidanceID
                       FROM			QMS_AssessmentQuestion AS AssessmentQuestion_New 
                       INNER JOIN	QMS_AssessmentQuestionConstraint AS AssessmentQuestionConstraint_New ON AssessmentQuestion_New.AssessmentQuestionID = AssessmentQuestionConstraint_New.AssessmentQuestionID 
                       INNER JOIN	QMS_Guidance AS Guidance_New ON AssessmentQuestionConstraint_New.GuidanceID = Guidance_New.GuidanceID
                       WHERE    (AssessmentQuestionConstraint_New.RecordStatus < 201) 
                       AND		(Guidance_New.RecordStatus < 201) 
                       AND		(AssessmentQuestion_New.AssessmentID = @NewAssessmentID)
            ) AS AssessmentGuidance_New 
INNER JOIN	(	SELECT DISTINCT AssessmentQuestion_Original.AssessmentID, Guidance_Original.GuidanceID, Guidance_Original.Sys_GuidanceID
                FROM		QMS_AssessmentQuestion AS AssessmentQuestion_Original 
                INNER JOIN	QMS_AssessmentQuestionConstraint AS AssessmentQuestionConstraint_Original ON AssessmentQuestion_Original.AssessmentQuestionID = AssessmentQuestionConstraint_Original.AssessmentQuestionID 
                INNER JOIN	QMS_Guidance AS Guidance_Original ON AssessmentQuestionConstraint_Original.GuidanceID = Guidance_Original.GuidanceID
                WHERE   (AssessmentQuestionConstraint_Original.RecordStatus < 201) 
                AND		(Guidance_Original.RecordStatus < 201) 
                AND		(AssessmentQuestion_Original.AssessmentID = @SourceAssessmentID)
			) AS AssessmentGuidance_Original ON AssessmentGuidance_New.Sys_GuidanceID = AssessmentGuidance_Original.Sys_GuidanceID 
INNER JOIN	QMS_Attachment AS QMS_Attachment_Original ON AssessmentGuidance_Original.GuidanceID = QMS_Attachment_Original.SourceObjectID
WHERE   (QMS_Attachment_Original.RecordStatus < 201) 
AND		(QMS_Attachment_Original.AttachmentSourceID = 3)
-- Don't duplicate exact match attachments.
AND NOT EXISTS (SELECT AttachmentID FROM QMS_Attachment 
				WHERE convert(varbinary(max), Attachment) = convert(varbinary(max), QMS_Attachment_Original.Attachment)
				AND ISNULL(AttachmentURL, '') = ISNULL(QMS_Attachment_Original.AttachmentURL, '')
				AND AttachmentSourceID = QMS_Attachment_Original.AttachmentSourceID
				AND SourceObjectID = AssessmentGuidance_New.GuidanceID
				AND ISNULL(AttachmentTitle, '') = ISNULL(QMS_Attachment_Original.AttachmentTitle, '')
				AND ISNULL(AttachmentFileName, '') = ISNULL(QMS_Attachment_Original.AttachmentFileName, ''))


GO
/****** Object:  StoredProcedure [dbo].[APP_Temp_ReportFilter_CorrectiveAction]    Script Date: 25/09/2014 15:49:09 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APP_Temp_ReportFilter_CorrectiveAction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[APP_Temp_ReportFilter_CorrectiveAction] AS' 
END
GO


-- =============================================
-- Author:		JToolan
-- Create date: 27/05/2014
-- Description:	Works out which ResponseIDs need to be put in the filter.
--              Can be used by any report.
-- Version:		2
-- =============================================
-- JT TFS 13-6955: Filtering can take place for a single tier (used to require both tiers for anything except location and supplier)
-- =============================================
ALTER PROCEDURE [dbo].[APP_Temp_ReportFilter_CorrectiveAction]
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(255),

	@ReportFilterID1 int = NULL,
	@FilterID_LIST nvarchar(4000),
	@FilterText_LIST nvarchar(4000),
	@ReportFilterID2 int = NULL,
	@FilterID2 int = NULL,
	@FilterText2 nvarchar(255) = NULL,
	
	@Offline bit = NULL,
	@SearchLocalChecksIfOffline bit = 1 -- Use QMS_Response even if offline (default)
AS
BEGIN 
	IF nullif(object_id('tempdb..#tmpUserCAs'), 0) IS NOT NULL DROP TABLE #tmpUserCAs
	CREATE TABLE #tmpUserCAs (
		CorrectiveActionID int,
		IsActive bit NULL
	)
	
	--temp table containing all CAs (i.e. all statuses) user has permission to see
	INSERT INTO	#tmpUserCAs (CorrectiveActionID, IsActive)
	SELECT	CorrectiveActionID, convert(bit, 1) as IsActive
	FROM	dbo.FNC_User_CorrectiveActionList(@UserID, 1)

	INSERT INTO	#tmpUserCAs (CorrectiveActionID, IsActive)
	SELECT	CorrectiveActionID, 0
	FROM	dbo.FNC_User_CorrectiveActionList(@UserID, 0)
	
	--strip out supplier and locations.
	DECLARE @SupplierFilter_LIST nvarchar(4000)
	SELECT @SupplierFilter_LIST = NULL
	IF (@ReportFilterID1 = 1) -- supplier
	BEGIN 
		SET @SupplierFilter_LIST = @FilterID_LIST
		SELECT @ReportFilterID1 = NULL, @FilterID_LIST = NULL, @FilterText_LIST = NULL
	END
	IF (@ReportFilterID2 = 1) -- supplier
	BEGIN 
		SET @SupplierFilter_LIST =  convert(nvarchar(4000), @FilterID2)
		SELECT @ReportFilterID2 = NULL, @FilterID2 = NULL, @FilterText2 = NULL
	END	
		
	DECLARE @LocationFilter_LIST nvarchar(4000)
	SELECT @LocationFilter_LIST = NULL
	IF (@ReportFilterID1 = 6) -- location
	BEGIN 
		SET @LocationFilter_LIST = @FilterID_LIST
		SELECT @ReportFilterID1 = NULL, @FilterID_LIST = NULL, @FilterText_LIST = NULL
	END
	IF (@ReportFilterID2 = 6) -- location
	BEGIN 
		SET @LocationFilter_LIST = convert(nvarchar(4000), @FilterID2)
		SELECT @ReportFilterID2 = NULL, @FilterID2 = NULL, @FilterText2 = NULL
	END	
	

	IF @SupplierFilter_LIST IS NOT NULL --filtering by Supplier
		DELETE #tmpUserCAs 
		WHERE CorrectiveActionID NOT IN (
			SELECT     CorrectiveActionID
			FROM         QMS_CorrectiveAction 
			LEFT OUTER JOIN	PM_VW_Supplier AS Supplier_Assign ON QMS_CorrectiveAction.AssignSupplierID = Supplier_Assign.SupplierID 
			WHERE	(QMS_CorrectiveAction.RecordStatus < 201) 
			AND		(QMS_CorrectiveAction.AssignSupplierID IN (SELECT Token FROM dbo.FNC_SplitString(@SupplierFilter_LIST, ','))) 
			AND		(QMS_CorrectiveAction.DateOccurred >= @DateFrom)
		)
		
	IF @LocationFilter_LIST IS NOT NULL --filtering by Supplier
		DELETE #tmpUserCAs 
		WHERE CorrectiveActionID NOT IN (
			SELECT     CorrectiveActionID
			FROM         QMS_CorrectiveAction 
			LEFT OUTER JOIN	PM_VW_Location ON QMS_CorrectiveAction.LocationID = PM_VW_Location.LocationID				  
			WHERE	(QMS_CorrectiveAction.RecordStatus < 201) 
			AND		(QMS_CorrectiveAction.LocationID IN (SELECT Token FROM dbo.FNC_SplitString(@LocationFilter_LIST, ',')))
			AND		(QMS_CorrectiveAction.DateOccurred >= @DateFrom)
		)
	
	IF @ReportFilterID1 IS NOT NULL OR @ReportFilterID2 IS NOT NULL  --not filtering by Supplier
	BEGIN
		-- To get response filters
		EXEC APP_Temp_ReportFilter @UserID,	@DateFrom, @DateTo, @AssessmentTypeID_LIST, 
									@ReportFilterID1, @FilterID_LIST, @FilterText_LIST,
									@ReportFilterID2, @FilterID2, @FilterText2,
									@Offline, @SearchLocalChecksIfOffline

		DELETE #tmpUserCAs 
		WHERE CorrectiveActionID NOT IN (
			SELECT UserCAList.CorrectiveActionID
			FROM #tmpUserCAs UserCAList
			INNER JOIN dbo.FNC_CorrectiveAction_Response() AS CAResponseList ON UserCAList.CorrectiveActionID = CAResponseList.CorrectiveActionID
			INNER JOIN TEMP_ResponseFilter ON CAResponseList.ResponseID = TEMP_ResponseFilter.ResponseID AND UserID = @UserID
		)
	END


	DELETE TEMP_CorrectiveActionFilter WHERE UserID = @UserID
	INSERT TEMP_CorrectiveActionFilter (CorrectiveActionID, UserID)
	SELECT QMS_CorrectiveAction.CorrectiveActionID, @UserID FROM #tmpUserCAs
	INNER JOIN QMS_CorrectiveAction ON QMS_CorrectiveAction.CorrectiveActionID = #tmpUserCAs.CorrectiveActionID
	WHERE (QMS_CorrectiveAction.RecordStatus < 201)
	AND (@DateFrom IS NULL OR DateOccurred > @DateFrom) --OR DateDeadline > @DateFrom OR DateCompleted > @DateFrom OR DateFailed > @DateFrom)
	AND (@DateTo IS NULL OR DateOccurred <= @DateTo)-- OR DateDeadline <= @DateTo OR DateCompleted <= @DateTo OR DateFailed <= @DateTo)
	
END


GO

/****** Object:  StoredProcedure [dbo].[QRY_CorrectiveAction_Alert]    Script Date: 25/09/2014 15:49:09 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_CorrectiveAction_Alert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_CorrectiveAction_Alert] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Gets list of users to notify for specific corrective action
-- Version:		15
-- =============================================
-- JE TFS 2947 - use Failure_NotificationGroupID for Completed CA's
-- JE TFS 2948 - get linked Supplier users for Signed-off CA's
-- JT TFS 3052 - new CAs for AssignSupplierID get an alert, too.
-- JT TFS 3054 - SP now handles all status/assignment cases.
-- JT TFS 3067 - SP handles reminder alerts too.
-- JT TFS 3077 - Returns CAStatus for email content.
-- JE TFS 7700 - added Logged_UserID to recipient list for sign-off alert
-- JE TFS 7877 - corrected above change to alert Logged_UserID for CA PENDING sign-off
-- JE TFS 13-4921: added CompletedByUser column
-- JE TFS 13-6298: added Location permissions check for Failed CAs
-- JE TFS 13-6298: added Location permissions check for all CA statuses
-- JE TFS 13-8940: amended query to populate @UserList so admin users are included
-- =============================================
ALTER PROCEDURE [dbo].[QRY_CorrectiveAction_Alert]
	@CorrectiveActionID int,
	@IsReminderAlert bit = 0
AS

-- TEST DATA: 
-- DECLARE @CorrectiveActionID int = 18507, @IsReminderAlert bit = 0
BEGIN
	--Get location for check to filter users
	DECLARE		@LocationID int, 
				@CASource int, 
				@CAStatusID int,
				@CAStatus nvarchar(255),
				@NotificationGroupID int, 
				@FailureNotificationGroupID int,
				@AssignUserID int,
				@AssignSupplierID int,
				@IsNotificationAlreadySent bit,
				@LoggedUserID int
			
	SET NOCOUNT ON

	--Get Corrective Action Source and Corrective Action Status, and destinations.
	SELECT		@CASource					= QMS_CorrectiveAction.CASourceID, 
				@CAStatusID					= QMS_CorrectiveAction.CAStatusID, 
				@CAStatus					= ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 1), APP_CorrectiveActionStatus.CAStatus),
				@NotificationGroupID		= QMS_CorrectiveAction.NotificationGroupID,
				@FailureNotificationGroupID	= QMS_CorrectiveActionEscalation.Failure_NotificationGroupID,
				@AssignUserID				= QMS_CorrectiveAction.AssignUserID,
				@AssignSupplierID			= QMS_CorrectiveAction.AssignSupplierID,
				@IsNotificationAlreadySent  = CASE	WHEN @IsReminderAlert = 0 AND NotificationSent = 1	THEN 1
													WHEN @IsReminderAlert = 1 AND ReminderSent = 1		THEN 1
																										ELSE 0 END,
				@LoggedUserID				= QMS_CorrectiveAction.Logged_UserID								
	FROM			QMS_CorrectiveAction
	LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID
	LEFT OUTER JOIN	APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID
	WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)

	-- Potentially short circuit the whole process if the notification has already gone.
	-- IF (@IsNotificationAlreadySent = 1) RETURN

	-- Get location
	IF @CASource = 1 --Get location from response header
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  QMS_CorrectiveAction ON QMS_ResponseHeader.ResponseID = QMS_CorrectiveAction.SourceObjectID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
							  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 2 --Response question
	BEGIN
		SELECT     @LocationID = QMS_ResponseHeader.Header_SourceID
		FROM         QMS_ResponseQuestion INNER JOIN
						  QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID INNER JOIN
						  QMS_ResponseHeader INNER JOIN
						  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID ON 
						  QMS_ResponseQuestion.ResponseID = QMS_ResponseHeader.ResponseID
		WHERE     (QMS_AssessmentHeader.DataLookupID = 4) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
						  (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	IF @CASource = 4 --Ad Hoc, so get Location CA has been assigned to
	BEGIN
		SELECT	@LocationID  = LocationID
		FROM	QMS_CorrectiveAction
		WHERE	(CorrectiveActionID = @CorrectiveActionID)
	END

	IF @LocationID IS NULL --Get location assigned to user
	BEGIN
		SELECT     @LocationID = QMS_User.LocationID
		FROM        QMS_User 
		INNER JOIN	QMS_CorrectiveAction ON QMS_User.UserID = QMS_CorrectiveAction.Logged_UserID
		WHERE     (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID)
	END

	-- Get body details (for non-sent notifications).
	IF @CAStatusID IN (4)  --Completed CA
	BEGIN
		--Get Completed CA details for message body
		SELECT  QMS_CorrectiveAction.CATitle, 
				QMS_CorrectiveAction.CASubTitle, 
				QMS_CorrectiveAction.CAReason,
				QMS_CorrectiveAction.CARequired, 
				QMS_CorrectiveAction.DateLogged, 
				QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
				APP_PriorityLevel.PriorityLevel, 
				QMS_CorrectiveAction.DateDeadline, 
				QMS_CorrectiveAction.ActionTaken,
				@CAStatus as [CAStatus],
				QMS_User.FullName AS CompletedByUser
		FROM			QMS_CorrectiveAction 
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		LEFT OUTER JOIN QMS_User ON QMS_CorrectiveAction.Completed_UserID = QMS_User.UserID	
		WHERE	(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	ELSE IF @CAStatusID IN (5) --Signed-off CA
	BEGIN
			--Get Signed-off CA details for message body
			SELECT		QMS_CorrectiveAction.CATitle, 
						QMS_CorrectiveAction.CASubTitle, 
						QMS_CorrectiveAction.CAReason, 
						QMS_CorrectiveAction.CARequired, 
						QMS_CorrectiveAction.DateLogged, 
						QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
						APP_PriorityLevel.PriorityLevel, 
						QMS_CorrectiveAction.DateDeadline, 
						QMS_User.UserName,
						@CAStatus as [CAStatus]
			FROM			QMS_CorrectiveAction 
			INNER JOIN		QMS_User ON QMS_CorrectiveAction.SignOff_UserID = QMS_User.UserID 
			LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
			LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
			WHERE		(QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
			AND			(@IsNotificationAlreadySent = 0)
	END
	ELSE -- Not Completed or Signed-off CA
	BEGIN
		--Get New CA details for message body
		SELECT      QMS_CorrectiveAction.CATitle, 
					QMS_CorrectiveAction.CASubTitle, 
					QMS_CorrectiveAction.CAReason, 
					QMS_CorrectiveAction.CARequired, 
					QMS_CorrectiveAction.DateLogged, 
					QMS_CorrectiveActionEscalation.ListIndex AS EscalationLevel, 
					APP_PriorityLevel.PriorityLevel, 
					QMS_CorrectiveAction.DateDeadline,
					@CAStatus as [CAStatus]
		FROM			QMS_CorrectiveAction
		LEFT OUTER JOIN	QMS_CorrectiveActionEscalation ON QMS_CorrectiveAction.CorrectiveActionEscalationID = QMS_CorrectiveActionEscalation.CorrectiveActionEscalationID 
		LEFT OUTER JOIN	APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID
		WHERE   (QMS_CorrectiveAction.CorrectiveActionID = @CorrectiveActionID) 
		--AND		(QMS_CorrectiveAction.CAStatusID = 1) 
		AND		(@IsNotificationAlreadySent = 0)
	END
	SET NOCOUNT OFF


	DECLARE @UserList TABLE (
		FullName nvarchar(256),
		Email nvarchar(256)
	)
	SET NOCOUNT ON

	IF @AssignUserID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) -- Individual user emails (New, In Progress, Signed-off, Rejected)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT		QMS_User.FullName, QMS_User.EMail
		FROM		QMS_User 
		WHERE   (QMS_User.UserID = @AssignUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	--Get list of users to include in alert (groupwise)
	IF @NotificationGroupID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --By group (not applicable for Signed-off CA)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT QMS_User.FullName,QMS_User.EMail
		FROM         QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @NotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	-- Suppliers get their own emails.
	IF @AssignSupplierID IS NOT NULL AND @CAStatusID IN (1, 2, 5, 6) --List of Suppliers linked to AssignSupplierID (everything except Completed)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User 
		INNER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID 
		WHERE	(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
		AND		(dbo.FNC_GetUserLevel(QMS_User.UserID) = 9) -- suppliers only.
		AND     (QMS_UserPermissions.PermissionTitle = @AssignSupplierID)
		AND		(QMS_UserPermissions.PermissionType = 101) 
		AND		(QMS_UserPermissions.PermissionAllow = 1)
	END

	--Get extra users to include in alert (owners of the CA alert (failure notification group))
	IF @FailureNotificationGroupID IS NOT NULL AND @CAStatusID IN (3, 4, 7) -- Failed, Completed, Failed (escalated)
	BEGIN
		INSERT @UserList (FullName, Email)
		SELECT DISTINCT	QMS_User.FullName,QMS_User.EMail
		FROM        QMS_NotificationGroup 
		INNER JOIN	QMS_NotificationGroupUser ON QMS_NotificationGroup.NotificationGroupID = QMS_NotificationGroupUser.NotificationGroupID 
				 --join on new function which returns list of users who have access to the CAs stock code
		INNER JOIN	FNC_CorrectiveAction_UserNotify(@CorrectiveActionID) AS CAStockCodeUsers ON QMS_NotificationGroupUser.UserID = CAStockCodeUsers.UserID 
		INNER JOIN	QMS_User ON CAStockCodeUsers.UserID = QMS_User.UserID
		LEFT OUTER JOIN	QMS_UserPermissions ON QMS_User.UserID = QMS_UserPermissions.UserID
		WHERE   (QMS_NotificationGroup.Enabled = 1) 
		AND		(QMS_NotificationGroupUser.RecordStatus < 201) 
		AND		(QMS_NotificationGroup.NotificationGroupID = @FailureNotificationGroupID)
		AND		((@LocationID IS NULL) OR
					(QMS_User.UserLevel = 1) OR --admin can see all CAs
					((@LocationID IS NOT NULL) --check permissions if CA has a LocationID
						AND (QMS_UserPermissions.PermissionType = 103)
						AND	(QMS_UserPermissions.PermissionAllow = 1)
						AND	(QMS_UserPermissions.PermissionTitle = CAST(@LocationID AS nvarchar))))
	END

	--get user who originally logged CA to include in notification list if CA is pending sign off (i.e. Completed)
	IF @LoggedUserID IS NOT NULL AND @CAStatusID = 4
	BEGIN
		INSERT INTO @UserList (FullName, Email)
		SELECT	QMS_User.FullName, QMS_User.EMail
		FROM	QMS_User
		WHERE	(QMS_User.UserID = @LoggedUserID)
		AND		(QMS_User.LeftCompany = 0) 
		AND		(QMS_User.RecordStatus < 201) 
		AND		(QMS_User.EMail IS NOT NULL) 
	END

	SET NOCOUNT OFF

	SELECT FullName, Email FROM @UserList
END

GO

/****** Object:  StoredProcedure [dbo].[QRY_User_Combo]    Script Date: 30/09/2014 11:55:11 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_User_Combo]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_User_Combo] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/07/2008
-- Description:	Fill user combo
-- Version:		4
-- =============================================
-- JT TFS 13-1791: Added Company to output.
-- JT TFS 13-8770: Added IsSupplier to output (suppliers have restrictions on what can be done to their permissions).
-- JT TFS 13-8407: Added LevelOrder to output (Standard users cannot modify permissions of admin users).
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_Combo] 
	@ShowUserGroups bit = 0,
	@Company nvarchar(255) = NULL
AS
BEGIN
	SELECT     UserID, FullName, Company, 
				dbo.FNC_GetUserOrderLevel(UserID) as OrderLevel, 
				CASE WHEN dbo.FNC_GetUserOrderLevel(UserID) = 9 THEN 1 ELSE 0 END IsSupplier
	FROM         QMS_User
	WHERE     (RecordStatus < 201) AND (LeftCompany = 0) AND (IsUserGroup = @ShowUserGroups) AND (@Company IS NULL) OR
						  (RecordStatus < 201) AND (LeftCompany = 0) AND (IsUserGroup = @ShowUserGroups) AND (@Company IS NOT NULL) AND (Company = @Company)
	ORDER BY FullName
END

GO

/****** Object:  StoredProcedure [dbo].[QRY_AssessmentQuestion_List]    Script Date: 03/10/2014 11:35:08 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_AssessmentQuestion_List]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_AssessmentQuestion_List]
GO
/****** Object:  StoredProcedure [dbo].[QRY_AssessmentQuestion_List]    Script Date: 03/10/2014 11:35:08 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_AssessmentQuestion_List]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_List] AS' 
END
GO

-- =============================================
-- Author:		Markp
-- Create date: 22/07/2008
-- Description:	Gets list of questions for specified assessment
-- Version: 6
-- =============================================
-- JE TFS 5069 - added DataLookupDataTypeID column
-- JE TFS 6268 - added DataSource column
-- JE TFS 6892 - added Numeric Min and Max columns (used in MCC)
-- JE TFS 13-6548: added DisplayWarning column
-- JE TFS 13-9479: LEFT OUTER JOIN to APP_QuestionLevel so NULL QuestionLevelID records aren't filtered out
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_List] 
	@AssessmentID int
AS

SELECT     'QMS_AssessmentQuestion' AS DataSource, QMS_AssessmentQuestion.AssessmentQuestionID, FNC_AssessmentQuestion_Sort.QuestionNumber AS SortNumber,
				QMS_QuestionPool.Question, QMS_AssessmentQuestion.ParentQuestionID, FNC_AssessmentQuestion_Sort.QuestionLevel,
				QMS_AssessmentQuestion.DataTypeID, QMS_AssessmentQuestion.DataLookupID, QMS_AssessmentQuestion.CustomLookupID, QMS_AssessmentQuestion.QuestionLevelID,
				APP_QuestionLevel.DisplayWarning,
				QMS_AssessmentQuestion.GuidanceID, QMS_AssessmentQuestion.ShortGuidance, QMS_AssessmentQuestion.HasSamples, 
				QMS_AssessmentQuestion.ResponseRequired, QMS_AssessmentQuestion.ScoreCalculationID, QMS_AssessmentQuestion.Hide, QMS_QuestionPool.Sys_Question, 
				QMS_AssessmentQuestion.ResponseFormula, QMS_AssessmentQuestion.ScoreFormula, QMS_AssessmentQuestion.Sample_DataTypeID, 
				QMS_AssessmentQuestion.InstrumentID, QMS_AssessmentQuestion.SampleSummaryID, QMS_AssessmentQuestion.LookupAssessmentQuestionID,
				QMS_AssessmentQuestion.LookupSampleSet,
				(SELECT		DataTypeID --TFS 5069
					FROM		APP_DataLookup
					WHERE	(DataLookupID = QMS_AssessmentQuestion.DataLookupID)) AS DataLookupDataTypeID,
				QMS_AssessmentQuestion.Acceptable_Numeric_Min, QMS_AssessmentQuestion.Acceptable_Numeric_Max
FROM         QMS_AssessmentQuestion INNER JOIN
                      dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) AS FNC_AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = FNC_AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
					  APP_QuestionLevel ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID
WHERE     (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_QuestionPool.RecordStatus < 201)
ORDER BY FNC_AssessmentQuestion_Sort.SortIndex1, FNC_AssessmentQuestion_Sort.SortIndex2, FNC_AssessmentQuestion_Sort.SortIndex3, 
                      FNC_AssessmentQuestion_Sort.SortIndex4


GO


PRINT 'Updating sync procedures...'

/****** Object:  StoredProcedure [dbo].[SYNC_Import_Attachment]    Script Date: 25/09/2014 15:54:01 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_Attachment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SYNC_Import_Attachment]
GO
/****** Object:  StoredProcedure [dbo].[SYNC_Import_Attachment]    Script Date: 25/09/2014 15:54:01 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_Attachment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SYNC_Import_Attachment] AS' 
END
GO
ALTER PROCEDURE [dbo].[SYNC_Import_Attachment] 
	@AttachmentSourceID int,
	@SourceObjectID int,
	@AttachmentTitle nvarchar(255),
	@AttachmentFileName nvarchar(100),
	@AttachmentURL nvarchar(255),
	@UserID int,
	@MachineName nvarchar(255),
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @AttachmentSourceID = 1 AND @RecordStatus = 100 --Failed attachment upload
BEGIN
	IF EXISTS(SELECT * FROM QMS_Attachment WHERE (GUID = @GUID))
	BEGIN --Update record
		UPDATE    QMS_Attachment
		SET              RecordStatus = CASE WHEN RecordStatus < 100 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE()
		WHERE     (GUID = @GUID)
		SET @UpdateCount = @@rowcount
	END
END
ELSE
BEGIN
	IF NOT EXISTS(SELECT * FROM QMS_Attachment WHERE (GUID = @GUID))
	BEGIN --Append record
		IF @RecordStatus < 201
		BEGIN
			--Append data
			INSERT INTO QMS_Attachment
						  (AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, AttachmentURL, UserID, MachineName, RecordStatus, Inserted, Updated, 
						  Deleted, GUID)
			VALUES     (@AttachmentSourceID,@SourceObjectID,@AttachmentTitle,@AttachmentFileName,@AttachmentURL,@UserID,@MachineName,@RecordStatus,@Inserted,@Updated,@Deleted,@GUID)
			SET @InsertCount = @@rowcount
		END
	END

	ELSE
	BEGIN --Update record
		UPDATE    QMS_Attachment
		SET              AttachmentSourceID = @AttachmentSourceID, SourceObjectID = @SourceObjectID, AttachmentTitle = @AttachmentTitle, AttachmentFileName = @AttachmentFileName, 
							  AttachmentURL = @AttachmentURL, UserID = @UserID, MachineName = @MachineName, RecordStatus = @RecordStatus, Inserted = @Inserted, 
							  Updated = @Updated, Deleted = @Deleted
		WHERE     (GUID = @GUID) AND (Updated < @Updated) OR
							  (GUID = @GUID) AND (Updated IS NULL) AND (@Updated IS NOT NULL) OR
							  (GUID = @GUID) AND (RecordStatus <> @RecordStatus)
		SET @UpdateCount = @@rowcount
	END
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created

GO


--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
